#pragma once
#include "AscensionTowerPage.h"
#pragma warning(disable : 4482)

class DoorListPage: public AscensionTowerPage
{

public:

	DoorListPage(AscensionTowerData *data):AscensionTowerPage(data){}

protected:

	char *LabelRenderer (int bt)
	{
		switch (bt)
		{
			case 6: return "HOM";
			case 7: return "BCK";
			case 8: return "RES";
			default: return AscensionTowerPage::LabelRenderer(bt);
		}
	}

	int MenuRenderer (MFDBUTTONMENU *mnu)
	{	
		static MFDBUTTONMENU menu[3] = 
		{
			{"Main menu", NULL, 'H'},
			{"Go back", NULL, 'B'},
			{"Reset to default", "values", 'R'}
		};
		
		mnu[0].line1="Select door";
		for(int i=0;i<3;i++) mnu[6+i]=menu[i];	
		return AscensionTowerPage::MenuRenderer(mnu);
	}

	AscensionTowerPageInstance KeyHandler(DWORD key)
	{	
		switch(key)
		{	
		case OAPI_KEY_H:
			return MainMenu;
		case OAPI_KEY_B:
			return HangarForDoorSelection;
		default:
			return AscensionTowerPage::KeyHandler(key);
		}
	}

	char *GetTitle(){return GetNameSafeTitle("Ground");}

	char *GetSubtitle(){return "Select Door for Roll-in/Roll-out";}

	int GetListSize(){return ((Hangar *)dataRoot)->GetDoors();}

	AscensionTowerListPair GetListItem(int index)
	{
		AscensionTowerListPair item =
		{
			index,
			((Hangar *)dataRoot)->GetDoor(index)->GetName()
		};
		return item;
	}

	AscensionTowerPageInstance Select(int index=-1)
	{
		AscensionTowerPage::Select(index);
		Hangar *hangar = (Hangar *)dataRoot;
		dataSet[0]=hangar->GetName();
		dataSet[1]=hangar->GetDoor(selectedIndex);
		data->GetPage(DoorControl)->SetDataRoot(dataSet);
		return DoorControl;
	}

private:
	void* dataSet[2];

};