﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Serialization;

namespace OPMLEditor.opml
{
    [XmlRoot("OPML")]
    public class Opml
    {
        [XmlAttribute("version")]
        public string version { get; set; }
        public Head head { get; set; }
        public Body body { get; set; }
    }
    [XmlRoot("Head")]
    public class Head
    {

        public string title { get; set; }
        public string expansionState { get; set; }
    }
    [XmlRoot("body")]
    public class Body
    {
        [XmlElement(typeof(Outline))]
        public List<Outline> outline { get; set; }
    }
    [XmlRoot("outline")]
    public class Outline
    {
        [XmlAttribute("text")]
        public String text { get; set; }
        [XmlAttribute("_note")]
        public String note { get; set; }
        [XmlAttribute("_status")]
        public String _status
        {
            get;
            set;
        }
        [XmlElement(typeof(Outline))]
        public List<Outline> outline
        {
            get
            {
                if (outlineInner == null)
                {
                    outlineInner = new List<Outline>();

                }
                return outlineInner;
            }
            set { this.outlineInner = value; }
        }

        private List<Outline> outlineInner;
    }
}
