﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using OPMLEditor.Structure;
using OPMLEditor.Forms;

namespace OPMLEditor.Controller
{
    class NodeController
    {
        private List<StructureNode> parentList;
        private FrmBase frontWindow;

        private List<StructureNode> redoBackup;
        private StructureNode bkSelectedNode;
        
        private StructureNode selectedNode;
        private StructureNode focusNode;
        
        private static NodeController singleton;

        public static NodeController getNodeController()
        {
            if (singleton == null)
            {
                singleton = new NodeController();
            }
            return singleton;
        }
        /// <summary>
        /// ノードコントローラをリセットする。
        /// </summary>
        /// <returns></returns>
        public NodeController resetNodeController()
        {
            singleton = new NodeController();
            return singleton;
        }

        private NodeController()
        {
            parentList = new List<StructureNode>();
            

            StructureNode data = new StructureNode(this);
            data.TitleText = string.Empty;
            parentList.Add(data);

        }


        public List<StructureNode> ParentList
        {
            get { return parentList; }
            set { parentList = value; }
        }
        public FrmBase FrontWindow
        {
            set { frontWindow = value; }
        }
        public StructureNode FocusData
        {
            get { return focusNode; }
        }
        public StructureNode SelectedNode
        {
            get { return selectedNode; }
            set { this.selectedNode = value; }
        }

        private void reflesh(StructureNode focusData)
        {
            resetSearch();
            this.focusNode = focusData;
            frontWindow.refleshNode();
        }


        #region backup/undo
        public void undo()
        {
            resetSearch();
            parentList = redoBackup;

            selectedNode = bkSelectedNode;
            focusNode = bkSelectedNode;
            frontWindow.refleshNode();

            //フロントのUndo機能をOffにする
            frontWindow.undoToolControl(false);
        }
        private void backup()
        {
            redoBackup = new List<StructureNode>();
            foreach (StructureNode current in parentList)
            {
                StructureNode bkup = current.clone();
                if (current == selectedNode) { bkSelectedNode = bkup; }
                recursiveBackup(bkup, current);
                redoBackup.Add(bkup);
            }
            //フロントのUndo機能をOnにする
            frontWindow.undoToolControl(true);

        }
        private void recursiveBackup(StructureNode bkupData, StructureNode currentData)
        {
            foreach (StructureNode currentChild in currentData.getAllChildlen())
            {
                StructureNode bkChild = currentChild.clone(bkupData);
                if (currentChild == selectedNode) { bkSelectedNode = bkChild; }

                recursiveBackup(bkChild, currentChild);
                bkupData.addChild(bkChild);
            }
        }
        #endregion


        #region search
        private List<StructureNode> searchResult;
        public void search(string target)
        {
            searchResult = new List<StructureNode>();
            foreach (StructureNode node in parentList)
            {
                if (node.TitleText.Contains(target) || node.Note.Contains(target))
                {
                    searchResult.Add(node);
                    node.becomeSearchResult(true);

                }
                else
                {
                    node.becomeSearchResult(false);
                }
                recursiveSearch(node,target);
            }
            if (searchResult.Count == 0) { return; }
            
            currentTarget = searchResult[0];
            searchTarget(currentTarget);
        }
        private void recursiveSearch(StructureNode parent,string target)
        {
            foreach(StructureNode child in parent.getAllChildlen())
            {
                if (child.TitleText.Contains(target) || child.Note.Contains(target))
                {
                    searchResult.Add(child);
                    child.becomeSearchResult(true);
                }
                else
                {
                    child.becomeSearchResult(false);
                }
                recursiveSearch(child,target);
            }
            
        }
        public void resetSearch()
        {
            if (searchResult == null) { return; }
            foreach (StructureNode sTarget in searchResult)
            {
                sTarget.becomeSearchResult(false);
            }
            searchResult=new List<StructureNode>();
        }
        private StructureNode currentTarget;
        public void searchPrev()
        {
            if (searchResult == null || searchResult.Count == 0) { return; }
            if (searchResult.IndexOf(currentTarget) == 0) { return; }
            searchTarget(searchResult[searchResult.IndexOf(currentTarget)-1]);
        }
        public void searchNext()
        {
            if (searchResult == null || searchResult.Count == 0) { return; }
            if (searchResult.IndexOf(currentTarget) == searchResult.Count - 1) { return; }
            searchTarget(searchResult[searchResult.IndexOf(currentTarget) + 1]);
        }
        private void searchTarget(StructureNode node)
        {
            StructureNode target = searchResult[searchResult.IndexOf(node)];
            currentTarget = target;
            target.Panel.NodeTitle.Focus();
            this.selectedNode = target;
            
        }

        #endregion

        #region NodeControl
        public void addNodes()
        {
            backup();
            if (selectedNode == null) return;
            StructureNode newNode = new StructureNode(this);

            if (selectedNode.ParentNode != null)
            {
                newNode.ParentNode = selectedNode.ParentNode;
                selectedNode.ParentNode.addChild(newNode);
            }
            else
            {
                newNode.ParentNode = null;
                parentList.Add(newNode);
            }
            reflesh(newNode);

            
        }
        public void addChild()
        {
            backup();
            StructureNode childData = new StructureNode(this);
            childData.ParentNode = selectedNode;
            //childData.ElderNode = (from n in selectedNode.getAllChildlen() select n).LastOrDefault();
            selectedNode.addChild(childData);

            reflesh(childData);
        }
        public void becomeChild()
        {
            backup();
            StructureNode becomePapa;
            //if (selectedNode.ElderNode == null) return;

            if (selectedNode.ParentNode == null)
            {
                if(parentList.IndexOf(selectedNode)==0) return;
                becomePapa = parentList[parentList.IndexOf(selectedNode) - 1];
                parentList.Remove(selectedNode);

            }
            else
            {
                becomePapa= selectedNode.ElderNode;
                if (becomePapa == null) return;
                selectedNode.ParentNode.removeChild(selectedNode);
            }

             
            selectedNode.ParentNode = becomePapa;
            //selectedNode.ElderNode = (from n in becomePapa.getAllChildlen() select n).LastOrDefault();

            becomePapa.addChild(selectedNode);
            reflesh(selectedNode);
        }

        public void becomeParent()
        {
            backup();
            if (selectedNode.ParentNode == null) return;

            StructureNode becomeElder = selectedNode.ParentNode;
            StructureNode becomePapa = selectedNode.ParentNode.ParentNode;

            selectedNode.ParentNode.removeChild(selectedNode);
            if (becomePapa == null)
            {
                
                selectedNode.ParentNode = null;
                parentList.Insert(parentList.IndexOf(becomeElder)+1,selectedNode);
                selectedNode.Indent = 0;
            }
            else
            {
                selectedNode.ParentNode = becomePapa;
                //becomePapa.addChild(selectedNode);
                becomePapa.insertChild(selectedNode,becomePapa.getAllChildlen().IndexOf(becomeElder)+1);
            }
            
            reflesh(selectedNode);
        }

        public void turnUp()
        {
            backup();
            //最上位階層
            if (selectedNode.ParentNode == null)
            {
                if (parentList.IndexOf(selectedNode) == 0) return;
                parentList.Reverse(parentList.IndexOf(selectedNode) - 1, 2);
            }
            //ノード内部
            else
            {
                if(selectedNode.nodeIndex==0) return;
                selectedNode.parentList.Reverse(selectedNode.nodeIndex-1, 2);
            }
            
            reflesh(selectedNode);
        }
        public void turnDown()
        {
            backup();
            //最上位階層
            if (selectedNode.ParentNode == null)
            {
                if (parentList.IndexOf(selectedNode) < parentList.Count - 1)
                {
                    parentList.Reverse(parentList.IndexOf(selectedNode), 2);
                }
            }
            //ノード内部
            else
            {
                if (selectedNode.nodeIndex < selectedNode.parentList.Count-1)
                {
                    selectedNode.parentList.Reverse(selectedNode.nodeIndex, 2);
                }
            }
            
            reflesh(selectedNode);
        }
        public void deleteNode()
        {
            backup();
            StructureNode elderData;
            if (selectedNode.ParentNode == null)
            {
                if (parentList.Count > 1)
                {
                    elderData = parentList[parentList.IndexOf(selectedNode) - 1];
                    parentList.Remove(selectedNode);
                }
                else
                {
                    return;
                }
            }
            else
            {
                elderData = selectedNode.ElderNode;
                selectedNode.ParentNode.removeChild(selectedNode);
            }
            reflesh(elderData);
        }

        public void changeNodeStatus()
        {
            selectedNode.IsChecked = !selectedNode.IsChecked;
        }
        #endregion

        public void addNote()
        {
            selectedNode.Panel.invokeNoteWindow();
        }

        public void gotoNext()
        {
            //最上位階層
            if (selectedNode.ParentNode == null)
            {
                if (parentList.IndexOf(selectedNode) < parentList.Count - 1)
                {
                    parentList[parentList.IndexOf(selectedNode)+1].Panel.NodeTitle.Focus();
                }
            }
            //ノード内部
            else
            {
                if (selectedNode.nodeIndex < selectedNode.parentList.Count - 1)
                {
                    selectedNode.parentList[selectedNode.nodeIndex+1].Panel.NodeTitle.Focus();
                }
            }
        }
        public void gotoPrev()
        {
            //最上位階層
            if (selectedNode.ParentNode == null)
            {
                if (parentList.IndexOf(selectedNode) > 0)
                {
                    parentList[parentList.IndexOf(selectedNode) - 1].Panel.NodeTitle.Focus();
                }
            }
            //ノード内部
            else
            {
                if (selectedNode.nodeIndex>0)
                {
                    selectedNode.parentList[selectedNode.nodeIndex - 1].Panel.NodeTitle.Focus();
                }
            }
        }

    }
}
