package jp.sourceforge.observoice.dao;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import jp.sourceforge.observoice.entity.Comment;

import org.seasar.dao.annotation.tiger.Query;
import org.seasar.dao.annotation.tiger.S2Dao;
import org.seasar.dao.annotation.tiger.Sql;

@S2Dao(bean = Comment.class)
public interface CommentDao extends Serializable {

    int insert(Comment comment);

    int update(Comment comment);

    List<Comment> selectAll();

    @Query("comment_id = ?")
    Comment select(int commentId);

    @Query("course_id = ? ORDER BY created LIMIT ?")
    List<Comment> selectByCourseId(int courseId, int count);

    @Query("course_id = ? AND created BETWEEN ? AND ? ORDER BY created LIMIT ?")
    List<Comment> selectByCourseIdBetween(int courseId, Date since, Date until,
            int count);

    @Query("course_id = ? AND created > ? ORDER BY created LIMIT ?")
    List<Comment> selectByCourseIdAfter(int courseId, Date since, int count);

    @Query("course_id = ? AND created < ? ORDER BY created LIMIT ?")
    List<Comment> selectByCourseIdBefore(int courseId, Date until, int count);

    @Sql("SELECT COUNT(*) FROM comment")
    long count();

    @Sql("SELECT COUNT(*) FROM comment WHERE course_id = ?")
    long countByCourseId(int courseId);

}
