package jp.sourceforge.observoice.resources.params;

import java.text.ParseException;
import java.util.Date;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;

import jp.sourceforge.observoice.util.DateFormatUtil;

public class DateParam {

    private final Date date;

    public DateParam(String value) {
        try {
            date = DateFormatUtil.parseRfc2822(value);
        } catch (ParseException e) {
            throw new WebApplicationException(Response
                    .status(Status.BAD_REQUEST)
                    .entity("Could not parse date: " + value + " ("
                            + e.getMessage() + ")").build());
        }
    }

    public Date getDate() {
        return date;
    }

}
