package jp.sourceforge.observoice.resources;

import java.util.List;

import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response.Status;

import jp.sourceforge.observoice.entity.Course;
import jp.sourceforge.observoice.entity.CourseSchedule;
import jp.sourceforge.observoice.service.CommentService;
import jp.sourceforge.observoice.service.CourseService;

import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.seasar.framework.container.annotation.tiger.Binding;

@Path("/courses")
public class CourseResource extends S2Resource {

    @Binding
    private CourseService courseService;

    @Binding
    private CommentService commentService;

    @GET
    @Produces(MediaType.APPLICATION_JSON)
    public JSONObject getCourses(@QueryParam("day") int day,
            @QueryParam("period") int period, @QueryParam("q") String q,
            @DefaultValue("100") @QueryParam("count") int count)
            throws JSONException {
        List<Course> courses = courseService.search(day, period, q, count);

        JSONObject obj = new JSONObject();
        JSONArray array = new JSONArray();
        for (Course c : courses) {
            array.put(encodeCourse(c));
        }
        obj.put("result", array);
        obj.put("count", courses.size());

        return obj;
    }

    @GET
    @Produces(MediaType.APPLICATION_JSON)
    @Path("/{courseId}")
    public JSONObject getCourse(@PathParam("courseId") int courseId)
            throws JSONException {
        Course course = courseService.find(courseId);

        if (course == null) {
            throw new WebApplicationException(Status.NOT_FOUND);
        }

        return encodeCourse(course);
    }

    private JSONObject encodeCourse(Course c) throws JSONException {
        JSONObject obj = new JSONObject();

        obj.put("courseId", c.courseId);
        obj.put("courseTitle", c.courseTitle);
        obj.put("lecturer", c.lecturer);
        obj.put("year", c.year);
        obj.put("semester", c.semester);
        obj.put("location", c.location.locationName);

        JSONArray array = new JSONArray();
        for (CourseSchedule s : courseService.getCourseSchedule(c.courseId)) {
            array.put(encodeCourseSchedule(s));
        }
        obj.put("schedule", array);

        obj.put("commentCount", commentService.getCommentCount(c.courseId));

        return obj;
    }

    private JSONObject encodeCourseSchedule(CourseSchedule s)
            throws JSONException {
        JSONObject obj = new JSONObject();
        obj.put("day", s.day);
        obj.put("period", s.period);
        return obj;
    }

}
