package jp.sourceforge.observoice.network.task;

import jp.sourceforge.observoice.network.requestmethod.ObsvRequestMethod;
import jp.sourceforge.observoice.network.requestmethod.PostCommentMethod;

public class PostCommentTask extends ObsvNetworkTask {

    private String userId;
    private int type;
    private String content;

    /**
     * @param userId
     * @param type 理解度(0 or 1)
     * @param content コメント内容
     */
    public PostCommentTask(String userId, int type, String content) {
        this.userId = userId;
        this.type = type;
        this.content = content;
    }

    @Override
    protected ObsvRequestMethod createRequestMethod() {
        return new PostCommentMethod(userId, type, content);
    }

}
