package jp.sourceforge.observoice.network.task;

import android.os.AsyncTask;
import jp.sourceforge.observoice.network.requestmethod.ObsvRequestMethod;
import jp.sourceforge.observoice.network.response.ObsvResponseObject;
import jp.sourceforge.observoice.network.task.ObsvNetworkListener;

/**
 * ネットワークを使用する処理を表す
 * 
 * @author rtakizawa
 */
public abstract class ObsvNetworkTask extends
        AsyncTask<Void, Void, ObsvResponseObject> {

    // ネットワーク処理終了後のUI操作を登録されている
    private ObsvNetworkListener listener;
    // doInBackground中で投げられた例外
    private Exception thrownException;

    /**
     * リスナーの登録
     * 
     * @param listener
     */
    public void setListener(ObsvNetworkListener listener) {
        this.listener = listener;
        this.thrownException = null;
    }

    /**
     * 別スレッドで行われる操作
     */
    @Override
    protected ObsvResponseObject doInBackground(Void... params) {
        try {
            // 対応するリクエストメソッドを生成
            ObsvRequestMethod requestMethod = createRequestMethod();
            // 送信して結果を返す
            return requestMethod.send();
        } catch (Exception e) {
            // 発生した例外を補足
            this.thrownException = e;
            return null;
        }
    }

    /**
     * doInBackgroundの処理が終了したあとの操作
     */
    @Override
    protected void onPostExecute(ObsvResponseObject response) {
        if (!isFailed()) {
            listener.onSuccess(response);
        } else {
            listener.onFailure(thrownException);
        }
    }

    /**
     * コマンドに対応するObsvRequestMethodを返す。
     * 
     * @return
     */
    protected abstract ObsvRequestMethod createRequestMethod();

    /**
     * doInBackgroundが失敗したか
     * 
     * @return
     */
    private boolean isFailed() {
        return (thrownException == null) ? false : true;
    }

}
