package jp.sourceforge.observoice.network.task;

import jp.sourceforge.observoice.network.response.ObsvResponseObject;

/**
 * Observoiceのネットワーク操作によるレスポンスを使った処理を記述する。
 * 使用例はObservoiceNetowrkingSampleActivity参照。
 * 
 * @author rtakizawa
 */
public interface ObsvNetworkListener {

    /**
     * ネットワーク処理が正常に終了した後のUIなどの処理を記述
     * 
     * @param response サーバからのレスポンスを表すオブジェクト
     */
    public void onSuccess(ObsvResponseObject response);

    /**
     * ネットワーク処理が異常終了した場合の処理を記述
     * 
     * @param e　発生した例外
     */
    public void onFailure(Exception e);
}
