package jp.sourceforge.observoice.network.task;

import jp.sourceforge.observoice.network.requestmethod.ObsvRequestMethod;
import jp.sourceforge.observoice.network.requestmethod.LoginMethod;

/**
 * ログイン操作を表す。
 * 
 * @author rtakizawa
 */
public class LoginTask extends ObsvNetworkTask {

    String user_id;
    int lecture_id;

    public LoginTask(String user_id, int lecture_id) {
        this.user_id = user_id;
        this.lecture_id = lecture_id;
    }

    /**
     * コマンドに対応するObsvRequestMethodを返す。
     * 
     * @return
     */
    @Override
    protected ObsvRequestMethod createRequestMethod() {
        return new LoginMethod(user_id, lecture_id);
    }

}
