package jp.sourceforge.observoice.network.task;

import java.util.Calendar;
import jp.sourceforge.observoice.network.requestmethod.ObsvRequestMethod;
import jp.sourceforge.observoice.network.requestmethod.GetCommentListMethod;

/**
 * courceIdの講義のコメントリストを取得する操作
 * 
 * @author rtakizawa
 */
public class GetCommentListTask extends ObsvNetworkTask {

    private String courceId;
    private int count;
    private Calendar since, until;
    
    /**
     * デフォルト設定
     * 
     * @param courceId 講義ID
     */
    public GetCommentListTask(String courceId) {
        this.courceId = courceId;
        this.count = 100;
        this.since = Calendar.getInstance();
        since.add(Calendar.MINUTE, -30);
        this.until = Calendar.getInstance();
    }

    /**
     * @param courceId 講義ID
     * @param count 取得するコメントの件数
     * @param since この日付以降のコメントを取得
     * @param until この日付以前のコメントを取得
     */
    public GetCommentListTask(String courceId, int count, Calendar since, Calendar until) {
        this.courceId = courceId;
        this.count = count;
        this.since = since;
        this.until = until;
    }

    @Override
    protected ObsvRequestMethod createRequestMethod() {
        return new GetCommentListMethod(courceId, count, since, until);
    }

}
