package jp.sourceforge.observoice.network.requestmethod;

import jp.sourceforge.observoice.network.response.ObsvResponseObject;
import jp.sourceforge.observoice.network.response.PostCommentResponse;
import org.json.JSONObject;
import org.json.JSONException;

/**
 * サーバにコメント投稿する際に送信するリクエストメソッドを表す
 * 
 * @author rtakizawa
 */
public class PostCommentMethod extends ObsvPostRequestMethod {

    private String userId;
    private int type;
    private String content;

    public PostCommentMethod(String userId, int type, String content) {
        this.userId = userId;
        this.type = type;
        this.content = content;
    }

    @Override
    public String createUrlString() {
        // あんまりよくないかなあ・・・
        return "http://" + hostName + "/api/courses.json";
    }

    @Override
    public ObsvResponseObject createResponseObject(String response) {
        return new PostCommentResponse(response);
    }

    @Override
    protected JSONObject createJson() {
        JSONObject json = new JSONObject();
        try {
            json.put("userId", userId);
            json.put("type", type);
            json.put("content", content);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return json;
    }

}
