package jp.sourceforge.observoice.network.requestmethod;

import java.io.IOException;

import org.json.JSONObject;
import org.json.JSONException;
import jp.sourceforge.observoice.network.HttpClient;
import jp.sourceforge.observoice.network.response.ObsvResponseObject;

/**
 * Observoiceのクライアントからサーバーへ送信するPOSTリクエストメソッドデータを表す抽象クラス。
 * 実際のリクエストメソッドのデータは子クラスになる。
 * 
 * @author rtakizawa
 */
public abstract class ObsvPostRequestMethod implements ObsvRequestMethod {

    protected String name;

    protected ObsvPostRequestMethod() {
        name = null;
    }

    /**
     * Observoiceリクエストメソッドの送信
     * 
     * @return
     * サーバーからのレスポンス
     * またはエラーレスポンス
     * @throws IOException 
     */
    public ObsvResponseObject send() throws IOException {
        HttpClient hc = new HttpClient();
        String postParam = createPostParameter();
        String response;
        if (postParam == null) {
            response = createErrorResponse(-1, "ポストパラメータを作成できなかったよ");
        }
        else {
            response = hc.post(createUrlString(), createPostParameter());
        }

        return createResponseObject(response);
    }

    /**
     * POSTパラメータを生成
     * 
     * @return
     * POSTパラメータ文字列
     * JSONオブジェクトから文字列への変換に失敗した場合はnull
     */
    protected String createPostParameter() {
        String postParam = null;
        try {
            /* リクエストメソッドに対応するJSONオブジェクトを生成 */
            JSONObject json = createJson();
            /* リクエストパラメータに変換 */
            postParam = json.toString(4);
        } catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
        return postParam;
    }

    /**
     * リクエストメソッドに対応するJSONオブジェクトを生成
     * 
     * @return
     * リクエストメソッドに対応するJSONオブジェクト
     * JSONオブジェクトの生成に失敗した場合はnull
     */
    protected abstract JSONObject createJson();
    
    protected String createErrorResponse(int status, String message) {
        return "{\"status\":" + status + ", \"error\":\"" + message + "\"}";
    }

}
