package jp.sourceforge.observoice.network.requestmethod;

import jp.sourceforge.observoice.network.response.ObsvResponseObject;
import jp.sourceforge.observoice.network.response.GetLectureInfoListResponse;

/**
 * 講義情報リストを取得するリクエストメソッド
 * 
 * @author rtakizawa
 */
public class GetLectureInfoListMethod extends ObsvGetRequestMethod {

    private int count;
    private String day;
    private int period;
    private String q;

    /**
     * @param count 取得する講義情報の件数
     * @param day 曜日
     * @param period 時限
     * @param q 検索文字列
     */
    public GetLectureInfoListMethod(int count, String day, int period, String q) {
        this.count = count;
        this.day = day;
        this.period = period;
        this.q = q;
    }

    @Override
    public String createUrlString() {
        // うーん
        return "http://" + hostName + "/api/courses.json?" + "count=" + count +
                "&day=" + day + "&period=" + period + "&q=" + q;
    }

    @Override
    public ObsvResponseObject createResponseObject(String response) {
        return new GetLectureInfoListResponse(response);
    }

}
