/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.automata;

import net.morilib.automata.nfa.GenericNFAMatcher;
import net.morilib.automata.nfa.NFAParser;
import junit.framework.TestCase;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/10/20
 */
public class NFAParserTest extends TestCase {

	public void test0001() throws Exception {
		NFA<Object, NFAState, Void> v;
		GenericNFAMatcher<Object, NFAState> m;

		v = NFAParser.parse("a");
		m = new GenericNFAMatcher<Object, NFAState>(v);
		assertTrue(m.match("a"));
		assertFalse(m.match("ab"));
	}

	public void test0002() throws Exception {
		NFA<Object, NFAState, Void> v;
		GenericNFAMatcher<Object, NFAState> m;

		v = NFAParser.parse("abc");
		m = new GenericNFAMatcher<Object, NFAState>(v);
		assertTrue(m.match("abc"));
		assertFalse(m.match("ab"));
		assertFalse(m.match("abcd"));
	}

	public void test0003() throws Exception {
		NFA<Object, NFAState, Void> v;
		GenericNFAMatcher<Object, NFAState> m;

		v = NFAParser.parse("a|c");
		m = new GenericNFAMatcher<Object, NFAState>(v);
		assertTrue(m.match("a"));
		assertTrue(m.match("c"));
		assertFalse(m.match("ac"));
	}

	public void test0004() throws Exception {
		NFA<Object, NFAState, Void> v;
		GenericNFAMatcher<Object, NFAState> m;

		v = NFAParser.parse("ab|cd");
		m = new GenericNFAMatcher<Object, NFAState>(v);
		assertTrue(m.match("ab"));
		assertTrue(m.match("cd"));
		assertFalse(m.match("abcd"));
	}

	public void test0005() throws Exception {
		NFA<Object, NFAState, Void> v;
		GenericNFAMatcher<Object, NFAState> m;

		v = NFAParser.parse("a*");
		m = new GenericNFAMatcher<Object, NFAState>(v);
		assertTrue(m.match(""));
		assertTrue(m.match("a"));
		assertTrue(m.match("aaaa"));
		assertFalse(m.match("ab"));
	}

	public void test0006() throws Exception {
		NFA<Object, NFAState, Void> v;
		GenericNFAMatcher<Object, NFAState> m;

		v = NFAParser.parse("a+");
		m = new GenericNFAMatcher<Object, NFAState>(v);
		assertTrue(m.match("a"));
		assertTrue(m.match("aaaa"));
		assertFalse(m.match(""));
		assertFalse(m.match("ab"));
	}

	public void test0007() throws Exception {
		NFA<Object, NFAState, Void> v;
		GenericNFAMatcher<Object, NFAState> m;

		v = NFAParser.parse("a?");
		m = new GenericNFAMatcher<Object, NFAState>(v);
		assertTrue(m.match(""));
		assertTrue(m.match("a"));
		assertFalse(m.match("aa"));
		assertFalse(m.match("ab"));
	}

	public void test0008() throws Exception {
		NFA<Object, NFAState, Void> v;
		GenericNFAMatcher<Object, NFAState> m;

		v = NFAParser.parse("(ab)*");
		m = new GenericNFAMatcher<Object, NFAState>(v);
		assertTrue(m.match(""));
		assertTrue(m.match("ab"));
		assertTrue(m.match("abab"));
		assertFalse(m.match("aba"));
	}

	public void test0009() throws Exception {
		NFA<Object, NFAState, Void> v;
		GenericNFAMatcher<Object, NFAState> m;

		v = NFAParser.parse("(ab)+");
		m = new GenericNFAMatcher<Object, NFAState>(v);
		assertTrue(m.match("ab"));
		assertTrue(m.match("abab"));
		assertFalse(m.match(""));
		assertFalse(m.match("aba"));
	}

	public void test0010() throws Exception {
		NFA<Object, NFAState, Void> v;
		GenericNFAMatcher<Object, NFAState> m;

		v = NFAParser.parse("(ab)?");
		m = new GenericNFAMatcher<Object, NFAState>(v);
		assertTrue(m.match(""));
		assertTrue(m.match("ab"));
		assertFalse(m.match("abab"));
		assertFalse(m.match("aba"));
	}

	public void test0011() throws Exception {
		NFA<Object, NFAState, Void> v;
		GenericNFAMatcher<Object, NFAState> m;

		v = NFAParser.parse("a(b|c)*d");
		m = new GenericNFAMatcher<Object, NFAState>(v);
		assertTrue(m.match("ad"));
		assertTrue(m.match("abd"));
		assertTrue(m.match("acd"));
		assertTrue(m.match("abcd"));
		assertTrue(m.match("abcbd"));
		assertFalse(m.match("azd"));
	}

}
