/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.nina;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import net.morilib.automata.DFA;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/10/13
 */
public final class Nina {

	private Nina() {}

	//
	static Object prendClasse(String s) {
		return prendClasse("", s);
	}

	//
	static Object prendClasse(String d, String n) {
		String s = n;
		Class<?> c;

		try {
			if(s.indexOf('.') < 0)  s = d + "." + n;
			c = Class.forName(s);
			return c.newInstance();
		} catch(ClassNotFoundException e) {
			throw new NinaParseException(e);
		} catch(InstantiationException e) {
			throw new NinaParseException(e);
		} catch(IllegalAccessException e) {
			throw new NinaParseException(e);
		}
	}

	//
	@SuppressWarnings({ "rawtypes", "unchecked" })
	static void apelle(Object o, String s, Object... os) {
		Class[] a = new Class[os.length];
		Class c = o.getClass();
		Method m;

		try {
			for(int i = 0; i < os.length; i++) {
				a[i] = os[i].getClass();
			}
			m = c.getMethod(s, a);
			m.invoke(o, os);
		} catch(SecurityException e) {
			throw new NinaParseException(e);
		} catch(NoSuchMethodException e) {
			throw new NinaParseException(e);
		} catch(IllegalArgumentException e) {
			throw new NinaParseException(e);
		} catch(IllegalAccessException e) {
			throw new NinaParseException(e);
		} catch(InvocationTargetException e) {
			throw new NinaParseException(e);
		}
	}

	//
	@SuppressWarnings({ "rawtypes", "unchecked" })
	static void apelleInt(Object o, String s, int n) {
		Class c = o.getClass();
		Method m;

		try {
			m = c.getMethod(s, Integer.TYPE);
			m.invoke(o, n);
		} catch(SecurityException e) {
			throw new NinaParseException(e);
		} catch(NoSuchMethodException e) {
			throw new NinaParseException(e);
		} catch(IllegalArgumentException e) {
			throw new NinaParseException(e);
		} catch(IllegalAccessException e) {
			throw new NinaParseException(e);
		} catch(InvocationTargetException e) {
			throw new NinaParseException(e);
		}
	}

	/**
	 * 
	 * @param s
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public static<T> T compile(String s) {
		return (T)NinaParser.compile(QuadroImpl.read(s), null, 0);
	}

	/**
	 * 
	 * @param rd
	 * @return
	 * @throws IOException
	 */
	@SuppressWarnings("unchecked")
	public static<T> T compile(Reader rd) throws IOException {
		return (T)NinaParser.compile(QuadroImpl.read(rd), null, 0);
	}

	/**
	 * 
	 * @param name
	 * @return
	 * @throws IOException
	 */
	@SuppressWarnings("unchecked")
	public static<T> T compileResource(
			String name) throws IOException {
		return (T)NinaParser.compile(QuadroImpl.readResource(name),
				null, 0);
	}

	/**
	 * 
	 * @param s
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public static<T> T trace(String s, boolean pause) {
		return (T)NinaParser.compile(QuadroImpl.read(s), null,
				NinaParser._PRINT | (pause ? NinaParser._PAUSE : 0));
	}

	/**
	 * 
	 * @param rd
	 * @return
	 * @throws IOException
	 */
	@SuppressWarnings("unchecked")
	public static<T> T trace(Reader rd,
			boolean pause) throws IOException {
		return (T)NinaParser.compile(QuadroImpl.read(rd), null,
				NinaParser._PRINT | (pause ? NinaParser._PAUSE : 0));
	}

	/**
	 * 
	 * @param name
	 * @return
	 * @throws IOException
	 */
	@SuppressWarnings("unchecked")
	public static<T> T traceResource(String name,
			boolean pause) throws IOException {
		return (T)NinaParser.compile(QuadroImpl.readResource(name),
				null,
				NinaParser._PRINT | (pause ? NinaParser._PAUSE : 0));
	}

	//
	@SuppressWarnings("unchecked")
	private static NinaPattern cst(Object o) {
		if(o instanceof NinaNFA) {
			return new NinaNFAPattern((NinaNFA)o);
		} else if(o instanceof DFA) {
			return new NinaDFAPattern((DFA<Object, Object, Void>)o);
		} else {
			throw new ClassCastException();
		}
	}

	/**
	 * 
	 * @param s
	 * @return
	 */
	public static NinaPattern pattern(String s) {
		return cst(compile(s));
	}

	/**
	 * 
	 * @param rd
	 * @return
	 * @throws IOException
	 */
	public static NinaPattern pattern(Reader rd) throws IOException {
		return cst(compile(rd));
	}

	/**
	 * 
	 * @param name
	 * @return
	 * @throws IOException
	 */
	public static NinaPattern patternResource(
			String name) throws IOException {
		return cst(compileResource(name));
	}

	/**
	 * 
	 * @param s
	 * @return
	 */
	public static NinaPattern patternTrace(String s, boolean z) {
		return cst(trace(s, z));
	}

	/**
	 * 
	 * @param rd
	 * @return
	 * @throws IOException
	 */
	public static NinaPattern patternTrace(Reader rd,
			boolean z) throws IOException {
		return cst(trace(rd, z));
	}

	/**
	 * 
	 * @param name
	 * @return
	 * @throws IOException
	 */
	public static NinaPattern patternResourceTrace(
			String name, boolean z) throws IOException {
		return cst(traceResource(name, z));
	}

}
