/*
 * Copyright (C) 2007 u6k.yu1@gmail.com, All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *    1. Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *
 *    2. Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *
 *    3. Neither the name of Clarkware Consulting, Inc. nor the names of its
 *       contributors may be used to endorse or promote products derived
 *       from this software without prior written permission. For written
 *       permission, please contact clarkware@clarkware.com.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL
 * CLARKWARE CONSULTING OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN  ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package jp.gr.java_conf.u6k.filelock;

import java.util.ResourceBundle;

/**
 * <p>
 * {@link ResourceBundle}クラスを使用して文字列を取得する機能を提供します。
 * </p>
 * 
 * @version $Id$
 */
final class ResourceUtil {

    /**
     * <p>
     * 外部リソース。
     * </p>
     */
    private static final ResourceBundle RESOURCE = ResourceBundle.getBundle("jp.gr.java_conf.u6k.filelock.resources.filelock");

    private ResourceUtil() {
    }

    /**
     * <p>
     * リソースから文字列を取得します。
     * </p>
     * 
     * @param key
     *            キー。
     * @return 文字列。
     */
    public static String get(String key) {
        return ResourceUtil.RESOURCE.getString(key);
    }

    /**
     * <p>
     * このクラスがロードしている{@link ResourceBundle}インスタンスを返します。
     * </p>
     * 
     * @return このクラスがロードしている{@link ResourceBundle}インスタンス。
     */
    public static ResourceBundle getResourceBundle() {
        return ResourceUtil.RESOURCE;
    }

}
