# -*- coding: utf-8 -*-
# Baxter-Segart Old Chinese Reconstruction

# BSOCR = 'PubReleasePY2011-02-20b-2.txt'
BSOCR = 'BSReconstruction.txt'
SOURCE = File.join(File.dirname(__FILE__), BSOCR)
TARGET = File.join(File.dirname(__FILE__), 'bsocr.pl')
HEADER = ":- module(bsconstruction, [char/6]).\n\n" +
  "% char(Char, Pinyin1, Mci, Mcf, Mct)\n"

class Converter
  def initialize
    @in = File.open(File.join(SOURCE), "r")
    @out = File.open(File.join(TARGET), "w")
  end
  def convert
    @out.print(HEADER)
    @in.readlines.each do |line|
      line.chomp!
      unless line.empty?
        (char, pinyin, pinyin1, mc, mci, mcf, mct, oc, gloss, gsr, utf) =
          line.split(/\t/)
        mc2 = mc.tr_s("'", "?") # TODO: escape -> adds 'gloss'
        mci2 = mci.tr_s("'", "?") # TODO: escape -> adds 'gloss'
        @out.printf("char('%s', '%s', '%s', '%s', '%s', '%s').\n",
                    char, pinyin1, mc2, mci2, mcf, mct) unless mc == "MC"

      end
    end
  end
end

conv = Converter.new
conv.convert
