# YAMLのスキーマによる検証

require 'kwalify'
require 'yaml'

SOURCE_DIR = File.join(File.dirname(__FILE__), '..', 'yml', 'swjz')
SCHEMA_DIR = File.join(File.dirname(__FILE__), '..', 'yml', 'schema')
SCHEMA_FILE = File.join(SCHEMA_DIR, 'biaodian.yml')

class YamlValidator
  def initialize
    schema = Kwalify::Yaml.load_file(SCHEMA_FILE)
    @validator = Kwalify::Validator.new(schema)
    @parser = Kwalify::Yaml::Parser.new(@validator)
  end
  def validate(filename)
    file = File.open(filename)
    doc_count = 0
    YAML.parse_documents(file) do |doc|
      doc_count += 1
      errors = @validator.validate(doc.transform)
      if errors and !errors.empty? then
        for e in errors
          printf("%s> %s %s\n", doc_count, e.path, e.message)
        end
      end
    end
  end
end

validator = YamlValidator.new
Dir.foreach(SOURCE_DIR) do |filename|
  if filename =~ /^.*\.yml$/ then 
    if filename != 'v29.yml' and filename != 'v30.yml' then
      printf("> %s\n", filename)
      validator.validate(File.join(SOURCE_DIR, filename))
    end
  end
end
