# 標点の検証
#   文法 biaodian.citrus
#   サンプル： ../yml/biaodian_sample.yml
#   TODO: TypeErrorの除去

require 'yaml'
require 'rubygems'
require 'citrus'

SOURCE_DIR = File.join(File.dirname(__FILE__), '..', 'yml', 'swjz')
GRAMMAR = File.join(File.dirname(__FILE__), 'lib', 'biaodian')

class BiaodianValidater
  def initialize
    @error_count = 0
    @title = ''
    Citrus.load GRAMMAR
  end
  def check(source_path)
    file = File.open(source_path)
    YAML::parse_documents(file) do |syck|
      doc = syck.transform
      @title = doc['chapter'] if doc['chapter']
      if doc['content'] then
        doc['content'].each do |wordinfo|
          word = wordinfo['word']
          info = wordinfo['content']
          id = wordinfo['id']
          if info then  # 十三篇上糸部 最後 w4672491はinfoなし
            check_sentences(word, id, info)
          end
        end
      end
    end
  end
  def check_sentences(word, id, info)
    info.each do |line|
      if line.has_key?('ex') then
        sentences = line['ex']
        check_explanation(sentences, word, id)
      elsif line.has_key?('dn') then
        sentences = line['dn']
        check_duan_note(sentences, word, id)
      end
    end
  end
  def check_explanation(sentences, word, id)
    check_biadian(sentences, word, id, :sentence_part, 'ex')
  end
  def check_duan_note(sentences, word, id)
    check_biadian(sentences, word, id, :sentence_seq, 'dn')
  end
  def check_biadian(sentences, word, id, root, type)
    begin
      Biaodian.parse(sentences, :root => root)
    rescue Citrus::ParseError => detail
      @error_count += 1
      printf("%s(%s)> %s(%s): %s\n", @error_count, type, word, id, detail)
    rescue TypeError => detail
      printf("%s(%s): %s\n%s\n", word, id, sentences, detail)
    end
  end
end

validater = BiaodianValidater.new
unless ARGV.empty? then
  filename = ARGV[0]
  printf("\n> %s\n", filename)
  validater.check(filename)
else
  Dir.foreach(SOURCE_DIR) do |filename|
    if filename =~ /^.*\.yml$/ then 
      if filename != 'v29.yml' and filename != 'v30.yml' then
        printf("\n> %s\n", filename)
        validater.check(File.join(SOURCE_DIR, filename))
      end
    end
  end
end
