# 説文解字注データのhtmlへの変換
#   暫定版：swjz.xslの利用
#   XSLT 1.0 への修正 result-document(XSLT 2.0)
#   TODO：標点マークアップ

require 'rexml/document'
require 'xml/libxslt'

# xslt = XML::XSLT.new()
# xslt.xsl = 'data/swjz.xsl'
# xslt.xml = 'data/swjz.xml'
#out = xslt.serve()
#print out;

SOURCE_DIR = File.join(File.dirname(__FILE__), '..', 'data')
SOURCE_XML = File.join(SOURCE_DIR, 'swjz.xml')
SOURCE_XSL = File.join(SOURCE_DIR, 'swjz2.xsl')
OUTPUT_DIR = File.join(File.dirname(__FILE__), '..', 'htdocs', 'swjz')

HEADER = '<?xml version="1.0"?>' +
  '<html xmlns="http://www.w3.org/1999/xhtml" lang="zh-tw" xml:lang="zh-tw">' +
  '<head><title>説文解字注データ</title>' +
  '<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />' +
  '</head><body><h1>説文解字注データ</h1><ul>'
FOOTER = '</ul></body></html>'
@out = File.new(File.join(OUTPUT_DIR, '..', 'swjz.html'), 'w')

def chapter_doc(chapter)
  doc = REXML::Document.new
  doc.add(chapter)
  return doc
end
def chaptertitle(chapter)
  title = chapter.elements["chaptertitle"]
  note = title.elements["duan_note"]
  sub = note ? note.text : ""
  return title.text + sub
end
def filename(chapter)
  title = chapter.elements["chaptertitle"]
  chapter_id = title.attribute("id").to_s
  return File.join(OUTPUT_DIR, chapter_id + '.html')
end

@out.printf(HEADER)
doc = REXML::Document.new File.open(SOURCE_XML)
doc.elements.each("*//chapter/") do |chapter|
  xslt = XML::XSLT.new()
  xslt.xsl = SOURCE_XSL
  xslt.xml = chapter_doc(chapter)
  filename = filename(chapter)
  chaptertitle = chaptertitle(chapter)
  @out.printf("<li><a href='%s'>%s</a></li>\n", filename, chaptertitle)
  xslt.save(filename)
  printf("> %s\n", filename)
end
@out.printf(FOOTER)
