require 'erb'

SOURCE_DIR = File.join(File.dirname(__FILE__), '..', 'data')
TARGET_DIR = File.join(File.dirname(__FILE__), '..', 'htdocs')
MAPPING_TABLE = File.join(SOURCE_DIR, 'swfont.txt')

class MyMapper
 extend ERB::DefMethod
  def_erb_method('render()', 'sw2ebas.rhtml')
  def initialize
   @lines = Array.new
    table_file = File.new(MAPPING_TABLE)
    table_file.each_line do |line|
      line.chomp!
      (codepoint, sw, chars) = line.split(/\s/)
#      printf("> %s %s %s\n", codepoint, sw, chars)
      @lines.push([codepoint, sw, chars])
    end
  end
end

out = File.new(File.join(TARGET_DIR, 'sw2ebas.html'), 'w')
out.print MyMapper.new.render()
