# -*- coding: utf-8 -*-
#  Daxuの抜けている箇所を入力する枠

require 'yaml'
require 'erb'
require File.join(File.dirname(__FILE__), 'lib', 'sw_seals')
require File.join(File.dirname(__FILE__), 'lib', 'unicode')
#require File.join(File.dirname(__FILE__), 'lib', 'tex_commands')

SOURCE_DIR = File.join(File.dirname(__FILE__), '..', 'yml', 'daxu')
TARGET_DIR = SOURCE_DIR
TEMPLATE = File.join(File.dirname(__FILE__), 'lib', 'missing_format.ryml')
TARGET = File.join(TARGET_DIR, 'missing.yml')
WORDINFO = "%04i「%s」(%s)"

class FormatMaker
# extend ERB::DefMethod
#  def_erb_method('render()', TEMPLATE)
  def initialize(out)
    @out = out
    @count = 0
    @previous_id = 0
    @previous_wd = ''
    @previous_sw = 0
    @daxu_page = 0
    @wordlist = Array.new
    @unicode = UnicodeUtility.new
    @sw_seals = SWSeals.new
  end
  def check(path)
    chapter = File.basename(path)[0,4]
 #   push_wordinfo(sprintf("\\subsubsection*{%s}", chapter))
    @out.printf("\n# %s\n", chapter)
    YAML::parse_documents(File.open(path)) do |syck|
      doc = syck.transform
      doc.each do |wordinfo|
        check_wordinfo(wordinfo)
      end
    end
  end
  def check_wordinfo(wordinfo)
    id = wordinfo['id']
    wd = wordinfo['wd']
    sw = wordinfo['sw']
    rad = wordinfo['rd']
    daxu = wordinfo['dx']
    duan = wordinfo['dn']
    unless id == @previous_id + 1 then
      @count += 1
      line1 = sprintf("[%i] %i頁: ", @count, daxu)
      line2 = sprintf(WORDINFO, @previous_id, @previous_wd, @previous_sw)
      line3 = sprintf("-" + WORDINFO, id, wd, sw)
      print_wordinfo(line1 + line2 + line3)
#      mssw = @previous_sw.to_s(16).to_i(16) if @previous_sw
      mssw = sprintf("%s", @previous_sw).to_i(16) if @previous_sw
      (@previous_id+1 .. id-1).each do |msid|
        @out.printf("- id: %i\n", msid)
        if mssw then
          mssw += 1 
          (mswd, mssw2) = @sw_seals.next_main(mssw)
          @out.printf("  sw: %X\n", mssw2)
          @out.printf("  wd: %s\n", mswd)
        else
          @out.printf("  sw: \n")
          @out.printf("  wd: \n")
        end
        @out.printf("  rd: %s\n", rad)
        @out.printf("  py: \n")
        @out.printf("  dx: %i\n", daxu)
        @out.printf("  dn: %s\n", duan)
        @out.printf("  fn: \n")
        @out.printf("  ex: \n")
        @out.printf("  dex: \n")
        @out.printf("  xex: \n")
      end
    end
    @previous_id = id
    @previous_wd = wd
    @previous_sw = sw
    @daxu_page = daxu
  end
  def print_wordinfo(info)
    @out.printf("# %s\n", info)
  end
end

out = File.open(File.join(TARGET), "w")
maker = FormatMaker.new(out)
#Dir.foreach(SOURCE_DIR) do |filename|
Dir.entries(SOURCE_DIR).sort.each do |filename|
  if filename =~ /^sw\d{2}\.yml$/ then 
#    if filename =~ /^sw01.yml$/ then 
    maker.check(File.join(SOURCE_DIR, filename))
  end
end

