# -*- coding: utf-8 -*-
#  Daxuの抜けをチェックする

require 'yaml'
require 'erb'
require File.join(File.dirname(__FILE__), 'lib', 'sw_seals')
require File.join(File.dirname(__FILE__), 'lib', 'unicode')
require File.join(File.dirname(__FILE__), 'lib', 'tex_commands')

SOURCE_DIR = File.join(File.dirname(__FILE__), '..', 'yml', 'daxu')
TEMPLATE = File.join(File.dirname(__FILE__), 'lib', 'missing.rtex')
TARGET = File.join(File.dirname(__FILE__), 'tmp', 'mlist.tex')
WORDINFO = "%04i「%s」(%s)"

class SealChecker
 extend ERB::DefMethod
  def_erb_method('render()', TEMPLATE)
  def initialize
    @count = 0
    @previous_id = 0
    @previous_wd = ''
    @previous_sw = 0
    @daxu_page = 0
    @wordlist = Array.new
    @unicode = UnicodeUtility.new
    @sw_seals = SWSeals.new
    @tex_commands = TeXCommands.new
  end
  def check(path)
    chapter = File.basename(path)[0,4]
    push_wordinfo(sprintf("\\subsubsection*{%s}", chapter))
    YAML::parse_documents(File.open(path)) do |syck|
      doc = syck.transform
      doc.each do |wordinfo|
        check_wordinfo(wordinfo)
      end
    end
  end
  def check_wordinfo(wordinfo)
    id = wordinfo['id']
    wd = wordinfo['wd']
    sw = wordinfo['sw']
    daxu = wordinfo['dx']
    unless id == @previous_id + 1 then
      @count += 1 
      line1 = sprintf("%i>~%i頁:~", @count, daxu)
      line2 = sprintf(WORDINFO, @previous_id, @previous_wd, @previous_sw)
      line3 = sprintf("-" + WORDINFO + "\\hspace{2em}", id, wd, sw)
      missing = '' # TODO
      mssw = sprintf("%s", @previous_sw).to_i(16) if @previous_sw
      (@previous_id+1 .. id-1).each do |msid|
        if mssw then
          mssw += 1 
          (mswd, mssw2) = @sw_seals.next_main(mssw)
          missing += sprintf("%s(%X)\\hspace{1em}", mswd, mssw2)
        end
      end
      push_wordinfo(line1 + line2 + line3 + missing)
    end
    @previous_id = id
    @previous_wd = wd
    @previous_sw = sw
    @daxu_page = daxu
  end
  def push_wordinfo(info)
    einfo = @tex_commands.insert_extensions(info)
    @wordlist.push(einfo)
  end
end

checker = SealChecker.new
#Dir.foreach(SOURCE_DIR) do |filename|
Dir.entries(SOURCE_DIR).sort.each do |filename|
  if filename =~ /^sw\d{2}\.yml$/ then 
#    if filename =~ /^sw01.yml$/ then 
    printf("\n> %s\n", filename)
    checker.check(File.join(SOURCE_DIR, filename))
  end
end
out = File.open(File.join(TARGET), "w")
out.print checker.render()
