# -*- coding: utf-8 -*-
# TeXコマンドの挿入用ユーティリティ

require 'rubygems'
require 'citrus'
require File.join(File.dirname(__FILE__), 'unicode')
COMMANDS = File.join(File.dirname(__FILE__), 'commands')

class TeXCommands
  def initialize
    @unicode = UnicodeUtility.new
    Citrus.load COMMANDS
  end
  def apply_commands(str)
    astr = replace_commands(str)
    return insert_extensions(astr)
  end

  def insert_extensions(str)
    # CJI Unified Extension(CJK_UNIFIED_EXT_Aは除く)に対して
    # TEXコマンド \extを挿入
    return '' unless str
    regexp = @unicode.extension_regexp
    result = ''
    while m = regexp.match(str) do
      result += m.pre_match + "{\\ext " + m[0] + "}"
      str = m.post_match 
    end
    result += str
    return result
  end
  def replace_commands(str)
    if str then
      match = Commands.parse(str, :root => :phrase)
      return match.value
    else
      return ''
    end
  end
end
