# -*- coding: utf-8 -*-
# 大徐の篆文を扱うライブラリ

require File.join(File.dirname(__FILE__), 'unicode')
SW_FILE = File.join(File.dirname(__FILE__), '..', '..', 'data', 'swfont.txt')

# TODO: テーブルファイルへの変更
#  <wordid, ebas_char>
DUAN_SEALS = {
  '0020010' => '上',
  '0020040' => '下',
  '0060210' =>'玊',
  '006022A' => '叡',
}

class SWSeals
  def initialize
    @unicode = UnicodeUtility.new
    @sw_table = Hash.new  # table[wordid] = char
    @wid_table = Hash.new  # table[codehex] = [wordid, unicode]
    load_sw_table
  end
  def load_sw_table
    File.open(SW_FILE) do |file|
      file.readlines.each do |line|
        line.chomp!
        (code, wordid, unicodes) = line.split("\s")
        set_sw_table(wordid, code)
        set_wid_table(code, wordid, unicodes)
      end
    end
  end
  def set_sw_table(wordid, code)
    char = @unicode.ucs2char("U+" + code) 
    @sw_table[wordid] = char
  end

  #--- Library Functions
  def wordid2char(wordid)
    return @sw_table[wordid]
  end
  def get_char(wordid)
    return wordid2char(wordid)
  end
  def get_type(wordid)
    if variant?(wordid)
      return 'variant'
    else
      return 'main'
    end
  end
  def variant?(wordid)
    variant = wordid[-1]
    if variant == 0x30 then # '0'
      return false
    else
      return true
    end
  end
  def main?(wordid)
    return ! variant?(wordid)
  end
  def get_duan_seal(wordid)
    # 大徐にない篆文を段注から取る
    return DUAN_SEALS[wordid]
  end

  #--- Auxiliary Functions ---
  def set_wid_table(code, wordid, unicodes)
    codehex = code.to_i(16)
    if unicodes =~ /^(.)/u then
      @wid_table[codehex] = [wordid, $1]
    end
  end
  def next_main(codehex)
    (wordid, unicode) = @wid_table[codehex]
    while variant?(wordid) do
      codehex += 1
      (wordid, unicode) = @wid_table[codehex]
    end
    return [unicode, codehex]
  end
end
