%-*- Prolog -*-
:- module(finals, [she/2, rhyme/5, final/4]).

% she(+She, -RhymeList).
% rhyme(Name, ?Ping, ?Sheng, ?Qu, ?Ru)
% final(+Name, +Division:Int, -FinalList, -FinalRuList)

she('通', ['東', '冬', '鍾']).
she('江', ['江']).
she('止', ['支', '脂', '之', '微']).
she('遇', ['魚', '虞', '模']).
she('蟹', ['齊', '祭', '泰', '佳', '皆', '夬', '灰', '咍', '廢']).
she('臻', ['眞', '諄', '臻', '文', '欣']).
she('山', ['元', '寒', '桓', '刪', '山', '先', '仙']).
she('效', ['蕭', '宵', '肴', '豪']).
she('果', ['歌']).
she('假', ['麻']).
she('宕', ['陽', '唐']).
she('梗', ['庚', '耕', '清', '青']).
she('曾', ['蒸', '登']).
she('流', ['尤', '侯', '幽']).
she('咸', ['覃', '談', '鹽', '添', '咸', '銜', '嚴', '凡']).
she('深', ['侵']).

% rhyme(Name, ?Ping, ?Sheng, ?Qu, ?Ru)
%% 1. 通攝
rhyme('東', '東', '董', '送', '屋').
rhyme('冬', '冬', '湩', '宋', '沃').
rhyme('鍾', '鍾', '腫', '用', '燭').
%% 2. 江攝
rhyme('江', '江', '講', '絳', '覺').
%% 3. 止攝
rhyme('支', '支', '紙', '寘', nil).
rhyme('脂', '脂', '旨', '至', nil).
rhyme('之', '之', '止', '志', nil).
rhyme('微', '微', '尾', '未', nil).
%% 4. 遇攝
rhyme('魚', '魚', '語', '御', nil).
rhyme('虞', '虞', '麌', '遇', nil).
rhyme('模', '模', '姥', '暮', nil).
%% 5. 蟹攝
rhyme('齊', '齊', '薺', '霽', nil).
rhyme('祭', nil, nil, '祭', nil).
rhyme('泰', nil, nil, '泰', nil).
rhyme('佳', '佳', '蟹', '卦', nil).
rhyme('皆', '皆', '駭', '怪', nil).
rhyme('夬', nil, nil, nil, nil).
rhyme('灰', '灰', '賄', '隊', nil).
rhyme('咍', '咍', '海', '代', nil).
rhyme('廢', nil, nil, '廢', nil).
%% 6. 臻攝
rhyme('眞', '眞', '軫', '震', '質').
% rhyme('諄', '諄', '準', '稕', '術').
rhyme('臻', '臻', '𧤛', '櫬', '櫛').
rhyme('文', '文', '吻', '問', '物').
rhyme('欣', '欣', '隱', '焮', '迄').
rhyme('魂', '魂', '混', '慁', '沒').
rhyme('痕', '痕', '很', '恨', '麧').
%% 7. 山攝
rhyme('元', '元', '阮', '願', '月').
rhyme('寒', '寒', '旱', '翰', '曷').
%rhyme('桓', '桓', '緩', '換', '末').
rhyme('刪', '刪', '潸', '諫', '黠').
rhyme('山', '山', '產', '襇', '鎋').
rhyme('先', '先', '銑', '霰', '屑').
rhyme('仙', '仙', '獮', '線', '薛').
%% 8. 效攝
rhyme('蕭', '蕭', '篠', '嘯', nil).
rhyme('宵', '宵', '小', '笑', nil).
rhyme('肴', '肴', '巧', '效', nil).
rhyme('豪', '豪', '晧', '号', nil).
%% 9. 果攝
rhyme('歌', '歌', '哿', '箇', nil).
% rhyme('戈', '戈', '果', '過', nil).
%% 10. 假攝
rhyme('麻', '麻', '馬', '禡', nil).
%% 11. 宕攝
rhyme('陽', '陽', '養', '漾', '藥').
rhyme('唐', '唐', '蕩', '宕', '鐸').
%% 12. 梗攝
rhyme('庚', '庚', '梗', '映', '陌').
rhyme('耕', '耕', '耿', '諍', '麥').
rhyme('清', '清', '靜', '勁', '昔').
rhyme('青', '青', '迥', '徑', '錫').
%% 13. 曾攝
rhyme('蒸', '蒸', '拯', '證', '職').
rhyme('登', '登', '等', '嶝', '德').
%% 14. 流攝
rhyme('尤', '尤', '有', '宥', nil).
rhyme('侯', '侯', '厚', '候', nil).
rhyme('幽', '幽', '黝', '幼', nil).
%% 15. 咸攝
rhyme('覃', '覃', '感', '勘', '合').
rhyme('談', '談', '敢', '闞', '盍').
rhyme('鹽', '鹽', '琰', '豔', '葉').
rhyme('添', '添', '忝', '㮇', '怗').
rhyme('咸', '咸', '豏', '陷', '洽').
rhyme('銜', '銜', '檻', '鑑', '狎').
rhyme('嚴', '嚴', '儼', '釅', '業').
rhyme('凡', '凡', '梵', '范', '乏').
%% 16. 深攝
rhyme('侵', '侵', '寑', '沁', '緝').

% final(+Name, +Division:Int, -FinalList, -FinalRuList)
%% 1. 通攝
%%     東 董 送 屋
%%     冬 湩 宋 沃
%%     鍾 腫 用 燭
final('東', 1, ['uwng'], ['uwk']).
final('冬', 1, ['owng'], ['owk']).
final('東', 3, ['juwng'], ['juwk']).
final('鍾', 3, ['jowng'], ['jowk']).

%% 2. 江攝
%%     江 講 絳 覺
final('江', 2, ['aewng'], ['aewk']).

%% 3. 止攝
%%     支A 紙A 寘A
%%     支B 紙B 寘B
%%     脂A 旨A 至A
%%     脂B 旨B 至B
%%     之 止 志
%%     微 尾 未
final('支', 3, ['je', 'jwe', 'jie', 'jwie'], nil).
final('脂', 3, ['ij', 'wij', 'jij', 'jwij'], nil).
final('之', 3, ['i'], nil).
final('微', 3, ['j+j', 'jw+j'], nil).

%% 4. 遇攝
%%     魚 語 御
%%     虞 麌 遇
%%     模 姥 暮
final('模', 1, ['u'], nil).
final('魚', 3, ['jo'], nil).
final('虞', 3, ['ju'], nil).

%% 5. 蟹攝
%%     齊 薺 霽
%%     祭A
%%     祭B
%%     泰
%%     佳 蟹 卦
%%     皆 駭 怪
%%     夬
%%     灰 賄 隊
%%     咍 海 代
%%     廢
final('咍', 1, ['oj'], nil).
final('灰', 1, ['woj'], nil).
final('泰', 1, ['aj', 'waj'], nil).     /* qusheng only */
final('皆', 2, ['eaj', 'weaj'], nil).
final('佳', 2, ['ea+', 'wea+'], nil).
final('夬', 2, ['aej', 'waej'], nil).   /* qusheng only */
final('祭', 3, ['jwej', 'jwiej'], nil). /* qusheng only */
final('廢', 3, ['joj', 'jwoj'], nil).   /* qusheng only */
final('齊', 4, ['ej', 'wej'], nil).

%% 6. 臻攝
%%     眞A 軫A 震A 質A
%%     眞B 軫B 震B 質B
%%  *  諄 準 稕 術
%%     臻 𧤛 櫬 櫛
%%     文 吻 問 物
%%     欣 隱 焮 迄
%%     魂 混 慁 沒
%%     痕 很 恨 麧
final('痕', 1, ['on'], ['ot']).
final('魂', 1, ['won'], ['wot']).
final('臻', 3, ['in'], ['it']).
final('眞', 3, ['in', 'win', 'jin', 'jwin'], ['it', 'wit', 'jit', 'jwit']).
final('欣', 3, ['j+n'], ['j+t']).
final('文', 3, ['jun'], ['jut']).

%% 7. 山攝
%%     元 阮 願 月
%%     寒 旱 翰 曷
%%  *  桓 緩 換 末
%%     刪 潸 諫 黠
%%     山 產 襇 鎋
%%     先 銑 霰 屑
%%     仙A 獮A 線A 薛A
%%     仙B 獮B 線B 薛B
final('寒', 1, ['an', 'wan'], ['at', 'wat']).
final('刪', 2, ['aen', 'waen'], ['aet', 'waet']).
final('山', 2, ['ean', 'wean'], ['eat', 'weat']).
final('仙', 3, ['jen', 'jwen', 'jien', 'jwien'],
      ['jet', 'jwet', 'jiet', 'jwiet']).
final('元', 3, ['jon', 'jwon'], ['jot', 'jwot']).
final('先', 4, ['en', 'wen'], ['et', 'wet']).

%% 8. 效攝
%%     蕭 篠 嘯
%%     宵A 小A 笑A
%%     宵B 小B 笑B
%%     肴 巧 效
%%     豪 晧 号
final('豪', 1, ['aw'], nil).
final('肴', 2, ['aew'], nil).
final('宵', 3, ['jew', 'jiew'], nil). 
final('蕭', 4, ['ew'], nil).

%% 9. 果攝
%%     歌 哿 箇
%% *   戈 果 過
final('歌', 1, ['a', 'wa'], nil). 
final('歌', 3, ['ja', 'jwa'], nil).

%% 10. 假攝
%%     麻 馬 禡
final('麻', 2, ['ae', 'wae'], nil).
final('麻', 3, ['jae'], nil).

%% 11. 宕攝
%%     陽 養 漾 藥
%%     唐 蕩 宕 鐸
final('唐', 1, ['ang', 'wang'], ['ak', 'wak']).
final('陽', 3, ['jang', 'jwang'], ['jak', 'jwak']).

%% 12. 梗攝
%%     庚 梗 映 陌
%%     耕 耿 諍 麥
%%     清 靜 勁 昔
%%     青 迥 徑 錫
final('庚', 2, ['aeng', 'waeng'], ['aek', 'waek']).
final('耕', 2, ['eang', 'weang'], ['eak', 'weak']).
final('庚', 3, ['jaeng', 'jwaeng'], ['jaek', 'jwaek']).
final('清', 3, ['jeng', 'jweng', 'jieng', 'jwieng'],
      ['jek', 'jwek', 'jiek', 'jwiek']).
final('青', 4, ['eng', 'weng'], ['ek', 'wek']).

%% 13. 曾攝
%%     蒸 拯 證 職
%%     登 等 嶝 德
final('登', 1, ['ong', 'wong'], ['ok', 'wok']).
final('蒸', 3, ['ing', 'wing'], ['ik', 'wik']).

%% 14. 流攝
%%     尤 有 宥
%%     侯 厚 候
%%     幽 黝 幼
final('侯', 1, ['uw'], nil).
final('尤', 3, ['juw'], nil).
final('幽', 3, ['iw', 'jiw'], nil).

%% 15. 咸攝
%%     覃 感 勘 合
%%     談 敢 闞 盍
%%     鹽A 琰A 豔A 葉A
%%     鹽B 琰B 豔B 葉B
%%     添 忝 㮇 怗
%%     咸 豏 陷 洽
%%     銜 檻 鑑 狎
%%     嚴 儼 釅 業
%%     凡 梵 范 乏
final('覃', 1, ['om'], ['op']).
final('談', 1, ['am'], ['ap']).
final('咸', 2, ['eam'], ['eap']).
final('銜', 2, ['aem'], ['aep']).
final('鹽', 3, ['jem', 'jiem'], ['jep', 'jiep']).
final('嚴', 3, ['jaem'], ['jaep']).
final('凡', 3, ['jom'], ['jop']).
final('添', 4, ['em'], ['ep']).

%% 16. 深攝
%%     侵A 寑A 沁A 緝A
%%     侵B 寑B 沁B 緝B
final('侵', 3, ['im', 'jim'], ['ip', 'jip']).
