# -*- coding: utf-8 -*-
# YAMLからTeXファイルを生成する
#    template: dx2tex.rtex

require 'yaml'
require 'erb'
require File.join(File.dirname(__FILE__), 'lib', 'sw_seals')
require File.join(File.dirname(__FILE__), 'lib', 'unicode')
require File.join(File.dirname(__FILE__), 'lib', 'tex_commands')

SOURCE_DIR = File.join(File.dirname(__FILE__), '..', 'yml', 'daxu')
TARGET_DIR = File.join(File.dirname(__FILE__), '..', 'tex', 'daxu')
TEMPLATE = File.join(File.dirname(__FILE__), 'lib', 'dx2tex.rtex')

class TexConverter
 extend ERB::DefMethod
  def_erb_method('render()', TEMPLATE)
  def initialize(source_path)
    @sw_seals = SWSeals.new
    @unicode = UnicodeUtility.new
    @tex_commands = TeXCommands.new
    @wordlist = Array.new
    @daxu_page = 0
    @title = File.basename(source_path)[0,4]
    parse(File.open(source_path))
  end
  def parse(file)
    YAML::parse_documents(file) do |syck|
      doc = syck.transform
      doc.each do |wordinfo|
        push_wordinfo(wordinfo)
      end
    end
  end
  def push_wordinfo(wordinfo)
    # TODO: 情報の加工
    id = sprintf("%04i", wordinfo['id'])
    word = wordinfo['wd']
    seal = wordinfo['sw'].to_s
    sealchar = 'none'
    sealchar = @unicode.ucs2char('U+' + seal) unless seal.empty?
    eword = @tex_commands.insert_extensions(word)
    pinyin = wordinfo['py']
    fanqie = @tex_commands.insert_extensions(wordinfo['fn'])
    exp = @tex_commands.insert_extensions(wordinfo['ex'])
    duan = wordinfo['dn']
    daxu = wordinfo['dx']
    daexp = @tex_commands.insert_extensions(wordinfo['dex'])
    xiaoexp = @tex_commands.insert_extensions(wordinfo['xex'])
    if daxu then
      unless @daxu_page == daxu then
        @wordlist.push(['page', daxu])
        @daxu_page = daxu
      end
    end
    @wordlist.push([id, eword, sealchar, seal, pinyin, fanqie,
                    exp, daexp, xiaoexp])
  end
end

unless ARGV.empty? then
  filename = ARGV[0]
  printf("\n%% %s\n", filename)
  converter = TexConverter.new(filename)
  print converter.render()
else
  Dir.foreach(SOURCE_DIR) do |filename|
    if filename =~ /^.*\.yml$/ then 
#    if filename =~ /^sw01.yml$/ then 
      printf("\n> %s\n", filename)
      converter = TexConverter.new(File.join(SOURCE_DIR, filename))
      outfile = File.basename(filename, 'yml') + 'tex'
      out = File.open(File.join(TARGET_DIR, outfile), "w")
      out.print converter.render()
    end
  end
end
