# -*- coding: utf-8 -*-
# YAMLからsqlを生成する

require 'yaml'
require 'erb'
#require File.join(File.dirname(__FILE__), 'lib', 'sw_seals')
require File.join(File.dirname(__FILE__), 'lib', 'unicode')

SOURCE_DIR = File.join(File.dirname(__FILE__), '..', 'yml', 'daxu')
TARGET_DIR = File.join(File.dirname(__FILE__), '..', 'sql', 'daxu')

VOLUMES = {
  1 => '一',
  2 => '二',
  3 => '三',
  4 => '四',
  5 => '五',
  6 => '六',
  7 => '七',
  8 => '八',
  9 => '九',
  10 => '十',
  11 => '十一',
  12 => '十二',
  13 => '十三',
  14 => '十四',
}

class SqlConverter
# extend ERB::DefMethod
  @@rad_total = 0
  @@volume = 0
  def initialize(filename)
    @unicode = UnicodeUtility.new
    source = File.join(SOURCE_DIR, filename)
    target = File.basename(filename, 'yml') + 'sql'
    @out = File.open(File.join(TARGET_DIR, target), "w")
    @radical = ''
    @rad_count = 0
    check(File.open(source))
  end
  def check(file)
    YAML::parse_documents(file) do |syck|
#      printf("%s\n", get_volume_title(@@volume))
      create_volume(@@volume)
      doc = syck.transform
      doc.each do |wordinfo|
#        check_radical(wordinfo)
        check_word_info(wordinfo)
      end
    end
    printf("Radicals: %i\n", @rad_count)
  end
  def check_word_info(wordinfo)
    wordid = sprintf("%04i", wordinfo['id'])
    word = wordinfo['wd']
    radical = wordinfo['rd']
    sw = @unicode.ucs2char("U+" + wordinfo['sw'].to_s)
    pinyin = wordinfo['py']
    fanqie = wordinfo['fn']
    exp = wordinfo['ex']
    dexp = wordinfo['dex']
    xexp = wordinfo['xex']
    check_radical_info(radical)
    create_wordhead(word, wordid, sw, pinyin, fanqie, exp, @@rad_total)
  end
  def check_radical_info(radical)
    if @radical != radical then
      @radical = radical
      @rad_count += 1
      @@rad_total += 1
      create_radical(radical, @@rad_total, @@volume)
    end
  end

  # Temp
  def check_radical(wordinfo)
    id = sprintf("%04i", wordinfo['id'])
    word = wordinfo['wd']
    radical = wordinfo['rd']
    if word == radical then
      @radical = radical
      @rad_count += 1
      @@rad_total += 1
    elsif radical != @radical then
      printf("%s: Missing a radical %s of %s\n", id, radical, word)
    end
  end
  def get_volume_title(num)
    return sprintf("說文解字第%s篇", VOLUMES[num])
  end

  # Create SQL statements
  def create_volume(num)
    title = get_volume_title(num)
    insert = "INSERT INTO dx_volumes (title, num)\n" +
      "  VALUES ('%s', '%s');\n"
    @out.printf(insert, title, num)
  end
  def create_radical(name, num, volume_num)
    insert = "INSERT INTO dx_radicals (name, num, volume_id)\n" +
      "  SELECT '%s', '%s', v.id FROM dx_volumes v WHERE v.num = '%s';\n"
    @out.printf(insert, name, num, volume_num)
  end
  def create_wordhead(name, wordid, sw, pinyin, fanqie, exp, radical_num)
    # TODO: 重文データの追加
    insert = "INSERT INTO dx_wordheads (name, wordid, sw, pinyin, fanqie, exp, radical_id)\n" +
      "  SELECT '%s', '%s', '%s', '%s', '%s', '%s', r.id FROM dx_radicals r WHERE r.num = '%s';\n"
    @out.printf(insert, name, wordid, sw, pinyin, fanqie, exp, radical_num)
  end

  # 現在は未使用(重文データを追加後に使用)
  def create_character(xmlid, wordid)
    insert = "INSERT INTO dx_characters (xmlid, wordid)\n" +
      "  VALUES('%s', '%s');\n"
    @out.printf(insert, xmlid, wordid)
  end

  def SqlConverter.rad_total
    return @@rad_total
  end
  def SqlConverter.inc_volume_num
    return @@volume += 1
  end
end

#Dir.foreach(SOURCE_DIR) do |filename|
Dir.entries(SOURCE_DIR).sort.each do |filename|
#  if filename =~ /^sw01\.yml$/ then 
  if filename =~ /^sw.*\.yml$/ then 
    printf("\n> %s\n", filename)
    SqlConverter.inc_volume_num
    converter = SqlConverter.new(filename)
  end
end
printf("Total: %i\n", SqlConverter.rad_total)
