# -*- coding: utf-8 -*-
# YAMLからTeXファイルを生成する
#    template: bd2tex.rtex
#
# [1] 篆文(見出し)の表示: 暫定(SWを基本、段注にしかない文字をEBASで表示)
# [2] partとvolumeの表示に差を付ける
# [3] Ext B, C, DにTeXコマンドの追加

# TODO:
#    [1] 篆文(見出し、説解、段注)の表示
#    [2] 標点符号のTeXコマンドによる表示

require 'yaml'
require 'yaml/dbm'
require 'erb'
require File.join(File.dirname(__FILE__), 'lib', 'sw_seals')
#require File.join(File.dirname(__FILE__), 'lib', 'unicode')
require File.join(File.dirname(__FILE__), 'lib', 'tex_commands')

SOURCE_DIR = File.join(File.dirname(__FILE__), '..', 'yml', 'swjz')
TARGET_DIR = File.join(File.dirname(__FILE__), '..', 'tex', 'swjz')

class TexConverter
 extend ERB::DefMethod
  def_erb_method('render()', 'bd2tex.rtex')
  def initialize(source_path)
    @sw_seals = SWSeals.new
#    @unicode = UnicodeUtility.new
    @tex_commands = TeXCommands.new
    @title = ''
    @wordlist = Array.new
    parse(File.open(source_path))
  end
  def parse(file)
    YAML::parse_documents(file) do |syck|
      doc = syck.transform
      parse_chapter(doc)
      parse_content(doc)
      parse_wordnum(doc)
    end
  end
  def parse_chapter(doc)
    @title = doc['chapter'] if doc['chapter']
  end
  def parse_content(doc)
    if doc['content'] then
      doc['content'].each do |wordinfo|
        # TODO: positionの付加
        word = wordinfo['word']
        info = wordinfo['content']
        wwordid = wordinfo['id']
        wordid = wwordid.delete('w')
        push_word(word, wordid, info)
#        printf("%s ", word)
      end
    end
  end
  def push_word(word, wordid, info)
    duan_seal = @sw_seals.get_duan_seal(wordid)
    if duan_seal then
      type = 'ebas'
      char = duan_seal
    else
      type = 'sw'
      char = @sw_seals.get_char(wordid)
    end
    if @sw_seals.variant?(wordid) then
      char = "\\hspace{1em}" + char if char
    end
#    ext_word = @unicode.replace_extensions(word)
    ext_word = @tex_commands.insert_extensions(word)
    if info then
      ext_info = add_extension_commands(info)
      push_wordlist([type, ext_word, char, wordid], ext_info)
    else
      push_wordlist([type, ext_word, char, wordid], [])  # 十三篇上糸部 最後 w4672491
    end
  end
  def parse_wordnum(doc)
    if doc.has_key?('part') then
      push_wordnum('part', doc)
    elsif doc.has_key?('volume')
      push_wordnum('volume', doc)
    end
  end
  def push_wordnum(type, doc)
    lines = doc[type]
    if lines then
      added = add_extension_commands(lines)
      push_wordlist(type, added)
    else
      push_wordlist(type, [])
    end
  end
  def push_wordlist(type, content)
    @wordlist.push([type, content])
  end
  def add_extension_commands(lines)
    # replace {\ext char} for char of
    # CJK Unified Extension B, C and D
    return "" unless lines
    lines.each do |line|
      if line.has_key?('ex') then
        content = line['ex']
#        line['ex'] = @tex_commands.insert_extensions(content)
        line['ex'] = @tex_commands.apply_commands(content)        
      elsif line.has_key?('dn') then
        content = line['dn']
#        line['dn'] = @tex_commands.insert_extensions(content)
        line['dn'] = @tex_commands.apply_commands(content)
      end
    end
  end
end

unless ARGV.empty? then
  filename = ARGV[0]
  printf("\n%% %s\n", filename)
  converter = TexConverter.new(filename)
  print converter.render()
else
  Dir.foreach(SOURCE_DIR) do |filename|
    if filename =~ /^.*\.yml$/ then 
      if filename != 'v29.yml' and filename != 'v30.yml' then
        printf("\n> %s\n", filename)
        converter = TexConverter.new(File.join(SOURCE_DIR, filename))
        outfile = File.basename(filename, 'yml') + 'tex'
        out = File.open(File.join(TARGET_DIR, outfile), "w")
        out.print converter.render()
      end
    end
  end
end
