package hayashi.yuu.register;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class AboutDialog extends JDialog implements WindowListener
{
    static final String TITLE = CardRegister.PROGRAM_NAME;
    static final String COPY_RIGHT = "All rights reserved.Copyright(c) 2010,, Yuu Hayashi.";

    JLabel label1;
    JButton okButton;
    JLabel label2;
    JTextArea textArea;
    JFrame parent;

    public AboutDialog(JFrame parent, boolean modal) {
        super(parent, modal);
        addWindowListener(this);
        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);

        this.parent = parent;
        setTitle("About...");
        getContentPane().setLayout(new BorderLayout());
        setSize(512,320);
        
		//--------------------------------------------------------
		// 上部パネル
		//-----------------------------------------------
        label1 = new JLabel(TITLE, JLabel.CENTER);
        add(BorderLayout.NORTH, label1);
        
		//--------------------------------------------------------
		// 中央パネル
		//-----------------------------------------------
        
        /*
         * [README.txt]ファイルの内容を表示するTEXTAREA
         */
        textArea = new JTextArea(7, 60);
        textArea.setEditable(false);
        textArea.setFont(new Font(Font.MONOSPACED, Font.PLAIN, 12));
		JScrollPane scrollPane = new JScrollPane(textArea);
		scrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
		add(BorderLayout.CENTER, scrollPane);
		
		URL url = getClass().getResource("/README.txt");
		InputStream is;
		try {
			is = url.openStream();
			BufferedReader br = new BufferedReader(new InputStreamReader(is));
			while (br.ready()) {
				textArea.append(br.readLine() + "\n");
			}
			textArea.setCaretPosition(0);
			br.close();
			is.close();
		} catch (IOException e) {
			e.printStackTrace();
		}

		//--------------------------------------------------------
		// 下部パネル
		//-----------------------------------------------
		JPanel bottonPanel = new JPanel();
		bottonPanel.setLayout(new BorderLayout());
		add(BorderLayout.SOUTH, bottonPanel);

		/*
		 * [OK]ボタン　:　このダイアログウインドウを閉じる
		 */
		okButton = new JButton("OK");
        okButton.setBounds(145,65,66,27);
        okButton.addActionListener(new java.awt.event.ActionListener() {
        	public void actionPerformed(java.awt.event.ActionEvent evt) {
        		Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent(AboutDialog.this, WindowEvent.WINDOW_CLOSING));
        		setVisible(false);
        	}
        });
        JPanel okPanel = new JPanel(new FlowLayout());
        try {
        	okPanel.add(okButton);
        }
        catch(Exception e) {
            e.printStackTrace();
            CardRegister.logger.warning(e.toString());
        }
        bottonPanel.add(BorderLayout.CENTER, okPanel);
        
        /*
         * コピーライト表示
         */
        label2 = new JLabel(COPY_RIGHT, JLabel.CENTER);
        label2.setBounds(10,40,340,20);
        bottonPanel.add(BorderLayout.SOUTH, label2);
        
        setVisible(true);
    }

    /**
    * Shows or hides the component depending on the boolean flag b.
    * @param b  if true, show the component; otherwise, hide the component.
    * @see java.awt.Component#isVisible
    */
    public void setVisible(boolean b) {
        if (b) {
            Rectangle bounds = getParent().getBounds();
            Rectangle abounds = getBounds();
            setLocation(bounds.x + (bounds.width - abounds.width)/ 2,
            bounds.y + (bounds.height - abounds.height)/2);
        }
        super.setVisible(b);
    }

	public void windowClosed(WindowEvent e) {
		setVisible(false);
    }

	public void windowActivated(WindowEvent arg0) {
	}

	public void windowClosing(WindowEvent arg0) {
		setVisible(false);
	}

	public void windowDeactivated(WindowEvent arg0) {
	}

	public void windowDeiconified(WindowEvent arg0) {
	}

	public void windowIconified(WindowEvent arg0) {
	}

	public void windowOpened(WindowEvent arg0) {
	}
}
