; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -fast-isel -mtriple=i386-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefixes=CHECK,X86,SSE,X86-SSE
; RUN: llc < %s -fast-isel -mtriple=i386-unknown-unknown -mattr=+avx | FileCheck %s --check-prefixes=CHECK,X86,AVX,X86-AVX,AVX1,X86-AVX1
; RUN: llc < %s -fast-isel -mtriple=i386-unknown-unknown -mattr=+avx512f,+avx512bw,+avx512dq,+avx512vl | FileCheck %s --check-prefixes=CHECK,X86,AVX,X86-AVX,AVX512,X86-AVX512
; RUN: llc < %s -fast-isel -mtriple=x86_64-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefixes=CHECK,X64,SSE,X64-SSE
; RUN: llc < %s -fast-isel -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefixes=CHECK,X64,AVX,X64-AVX,AVX1,X64-AVX1
; RUN: llc < %s -fast-isel -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512bw,+avx512dq,+avx512vl | FileCheck %s --check-prefixes=CHECK,X64,AVX,X64-AVX,AVX512,X64-AVX512

; NOTE: This should use IR equivalent to what is generated by clang/test/CodeGen/sse2-builtins.c

define <2 x i64> @test_mm_add_epi8(<2 x i64> %a0, <2 x i64> %a1) nounwind {
; SSE-LABEL: test_mm_add_epi8:
; SSE:       # %bb.0:
; SSE-NEXT:    paddb %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_add_epi8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <16 x i8>
  %arg1 = bitcast <2 x i64> %a1 to <16 x i8>
  %res = add <16 x i8> %arg0, %arg1
  %bc = bitcast <16 x i8> %res to <2 x i64>
  ret <2 x i64> %bc
}

define <2 x i64> @test_mm_add_epi16(<2 x i64> %a0, <2 x i64> %a1) nounwind {
; SSE-LABEL: test_mm_add_epi16:
; SSE:       # %bb.0:
; SSE-NEXT:    paddw %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_add_epi16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <8 x i16>
  %arg1 = bitcast <2 x i64> %a1 to <8 x i16>
  %res = add <8 x i16> %arg0, %arg1
  %bc = bitcast <8 x i16> %res to <2 x i64>
  ret <2 x i64> %bc
}

define <2 x i64> @test_mm_add_epi32(<2 x i64> %a0, <2 x i64> %a1) nounwind {
; SSE-LABEL: test_mm_add_epi32:
; SSE:       # %bb.0:
; SSE-NEXT:    paddd %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_add_epi32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <4 x i32>
  %arg1 = bitcast <2 x i64> %a1 to <4 x i32>
  %res = add <4 x i32> %arg0, %arg1
  %bc = bitcast <4 x i32> %res to <2 x i64>
  ret <2 x i64> %bc
}

define <2 x i64> @test_mm_add_epi64(<2 x i64> %a0, <2 x i64> %a1) nounwind {
; SSE-LABEL: test_mm_add_epi64:
; SSE:       # %bb.0:
; SSE-NEXT:    paddq %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_add_epi64:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %res = add <2 x i64> %a0, %a1
  ret <2 x i64> %res
}

define <2 x double> @test_mm_add_pd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_add_pd:
; SSE:       # %bb.0:
; SSE-NEXT:    addpd %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_add_pd:
; AVX:       # %bb.0:
; AVX-NEXT:    vaddpd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %res = fadd <2 x double> %a0, %a1
  ret <2 x double> %res
}

define <2 x double> @test_mm_add_sd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_add_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    addsd %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_add_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    vaddsd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %ext0 = extractelement <2 x double> %a0, i32 0
  %ext1 = extractelement <2 x double> %a1, i32 0
  %fadd = fadd double %ext0, %ext1
  %res = insertelement <2 x double> %a0, double %fadd, i32 0
  ret <2 x double> %res
}

define <2 x i64> @test_mm_adds_epi8(<2 x i64> %a0, <2 x i64> %a1) nounwind {
; SSE-LABEL: test_mm_adds_epi8:
; SSE:       # %bb.0:
; SSE-NEXT:    paddsb %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_adds_epi8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddsb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <16 x i8>
  %arg1 = bitcast <2 x i64> %a1 to <16 x i8>
  %res = call <16 x i8> @llvm.x86.sse2.padds.b(<16 x i8> %arg0, <16 x i8> %arg1)
  %bc = bitcast <16 x i8> %res to <2 x i64>
  ret <2 x i64> %bc
}
declare <16 x i8> @llvm.x86.sse2.padds.b(<16 x i8>, <16 x i8>) nounwind readnone

define <2 x i64> @test_mm_adds_epi16(<2 x i64> %a0, <2 x i64> %a1) nounwind {
; SSE-LABEL: test_mm_adds_epi16:
; SSE:       # %bb.0:
; SSE-NEXT:    paddsw %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_adds_epi16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddsw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <8 x i16>
  %arg1 = bitcast <2 x i64> %a1 to <8 x i16>
  %res = call <8 x i16> @llvm.x86.sse2.padds.w(<8 x i16> %arg0, <8 x i16> %arg1)
  %bc = bitcast <8 x i16> %res to <2 x i64>
  ret <2 x i64> %bc
}
declare <8 x i16> @llvm.x86.sse2.padds.w(<8 x i16>, <8 x i16>) nounwind readnone

define <2 x i64> @test_mm_adds_epu8(<2 x i64> %a0, <2 x i64> %a1) nounwind {
; SSE-LABEL: test_mm_adds_epu8:
; SSE:       # %bb.0:
; SSE-NEXT:    paddusb %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_adds_epu8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddusb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <16 x i8>
  %arg1 = bitcast <2 x i64> %a1 to <16 x i8>
  %res = call <16 x i8> @llvm.x86.sse2.paddus.b(<16 x i8> %arg0, <16 x i8> %arg1)
  %bc = bitcast <16 x i8> %res to <2 x i64>
  ret <2 x i64> %bc
}
declare <16 x i8> @llvm.x86.sse2.paddus.b(<16 x i8>, <16 x i8>) nounwind readnone

define <2 x i64> @test_mm_adds_epu16(<2 x i64> %a0, <2 x i64> %a1) nounwind {
; SSE-LABEL: test_mm_adds_epu16:
; SSE:       # %bb.0:
; SSE-NEXT:    paddusw %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_adds_epu16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddusw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <8 x i16>
  %arg1 = bitcast <2 x i64> %a1 to <8 x i16>
  %res = call <8 x i16> @llvm.x86.sse2.paddus.w(<8 x i16> %arg0, <8 x i16> %arg1)
  %bc = bitcast <8 x i16> %res to <2 x i64>
  ret <2 x i64> %bc
}
declare <8 x i16> @llvm.x86.sse2.paddus.w(<8 x i16>, <8 x i16>) nounwind readnone

define <2 x double> @test_mm_and_pd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_and_pd:
; SSE:       # %bb.0:
; SSE-NEXT:    andps %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_and_pd:
; AVX:       # %bb.0:
; AVX-NEXT:    vandps %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x double> %a0 to <4 x i32>
  %arg1 = bitcast <2 x double> %a1 to <4 x i32>
  %res = and <4 x i32> %arg0, %arg1
  %bc = bitcast <4 x i32> %res to <2 x double>
  ret <2 x double> %bc
}

define <2 x i64> @test_mm_and_si128(<2 x i64> %a0, <2 x i64> %a1) nounwind {
; SSE-LABEL: test_mm_and_si128:
; SSE:       # %bb.0:
; SSE-NEXT:    andps %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_and_si128:
; AVX:       # %bb.0:
; AVX-NEXT:    vandps %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %res = and <2 x i64> %a0, %a1
  ret <2 x i64> %res
}

define <2 x double> @test_mm_andnot_pd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_andnot_pd:
; SSE:       # %bb.0:
; SSE-NEXT:    andnps %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_andnot_pd:
; AVX:       # %bb.0:
; AVX-NEXT:    vandnps %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x double> %a0 to <4 x i32>
  %arg1 = bitcast <2 x double> %a1 to <4 x i32>
  %not = xor <4 x i32> %arg0, <i32 -1, i32 -1, i32 -1, i32 -1>
  %res = and <4 x i32> %not, %arg1
  %bc = bitcast <4 x i32> %res to <2 x double>
  ret <2 x double> %bc
}

define <2 x i64> @test_mm_andnot_si128(<2 x i64> %a0, <2 x i64> %a1) nounwind {
; SSE-LABEL: test_mm_andnot_si128:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE-NEXT:    pxor %xmm2, %xmm0
; SSE-NEXT:    pand %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1-LABEL: test_mm_andnot_si128:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpxor %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    ret{{[l|q]}}
;
; AVX512-LABEL: test_mm_andnot_si128:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpternlogq $15, %xmm0, %xmm0, %xmm0
; AVX512-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    ret{{[l|q]}}
  %not = xor <2 x i64> %a0, <i64 -1, i64 -1>
  %res = and <2 x i64> %not, %a1
  ret <2 x i64> %res
}

define <2 x i64> @test_mm_avg_epu8(<2 x i64> %a0, <2 x i64> %a1) nounwind {
; SSE-LABEL: test_mm_avg_epu8:
; SSE:       # %bb.0:
; SSE-NEXT:    pavgb %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1-LABEL: test_mm_avg_epu8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpavgb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    ret{{[l|q]}}
;
; AVX512-LABEL: test_mm_avg_epu8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovzxbw {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero,xmm0[8],zero,xmm0[9],zero,xmm0[10],zero,xmm0[11],zero,xmm0[12],zero,xmm0[13],zero,xmm0[14],zero,xmm0[15],zero
; AVX512-NEXT:    vpmovzxbw {{.*#+}} ymm1 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero,xmm1[8],zero,xmm1[9],zero,xmm1[10],zero,xmm1[11],zero,xmm1[12],zero,xmm1[13],zero,xmm1[14],zero,xmm1[15],zero
; AVX512-NEXT:    vpaddw %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512-NEXT:    vpsubw %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpsrlw $1, %ymm0, %ymm0
; AVX512-NEXT:    vpmovwb %ymm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <16 x i8>
  %arg1 = bitcast <2 x i64> %a1 to <16 x i8>
  %zext0 = zext <16 x i8> %arg0 to <16 x i16>
  %zext1 = zext <16 x i8> %arg1 to <16 x i16>
  %add = add <16 x i16> %zext0, %zext1
  %add1 = add <16 x i16> %add, <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  %lshr = lshr <16 x i16> %add1, <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  %res = trunc <16 x i16> %lshr to <16 x i8>
  %bc = bitcast <16 x i8> %res to <2 x i64>
  ret <2 x i64> %bc
}

define <2 x i64> @test_mm_avg_epu16(<2 x i64> %a0, <2 x i64> %a1) nounwind {
; SSE-LABEL: test_mm_avg_epu16:
; SSE:       # %bb.0:
; SSE-NEXT:    pavgw %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1-LABEL: test_mm_avg_epu16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpavgw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    ret{{[l|q]}}
;
; AVX512-LABEL: test_mm_avg_epu16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX512-NEXT:    vpmovzxwd {{.*#+}} ymm1 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero
; AVX512-NEXT:    vpaddd %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512-NEXT:    vpsubd %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpsrld $1, %ymm0, %ymm0
; AVX512-NEXT:    vpmovdw %ymm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <8 x i16>
  %arg1 = bitcast <2 x i64> %a1 to <8 x i16>
  %zext0 = zext <8 x i16> %arg0 to <8 x i32>
  %zext1 = zext <8 x i16> %arg1 to <8 x i32>
  %add = add <8 x i32> %zext0, %zext1
  %add1 = add <8 x i32> %add, <i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>
  %lshr = lshr <8 x i32> %add1, <i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>
  %res = trunc <8 x i32> %lshr to <8 x i16>
  %bc = bitcast <8 x i16> %res to <2 x i64>
  ret <2 x i64> %bc
}

define <2 x i64> @test_mm_bslli_si128(<2 x i64> %a0) nounwind {
; SSE-LABEL: test_mm_bslli_si128:
; SSE:       # %bb.0:
; SSE-NEXT:    pslldq {{.*#+}} xmm0 = zero,zero,zero,zero,zero,xmm0[0,1,2,3,4,5,6,7,8,9,10]
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_bslli_si128:
; AVX:       # %bb.0:
; AVX-NEXT:    vpslldq {{.*#+}} xmm0 = zero,zero,zero,zero,zero,xmm0[0,1,2,3,4,5,6,7,8,9,10]
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <16 x i8>
  %res = shufflevector <16 x i8> zeroinitializer, <16 x i8> %arg0, <16 x i32> <i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26>
  %bc = bitcast <16 x i8> %res to <2 x i64>
  ret <2 x i64> %bc
}

define <2 x i64> @test_mm_bsrli_si128(<2 x i64> %a0) nounwind {
; SSE-LABEL: test_mm_bsrli_si128:
; SSE:       # %bb.0:
; SSE-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[5,6,7,8,9,10,11,12,13,14,15],zero,zero,zero,zero,zero
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_bsrli_si128:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsrldq {{.*#+}} xmm0 = xmm0[5,6,7,8,9,10,11,12,13,14,15],zero,zero,zero,zero,zero
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <16 x i8>
  %res = shufflevector <16 x i8> %arg0, <16 x i8> zeroinitializer, <16 x i32> <i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20>
  %bc = bitcast <16 x i8> %res to <2 x i64>
  ret <2 x i64> %bc
}

define <4 x float> @test_mm_castpd_ps(<2 x double> %a0) nounwind {
; CHECK-LABEL: test_mm_castpd_ps:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ret{{[l|q]}}
  %res = bitcast <2 x double> %a0 to <4 x float>
  ret <4 x float> %res
}

define <2 x i64> @test_mm_castpd_si128(<2 x double> %a0) nounwind {
; CHECK-LABEL: test_mm_castpd_si128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ret{{[l|q]}}
  %res = bitcast <2 x double> %a0 to <2 x i64>
  ret <2 x i64> %res
}

define <2 x double> @test_mm_castps_pd(<4 x float> %a0) nounwind {
; CHECK-LABEL: test_mm_castps_pd:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ret{{[l|q]}}
  %res = bitcast <4 x float> %a0 to <2 x double>
  ret <2 x double> %res
}

define <2 x i64> @test_mm_castps_si128(<4 x float> %a0) nounwind {
; CHECK-LABEL: test_mm_castps_si128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ret{{[l|q]}}
  %res = bitcast <4 x float> %a0 to <2 x i64>
  ret <2 x i64> %res
}

define <2 x double> @test_mm_castsi128_pd(<2 x i64> %a0) nounwind {
; CHECK-LABEL: test_mm_castsi128_pd:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ret{{[l|q]}}
  %res = bitcast <2 x i64> %a0 to <2 x double>
  ret <2 x double> %res
}

define <4 x float> @test_mm_castsi128_ps(<2 x i64> %a0) nounwind {
; CHECK-LABEL: test_mm_castsi128_ps:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ret{{[l|q]}}
  %res = bitcast <2 x i64> %a0 to <4 x float>
  ret <4 x float> %res
}

define void @test_mm_clflush(i8* %a0) nounwind {
; X86-LABEL: test_mm_clflush:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    clflush (%eax)
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_clflush:
; X64:       # %bb.0:
; X64-NEXT:    clflush (%rdi)
; X64-NEXT:    retq
  call void @llvm.x86.sse2.clflush(i8* %a0)
  ret void
}
declare void @llvm.x86.sse2.clflush(i8*) nounwind readnone

define <2 x i64> @test_mm_cmpeq_epi8(<2 x i64> %a0, <2 x i64> %a1) nounwind {
; SSE-LABEL: test_mm_cmpeq_epi8:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqb %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1-LABEL: test_mm_cmpeq_epi8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpcmpeqb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    ret{{[l|q]}}
;
; AVX512-LABEL: test_mm_cmpeq_epi8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpcmpeqb %xmm1, %xmm0, %k0
; AVX512-NEXT:    vpmovm2b %k0, %xmm0
; AVX512-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <16 x i8>
  %arg1 = bitcast <2 x i64> %a1 to <16 x i8>
  %cmp = icmp eq <16 x i8> %arg0, %arg1
  %res = sext <16 x i1> %cmp to <16 x i8>
  %bc = bitcast <16 x i8> %res to <2 x i64>
  ret <2 x i64> %bc
}

define <2 x i64> @test_mm_cmpeq_epi16(<2 x i64> %a0, <2 x i64> %a1) nounwind {
; SSE-LABEL: test_mm_cmpeq_epi16:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqw %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1-LABEL: test_mm_cmpeq_epi16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpcmpeqw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    ret{{[l|q]}}
;
; AVX512-LABEL: test_mm_cmpeq_epi16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpcmpeqw %xmm1, %xmm0, %k0
; AVX512-NEXT:    vpmovm2w %k0, %xmm0
; AVX512-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <8 x i16>
  %arg1 = bitcast <2 x i64> %a1 to <8 x i16>
  %cmp = icmp eq <8 x i16> %arg0, %arg1
  %res = sext <8 x i1> %cmp to <8 x i16>
  %bc = bitcast <8 x i16> %res to <2 x i64>
  ret <2 x i64> %bc
}

define <2 x i64> @test_mm_cmpeq_epi32(<2 x i64> %a0, <2 x i64> %a1) nounwind {
; SSE-LABEL: test_mm_cmpeq_epi32:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1-LABEL: test_mm_cmpeq_epi32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpcmpeqd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    ret{{[l|q]}}
;
; AVX512-LABEL: test_mm_cmpeq_epi32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpcmpeqd %xmm1, %xmm0, %k0
; AVX512-NEXT:    vpmovm2d %k0, %xmm0
; AVX512-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <4 x i32>
  %arg1 = bitcast <2 x i64> %a1 to <4 x i32>
  %cmp = icmp eq <4 x i32> %arg0, %arg1
  %res = sext <4 x i1> %cmp to <4 x i32>
  %bc = bitcast <4 x i32> %res to <2 x i64>
  ret <2 x i64> %bc
}

define <2 x double> @test_mm_cmpeq_pd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_cmpeq_pd:
; SSE:       # %bb.0:
; SSE-NEXT:    cmpeqpd %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1-LABEL: test_mm_cmpeq_pd:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vcmpeqpd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    ret{{[l|q]}}
;
; AVX512-LABEL: test_mm_cmpeq_pd:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vcmpeqpd %xmm1, %xmm0, %k0
; AVX512-NEXT:    vpmovm2q %k0, %xmm0
; AVX512-NEXT:    ret{{[l|q]}}
  %fcmp = fcmp oeq <2 x double> %a0, %a1
  %sext = sext <2 x i1> %fcmp to <2 x i64>
  %res = bitcast <2 x i64> %sext to <2 x double>
  ret <2 x double> %res
}

define <2 x double> @test_mm_cmpeq_sd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_cmpeq_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    cmpeqsd %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_cmpeq_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    vcmpeqsd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %res = call <2 x double> @llvm.x86.sse2.cmp.sd(<2 x double> %a0, <2 x double> %a1, i8 0)
  ret <2 x double> %res
}
declare <2 x double> @llvm.x86.sse2.cmp.sd(<2 x double>, <2 x double>, i8) nounwind readnone

define <2 x double> @test_mm_cmpge_pd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_cmpge_pd:
; SSE:       # %bb.0:
; SSE-NEXT:    cmplepd %xmm0, %xmm1
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1-LABEL: test_mm_cmpge_pd:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vcmplepd %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    ret{{[l|q]}}
;
; AVX512-LABEL: test_mm_cmpge_pd:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vcmplepd %xmm0, %xmm1, %k0
; AVX512-NEXT:    vpmovm2q %k0, %xmm0
; AVX512-NEXT:    ret{{[l|q]}}
  %fcmp = fcmp ole <2 x double> %a1, %a0
  %sext = sext <2 x i1> %fcmp to <2 x i64>
  %res = bitcast <2 x i64> %sext to <2 x double>
  ret <2 x double> %res
}

define <2 x double> @test_mm_cmpge_sd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_cmpge_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    cmplesd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm1[0],xmm0[1]
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1-LABEL: test_mm_cmpge_sd:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vcmplesd %xmm0, %xmm1, %xmm1
; AVX1-NEXT:    vblendpd {{.*#+}} xmm0 = xmm1[0],xmm0[1]
; AVX1-NEXT:    ret{{[l|q]}}
;
; AVX512-LABEL: test_mm_cmpge_sd:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vcmplesd %xmm0, %xmm1, %xmm1
; AVX512-NEXT:    vmovsd {{.*#+}} xmm0 = xmm1[0],xmm0[1]
; AVX512-NEXT:    ret{{[l|q]}}
  %cmp = call <2 x double> @llvm.x86.sse2.cmp.sd(<2 x double> %a1, <2 x double> %a0, i8 2)
  %ext0 = extractelement <2 x double> %cmp, i32 0
  %ins0 = insertelement <2 x double> undef, double %ext0, i32 0
  %ext1 = extractelement <2 x double> %a0, i32 1
  %ins1 = insertelement <2 x double> %ins0, double %ext1, i32 1
  ret <2 x double> %ins1
}

define <2 x i64> @test_mm_cmpgt_epi8(<2 x i64> %a0, <2 x i64> %a1) nounwind {
; SSE-LABEL: test_mm_cmpgt_epi8:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpgtb %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1-LABEL: test_mm_cmpgt_epi8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpcmpgtb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    ret{{[l|q]}}
;
; AVX512-LABEL: test_mm_cmpgt_epi8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpcmpgtb %xmm1, %xmm0, %k0
; AVX512-NEXT:    vpmovm2b %k0, %xmm0
; AVX512-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <16 x i8>
  %arg1 = bitcast <2 x i64> %a1 to <16 x i8>
  %cmp = icmp sgt <16 x i8> %arg0, %arg1
  %res = sext <16 x i1> %cmp to <16 x i8>
  %bc = bitcast <16 x i8> %res to <2 x i64>
  ret <2 x i64> %bc
}

define <2 x i64> @test_mm_cmpgt_epi16(<2 x i64> %a0, <2 x i64> %a1) nounwind {
; SSE-LABEL: test_mm_cmpgt_epi16:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpgtw %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1-LABEL: test_mm_cmpgt_epi16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpcmpgtw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    ret{{[l|q]}}
;
; AVX512-LABEL: test_mm_cmpgt_epi16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpcmpgtw %xmm1, %xmm0, %k0
; AVX512-NEXT:    vpmovm2w %k0, %xmm0
; AVX512-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <8 x i16>
  %arg1 = bitcast <2 x i64> %a1 to <8 x i16>
  %cmp = icmp sgt <8 x i16> %arg0, %arg1
  %res = sext <8 x i1> %cmp to <8 x i16>
  %bc = bitcast <8 x i16> %res to <2 x i64>
  ret <2 x i64> %bc
}

define <2 x i64> @test_mm_cmpgt_epi32(<2 x i64> %a0, <2 x i64> %a1) nounwind {
; SSE-LABEL: test_mm_cmpgt_epi32:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpgtd %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1-LABEL: test_mm_cmpgt_epi32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpcmpgtd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    ret{{[l|q]}}
;
; AVX512-LABEL: test_mm_cmpgt_epi32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpcmpgtd %xmm1, %xmm0, %k0
; AVX512-NEXT:    vpmovm2d %k0, %xmm0
; AVX512-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <4 x i32>
  %arg1 = bitcast <2 x i64> %a1 to <4 x i32>
  %cmp = icmp sgt <4 x i32> %arg0, %arg1
  %res = sext <4 x i1> %cmp to <4 x i32>
  %bc = bitcast <4 x i32> %res to <2 x i64>
  ret <2 x i64> %bc
}

define <2 x double> @test_mm_cmpgt_pd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_cmpgt_pd:
; SSE:       # %bb.0:
; SSE-NEXT:    cmpltpd %xmm0, %xmm1
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1-LABEL: test_mm_cmpgt_pd:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vcmpltpd %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    ret{{[l|q]}}
;
; AVX512-LABEL: test_mm_cmpgt_pd:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vcmpltpd %xmm0, %xmm1, %k0
; AVX512-NEXT:    vpmovm2q %k0, %xmm0
; AVX512-NEXT:    ret{{[l|q]}}
  %fcmp = fcmp olt <2 x double> %a1, %a0
  %sext = sext <2 x i1> %fcmp to <2 x i64>
  %res = bitcast <2 x i64> %sext to <2 x double>
  ret <2 x double> %res
}

define <2 x double> @test_mm_cmpgt_sd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_cmpgt_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    cmpltsd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm1[0],xmm0[1]
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1-LABEL: test_mm_cmpgt_sd:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vcmpltsd %xmm0, %xmm1, %xmm1
; AVX1-NEXT:    vblendpd {{.*#+}} xmm0 = xmm1[0],xmm0[1]
; AVX1-NEXT:    ret{{[l|q]}}
;
; AVX512-LABEL: test_mm_cmpgt_sd:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vcmpltsd %xmm0, %xmm1, %xmm1
; AVX512-NEXT:    vmovsd {{.*#+}} xmm0 = xmm1[0],xmm0[1]
; AVX512-NEXT:    ret{{[l|q]}}
  %cmp = call <2 x double> @llvm.x86.sse2.cmp.sd(<2 x double> %a1, <2 x double> %a0, i8 1)
  %ext0 = extractelement <2 x double> %cmp, i32 0
  %ins0 = insertelement <2 x double> undef, double %ext0, i32 0
  %ext1 = extractelement <2 x double> %a0, i32 1
  %ins1 = insertelement <2 x double> %ins0, double %ext1, i32 1
  ret <2 x double> %ins1
}

define <2 x double> @test_mm_cmple_pd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_cmple_pd:
; SSE:       # %bb.0:
; SSE-NEXT:    cmplepd %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1-LABEL: test_mm_cmple_pd:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vcmplepd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    ret{{[l|q]}}
;
; AVX512-LABEL: test_mm_cmple_pd:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vcmplepd %xmm1, %xmm0, %k0
; AVX512-NEXT:    vpmovm2q %k0, %xmm0
; AVX512-NEXT:    ret{{[l|q]}}
  %fcmp = fcmp ole <2 x double> %a0, %a1
  %sext = sext <2 x i1> %fcmp to <2 x i64>
  %res = bitcast <2 x i64> %sext to <2 x double>
  ret <2 x double> %res
}

define <2 x double> @test_mm_cmple_sd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_cmple_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    cmplesd %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_cmple_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    vcmplesd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %res = call <2 x double> @llvm.x86.sse2.cmp.sd(<2 x double> %a0, <2 x double> %a1, i8 2)
  ret <2 x double> %res
}

define <2 x i64> @test_mm_cmplt_epi8(<2 x i64> %a0, <2 x i64> %a1) nounwind {
; SSE-LABEL: test_mm_cmplt_epi8:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpgtb %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1-LABEL: test_mm_cmplt_epi8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpcmpgtb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    ret{{[l|q]}}
;
; AVX512-LABEL: test_mm_cmplt_epi8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpcmpgtb %xmm0, %xmm1, %k0
; AVX512-NEXT:    vpmovm2b %k0, %xmm0
; AVX512-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <16 x i8>
  %arg1 = bitcast <2 x i64> %a1 to <16 x i8>
  %cmp = icmp sgt <16 x i8> %arg1, %arg0
  %res = sext <16 x i1> %cmp to <16 x i8>
  %bc = bitcast <16 x i8> %res to <2 x i64>
  ret <2 x i64> %bc
}

define <2 x i64> @test_mm_cmplt_epi16(<2 x i64> %a0, <2 x i64> %a1) nounwind {
; SSE-LABEL: test_mm_cmplt_epi16:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpgtw %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1-LABEL: test_mm_cmplt_epi16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpcmpgtw %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    ret{{[l|q]}}
;
; AVX512-LABEL: test_mm_cmplt_epi16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpcmpgtw %xmm0, %xmm1, %k0
; AVX512-NEXT:    vpmovm2w %k0, %xmm0
; AVX512-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <8 x i16>
  %arg1 = bitcast <2 x i64> %a1 to <8 x i16>
  %cmp = icmp sgt <8 x i16> %arg1, %arg0
  %res = sext <8 x i1> %cmp to <8 x i16>
  %bc = bitcast <8 x i16> %res to <2 x i64>
  ret <2 x i64> %bc
}

define <2 x i64> @test_mm_cmplt_epi32(<2 x i64> %a0, <2 x i64> %a1) nounwind {
; SSE-LABEL: test_mm_cmplt_epi32:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpgtd %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1-LABEL: test_mm_cmplt_epi32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpcmpgtd %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    ret{{[l|q]}}
;
; AVX512-LABEL: test_mm_cmplt_epi32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpcmpgtd %xmm0, %xmm1, %k0
; AVX512-NEXT:    vpmovm2d %k0, %xmm0
; AVX512-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <4 x i32>
  %arg1 = bitcast <2 x i64> %a1 to <4 x i32>
  %cmp = icmp sgt <4 x i32> %arg1, %arg0
  %res = sext <4 x i1> %cmp to <4 x i32>
  %bc = bitcast <4 x i32> %res to <2 x i64>
  ret <2 x i64> %bc
}

define <2 x double> @test_mm_cmplt_pd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_cmplt_pd:
; SSE:       # %bb.0:
; SSE-NEXT:    cmpltpd %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1-LABEL: test_mm_cmplt_pd:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vcmpltpd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    ret{{[l|q]}}
;
; AVX512-LABEL: test_mm_cmplt_pd:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vcmpltpd %xmm1, %xmm0, %k0
; AVX512-NEXT:    vpmovm2q %k0, %xmm0
; AVX512-NEXT:    ret{{[l|q]}}
  %fcmp = fcmp olt <2 x double> %a0, %a1
  %sext = sext <2 x i1> %fcmp to <2 x i64>
  %res = bitcast <2 x i64> %sext to <2 x double>
  ret <2 x double> %res
}

define <2 x double> @test_mm_cmplt_sd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_cmplt_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    cmpltsd %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_cmplt_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    vcmpltsd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %res = call <2 x double> @llvm.x86.sse2.cmp.sd(<2 x double> %a0, <2 x double> %a1, i8 1)
  ret <2 x double> %res
}

define <2 x double> @test_mm_cmpneq_pd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_cmpneq_pd:
; SSE:       # %bb.0:
; SSE-NEXT:    cmpneqpd %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1-LABEL: test_mm_cmpneq_pd:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vcmpneqpd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    ret{{[l|q]}}
;
; AVX512-LABEL: test_mm_cmpneq_pd:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vcmpneqpd %xmm1, %xmm0, %k0
; AVX512-NEXT:    vpmovm2q %k0, %xmm0
; AVX512-NEXT:    ret{{[l|q]}}
  %fcmp = fcmp une <2 x double> %a0, %a1
  %sext = sext <2 x i1> %fcmp to <2 x i64>
  %res = bitcast <2 x i64> %sext to <2 x double>
  ret <2 x double> %res
}

define <2 x double> @test_mm_cmpneq_sd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_cmpneq_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    cmpneqsd %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_cmpneq_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    vcmpneqsd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %res = call <2 x double> @llvm.x86.sse2.cmp.sd(<2 x double> %a0, <2 x double> %a1, i8 4)
  ret <2 x double> %res
}

define <2 x double> @test_mm_cmpnge_pd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_cmpnge_pd:
; SSE:       # %bb.0:
; SSE-NEXT:    cmpnlepd %xmm0, %xmm1
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1-LABEL: test_mm_cmpnge_pd:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vcmpnlepd %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    ret{{[l|q]}}
;
; AVX512-LABEL: test_mm_cmpnge_pd:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vcmpnlepd %xmm0, %xmm1, %k0
; AVX512-NEXT:    vpmovm2q %k0, %xmm0
; AVX512-NEXT:    ret{{[l|q]}}
  %fcmp = fcmp ugt <2 x double> %a1, %a0
  %sext = sext <2 x i1> %fcmp to <2 x i64>
  %res = bitcast <2 x i64> %sext to <2 x double>
  ret <2 x double> %res
}

define <2 x double> @test_mm_cmpnge_sd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_cmpnge_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    cmpnlesd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm1[0],xmm0[1]
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1-LABEL: test_mm_cmpnge_sd:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vcmpnlesd %xmm0, %xmm1, %xmm1
; AVX1-NEXT:    vblendpd {{.*#+}} xmm0 = xmm1[0],xmm0[1]
; AVX1-NEXT:    ret{{[l|q]}}
;
; AVX512-LABEL: test_mm_cmpnge_sd:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vcmpnlesd %xmm0, %xmm1, %xmm1
; AVX512-NEXT:    vmovsd {{.*#+}} xmm0 = xmm1[0],xmm0[1]
; AVX512-NEXT:    ret{{[l|q]}}
  %cmp = call <2 x double> @llvm.x86.sse2.cmp.sd(<2 x double> %a1, <2 x double> %a0, i8 6)
  %ext0 = extractelement <2 x double> %cmp, i32 0
  %ins0 = insertelement <2 x double> undef, double %ext0, i32 0
  %ext1 = extractelement <2 x double> %a0, i32 1
  %ins1 = insertelement <2 x double> %ins0, double %ext1, i32 1
  ret <2 x double> %ins1
}

define <2 x double> @test_mm_cmpngt_pd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_cmpngt_pd:
; SSE:       # %bb.0:
; SSE-NEXT:    cmpnltpd %xmm0, %xmm1
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1-LABEL: test_mm_cmpngt_pd:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vcmpnltpd %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    ret{{[l|q]}}
;
; AVX512-LABEL: test_mm_cmpngt_pd:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vcmpnltpd %xmm0, %xmm1, %k0
; AVX512-NEXT:    vpmovm2q %k0, %xmm0
; AVX512-NEXT:    ret{{[l|q]}}
  %fcmp = fcmp uge <2 x double> %a1, %a0
  %sext = sext <2 x i1> %fcmp to <2 x i64>
  %res = bitcast <2 x i64> %sext to <2 x double>
  ret <2 x double> %res
}

define <2 x double> @test_mm_cmpngt_sd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_cmpngt_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    cmpnltsd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm1[0],xmm0[1]
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1-LABEL: test_mm_cmpngt_sd:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vcmpnltsd %xmm0, %xmm1, %xmm1
; AVX1-NEXT:    vblendpd {{.*#+}} xmm0 = xmm1[0],xmm0[1]
; AVX1-NEXT:    ret{{[l|q]}}
;
; AVX512-LABEL: test_mm_cmpngt_sd:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vcmpnltsd %xmm0, %xmm1, %xmm1
; AVX512-NEXT:    vmovsd {{.*#+}} xmm0 = xmm1[0],xmm0[1]
; AVX512-NEXT:    ret{{[l|q]}}
  %cmp = call <2 x double> @llvm.x86.sse2.cmp.sd(<2 x double> %a1, <2 x double> %a0, i8 5)
  %ext0 = extractelement <2 x double> %cmp, i32 0
  %ins0 = insertelement <2 x double> undef, double %ext0, i32 0
  %ext1 = extractelement <2 x double> %a0, i32 1
  %ins1 = insertelement <2 x double> %ins0, double %ext1, i32 1
  ret <2 x double> %ins1
}

define <2 x double> @test_mm_cmpnle_pd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_cmpnle_pd:
; SSE:       # %bb.0:
; SSE-NEXT:    cmpnlepd %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1-LABEL: test_mm_cmpnle_pd:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vcmpnlepd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    ret{{[l|q]}}
;
; AVX512-LABEL: test_mm_cmpnle_pd:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vcmpnlepd %xmm1, %xmm0, %k0
; AVX512-NEXT:    vpmovm2q %k0, %xmm0
; AVX512-NEXT:    ret{{[l|q]}}
  %fcmp = fcmp ugt <2 x double> %a0, %a1
  %sext = sext <2 x i1> %fcmp to <2 x i64>
  %res = bitcast <2 x i64> %sext to <2 x double>
  ret <2 x double> %res
}

define <2 x double> @test_mm_cmpnle_sd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_cmpnle_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    cmpnlesd %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_cmpnle_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    vcmpnlesd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %res = call <2 x double> @llvm.x86.sse2.cmp.sd(<2 x double> %a0, <2 x double> %a1, i8 6)
  ret <2 x double> %res
}

define <2 x double> @test_mm_cmpnlt_pd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_cmpnlt_pd:
; SSE:       # %bb.0:
; SSE-NEXT:    cmpnltpd %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1-LABEL: test_mm_cmpnlt_pd:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vcmpnltpd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    ret{{[l|q]}}
;
; AVX512-LABEL: test_mm_cmpnlt_pd:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vcmpnltpd %xmm1, %xmm0, %k0
; AVX512-NEXT:    vpmovm2q %k0, %xmm0
; AVX512-NEXT:    ret{{[l|q]}}
  %fcmp = fcmp uge <2 x double> %a0, %a1
  %sext = sext <2 x i1> %fcmp to <2 x i64>
  %res = bitcast <2 x i64> %sext to <2 x double>
  ret <2 x double> %res
}

define <2 x double> @test_mm_cmpnlt_sd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_cmpnlt_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    cmpnltsd %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_cmpnlt_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    vcmpnltsd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %res = call <2 x double> @llvm.x86.sse2.cmp.sd(<2 x double> %a0, <2 x double> %a1, i8 5)
  ret <2 x double> %res
}

define <2 x double> @test_mm_cmpord_pd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_cmpord_pd:
; SSE:       # %bb.0:
; SSE-NEXT:    cmpordpd %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1-LABEL: test_mm_cmpord_pd:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vcmpordpd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    ret{{[l|q]}}
;
; AVX512-LABEL: test_mm_cmpord_pd:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vcmpordpd %xmm1, %xmm0, %k0
; AVX512-NEXT:    vpmovm2q %k0, %xmm0
; AVX512-NEXT:    ret{{[l|q]}}
  %fcmp = fcmp ord <2 x double> %a0, %a1
  %sext = sext <2 x i1> %fcmp to <2 x i64>
  %res = bitcast <2 x i64> %sext to <2 x double>
  ret <2 x double> %res
}

define <2 x double> @test_mm_cmpord_sd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_cmpord_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    cmpordsd %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_cmpord_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    vcmpordsd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %res = call <2 x double> @llvm.x86.sse2.cmp.sd(<2 x double> %a0, <2 x double> %a1, i8 7)
  ret <2 x double> %res
}

define <2 x double> @test_mm_cmpunord_pd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_cmpunord_pd:
; SSE:       # %bb.0:
; SSE-NEXT:    cmpunordpd %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1-LABEL: test_mm_cmpunord_pd:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vcmpunordpd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    ret{{[l|q]}}
;
; AVX512-LABEL: test_mm_cmpunord_pd:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vcmpunordpd %xmm1, %xmm0, %k0
; AVX512-NEXT:    vpmovm2q %k0, %xmm0
; AVX512-NEXT:    ret{{[l|q]}}
  %fcmp = fcmp uno <2 x double> %a0, %a1
  %sext = sext <2 x i1> %fcmp to <2 x i64>
  %res = bitcast <2 x i64> %sext to <2 x double>
  ret <2 x double> %res
}

define <2 x double> @test_mm_cmpunord_sd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_cmpunord_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    cmpunordsd %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_cmpunord_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    vcmpunordsd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %res = call <2 x double> @llvm.x86.sse2.cmp.sd(<2 x double> %a0, <2 x double> %a1, i8 3)
  ret <2 x double> %res
}

define i32 @test_mm_comieq_sd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_comieq_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    comisd %xmm1, %xmm0
; SSE-NEXT:    setnp %al
; SSE-NEXT:    sete %cl
; SSE-NEXT:    andb %al, %cl
; SSE-NEXT:    movzbl %cl, %eax
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_comieq_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    vcomisd %xmm1, %xmm0
; AVX-NEXT:    setnp %al
; AVX-NEXT:    sete %cl
; AVX-NEXT:    andb %al, %cl
; AVX-NEXT:    movzbl %cl, %eax
; AVX-NEXT:    ret{{[l|q]}}
  %res = call i32 @llvm.x86.sse2.comieq.sd(<2 x double> %a0, <2 x double> %a1)
  ret i32 %res
}
declare i32 @llvm.x86.sse2.comieq.sd(<2 x double>, <2 x double>) nounwind readnone

define i32 @test_mm_comige_sd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_comige_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    xorl %eax, %eax
; SSE-NEXT:    comisd %xmm1, %xmm0
; SSE-NEXT:    setae %al
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_comige_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    xorl %eax, %eax
; AVX-NEXT:    vcomisd %xmm1, %xmm0
; AVX-NEXT:    setae %al
; AVX-NEXT:    ret{{[l|q]}}
  %res = call i32 @llvm.x86.sse2.comige.sd(<2 x double> %a0, <2 x double> %a1)
  ret i32 %res
}
declare i32 @llvm.x86.sse2.comige.sd(<2 x double>, <2 x double>) nounwind readnone

define i32 @test_mm_comigt_sd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_comigt_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    xorl %eax, %eax
; SSE-NEXT:    comisd %xmm1, %xmm0
; SSE-NEXT:    seta %al
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_comigt_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    xorl %eax, %eax
; AVX-NEXT:    vcomisd %xmm1, %xmm0
; AVX-NEXT:    seta %al
; AVX-NEXT:    ret{{[l|q]}}
  %res = call i32 @llvm.x86.sse2.comigt.sd(<2 x double> %a0, <2 x double> %a1)
  ret i32 %res
}
declare i32 @llvm.x86.sse2.comigt.sd(<2 x double>, <2 x double>) nounwind readnone

define i32 @test_mm_comile_sd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_comile_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    xorl %eax, %eax
; SSE-NEXT:    comisd %xmm0, %xmm1
; SSE-NEXT:    setae %al
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_comile_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    xorl %eax, %eax
; AVX-NEXT:    vcomisd %xmm0, %xmm1
; AVX-NEXT:    setae %al
; AVX-NEXT:    ret{{[l|q]}}
  %res = call i32 @llvm.x86.sse2.comile.sd(<2 x double> %a0, <2 x double> %a1)
  ret i32 %res
}
declare i32 @llvm.x86.sse2.comile.sd(<2 x double>, <2 x double>) nounwind readnone

define i32 @test_mm_comilt_sd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_comilt_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    xorl %eax, %eax
; SSE-NEXT:    comisd %xmm0, %xmm1
; SSE-NEXT:    seta %al
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_comilt_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    xorl %eax, %eax
; AVX-NEXT:    vcomisd %xmm0, %xmm1
; AVX-NEXT:    seta %al
; AVX-NEXT:    ret{{[l|q]}}
  %res = call i32 @llvm.x86.sse2.comilt.sd(<2 x double> %a0, <2 x double> %a1)
  ret i32 %res
}
declare i32 @llvm.x86.sse2.comilt.sd(<2 x double>, <2 x double>) nounwind readnone

define i32 @test_mm_comineq_sd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_comineq_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    comisd %xmm1, %xmm0
; SSE-NEXT:    setp %al
; SSE-NEXT:    setne %cl
; SSE-NEXT:    orb %al, %cl
; SSE-NEXT:    movzbl %cl, %eax
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_comineq_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    vcomisd %xmm1, %xmm0
; AVX-NEXT:    setp %al
; AVX-NEXT:    setne %cl
; AVX-NEXT:    orb %al, %cl
; AVX-NEXT:    movzbl %cl, %eax
; AVX-NEXT:    ret{{[l|q]}}
  %res = call i32 @llvm.x86.sse2.comineq.sd(<2 x double> %a0, <2 x double> %a1)
  ret i32 %res
}
declare i32 @llvm.x86.sse2.comineq.sd(<2 x double>, <2 x double>) nounwind readnone

define <2 x double> @test_mm_cvtepi32_pd(<2 x i64> %a0) nounwind {
; SSE-LABEL: test_mm_cvtepi32_pd:
; SSE:       # %bb.0:
; SSE-NEXT:    cvtdq2pd %xmm0, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_cvtepi32_pd:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvtdq2pd %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <4 x i32>
  %ext = shufflevector <4 x i32> %arg0, <4 x i32> %arg0, <2 x i32> <i32 0, i32 1>
  %res = sitofp <2 x i32> %ext to <2 x double>
  ret <2 x double> %res
}

define <4 x float> @test_mm_cvtepi32_ps(<2 x i64> %a0) nounwind {
; SSE-LABEL: test_mm_cvtepi32_ps:
; SSE:       # %bb.0:
; SSE-NEXT:    cvtdq2ps %xmm0, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_cvtepi32_ps:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvtdq2ps %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <4 x i32>
  %res = sitofp <4 x i32> %arg0 to <4 x float>
  ret <4 x float> %res
}

define <2 x i64> @test_mm_cvtpd_epi32(<2 x double> %a0) nounwind {
; SSE-LABEL: test_mm_cvtpd_epi32:
; SSE:       # %bb.0:
; SSE-NEXT:    cvtpd2dq %xmm0, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_cvtpd_epi32:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvtpd2dq %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %res = call <4 x i32> @llvm.x86.sse2.cvtpd2dq(<2 x double> %a0)
  %bc = bitcast <4 x i32> %res to <2 x i64>
  ret <2 x i64> %bc
}
declare <4 x i32> @llvm.x86.sse2.cvtpd2dq(<2 x double>) nounwind readnone

define <4 x float> @test_mm_cvtpd_ps(<2 x double> %a0) nounwind {
; SSE-LABEL: test_mm_cvtpd_ps:
; SSE:       # %bb.0:
; SSE-NEXT:    cvtpd2ps %xmm0, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_cvtpd_ps:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvtpd2ps %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %res = call <4 x float> @llvm.x86.sse2.cvtpd2ps(<2 x double> %a0)
  ret <4 x float> %res
}
declare <4 x float> @llvm.x86.sse2.cvtpd2ps(<2 x double>) nounwind readnone

define <2 x i64> @test_mm_cvtps_epi32(<4 x float> %a0) nounwind {
; SSE-LABEL: test_mm_cvtps_epi32:
; SSE:       # %bb.0:
; SSE-NEXT:    cvtps2dq %xmm0, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_cvtps_epi32:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvtps2dq %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %res = call <4 x i32> @llvm.x86.sse2.cvtps2dq(<4 x float> %a0)
  %bc = bitcast <4 x i32> %res to <2 x i64>
  ret <2 x i64> %bc
}
declare <4 x i32> @llvm.x86.sse2.cvtps2dq(<4 x float>) nounwind readnone

define <2 x double> @test_mm_cvtps_pd(<4 x float> %a0) nounwind {
; SSE-LABEL: test_mm_cvtps_pd:
; SSE:       # %bb.0:
; SSE-NEXT:    cvtps2pd %xmm0, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_cvtps_pd:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvtps2pd %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %ext = shufflevector <4 x float> %a0, <4 x float> %a0, <2 x i32> <i32 0, i32 1>
  %res = fpext <2 x float> %ext to <2 x double>
  ret <2 x double> %res
}

define double @test_mm_cvtsd_f64(<2 x double> %a0) nounwind {
; X86-SSE-LABEL: test_mm_cvtsd_f64:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    pushl %ebp
; X86-SSE-NEXT:    movl %esp, %ebp
; X86-SSE-NEXT:    andl $-8, %esp
; X86-SSE-NEXT:    subl $8, %esp
; X86-SSE-NEXT:    movlps %xmm0, (%esp)
; X86-SSE-NEXT:    fldl (%esp)
; X86-SSE-NEXT:    movl %ebp, %esp
; X86-SSE-NEXT:    popl %ebp
; X86-SSE-NEXT:    retl
;
; X86-AVX-LABEL: test_mm_cvtsd_f64:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    pushl %ebp
; X86-AVX-NEXT:    movl %esp, %ebp
; X86-AVX-NEXT:    andl $-8, %esp
; X86-AVX-NEXT:    subl $8, %esp
; X86-AVX-NEXT:    vmovlps %xmm0, (%esp)
; X86-AVX-NEXT:    fldl (%esp)
; X86-AVX-NEXT:    movl %ebp, %esp
; X86-AVX-NEXT:    popl %ebp
; X86-AVX-NEXT:    retl
;
; X64-LABEL: test_mm_cvtsd_f64:
; X64:       # %bb.0:
; X64-NEXT:    retq
  %res = extractelement <2 x double> %a0, i32 0
  ret double %res
}

define i32 @test_mm_cvtsd_si32(<2 x double> %a0) nounwind {
; SSE-LABEL: test_mm_cvtsd_si32:
; SSE:       # %bb.0:
; SSE-NEXT:    cvtsd2si %xmm0, %eax
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_cvtsd_si32:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvtsd2si %xmm0, %eax
; AVX-NEXT:    ret{{[l|q]}}
  %res = call i32 @llvm.x86.sse2.cvtsd2si(<2 x double> %a0)
  ret i32 %res
}
declare i32 @llvm.x86.sse2.cvtsd2si(<2 x double>) nounwind readnone

define <4 x float> @test_mm_cvtsd_ss(<4 x float> %a0, <2 x double> %a1) {
; SSE-LABEL: test_mm_cvtsd_ss:
; SSE:       # %bb.0:
; SSE-NEXT:    cvtsd2ss %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_cvtsd_ss:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvtsd2ss %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %res = call <4 x float> @llvm.x86.sse2.cvtsd2ss(<4 x float> %a0, <2 x double> %a1)
  ret <4 x float> %res
}
declare <4 x float> @llvm.x86.sse2.cvtsd2ss(<4 x float>, <2 x double>) nounwind readnone

define <4 x float> @test_mm_cvtsd_ss_load(<4 x float> %a0, <2 x double>* %p1) {
; X86-SSE-LABEL: test_mm_cvtsd_ss_load:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    cvtsd2ss (%eax), %xmm0
; X86-SSE-NEXT:    retl
;
; X86-AVX-LABEL: test_mm_cvtsd_ss_load:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vmovaps (%eax), %xmm1
; X86-AVX-NEXT:    vcvtsd2ss %xmm1, %xmm0, %xmm0
; X86-AVX-NEXT:    retl
;
; X64-SSE-LABEL: test_mm_cvtsd_ss_load:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    cvtsd2ss (%rdi), %xmm0
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: test_mm_cvtsd_ss_load:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovaps (%rdi), %xmm1
; X64-AVX-NEXT:    vcvtsd2ss %xmm1, %xmm0, %xmm0
; X64-AVX-NEXT:    retq
  %a1 = load <2 x double>, <2 x double>* %p1
  %res = call <4 x float> @llvm.x86.sse2.cvtsd2ss(<4 x float> %a0, <2 x double> %a1)
  ret <4 x float> %res
}

define i32 @test_mm_cvtsi128_si32(<2 x i64> %a0) nounwind {
; SSE-LABEL: test_mm_cvtsi128_si32:
; SSE:       # %bb.0:
; SSE-NEXT:    movd %xmm0, %eax
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_cvtsi128_si32:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovd %xmm0, %eax
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <4 x i32>
  %res = extractelement <4 x i32> %arg0, i32 0
  ret i32 %res
}

define <2 x double> @test_mm_cvtsi32_sd(<2 x double> %a0, i32 %a1) nounwind {
; X86-SSE-LABEL: test_mm_cvtsi32_sd:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    cvtsi2sdl {{[0-9]+}}(%esp), %xmm0
; X86-SSE-NEXT:    retl
;
; X86-AVX1-LABEL: test_mm_cvtsi32_sd:
; X86-AVX1:       # %bb.0:
; X86-AVX1-NEXT:    vcvtsi2sdl {{[0-9]+}}(%esp), %xmm0, %xmm0
; X86-AVX1-NEXT:    retl
;
; X86-AVX512-LABEL: test_mm_cvtsi32_sd:
; X86-AVX512:       # %bb.0:
; X86-AVX512-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX512-NEXT:    vcvtsi2sdl %eax, %xmm0, %xmm0
; X86-AVX512-NEXT:    retl
;
; X64-SSE-LABEL: test_mm_cvtsi32_sd:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    cvtsi2sdl %edi, %xmm0
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: test_mm_cvtsi32_sd:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vcvtsi2sdl %edi, %xmm0, %xmm0
; X64-AVX-NEXT:    retq
  %cvt = sitofp i32 %a1 to double
  %res = insertelement <2 x double> %a0, double %cvt, i32 0
  ret <2 x double> %res
}

define <2 x i64> @test_mm_cvtsi32_si128(i32 %a0) nounwind {
; X86-SSE-LABEL: test_mm_cvtsi32_si128:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-SSE-NEXT:    retl
;
; X86-AVX-LABEL: test_mm_cvtsi32_si128:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-AVX-NEXT:    retl
;
; X64-SSE-LABEL: test_mm_cvtsi32_si128:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movd %edi, %xmm0
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: test_mm_cvtsi32_si128:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovd %edi, %xmm0
; X64-AVX-NEXT:    retq
  %res0 = insertelement <4 x i32> undef, i32 %a0, i32 0
  %res1 = insertelement <4 x i32> %res0, i32 0, i32 1
  %res2 = insertelement <4 x i32> %res1, i32 0, i32 2
  %res3 = insertelement <4 x i32> %res2, i32 0, i32 3
  %res = bitcast <4 x i32> %res3 to <2 x i64>
  ret <2 x i64> %res
}

define <2 x double> @test_mm_cvtss_sd(<2 x double> %a0, <4 x float> %a1) nounwind {
; SSE-LABEL: test_mm_cvtss_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    cvtss2sd %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_cvtss_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvtss2sd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %ext = extractelement <4 x float> %a1, i32 0
  %cvt = fpext float %ext to double
  %res = insertelement <2 x double> %a0, double %cvt, i32 0
  ret <2 x double> %res
}

define <2 x i64> @test_mm_cvttpd_epi32(<2 x double> %a0) nounwind {
; SSE-LABEL: test_mm_cvttpd_epi32:
; SSE:       # %bb.0:
; SSE-NEXT:    cvttpd2dq %xmm0, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_cvttpd_epi32:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvttpd2dq %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %res = call <4 x i32> @llvm.x86.sse2.cvttpd2dq(<2 x double> %a0)
  %bc = bitcast <4 x i32> %res to <2 x i64>
  ret <2 x i64> %bc
}
declare <4 x i32> @llvm.x86.sse2.cvttpd2dq(<2 x double>) nounwind readnone

define <2 x i64> @test_mm_cvttps_epi32(<4 x float> %a0) nounwind {
; SSE-LABEL: test_mm_cvttps_epi32:
; SSE:       # %bb.0:
; SSE-NEXT:    cvttps2dq %xmm0, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_cvttps_epi32:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvttps2dq %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %res = call <4 x i32> @llvm.x86.sse2.cvttps2dq(<4 x float> %a0)
  %bc = bitcast <4 x i32> %res to <2 x i64>
  ret <2 x i64> %bc
}
declare <4 x i32> @llvm.x86.sse2.cvttps2dq(<4 x float>) nounwind readnone

define i32 @test_mm_cvttsd_si32(<2 x double> %a0) nounwind {
; SSE-LABEL: test_mm_cvttsd_si32:
; SSE:       # %bb.0:
; SSE-NEXT:    cvttsd2si %xmm0, %eax
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_cvttsd_si32:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvttsd2si %xmm0, %eax
; AVX-NEXT:    ret{{[l|q]}}
  %res = call i32 @llvm.x86.sse2.cvttsd2si(<2 x double> %a0)
  ret i32 %res
}
declare i32 @llvm.x86.sse2.cvttsd2si(<2 x double>) nounwind readnone

define <2 x double> @test_mm_div_pd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_div_pd:
; SSE:       # %bb.0:
; SSE-NEXT:    divpd %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_div_pd:
; AVX:       # %bb.0:
; AVX-NEXT:    vdivpd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %res = fdiv <2 x double> %a0, %a1
  ret <2 x double> %res
}

define <2 x double> @test_mm_div_sd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_div_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    divsd %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_div_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    vdivsd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %ext0 = extractelement <2 x double> %a0, i32 0
  %ext1 = extractelement <2 x double> %a1, i32 0
  %fdiv = fdiv double %ext0, %ext1
  %res = insertelement <2 x double> %a0, double %fdiv, i32 0
  ret <2 x double> %res
}

define i32 @test_mm_extract_epi16(<2 x i64> %a0) nounwind {
; SSE-LABEL: test_mm_extract_epi16:
; SSE:       # %bb.0:
; SSE-NEXT:    pextrw $1, %xmm0, %eax
; SSE-NEXT:    movzwl %ax, %eax
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_extract_epi16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpextrw $1, %xmm0, %eax
; AVX-NEXT:    movzwl %ax, %eax
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <8 x i16>
  %ext = extractelement <8 x i16> %arg0, i32 1
  %res = zext i16 %ext to i32
  ret i32 %res
}

define <2 x i64> @test_mm_insert_epi16(<2 x i64> %a0, i16 %a1) nounwind {
; X86-SSE-LABEL: test_mm_insert_epi16:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    pinsrw $1, %eax, %xmm0
; X86-SSE-NEXT:    retl
;
; X86-AVX-LABEL: test_mm_insert_epi16:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vpinsrw $1, %eax, %xmm0, %xmm0
; X86-AVX-NEXT:    retl
;
; X64-SSE-LABEL: test_mm_insert_epi16:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    pinsrw $1, %edi, %xmm0
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: test_mm_insert_epi16:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vpinsrw $1, %edi, %xmm0, %xmm0
; X64-AVX-NEXT:    retq
  %arg0 = bitcast <2 x i64> %a0 to <8 x i16>
  %res = insertelement <8 x i16> %arg0, i16 %a1,i32 1
  %bc = bitcast <8 x i16> %res to <2 x i64>
  ret <2 x i64> %bc
}

define void @test_mm_lfence() nounwind {
; CHECK-LABEL: test_mm_lfence:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lfence
; CHECK-NEXT:    ret{{[l|q]}}
  call void @llvm.x86.sse2.lfence()
  ret void
}
declare void @llvm.x86.sse2.lfence() nounwind readnone

define <2 x double> @test_mm_load_pd(double* %a0) nounwind {
; X86-SSE-LABEL: test_mm_load_pd:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movaps (%eax), %xmm0
; X86-SSE-NEXT:    retl
;
; X86-AVX-LABEL: test_mm_load_pd:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vmovaps (%eax), %xmm0
; X86-AVX-NEXT:    retl
;
; X64-SSE-LABEL: test_mm_load_pd:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movaps (%rdi), %xmm0
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: test_mm_load_pd:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovaps (%rdi), %xmm0
; X64-AVX-NEXT:    retq
  %arg0 = bitcast double* %a0 to <2 x double>*
  %res = load <2 x double>, <2 x double>* %arg0, align 16
  ret <2 x double> %res
}

define <2 x double> @test_mm_load_sd(double* %a0) nounwind {
; X86-SSE-LABEL: test_mm_load_sd:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; X86-SSE-NEXT:    retl
;
; X86-AVX-LABEL: test_mm_load_sd:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; X86-AVX-NEXT:    retl
;
; X64-SSE-LABEL: test_mm_load_sd:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: test_mm_load_sd:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; X64-AVX-NEXT:    retq
  %ld = load double, double* %a0, align 1
  %res0 = insertelement <2 x double> undef, double %ld, i32 0
  %res1 = insertelement <2 x double> %res0, double 0.0, i32 1
  ret <2 x double> %res1
}

define <2 x i64> @test_mm_load_si128(<2 x i64>* %a0) nounwind {
; X86-SSE-LABEL: test_mm_load_si128:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movaps (%eax), %xmm0
; X86-SSE-NEXT:    retl
;
; X86-AVX-LABEL: test_mm_load_si128:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vmovaps (%eax), %xmm0
; X86-AVX-NEXT:    retl
;
; X64-SSE-LABEL: test_mm_load_si128:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movaps (%rdi), %xmm0
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: test_mm_load_si128:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovaps (%rdi), %xmm0
; X64-AVX-NEXT:    retq
  %res = load <2 x i64>, <2 x i64>* %a0, align 16
  ret <2 x i64> %res
}

define <2 x double> @test_mm_load1_pd(double* %a0) nounwind {
; X86-SSE-LABEL: test_mm_load1_pd:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; X86-SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0,0]
; X86-SSE-NEXT:    retl
;
; X86-AVX-LABEL: test_mm_load1_pd:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vmovddup {{.*#+}} xmm0 = mem[0,0]
; X86-AVX-NEXT:    retl
;
; X64-SSE-LABEL: test_mm_load1_pd:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; X64-SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0,0]
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: test_mm_load1_pd:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovddup {{.*#+}} xmm0 = mem[0,0]
; X64-AVX-NEXT:    retq
  %ld = load double, double* %a0, align 8
  %res0 = insertelement <2 x double> undef, double %ld, i32 0
  %res1 = insertelement <2 x double> %res0, double %ld, i32 1
  ret <2 x double> %res1
}

define <2 x double> @test_mm_loadh_pd(<2 x double> %a0, double* %a1) nounwind {
; X86-SSE-LABEL: test_mm_loadh_pd:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movhpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; X86-SSE-NEXT:    retl
;
; X86-AVX-LABEL: test_mm_loadh_pd:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vmovhpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; X86-AVX-NEXT:    retl
;
; X64-SSE-LABEL: test_mm_loadh_pd:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movhpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: test_mm_loadh_pd:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovhpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; X64-AVX-NEXT:    retq
  %ld = load double, double* %a1, align 8
  %res = insertelement <2 x double> %a0, double %ld, i32 1
  ret <2 x double> %res
}

define <2 x i64> @test_mm_loadl_epi64(<2 x i64> %a0, <2 x i64>* %a1) nounwind {
; X86-SSE-LABEL: test_mm_loadl_epi64:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; X86-SSE-NEXT:    retl
;
; X86-AVX-LABEL: test_mm_loadl_epi64:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; X86-AVX-NEXT:    retl
;
; X64-SSE-LABEL: test_mm_loadl_epi64:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: test_mm_loadl_epi64:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; X64-AVX-NEXT:    retq
  %bc = bitcast <2 x i64>* %a1 to i64*
  %ld = load i64, i64* %bc, align 1
  %res0 = insertelement <2 x i64> undef, i64 %ld, i32 0
  %res1 = insertelement <2 x i64> %res0, i64 0, i32 1
  ret <2 x i64> %res1
}

define <2 x double> @test_mm_loadl_pd(<2 x double> %a0, double* %a1) nounwind {
; X86-SSE-LABEL: test_mm_loadl_pd:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movlpd {{.*#+}} xmm0 = mem[0],xmm0[1]
; X86-SSE-NEXT:    retl
;
; X86-AVX-LABEL: test_mm_loadl_pd:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vmovlpd {{.*#+}} xmm0 = mem[0],xmm0[1]
; X86-AVX-NEXT:    retl
;
; X64-SSE-LABEL: test_mm_loadl_pd:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movlpd {{.*#+}} xmm0 = mem[0],xmm0[1]
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: test_mm_loadl_pd:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovlpd {{.*#+}} xmm0 = mem[0],xmm0[1]
; X64-AVX-NEXT:    retq
  %ld = load double, double* %a1, align 8
  %res = insertelement <2 x double> %a0, double %ld, i32 0
  ret <2 x double> %res
}

define <2 x double> @test_mm_loadr_pd(double* %a0) nounwind {
; X86-SSE-LABEL: test_mm_loadr_pd:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movapd (%eax), %xmm0
; X86-SSE-NEXT:    shufpd {{.*#+}} xmm0 = xmm0[1,0]
; X86-SSE-NEXT:    retl
;
; X86-AVX-LABEL: test_mm_loadr_pd:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vpermilpd {{.*#+}} xmm0 = mem[1,0]
; X86-AVX-NEXT:    retl
;
; X64-SSE-LABEL: test_mm_loadr_pd:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movapd (%rdi), %xmm0
; X64-SSE-NEXT:    shufpd {{.*#+}} xmm0 = xmm0[1,0]
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: test_mm_loadr_pd:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vpermilpd {{.*#+}} xmm0 = mem[1,0]
; X64-AVX-NEXT:    retq
  %arg0 = bitcast double* %a0 to <2 x double>*
  %ld = load <2 x double>, <2 x double>* %arg0, align 16
  %res = shufflevector <2 x double> %ld, <2 x double> undef, <2 x i32> <i32 1, i32 0>
  ret <2 x double> %res
}

define <2 x double> @test_mm_loadu_pd(double* %a0) nounwind {
; X86-SSE-LABEL: test_mm_loadu_pd:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movups (%eax), %xmm0
; X86-SSE-NEXT:    retl
;
; X86-AVX-LABEL: test_mm_loadu_pd:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vmovups (%eax), %xmm0
; X86-AVX-NEXT:    retl
;
; X64-SSE-LABEL: test_mm_loadu_pd:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movups (%rdi), %xmm0
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: test_mm_loadu_pd:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovups (%rdi), %xmm0
; X64-AVX-NEXT:    retq
  %arg0 = bitcast double* %a0 to <2 x double>*
  %res = load <2 x double>, <2 x double>* %arg0, align 1
  ret <2 x double> %res
}

define <2 x i64> @test_mm_loadu_si128(<2 x i64>* %a0) nounwind {
; X86-SSE-LABEL: test_mm_loadu_si128:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movups (%eax), %xmm0
; X86-SSE-NEXT:    retl
;
; X86-AVX-LABEL: test_mm_loadu_si128:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vmovups (%eax), %xmm0
; X86-AVX-NEXT:    retl
;
; X64-SSE-LABEL: test_mm_loadu_si128:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movups (%rdi), %xmm0
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: test_mm_loadu_si128:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovups (%rdi), %xmm0
; X64-AVX-NEXT:    retq
  %res = load <2 x i64>, <2 x i64>* %a0, align 1
  ret <2 x i64> %res
}

define <2 x i64> @test_mm_madd_epi16(<2 x i64> %a0, <2 x i64> %a1) nounwind {
; SSE-LABEL: test_mm_madd_epi16:
; SSE:       # %bb.0:
; SSE-NEXT:    pmaddwd %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_madd_epi16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpmaddwd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <8 x i16>
  %arg1 = bitcast <2 x i64> %a1 to <8 x i16>
  %res = call <4 x i32> @llvm.x86.sse2.pmadd.wd(<8 x i16> %arg0, <8 x i16> %arg1)
  %bc = bitcast <4 x i32> %res to <2 x i64>
  ret <2 x i64> %bc
}
declare <4 x i32> @llvm.x86.sse2.pmadd.wd(<8 x i16>, <8 x i16>) nounwind readnone

define void @test_mm_maskmoveu_si128(<2 x i64> %a0, <2 x i64> %a1, i8* %a2) nounwind {
; X86-SSE-LABEL: test_mm_maskmoveu_si128:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    pushl %edi
; X86-SSE-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-SSE-NEXT:    maskmovdqu %xmm1, %xmm0
; X86-SSE-NEXT:    popl %edi
; X86-SSE-NEXT:    retl
;
; X86-AVX-LABEL: test_mm_maskmoveu_si128:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    pushl %edi
; X86-AVX-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-AVX-NEXT:    vmaskmovdqu %xmm1, %xmm0
; X86-AVX-NEXT:    popl %edi
; X86-AVX-NEXT:    retl
;
; X64-SSE-LABEL: test_mm_maskmoveu_si128:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    maskmovdqu %xmm1, %xmm0
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: test_mm_maskmoveu_si128:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmaskmovdqu %xmm1, %xmm0
; X64-AVX-NEXT:    retq
  %arg0 = bitcast <2 x i64> %a0 to <16 x i8>
  %arg1 = bitcast <2 x i64> %a1 to <16 x i8>
  call void @llvm.x86.sse2.maskmov.dqu(<16 x i8> %arg0, <16 x i8> %arg1, i8* %a2)
  ret void
}
declare void @llvm.x86.sse2.maskmov.dqu(<16 x i8>, <16 x i8>, i8*) nounwind

define <2 x i64> @test_mm_max_epi16(<2 x i64> %a0, <2 x i64> %a1) nounwind {
; SSE-LABEL: test_mm_max_epi16:
; SSE:       # %bb.0:
; SSE-NEXT:    pmaxsw %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_max_epi16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpmaxsw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <8 x i16>
  %arg1 = bitcast <2 x i64> %a1 to <8 x i16>
  %cmp = icmp sgt <8 x i16> %arg0, %arg1
  %sel = select <8 x i1> %cmp, <8 x i16> %arg0, <8 x i16> %arg1
  %bc = bitcast <8 x i16> %sel to <2 x i64>
  ret <2 x i64> %bc
}

define <2 x i64> @test_mm_max_epu8(<2 x i64> %a0, <2 x i64> %a1) nounwind {
; SSE-LABEL: test_mm_max_epu8:
; SSE:       # %bb.0:
; SSE-NEXT:    pmaxub %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_max_epu8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpmaxub %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <16 x i8>
  %arg1 = bitcast <2 x i64> %a1 to <16 x i8>
  %cmp = icmp ugt <16 x i8> %arg0, %arg1
  %sel = select <16 x i1> %cmp, <16 x i8> %arg0, <16 x i8> %arg1
  %bc = bitcast <16 x i8> %sel to <2 x i64>
  ret <2 x i64> %bc
}

define <2 x double> @test_mm_max_pd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_max_pd:
; SSE:       # %bb.0:
; SSE-NEXT:    maxpd %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_max_pd:
; AVX:       # %bb.0:
; AVX-NEXT:    vmaxpd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %res = call <2 x double> @llvm.x86.sse2.max.pd(<2 x double> %a0, <2 x double> %a1)
  ret <2 x double> %res
}
declare <2 x double> @llvm.x86.sse2.max.pd(<2 x double>, <2 x double>) nounwind readnone

define <2 x double> @test_mm_max_sd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_max_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    maxsd %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_max_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    vmaxsd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %res = call <2 x double> @llvm.x86.sse2.max.sd(<2 x double> %a0, <2 x double> %a1)
  ret <2 x double> %res
}
declare <2 x double> @llvm.x86.sse2.max.sd(<2 x double>, <2 x double>) nounwind readnone

define void @test_mm_mfence() nounwind {
; CHECK-LABEL: test_mm_mfence:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mfence
; CHECK-NEXT:    ret{{[l|q]}}
  call void @llvm.x86.sse2.mfence()
  ret void
}
declare void @llvm.x86.sse2.mfence() nounwind readnone

define <2 x i64> @test_mm_min_epi16(<2 x i64> %a0, <2 x i64> %a1) nounwind {
; SSE-LABEL: test_mm_min_epi16:
; SSE:       # %bb.0:
; SSE-NEXT:    pminsw %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_min_epi16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpminsw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <8 x i16>
  %arg1 = bitcast <2 x i64> %a1 to <8 x i16>
  %cmp = icmp slt <8 x i16> %arg0, %arg1
  %sel = select <8 x i1> %cmp, <8 x i16> %arg0, <8 x i16> %arg1
  %bc = bitcast <8 x i16> %sel to <2 x i64>
  ret <2 x i64> %bc
}

define <2 x i64> @test_mm_min_epu8(<2 x i64> %a0, <2 x i64> %a1) nounwind {
; SSE-LABEL: test_mm_min_epu8:
; SSE:       # %bb.0:
; SSE-NEXT:    pminub %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_min_epu8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpminub %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <16 x i8>
  %arg1 = bitcast <2 x i64> %a1 to <16 x i8>
  %cmp = icmp ult <16 x i8> %arg0, %arg1
  %sel = select <16 x i1> %cmp, <16 x i8> %arg0, <16 x i8> %arg1
  %bc = bitcast <16 x i8> %sel to <2 x i64>
  ret <2 x i64> %bc
}

define <2 x double> @test_mm_min_pd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_min_pd:
; SSE:       # %bb.0:
; SSE-NEXT:    minpd %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_min_pd:
; AVX:       # %bb.0:
; AVX-NEXT:    vminpd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %res = call <2 x double> @llvm.x86.sse2.min.pd(<2 x double> %a0, <2 x double> %a1)
  ret <2 x double> %res
}
declare <2 x double> @llvm.x86.sse2.min.pd(<2 x double>, <2 x double>) nounwind readnone

define <2 x double> @test_mm_min_sd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_min_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    minsd %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_min_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    vminsd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %res = call <2 x double> @llvm.x86.sse2.min.sd(<2 x double> %a0, <2 x double> %a1)
  ret <2 x double> %res
}
declare <2 x double> @llvm.x86.sse2.min.sd(<2 x double>, <2 x double>) nounwind readnone

define <2 x i64> @test_mm_move_epi64(<2 x i64> %a0) nounwind {
; SSE-LABEL: test_mm_move_epi64:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{.*#+}} xmm0 = xmm0[0],zero
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_move_epi64:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; AVX-NEXT:    ret{{[l|q]}}
  %res = shufflevector <2 x i64> %a0, <2 x i64> zeroinitializer, <2 x i32> <i32 0, i32 2>
  ret <2 x i64> %res
}

define <2 x double> @test_mm_move_sd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_move_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm1[0],xmm0[1]
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1-LABEL: test_mm_move_sd:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vblendps {{.*#+}} xmm0 = xmm1[0,1],xmm0[2,3]
; AVX1-NEXT:    ret{{[l|q]}}
;
; AVX512-LABEL: test_mm_move_sd:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovsd {{.*#+}} xmm0 = xmm1[0],xmm0[1]
; AVX512-NEXT:    ret{{[l|q]}}
  %ext0 = extractelement <2 x double> %a1, i32 0
  %res0 = insertelement <2 x double> undef, double %ext0, i32 0
  %ext1 = extractelement <2 x double> %a0, i32 1
  %res1 = insertelement <2 x double> %res0, double %ext1, i32 1
  ret <2 x double> %res1
}

define i32 @test_mm_movemask_epi8(<2 x i64> %a0) nounwind {
; SSE-LABEL: test_mm_movemask_epi8:
; SSE:       # %bb.0:
; SSE-NEXT:    pmovmskb %xmm0, %eax
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_movemask_epi8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpmovmskb %xmm0, %eax
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <16 x i8>
  %res = call i32 @llvm.x86.sse2.pmovmskb.128(<16 x i8> %arg0)
  ret i32 %res
}
declare i32 @llvm.x86.sse2.pmovmskb.128(<16 x i8>) nounwind readnone

define i32 @test_mm_movemask_pd(<2 x double> %a0) nounwind {
; SSE-LABEL: test_mm_movemask_pd:
; SSE:       # %bb.0:
; SSE-NEXT:    movmskpd %xmm0, %eax
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_movemask_pd:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovmskpd %xmm0, %eax
; AVX-NEXT:    ret{{[l|q]}}
  %res = call i32 @llvm.x86.sse2.movmsk.pd(<2 x double> %a0)
  ret i32 %res
}
declare i32 @llvm.x86.sse2.movmsk.pd(<2 x double>) nounwind readnone

define <2 x i64> @test_mm_mul_epu32(<2 x i64> %a0, <2 x i64> %a1) nounwind {
; SSE-LABEL: test_mm_mul_epu32:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [4294967295,0,4294967295,0]
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    pmuludq %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1-LABEL: test_mm_mul_epu32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1],xmm2[2,3],xmm0[4,5],xmm2[6,7]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1],xmm2[2,3],xmm1[4,5],xmm2[6,7]
; AVX1-NEXT:    vpmuludq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    ret{{[l|q]}}
;
; AVX512-LABEL: test_mm_mul_epu32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3]
; AVX512-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0],xmm2[1],xmm1[2],xmm2[3]
; AVX512-NEXT:    vpmullq %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    ret{{[l|q]}}
  %A = and <2 x i64> %a0, <i64 4294967295, i64 4294967295>
  %B = and <2 x i64> %a1, <i64 4294967295, i64 4294967295>
  %res = mul nuw <2 x i64> %A, %B
  ret <2 x i64> %res
}

define <2 x double> @test_mm_mul_pd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_mul_pd:
; SSE:       # %bb.0:
; SSE-NEXT:    mulpd %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_mul_pd:
; AVX:       # %bb.0:
; AVX-NEXT:    vmulpd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %res = fmul <2 x double> %a0, %a1
  ret <2 x double> %res
}

define <2 x double> @test_mm_mul_sd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_mul_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    mulsd %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_mul_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    vmulsd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %ext0 = extractelement <2 x double> %a0, i32 0
  %ext1 = extractelement <2 x double> %a1, i32 0
  %fmul = fmul double %ext0, %ext1
  %res = insertelement <2 x double> %a0, double %fmul, i32 0
  ret <2 x double> %res
}

define <2 x i64> @test_mm_mulhi_epi16(<2 x i64> %a0, <2 x i64> %a1) {
; SSE-LABEL: test_mm_mulhi_epi16:
; SSE:       # %bb.0:
; SSE-NEXT:    pmulhw %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_mulhi_epi16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpmulhw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <8 x i16>
  %arg1 = bitcast <2 x i64> %a1 to <8 x i16>
  %res = call <8 x i16> @llvm.x86.sse2.pmulh.w(<8 x i16> %arg0, <8 x i16> %arg1)
  %bc = bitcast <8 x i16> %res to <2 x i64>
  ret <2 x i64> %bc
}
declare <8 x i16> @llvm.x86.sse2.pmulh.w(<8 x i16>, <8 x i16>) nounwind readnone

define <2 x i64> @test_mm_mulhi_epu16(<2 x i64> %a0, <2 x i64> %a1) {
; SSE-LABEL: test_mm_mulhi_epu16:
; SSE:       # %bb.0:
; SSE-NEXT:    pmulhuw %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_mulhi_epu16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpmulhuw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <8 x i16>
  %arg1 = bitcast <2 x i64> %a1 to <8 x i16>
  %res = call <8 x i16> @llvm.x86.sse2.pmulhu.w(<8 x i16> %arg0, <8 x i16> %arg1)
  %bc = bitcast <8 x i16> %res to <2 x i64>
  ret <2 x i64> %bc
}
declare <8 x i16> @llvm.x86.sse2.pmulhu.w(<8 x i16>, <8 x i16>) nounwind readnone

define <2 x i64> @test_mm_mullo_epi16(<2 x i64> %a0, <2 x i64> %a1) {
; SSE-LABEL: test_mm_mullo_epi16:
; SSE:       # %bb.0:
; SSE-NEXT:    pmullw %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_mullo_epi16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpmullw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <8 x i16>
  %arg1 = bitcast <2 x i64> %a1 to <8 x i16>
  %res = mul <8 x i16> %arg0, %arg1
  %bc = bitcast <8 x i16> %res to <2 x i64>
  ret <2 x i64> %bc
}

define <2 x double> @test_mm_or_pd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_or_pd:
; SSE:       # %bb.0:
; SSE-NEXT:    orps %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_or_pd:
; AVX:       # %bb.0:
; AVX-NEXT:    vorps %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x double> %a0 to <4 x i32>
  %arg1 = bitcast <2 x double> %a1 to <4 x i32>
  %res = or <4 x i32> %arg0, %arg1
  %bc = bitcast <4 x i32> %res to <2 x double>
  ret <2 x double> %bc
}

define <2 x i64> @test_mm_or_si128(<2 x i64> %a0, <2 x i64> %a1) nounwind {
; SSE-LABEL: test_mm_or_si128:
; SSE:       # %bb.0:
; SSE-NEXT:    orps %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_or_si128:
; AVX:       # %bb.0:
; AVX-NEXT:    vorps %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %res = or <2 x i64> %a0, %a1
  ret <2 x i64> %res
}

define <2 x i64> @test_mm_packs_epi16(<2 x i64> %a0, <2 x i64> %a1) {
; SSE-LABEL: test_mm_packs_epi16:
; SSE:       # %bb.0:
; SSE-NEXT:    packsswb %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_packs_epi16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpacksswb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <8 x i16>
  %arg1 = bitcast <2 x i64> %a1 to <8 x i16>
  %res = call <16 x i8> @llvm.x86.sse2.packsswb.128(<8 x i16> %arg0, <8 x i16> %arg1)
  %bc = bitcast <16 x i8> %res to <2 x i64>
  ret <2 x i64> %bc
}
declare <16 x i8> @llvm.x86.sse2.packsswb.128(<8 x i16>, <8 x i16>) nounwind readnone

define <2 x i64> @test_mm_packs_epi32(<2 x i64> %a0, <2 x i64> %a1) {
; SSE-LABEL: test_mm_packs_epi32:
; SSE:       # %bb.0:
; SSE-NEXT:    packssdw %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_packs_epi32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <4 x i32>
  %arg1 = bitcast <2 x i64> %a1 to <4 x i32>
  %res = call <8 x i16> @llvm.x86.sse2.packssdw.128(<4 x i32> %arg0, <4 x i32> %arg1)
  %bc = bitcast <8 x i16> %res to <2 x i64>
  ret <2 x i64> %bc
}
declare <8 x i16> @llvm.x86.sse2.packssdw.128(<4 x i32>, <4 x i32>) nounwind readnone

define <2 x i64> @test_mm_packus_epi16(<2 x i64> %a0, <2 x i64> %a1) {
; SSE-LABEL: test_mm_packus_epi16:
; SSE:       # %bb.0:
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_packus_epi16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <8 x i16>
  %arg1 = bitcast <2 x i64> %a1 to <8 x i16>
  %res = call <16 x i8> @llvm.x86.sse2.packuswb.128(<8 x i16> %arg0, <8 x i16> %arg1)
  %bc = bitcast <16 x i8> %res to <2 x i64>
  ret <2 x i64> %bc
}
declare <16 x i8> @llvm.x86.sse2.packuswb.128(<8 x i16>, <8 x i16>) nounwind readnone

define void @test_mm_pause() nounwind {
; CHECK-LABEL: test_mm_pause:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pause
; CHECK-NEXT:    ret{{[l|q]}}
  call void @llvm.x86.sse2.pause()
  ret void
}
declare void @llvm.x86.sse2.pause() nounwind readnone

define <2 x i64> @test_mm_sad_epu8(<2 x i64> %a0, <2 x i64> %a1) nounwind {
; SSE-LABEL: test_mm_sad_epu8:
; SSE:       # %bb.0:
; SSE-NEXT:    psadbw %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_sad_epu8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsadbw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <16 x i8>
  %arg1 = bitcast <2 x i64> %a1 to <16 x i8>
  %res = call <2 x i64> @llvm.x86.sse2.psad.bw(<16 x i8> %arg0, <16 x i8> %arg1)
  ret <2 x i64> %res
}
declare <2 x i64> @llvm.x86.sse2.psad.bw(<16 x i8>, <16 x i8>) nounwind readnone

define <2 x i64> @test_mm_set_epi8(i8 %a0, i8 %a1, i8 %a2, i8 %a3, i8 %a4, i8 %a5, i8 %a6, i8 %a7, i8 %a8, i8 %a9, i8 %a10, i8 %a11, i8 %a12, i8 %a13, i8 %a14, i8 %a15) nounwind {
; X86-SSE-LABEL: test_mm_set_epi8:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm0
; X86-SSE-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm1
; X86-SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; X86-SSE-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm0
; X86-SSE-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm2
; X86-SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3],xmm2[4],xmm0[4],xmm2[5],xmm0[5],xmm2[6],xmm0[6],xmm2[7],xmm0[7]
; X86-SSE-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; X86-SSE-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm0
; X86-SSE-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm3
; X86-SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm0[0],xmm3[1],xmm0[1],xmm3[2],xmm0[2],xmm3[3],xmm0[3],xmm3[4],xmm0[4],xmm3[5],xmm0[5],xmm3[6],xmm0[6],xmm3[7],xmm0[7]
; X86-SSE-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm0
; X86-SSE-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm1
; X86-SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; X86-SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm3[0],xmm1[1],xmm3[1],xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; X86-SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1]
; X86-SSE-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm0
; X86-SSE-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm2
; X86-SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3],xmm2[4],xmm0[4],xmm2[5],xmm0[5],xmm2[6],xmm0[6],xmm2[7],xmm0[7]
; X86-SSE-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm0
; X86-SSE-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm3
; X86-SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm0[0],xmm3[1],xmm0[1],xmm3[2],xmm0[2],xmm3[3],xmm0[3],xmm3[4],xmm0[4],xmm3[5],xmm0[5],xmm3[6],xmm0[6],xmm3[7],xmm0[7]
; X86-SSE-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1],xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; X86-SSE-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm0
; X86-SSE-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm2
; X86-SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3],xmm2[4],xmm0[4],xmm2[5],xmm0[5],xmm2[6],xmm0[6],xmm2[7],xmm0[7]
; X86-SSE-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm4
; X86-SSE-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm0
; X86-SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm4[0],xmm0[1],xmm4[1],xmm0[2],xmm4[2],xmm0[3],xmm4[3],xmm0[4],xmm4[4],xmm0[5],xmm4[5],xmm0[6],xmm4[6],xmm0[7],xmm4[7]
; X86-SSE-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1],xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; X86-SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1]
; X86-SSE-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; X86-SSE-NEXT:    retl
;
; X86-AVX-LABEL: test_mm_set_epi8:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-AVX-NEXT:    vmovd %ecx, %xmm0
; X86-AVX-NEXT:    vpinsrb $1, %eax, %xmm0, %xmm0
; X86-AVX-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vpinsrb $2, %eax, %xmm0, %xmm0
; X86-AVX-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vpinsrb $3, %eax, %xmm0, %xmm0
; X86-AVX-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vpinsrb $4, %eax, %xmm0, %xmm0
; X86-AVX-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vpinsrb $5, %eax, %xmm0, %xmm0
; X86-AVX-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vpinsrb $6, %eax, %xmm0, %xmm0
; X86-AVX-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vpinsrb $7, %eax, %xmm0, %xmm0
; X86-AVX-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vpinsrb $8, %eax, %xmm0, %xmm0
; X86-AVX-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vpinsrb $9, %eax, %xmm0, %xmm0
; X86-AVX-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vpinsrb $10, %eax, %xmm0, %xmm0
; X86-AVX-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vpinsrb $11, %eax, %xmm0, %xmm0
; X86-AVX-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vpinsrb $12, %eax, %xmm0, %xmm0
; X86-AVX-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vpinsrb $13, %eax, %xmm0, %xmm0
; X86-AVX-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vpinsrb $14, %eax, %xmm0, %xmm0
; X86-AVX-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vpinsrb $15, %eax, %xmm0, %xmm0
; X86-AVX-NEXT:    retl
;
; X64-SSE-LABEL: test_mm_set_epi8:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movzbl %dil, %eax
; X64-SSE-NEXT:    movd %eax, %xmm0
; X64-SSE-NEXT:    movzbl %sil, %eax
; X64-SSE-NEXT:    movd %eax, %xmm1
; X64-SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; X64-SSE-NEXT:    movzbl %dl, %eax
; X64-SSE-NEXT:    movd %eax, %xmm0
; X64-SSE-NEXT:    movzbl %cl, %eax
; X64-SSE-NEXT:    movd %eax, %xmm2
; X64-SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3],xmm2[4],xmm0[4],xmm2[5],xmm0[5],xmm2[6],xmm0[6],xmm2[7],xmm0[7]
; X64-SSE-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; X64-SSE-NEXT:    movzbl %r8b, %eax
; X64-SSE-NEXT:    movd %eax, %xmm0
; X64-SSE-NEXT:    movzbl %r9b, %eax
; X64-SSE-NEXT:    movd %eax, %xmm3
; X64-SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm0[0],xmm3[1],xmm0[1],xmm3[2],xmm0[2],xmm3[3],xmm0[3],xmm3[4],xmm0[4],xmm3[5],xmm0[5],xmm3[6],xmm0[6],xmm3[7],xmm0[7]
; X64-SSE-NEXT:    movzbl {{[0-9]+}}(%rsp), %eax
; X64-SSE-NEXT:    movd %eax, %xmm0
; X64-SSE-NEXT:    movzbl {{[0-9]+}}(%rsp), %eax
; X64-SSE-NEXT:    movd %eax, %xmm1
; X64-SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; X64-SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm3[0],xmm1[1],xmm3[1],xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; X64-SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1]
; X64-SSE-NEXT:    movzbl {{[0-9]+}}(%rsp), %eax
; X64-SSE-NEXT:    movd %eax, %xmm0
; X64-SSE-NEXT:    movzbl {{[0-9]+}}(%rsp), %eax
; X64-SSE-NEXT:    movd %eax, %xmm2
; X64-SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3],xmm2[4],xmm0[4],xmm2[5],xmm0[5],xmm2[6],xmm0[6],xmm2[7],xmm0[7]
; X64-SSE-NEXT:    movzbl {{[0-9]+}}(%rsp), %eax
; X64-SSE-NEXT:    movd %eax, %xmm0
; X64-SSE-NEXT:    movzbl {{[0-9]+}}(%rsp), %eax
; X64-SSE-NEXT:    movd %eax, %xmm3
; X64-SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm0[0],xmm3[1],xmm0[1],xmm3[2],xmm0[2],xmm3[3],xmm0[3],xmm3[4],xmm0[4],xmm3[5],xmm0[5],xmm3[6],xmm0[6],xmm3[7],xmm0[7]
; X64-SSE-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1],xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; X64-SSE-NEXT:    movzbl {{[0-9]+}}(%rsp), %eax
; X64-SSE-NEXT:    movd %eax, %xmm0
; X64-SSE-NEXT:    movzbl {{[0-9]+}}(%rsp), %eax
; X64-SSE-NEXT:    movd %eax, %xmm2
; X64-SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3],xmm2[4],xmm0[4],xmm2[5],xmm0[5],xmm2[6],xmm0[6],xmm2[7],xmm0[7]
; X64-SSE-NEXT:    movzbl {{[0-9]+}}(%rsp), %eax
; X64-SSE-NEXT:    movd %eax, %xmm4
; X64-SSE-NEXT:    movzbl {{[0-9]+}}(%rsp), %eax
; X64-SSE-NEXT:    movd %eax, %xmm0
; X64-SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm4[0],xmm0[1],xmm4[1],xmm0[2],xmm4[2],xmm0[3],xmm4[3],xmm0[4],xmm4[4],xmm0[5],xmm4[5],xmm0[6],xmm4[6],xmm0[7],xmm4[7]
; X64-SSE-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1],xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; X64-SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1]
; X64-SSE-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: test_mm_set_epi8:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movzbl {{[0-9]+}}(%rsp), %r10d
; X64-AVX-NEXT:    movzbl {{[0-9]+}}(%rsp), %eax
; X64-AVX-NEXT:    vmovd %eax, %xmm0
; X64-AVX-NEXT:    vpinsrb $1, %r10d, %xmm0, %xmm0
; X64-AVX-NEXT:    movzbl {{[0-9]+}}(%rsp), %eax
; X64-AVX-NEXT:    vpinsrb $2, %eax, %xmm0, %xmm0
; X64-AVX-NEXT:    movzbl {{[0-9]+}}(%rsp), %eax
; X64-AVX-NEXT:    vpinsrb $3, %eax, %xmm0, %xmm0
; X64-AVX-NEXT:    movzbl {{[0-9]+}}(%rsp), %eax
; X64-AVX-NEXT:    vpinsrb $4, %eax, %xmm0, %xmm0
; X64-AVX-NEXT:    movzbl {{[0-9]+}}(%rsp), %eax
; X64-AVX-NEXT:    vpinsrb $5, %eax, %xmm0, %xmm0
; X64-AVX-NEXT:    movzbl {{[0-9]+}}(%rsp), %eax
; X64-AVX-NEXT:    vpinsrb $6, %eax, %xmm0, %xmm0
; X64-AVX-NEXT:    movzbl {{[0-9]+}}(%rsp), %eax
; X64-AVX-NEXT:    vpinsrb $7, %eax, %xmm0, %xmm0
; X64-AVX-NEXT:    movzbl {{[0-9]+}}(%rsp), %eax
; X64-AVX-NEXT:    vpinsrb $8, %eax, %xmm0, %xmm0
; X64-AVX-NEXT:    movzbl {{[0-9]+}}(%rsp), %eax
; X64-AVX-NEXT:    vpinsrb $9, %eax, %xmm0, %xmm0
; X64-AVX-NEXT:    movzbl %r9b, %eax
; X64-AVX-NEXT:    vpinsrb $10, %eax, %xmm0, %xmm0
; X64-AVX-NEXT:    movzbl %r8b, %eax
; X64-AVX-NEXT:    vpinsrb $11, %eax, %xmm0, %xmm0
; X64-AVX-NEXT:    movzbl %cl, %eax
; X64-AVX-NEXT:    vpinsrb $12, %eax, %xmm0, %xmm0
; X64-AVX-NEXT:    movzbl %dl, %eax
; X64-AVX-NEXT:    vpinsrb $13, %eax, %xmm0, %xmm0
; X64-AVX-NEXT:    movzbl %sil, %eax
; X64-AVX-NEXT:    vpinsrb $14, %eax, %xmm0, %xmm0
; X64-AVX-NEXT:    movzbl %dil, %eax
; X64-AVX-NEXT:    vpinsrb $15, %eax, %xmm0, %xmm0
; X64-AVX-NEXT:    retq
  %res0  = insertelement <16 x i8> undef,  i8 %a15, i32 0
  %res1  = insertelement <16 x i8> %res0,  i8 %a14, i32 1
  %res2  = insertelement <16 x i8> %res1,  i8 %a13, i32 2
  %res3  = insertelement <16 x i8> %res2,  i8 %a12, i32 3
  %res4  = insertelement <16 x i8> %res3,  i8 %a11, i32 4
  %res5  = insertelement <16 x i8> %res4,  i8 %a10, i32 5
  %res6  = insertelement <16 x i8> %res5,  i8 %a9 , i32 6
  %res7  = insertelement <16 x i8> %res6,  i8 %a8 , i32 7
  %res8  = insertelement <16 x i8> %res7,  i8 %a7 , i32 8
  %res9  = insertelement <16 x i8> %res8,  i8 %a6 , i32 9
  %res10 = insertelement <16 x i8> %res9,  i8 %a5 , i32 10
  %res11 = insertelement <16 x i8> %res10, i8 %a4 , i32 11
  %res12 = insertelement <16 x i8> %res11, i8 %a3 , i32 12
  %res13 = insertelement <16 x i8> %res12, i8 %a2 , i32 13
  %res14 = insertelement <16 x i8> %res13, i8 %a1 , i32 14
  %res15 = insertelement <16 x i8> %res14, i8 %a0 , i32 15
  %res = bitcast <16 x i8> %res15 to <2 x i64>
  ret <2 x i64> %res
}

define <2 x i64> @test_mm_set_epi16(i16 %a0, i16 %a1, i16 %a2, i16 %a3, i16 %a4, i16 %a5, i16 %a6, i16 %a7) nounwind {
; X86-SSE-LABEL: test_mm_set_epi16:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm1
; X86-SSE-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm2
; X86-SSE-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm3
; X86-SSE-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm4
; X86-SSE-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm5
; X86-SSE-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm6
; X86-SSE-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm7
; X86-SSE-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm0
; X86-SSE-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; X86-SSE-NEXT:    punpcklwd {{.*#+}} xmm4 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; X86-SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1]
; X86-SSE-NEXT:    punpcklwd {{.*#+}} xmm6 = xmm6[0],xmm5[0],xmm6[1],xmm5[1],xmm6[2],xmm5[2],xmm6[3],xmm5[3]
; X86-SSE-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm7[0],xmm0[1],xmm7[1],xmm0[2],xmm7[2],xmm0[3],xmm7[3]
; X86-SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm6[0],xmm0[1],xmm6[1]
; X86-SSE-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm4[0]
; X86-SSE-NEXT:    retl
;
; X86-AVX-LABEL: test_mm_set_epi16:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vmovd %eax, %xmm0
; X86-AVX-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vpinsrw $1, %eax, %xmm0, %xmm0
; X86-AVX-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vpinsrw $2, %eax, %xmm0, %xmm0
; X86-AVX-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vpinsrw $3, %eax, %xmm0, %xmm0
; X86-AVX-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vpinsrw $4, %eax, %xmm0, %xmm0
; X86-AVX-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vpinsrw $5, %eax, %xmm0, %xmm0
; X86-AVX-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vpinsrw $6, %eax, %xmm0, %xmm0
; X86-AVX-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vpinsrw $7, %eax, %xmm0, %xmm0
; X86-AVX-NEXT:    retl
;
; X64-SSE-LABEL: test_mm_set_epi16:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movzwl {{[0-9]+}}(%rsp), %r10d
; X64-SSE-NEXT:    movzwl {{[0-9]+}}(%rsp), %eax
; X64-SSE-NEXT:    movd %edi, %xmm0
; X64-SSE-NEXT:    movd %esi, %xmm1
; X64-SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; X64-SSE-NEXT:    movd %edx, %xmm0
; X64-SSE-NEXT:    movd %ecx, %xmm2
; X64-SSE-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3]
; X64-SSE-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1]
; X64-SSE-NEXT:    movd %r8d, %xmm0
; X64-SSE-NEXT:    movd %r9d, %xmm1
; X64-SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; X64-SSE-NEXT:    movd %eax, %xmm3
; X64-SSE-NEXT:    movd %r10d, %xmm0
; X64-SSE-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1],xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; X64-SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; X64-SSE-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: test_mm_set_epi16:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movzwl {{[0-9]+}}(%rsp), %eax
; X64-AVX-NEXT:    movzwl {{[0-9]+}}(%rsp), %r10d
; X64-AVX-NEXT:    vmovd %eax, %xmm0
; X64-AVX-NEXT:    vpinsrw $1, %r10d, %xmm0, %xmm0
; X64-AVX-NEXT:    vpinsrw $2, %r9d, %xmm0, %xmm0
; X64-AVX-NEXT:    vpinsrw $3, %r8d, %xmm0, %xmm0
; X64-AVX-NEXT:    vpinsrw $4, %ecx, %xmm0, %xmm0
; X64-AVX-NEXT:    vpinsrw $5, %edx, %xmm0, %xmm0
; X64-AVX-NEXT:    vpinsrw $6, %esi, %xmm0, %xmm0
; X64-AVX-NEXT:    vpinsrw $7, %edi, %xmm0, %xmm0
; X64-AVX-NEXT:    retq
  %res0  = insertelement <8 x i16> undef, i16 %a7, i32 0
  %res1  = insertelement <8 x i16> %res0, i16 %a6, i32 1
  %res2  = insertelement <8 x i16> %res1, i16 %a5, i32 2
  %res3  = insertelement <8 x i16> %res2, i16 %a4, i32 3
  %res4  = insertelement <8 x i16> %res3, i16 %a3, i32 4
  %res5  = insertelement <8 x i16> %res4, i16 %a2, i32 5
  %res6  = insertelement <8 x i16> %res5, i16 %a1, i32 6
  %res7  = insertelement <8 x i16> %res6, i16 %a0, i32 7
  %res = bitcast <8 x i16> %res7 to <2 x i64>
  ret <2 x i64> %res
}

define <2 x i64> @test_mm_set_epi32(i32 %a0, i32 %a1, i32 %a2, i32 %a3) nounwind {
; X86-SSE-LABEL: test_mm_set_epi32:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-SSE-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; X86-SSE-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; X86-SSE-NEXT:    movss {{.*#+}} xmm2 = mem[0],zero,zero,zero
; X86-SSE-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; X86-SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; X86-SSE-NEXT:    retl
;
; X86-AVX-LABEL: test_mm_set_epi32:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-AVX-NEXT:    vpinsrd $1, {{[0-9]+}}(%esp), %xmm0, %xmm0
; X86-AVX-NEXT:    vpinsrd $2, {{[0-9]+}}(%esp), %xmm0, %xmm0
; X86-AVX-NEXT:    vpinsrd $3, {{[0-9]+}}(%esp), %xmm0, %xmm0
; X86-AVX-NEXT:    retl
;
; X64-SSE-LABEL: test_mm_set_epi32:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movd %edi, %xmm0
; X64-SSE-NEXT:    movd %esi, %xmm1
; X64-SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; X64-SSE-NEXT:    movd %edx, %xmm2
; X64-SSE-NEXT:    movd %ecx, %xmm0
; X64-SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; X64-SSE-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: test_mm_set_epi32:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovd %ecx, %xmm0
; X64-AVX-NEXT:    vpinsrd $1, %edx, %xmm0, %xmm0
; X64-AVX-NEXT:    vpinsrd $2, %esi, %xmm0, %xmm0
; X64-AVX-NEXT:    vpinsrd $3, %edi, %xmm0, %xmm0
; X64-AVX-NEXT:    retq
  %res0  = insertelement <4 x i32> undef, i32 %a3, i32 0
  %res1  = insertelement <4 x i32> %res0, i32 %a2, i32 1
  %res2  = insertelement <4 x i32> %res1, i32 %a1, i32 2
  %res3  = insertelement <4 x i32> %res2, i32 %a0, i32 3
  %res = bitcast <4 x i32> %res3 to <2 x i64>
  ret <2 x i64> %res
}

; TODO test_mm_set_epi64

define <2 x i64> @test_mm_set_epi64x(i64 %a0, i64 %a1) nounwind {
; X86-SSE-LABEL: test_mm_set_epi64x:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; X86-SSE-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-SSE-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; X86-SSE-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-SSE-NEXT:    movss {{.*#+}} xmm2 = mem[0],zero,zero,zero
; X86-SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; X86-SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; X86-SSE-NEXT:    retl
;
; X86-AVX-LABEL: test_mm_set_epi64x:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-AVX-NEXT:    vpinsrd $1, {{[0-9]+}}(%esp), %xmm0, %xmm0
; X86-AVX-NEXT:    vpinsrd $2, {{[0-9]+}}(%esp), %xmm0, %xmm0
; X86-AVX-NEXT:    vpinsrd $3, {{[0-9]+}}(%esp), %xmm0, %xmm0
; X86-AVX-NEXT:    retl
;
; X64-SSE-LABEL: test_mm_set_epi64x:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movq %rdi, %xmm1
; X64-SSE-NEXT:    movq %rsi, %xmm0
; X64-SSE-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: test_mm_set_epi64x:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovq %rdi, %xmm0
; X64-AVX-NEXT:    vmovq %rsi, %xmm1
; X64-AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; X64-AVX-NEXT:    retq
  %res0  = insertelement <2 x i64> undef, i64 %a1, i32 0
  %res1  = insertelement <2 x i64> %res0, i64 %a0, i32 1
  ret <2 x i64> %res1
}

define <2 x double> @test_mm_set_pd(double %a0, double %a1) nounwind {
; X86-SSE-LABEL: test_mm_set_pd:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; X86-SSE-NEXT:    movsd {{.*#+}} xmm1 = mem[0],zero
; X86-SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; X86-SSE-NEXT:    retl
;
; X86-AVX-LABEL: test_mm_set_pd:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; X86-AVX-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; X86-AVX-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; X86-AVX-NEXT:    retl
;
; X64-SSE-LABEL: test_mm_set_pd:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; X64-SSE-NEXT:    movaps %xmm1, %xmm0
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: test_mm_set_pd:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; X64-AVX-NEXT:    retq
  %res0  = insertelement <2 x double> undef, double %a1, i32 0
  %res1  = insertelement <2 x double> %res0, double %a0, i32 1
  ret <2 x double> %res1
}

define <2 x double> @test_mm_set_pd1(double %a0) nounwind {
; X86-SSE-LABEL: test_mm_set_pd1:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; X86-SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0,0]
; X86-SSE-NEXT:    retl
;
; X86-AVX-LABEL: test_mm_set_pd1:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; X86-AVX-NEXT:    vmovddup {{.*#+}} xmm0 = xmm0[0,0]
; X86-AVX-NEXT:    retl
;
; X64-SSE-LABEL: test_mm_set_pd1:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0,0]
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: test_mm_set_pd1:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovddup {{.*#+}} xmm0 = xmm0[0,0]
; X64-AVX-NEXT:    retq
  %res0  = insertelement <2 x double> undef, double %a0, i32 0
  %res1  = insertelement <2 x double> %res0, double %a0, i32 1
  ret <2 x double> %res1
}

define <2 x double> @test_mm_set_sd(double %a0) nounwind {
; X86-SSE-LABEL: test_mm_set_sd:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X86-SSE-NEXT:    movq {{.*#+}} xmm0 = xmm0[0],zero
; X86-SSE-NEXT:    retl
;
; X86-AVX-LABEL: test_mm_set_sd:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; X86-AVX-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; X86-AVX-NEXT:    retl
;
; X64-SSE-LABEL: test_mm_set_sd:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movq {{.*#+}} xmm0 = xmm0[0],zero
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: test_mm_set_sd:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; X64-AVX-NEXT:    retq
  %res0  = insertelement <2 x double> undef, double %a0, i32 0
  %res1  = insertelement <2 x double> %res0, double 0.0, i32 1
  ret <2 x double> %res1
}

define <2 x i64> @test_mm_set1_epi8(i8 %a0) nounwind {
; X86-SSE-LABEL: test_mm_set1_epi8:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm0
; X86-SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; X86-SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,0,2,3,4,5,6,7]
; X86-SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; X86-SSE-NEXT:    retl
;
; X86-AVX1-LABEL: test_mm_set1_epi8:
; X86-AVX1:       # %bb.0:
; X86-AVX1-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-AVX1-NEXT:    vmovd %eax, %xmm0
; X86-AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X86-AVX1-NEXT:    vpshufb %xmm1, %xmm0, %xmm0
; X86-AVX1-NEXT:    retl
;
; X86-AVX512-LABEL: test_mm_set1_epi8:
; X86-AVX512:       # %bb.0:
; X86-AVX512-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-AVX512-NEXT:    vpbroadcastb %eax, %xmm0
; X86-AVX512-NEXT:    retl
;
; X64-SSE-LABEL: test_mm_set1_epi8:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movzbl %dil, %eax
; X64-SSE-NEXT:    movd %eax, %xmm0
; X64-SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; X64-SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,0,2,3,4,5,6,7]
; X64-SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; X64-SSE-NEXT:    retq
;
; X64-AVX1-LABEL: test_mm_set1_epi8:
; X64-AVX1:       # %bb.0:
; X64-AVX1-NEXT:    movzbl %dil, %eax
; X64-AVX1-NEXT:    vmovd %eax, %xmm0
; X64-AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X64-AVX1-NEXT:    vpshufb %xmm1, %xmm0, %xmm0
; X64-AVX1-NEXT:    retq
;
; X64-AVX512-LABEL: test_mm_set1_epi8:
; X64-AVX512:       # %bb.0:
; X64-AVX512-NEXT:    vpbroadcastb %edi, %xmm0
; X64-AVX512-NEXT:    retq
  %res0  = insertelement <16 x i8> undef,  i8 %a0, i32 0
  %res1  = insertelement <16 x i8> %res0,  i8 %a0, i32 1
  %res2  = insertelement <16 x i8> %res1,  i8 %a0, i32 2
  %res3  = insertelement <16 x i8> %res2,  i8 %a0, i32 3
  %res4  = insertelement <16 x i8> %res3,  i8 %a0, i32 4
  %res5  = insertelement <16 x i8> %res4,  i8 %a0, i32 5
  %res6  = insertelement <16 x i8> %res5,  i8 %a0, i32 6
  %res7  = insertelement <16 x i8> %res6,  i8 %a0, i32 7
  %res8  = insertelement <16 x i8> %res7,  i8 %a0, i32 8
  %res9  = insertelement <16 x i8> %res8,  i8 %a0, i32 9
  %res10 = insertelement <16 x i8> %res9,  i8 %a0, i32 10
  %res11 = insertelement <16 x i8> %res10, i8 %a0, i32 11
  %res12 = insertelement <16 x i8> %res11, i8 %a0, i32 12
  %res13 = insertelement <16 x i8> %res12, i8 %a0, i32 13
  %res14 = insertelement <16 x i8> %res13, i8 %a0, i32 14
  %res15 = insertelement <16 x i8> %res14, i8 %a0, i32 15
  %res = bitcast <16 x i8> %res15 to <2 x i64>
  ret <2 x i64> %res
}

define <2 x i64> @test_mm_set1_epi16(i16 %a0) nounwind {
; X86-SSE-LABEL: test_mm_set1_epi16:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm0
; X86-SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,0,2,3,4,5,6,7]
; X86-SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; X86-SSE-NEXT:    retl
;
; X86-AVX1-LABEL: test_mm_set1_epi16:
; X86-AVX1:       # %bb.0:
; X86-AVX1-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-AVX1-NEXT:    vmovd %eax, %xmm0
; X86-AVX1-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,0,2,3,4,5,6,7]
; X86-AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; X86-AVX1-NEXT:    retl
;
; X86-AVX512-LABEL: test_mm_set1_epi16:
; X86-AVX512:       # %bb.0:
; X86-AVX512-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-AVX512-NEXT:    vpbroadcastw %eax, %xmm0
; X86-AVX512-NEXT:    retl
;
; X64-SSE-LABEL: test_mm_set1_epi16:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movd %edi, %xmm0
; X64-SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,0,2,3,4,5,6,7]
; X64-SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; X64-SSE-NEXT:    retq
;
; X64-AVX1-LABEL: test_mm_set1_epi16:
; X64-AVX1:       # %bb.0:
; X64-AVX1-NEXT:    vmovd %edi, %xmm0
; X64-AVX1-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,0,2,3,4,5,6,7]
; X64-AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; X64-AVX1-NEXT:    retq
;
; X64-AVX512-LABEL: test_mm_set1_epi16:
; X64-AVX512:       # %bb.0:
; X64-AVX512-NEXT:    vpbroadcastw %edi, %xmm0
; X64-AVX512-NEXT:    retq
  %res0  = insertelement <8 x i16> undef, i16 %a0, i32 0
  %res1  = insertelement <8 x i16> %res0, i16 %a0, i32 1
  %res2  = insertelement <8 x i16> %res1, i16 %a0, i32 2
  %res3  = insertelement <8 x i16> %res2, i16 %a0, i32 3
  %res4  = insertelement <8 x i16> %res3, i16 %a0, i32 4
  %res5  = insertelement <8 x i16> %res4, i16 %a0, i32 5
  %res6  = insertelement <8 x i16> %res5, i16 %a0, i32 6
  %res7  = insertelement <8 x i16> %res6, i16 %a0, i32 7
  %res = bitcast <8 x i16> %res7 to <2 x i64>
  ret <2 x i64> %res
}

define <2 x i64> @test_mm_set1_epi32(i32 %a0) nounwind {
; X86-SSE-LABEL: test_mm_set1_epi32:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; X86-SSE-NEXT:    retl
;
; X86-AVX1-LABEL: test_mm_set1_epi32:
; X86-AVX1:       # %bb.0:
; X86-AVX1-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-AVX1-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,0,0,0]
; X86-AVX1-NEXT:    retl
;
; X86-AVX512-LABEL: test_mm_set1_epi32:
; X86-AVX512:       # %bb.0:
; X86-AVX512-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX512-NEXT:    vpbroadcastd %eax, %xmm0
; X86-AVX512-NEXT:    retl
;
; X64-SSE-LABEL: test_mm_set1_epi32:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movd %edi, %xmm0
; X64-SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; X64-SSE-NEXT:    retq
;
; X64-AVX1-LABEL: test_mm_set1_epi32:
; X64-AVX1:       # %bb.0:
; X64-AVX1-NEXT:    vmovd %edi, %xmm0
; X64-AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; X64-AVX1-NEXT:    retq
;
; X64-AVX512-LABEL: test_mm_set1_epi32:
; X64-AVX512:       # %bb.0:
; X64-AVX512-NEXT:    vpbroadcastd %edi, %xmm0
; X64-AVX512-NEXT:    retq
  %res0  = insertelement <4 x i32> undef, i32 %a0, i32 0
  %res1  = insertelement <4 x i32> %res0, i32 %a0, i32 1
  %res2  = insertelement <4 x i32> %res1, i32 %a0, i32 2
  %res3  = insertelement <4 x i32> %res2, i32 %a0, i32 3
  %res = bitcast <4 x i32> %res3 to <2 x i64>
  ret <2 x i64> %res
}

; TODO test_mm_set1_epi64

define <2 x i64> @test_mm_set1_epi64x(i64 %a0) nounwind {
; X86-SSE-LABEL: test_mm_set1_epi64x:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-SSE-NEXT:    movd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; X86-SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; X86-SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,0,1]
; X86-SSE-NEXT:    retl
;
; X86-AVX1-LABEL: test_mm_set1_epi64x:
; X86-AVX1:       # %bb.0:
; X86-AVX1-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX1-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-AVX1-NEXT:    vmovd %ecx, %xmm0
; X86-AVX1-NEXT:    vpinsrd $1, %eax, %xmm0, %xmm0
; X86-AVX1-NEXT:    vpinsrd $2, %ecx, %xmm0, %xmm0
; X86-AVX1-NEXT:    vpinsrd $3, %eax, %xmm0, %xmm0
; X86-AVX1-NEXT:    retl
;
; X86-AVX512-LABEL: test_mm_set1_epi64x:
; X86-AVX512:       # %bb.0:
; X86-AVX512-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-AVX512-NEXT:    vpinsrd $1, {{[0-9]+}}(%esp), %xmm0, %xmm0
; X86-AVX512-NEXT:    vpbroadcastq %xmm0, %xmm0
; X86-AVX512-NEXT:    retl
;
; X64-SSE-LABEL: test_mm_set1_epi64x:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movq %rdi, %xmm0
; X64-SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,0,1]
; X64-SSE-NEXT:    retq
;
; X64-AVX1-LABEL: test_mm_set1_epi64x:
; X64-AVX1:       # %bb.0:
; X64-AVX1-NEXT:    vmovq %rdi, %xmm0
; X64-AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,1,0,1]
; X64-AVX1-NEXT:    retq
;
; X64-AVX512-LABEL: test_mm_set1_epi64x:
; X64-AVX512:       # %bb.0:
; X64-AVX512-NEXT:    vpbroadcastq %rdi, %xmm0
; X64-AVX512-NEXT:    retq
  %res0  = insertelement <2 x i64> undef, i64 %a0, i32 0
  %res1  = insertelement <2 x i64> %res0, i64 %a0, i32 1
  ret <2 x i64> %res1
}

define <2 x double> @test_mm_set1_pd(double %a0) nounwind {
; X86-SSE-LABEL: test_mm_set1_pd:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; X86-SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0,0]
; X86-SSE-NEXT:    retl
;
; X86-AVX-LABEL: test_mm_set1_pd:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; X86-AVX-NEXT:    vmovddup {{.*#+}} xmm0 = xmm0[0,0]
; X86-AVX-NEXT:    retl
;
; X64-SSE-LABEL: test_mm_set1_pd:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0,0]
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: test_mm_set1_pd:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovddup {{.*#+}} xmm0 = xmm0[0,0]
; X64-AVX-NEXT:    retq
  %res0  = insertelement <2 x double> undef, double %a0, i32 0
  %res1  = insertelement <2 x double> %res0, double %a0, i32 1
  ret <2 x double> %res1
}

define <2 x i64> @test_mm_setr_epi8(i8 %a0, i8 %a1, i8 %a2, i8 %a3, i8 %a4, i8 %a5, i8 %a6, i8 %a7, i8 %a8, i8 %a9, i8 %a10, i8 %a11, i8 %a12, i8 %a13, i8 %a14, i8 %a15) nounwind {
; X86-SSE-LABEL: test_mm_setr_epi8:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm0
; X86-SSE-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm1
; X86-SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; X86-SSE-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm0
; X86-SSE-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm2
; X86-SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3],xmm2[4],xmm0[4],xmm2[5],xmm0[5],xmm2[6],xmm0[6],xmm2[7],xmm0[7]
; X86-SSE-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; X86-SSE-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm0
; X86-SSE-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm3
; X86-SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm0[0],xmm3[1],xmm0[1],xmm3[2],xmm0[2],xmm3[3],xmm0[3],xmm3[4],xmm0[4],xmm3[5],xmm0[5],xmm3[6],xmm0[6],xmm3[7],xmm0[7]
; X86-SSE-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm0
; X86-SSE-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm1
; X86-SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; X86-SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm3[0],xmm1[1],xmm3[1],xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; X86-SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1]
; X86-SSE-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm0
; X86-SSE-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm2
; X86-SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3],xmm2[4],xmm0[4],xmm2[5],xmm0[5],xmm2[6],xmm0[6],xmm2[7],xmm0[7]
; X86-SSE-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm0
; X86-SSE-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm3
; X86-SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm0[0],xmm3[1],xmm0[1],xmm3[2],xmm0[2],xmm3[3],xmm0[3],xmm3[4],xmm0[4],xmm3[5],xmm0[5],xmm3[6],xmm0[6],xmm3[7],xmm0[7]
; X86-SSE-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1],xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; X86-SSE-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm0
; X86-SSE-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm2
; X86-SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3],xmm2[4],xmm0[4],xmm2[5],xmm0[5],xmm2[6],xmm0[6],xmm2[7],xmm0[7]
; X86-SSE-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm4
; X86-SSE-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm0
; X86-SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm4[0],xmm0[1],xmm4[1],xmm0[2],xmm4[2],xmm0[3],xmm4[3],xmm0[4],xmm4[4],xmm0[5],xmm4[5],xmm0[6],xmm4[6],xmm0[7],xmm4[7]
; X86-SSE-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1],xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; X86-SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1]
; X86-SSE-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; X86-SSE-NEXT:    retl
;
; X86-AVX-LABEL: test_mm_setr_epi8:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-AVX-NEXT:    vmovd %ecx, %xmm0
; X86-AVX-NEXT:    vpinsrb $1, %eax, %xmm0, %xmm0
; X86-AVX-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vpinsrb $2, %eax, %xmm0, %xmm0
; X86-AVX-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vpinsrb $3, %eax, %xmm0, %xmm0
; X86-AVX-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vpinsrb $4, %eax, %xmm0, %xmm0
; X86-AVX-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vpinsrb $5, %eax, %xmm0, %xmm0
; X86-AVX-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vpinsrb $6, %eax, %xmm0, %xmm0
; X86-AVX-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vpinsrb $7, %eax, %xmm0, %xmm0
; X86-AVX-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vpinsrb $8, %eax, %xmm0, %xmm0
; X86-AVX-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vpinsrb $9, %eax, %xmm0, %xmm0
; X86-AVX-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vpinsrb $10, %eax, %xmm0, %xmm0
; X86-AVX-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vpinsrb $11, %eax, %xmm0, %xmm0
; X86-AVX-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vpinsrb $12, %eax, %xmm0, %xmm0
; X86-AVX-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vpinsrb $13, %eax, %xmm0, %xmm0
; X86-AVX-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vpinsrb $14, %eax, %xmm0, %xmm0
; X86-AVX-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vpinsrb $15, %eax, %xmm0, %xmm0
; X86-AVX-NEXT:    retl
;
; X64-SSE-LABEL: test_mm_setr_epi8:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movzbl {{[0-9]+}}(%rsp), %eax
; X64-SSE-NEXT:    movd %eax, %xmm0
; X64-SSE-NEXT:    movzbl {{[0-9]+}}(%rsp), %eax
; X64-SSE-NEXT:    movd %eax, %xmm1
; X64-SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; X64-SSE-NEXT:    movzbl {{[0-9]+}}(%rsp), %eax
; X64-SSE-NEXT:    movd %eax, %xmm0
; X64-SSE-NEXT:    movzbl {{[0-9]+}}(%rsp), %eax
; X64-SSE-NEXT:    movd %eax, %xmm2
; X64-SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3],xmm2[4],xmm0[4],xmm2[5],xmm0[5],xmm2[6],xmm0[6],xmm2[7],xmm0[7]
; X64-SSE-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; X64-SSE-NEXT:    movzbl {{[0-9]+}}(%rsp), %eax
; X64-SSE-NEXT:    movd %eax, %xmm0
; X64-SSE-NEXT:    movzbl {{[0-9]+}}(%rsp), %eax
; X64-SSE-NEXT:    movd %eax, %xmm3
; X64-SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm0[0],xmm3[1],xmm0[1],xmm3[2],xmm0[2],xmm3[3],xmm0[3],xmm3[4],xmm0[4],xmm3[5],xmm0[5],xmm3[6],xmm0[6],xmm3[7],xmm0[7]
; X64-SSE-NEXT:    movzbl {{[0-9]+}}(%rsp), %eax
; X64-SSE-NEXT:    movd %eax, %xmm0
; X64-SSE-NEXT:    movzbl {{[0-9]+}}(%rsp), %eax
; X64-SSE-NEXT:    movd %eax, %xmm1
; X64-SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; X64-SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm3[0],xmm1[1],xmm3[1],xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; X64-SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1]
; X64-SSE-NEXT:    movzbl {{[0-9]+}}(%rsp), %eax
; X64-SSE-NEXT:    movd %eax, %xmm0
; X64-SSE-NEXT:    movzbl {{[0-9]+}}(%rsp), %eax
; X64-SSE-NEXT:    movd %eax, %xmm2
; X64-SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3],xmm2[4],xmm0[4],xmm2[5],xmm0[5],xmm2[6],xmm0[6],xmm2[7],xmm0[7]
; X64-SSE-NEXT:    movzbl %r9b, %eax
; X64-SSE-NEXT:    movd %eax, %xmm0
; X64-SSE-NEXT:    movzbl %r8b, %eax
; X64-SSE-NEXT:    movd %eax, %xmm3
; X64-SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm0[0],xmm3[1],xmm0[1],xmm3[2],xmm0[2],xmm3[3],xmm0[3],xmm3[4],xmm0[4],xmm3[5],xmm0[5],xmm3[6],xmm0[6],xmm3[7],xmm0[7]
; X64-SSE-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1],xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; X64-SSE-NEXT:    movzbl %cl, %eax
; X64-SSE-NEXT:    movd %eax, %xmm0
; X64-SSE-NEXT:    movzbl %dl, %eax
; X64-SSE-NEXT:    movd %eax, %xmm2
; X64-SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3],xmm2[4],xmm0[4],xmm2[5],xmm0[5],xmm2[6],xmm0[6],xmm2[7],xmm0[7]
; X64-SSE-NEXT:    movzbl %sil, %eax
; X64-SSE-NEXT:    movd %eax, %xmm4
; X64-SSE-NEXT:    movzbl %dil, %eax
; X64-SSE-NEXT:    movd %eax, %xmm0
; X64-SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm4[0],xmm0[1],xmm4[1],xmm0[2],xmm4[2],xmm0[3],xmm4[3],xmm0[4],xmm4[4],xmm0[5],xmm4[5],xmm0[6],xmm4[6],xmm0[7],xmm4[7]
; X64-SSE-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1],xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; X64-SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1]
; X64-SSE-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: test_mm_setr_epi8:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movzbl %sil, %eax
; X64-AVX-NEXT:    movzbl %dil, %esi
; X64-AVX-NEXT:    vmovd %esi, %xmm0
; X64-AVX-NEXT:    vpinsrb $1, %eax, %xmm0, %xmm0
; X64-AVX-NEXT:    movzbl %dl, %eax
; X64-AVX-NEXT:    vpinsrb $2, %eax, %xmm0, %xmm0
; X64-AVX-NEXT:    movzbl %cl, %eax
; X64-AVX-NEXT:    vpinsrb $3, %eax, %xmm0, %xmm0
; X64-AVX-NEXT:    movzbl %r8b, %eax
; X64-AVX-NEXT:    vpinsrb $4, %eax, %xmm0, %xmm0
; X64-AVX-NEXT:    movzbl %r9b, %eax
; X64-AVX-NEXT:    vpinsrb $5, %eax, %xmm0, %xmm0
; X64-AVX-NEXT:    movzbl {{[0-9]+}}(%rsp), %eax
; X64-AVX-NEXT:    vpinsrb $6, %eax, %xmm0, %xmm0
; X64-AVX-NEXT:    movzbl {{[0-9]+}}(%rsp), %eax
; X64-AVX-NEXT:    vpinsrb $7, %eax, %xmm0, %xmm0
; X64-AVX-NEXT:    movzbl {{[0-9]+}}(%rsp), %eax
; X64-AVX-NEXT:    vpinsrb $8, %eax, %xmm0, %xmm0
; X64-AVX-NEXT:    movzbl {{[0-9]+}}(%rsp), %eax
; X64-AVX-NEXT:    vpinsrb $9, %eax, %xmm0, %xmm0
; X64-AVX-NEXT:    movzbl {{[0-9]+}}(%rsp), %eax
; X64-AVX-NEXT:    vpinsrb $10, %eax, %xmm0, %xmm0
; X64-AVX-NEXT:    movzbl {{[0-9]+}}(%rsp), %eax
; X64-AVX-NEXT:    vpinsrb $11, %eax, %xmm0, %xmm0
; X64-AVX-NEXT:    movzbl {{[0-9]+}}(%rsp), %eax
; X64-AVX-NEXT:    vpinsrb $12, %eax, %xmm0, %xmm0
; X64-AVX-NEXT:    movzbl {{[0-9]+}}(%rsp), %eax
; X64-AVX-NEXT:    vpinsrb $13, %eax, %xmm0, %xmm0
; X64-AVX-NEXT:    movzbl {{[0-9]+}}(%rsp), %eax
; X64-AVX-NEXT:    vpinsrb $14, %eax, %xmm0, %xmm0
; X64-AVX-NEXT:    movzbl {{[0-9]+}}(%rsp), %eax
; X64-AVX-NEXT:    vpinsrb $15, %eax, %xmm0, %xmm0
; X64-AVX-NEXT:    retq
  %res0  = insertelement <16 x i8> undef,  i8 %a0 , i32 0
  %res1  = insertelement <16 x i8> %res0,  i8 %a1 , i32 1
  %res2  = insertelement <16 x i8> %res1,  i8 %a2 , i32 2
  %res3  = insertelement <16 x i8> %res2,  i8 %a3 , i32 3
  %res4  = insertelement <16 x i8> %res3,  i8 %a4 , i32 4
  %res5  = insertelement <16 x i8> %res4,  i8 %a5 , i32 5
  %res6  = insertelement <16 x i8> %res5,  i8 %a6 , i32 6
  %res7  = insertelement <16 x i8> %res6,  i8 %a7 , i32 7
  %res8  = insertelement <16 x i8> %res7,  i8 %a8 , i32 8
  %res9  = insertelement <16 x i8> %res8,  i8 %a9 , i32 9
  %res10 = insertelement <16 x i8> %res9,  i8 %a10, i32 10
  %res11 = insertelement <16 x i8> %res10, i8 %a11, i32 11
  %res12 = insertelement <16 x i8> %res11, i8 %a12, i32 12
  %res13 = insertelement <16 x i8> %res12, i8 %a13, i32 13
  %res14 = insertelement <16 x i8> %res13, i8 %a14, i32 14
  %res15 = insertelement <16 x i8> %res14, i8 %a15, i32 15
  %res = bitcast <16 x i8> %res15 to <2 x i64>
  ret <2 x i64> %res
}

define <2 x i64> @test_mm_setr_epi16(i16 %a0, i16 %a1, i16 %a2, i16 %a3, i16 %a4, i16 %a5, i16 %a6, i16 %a7) nounwind {
; X86-SSE-LABEL: test_mm_setr_epi16:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm1
; X86-SSE-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm2
; X86-SSE-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm3
; X86-SSE-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm4
; X86-SSE-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm5
; X86-SSE-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm6
; X86-SSE-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm7
; X86-SSE-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd %eax, %xmm0
; X86-SSE-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; X86-SSE-NEXT:    punpcklwd {{.*#+}} xmm4 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; X86-SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1]
; X86-SSE-NEXT:    punpcklwd {{.*#+}} xmm6 = xmm6[0],xmm5[0],xmm6[1],xmm5[1],xmm6[2],xmm5[2],xmm6[3],xmm5[3]
; X86-SSE-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm7[0],xmm0[1],xmm7[1],xmm0[2],xmm7[2],xmm0[3],xmm7[3]
; X86-SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm6[0],xmm0[1],xmm6[1]
; X86-SSE-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm4[0]
; X86-SSE-NEXT:    retl
;
; X86-AVX-LABEL: test_mm_setr_epi16:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vmovd %eax, %xmm0
; X86-AVX-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vpinsrw $1, %eax, %xmm0, %xmm0
; X86-AVX-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vpinsrw $2, %eax, %xmm0, %xmm0
; X86-AVX-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vpinsrw $3, %eax, %xmm0, %xmm0
; X86-AVX-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vpinsrw $4, %eax, %xmm0, %xmm0
; X86-AVX-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vpinsrw $5, %eax, %xmm0, %xmm0
; X86-AVX-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vpinsrw $6, %eax, %xmm0, %xmm0
; X86-AVX-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vpinsrw $7, %eax, %xmm0, %xmm0
; X86-AVX-NEXT:    retl
;
; X64-SSE-LABEL: test_mm_setr_epi16:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movzwl {{[0-9]+}}(%rsp), %eax
; X64-SSE-NEXT:    movzwl {{[0-9]+}}(%rsp), %r10d
; X64-SSE-NEXT:    movd %eax, %xmm0
; X64-SSE-NEXT:    movd %r10d, %xmm1
; X64-SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; X64-SSE-NEXT:    movd %r9d, %xmm0
; X64-SSE-NEXT:    movd %r8d, %xmm2
; X64-SSE-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3]
; X64-SSE-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1]
; X64-SSE-NEXT:    movd %ecx, %xmm0
; X64-SSE-NEXT:    movd %edx, %xmm1
; X64-SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; X64-SSE-NEXT:    movd %esi, %xmm3
; X64-SSE-NEXT:    movd %edi, %xmm0
; X64-SSE-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1],xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; X64-SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; X64-SSE-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: test_mm_setr_epi16:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    movzwl {{[0-9]+}}(%rsp), %r10d
; X64-AVX-NEXT:    movzwl {{[0-9]+}}(%rsp), %eax
; X64-AVX-NEXT:    vmovd %edi, %xmm0
; X64-AVX-NEXT:    vpinsrw $1, %esi, %xmm0, %xmm0
; X64-AVX-NEXT:    vpinsrw $2, %edx, %xmm0, %xmm0
; X64-AVX-NEXT:    vpinsrw $3, %ecx, %xmm0, %xmm0
; X64-AVX-NEXT:    vpinsrw $4, %r8d, %xmm0, %xmm0
; X64-AVX-NEXT:    vpinsrw $5, %r9d, %xmm0, %xmm0
; X64-AVX-NEXT:    vpinsrw $6, %eax, %xmm0, %xmm0
; X64-AVX-NEXT:    vpinsrw $7, %r10d, %xmm0, %xmm0
; X64-AVX-NEXT:    retq
  %res0  = insertelement <8 x i16> undef, i16 %a0, i32 0
  %res1  = insertelement <8 x i16> %res0, i16 %a1, i32 1
  %res2  = insertelement <8 x i16> %res1, i16 %a2, i32 2
  %res3  = insertelement <8 x i16> %res2, i16 %a3, i32 3
  %res4  = insertelement <8 x i16> %res3, i16 %a4, i32 4
  %res5  = insertelement <8 x i16> %res4, i16 %a5, i32 5
  %res6  = insertelement <8 x i16> %res5, i16 %a6, i32 6
  %res7  = insertelement <8 x i16> %res6, i16 %a7, i32 7
  %res = bitcast <8 x i16> %res7 to <2 x i64>
  ret <2 x i64> %res
}

define <2 x i64> @test_mm_setr_epi32(i32 %a0, i32 %a1, i32 %a2, i32 %a3) nounwind {
; X86-SSE-LABEL: test_mm_setr_epi32:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-SSE-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; X86-SSE-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; X86-SSE-NEXT:    movss {{.*#+}} xmm2 = mem[0],zero,zero,zero
; X86-SSE-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; X86-SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; X86-SSE-NEXT:    retl
;
; X86-AVX-LABEL: test_mm_setr_epi32:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-AVX-NEXT:    vpinsrd $1, {{[0-9]+}}(%esp), %xmm0, %xmm0
; X86-AVX-NEXT:    vpinsrd $2, {{[0-9]+}}(%esp), %xmm0, %xmm0
; X86-AVX-NEXT:    vpinsrd $3, {{[0-9]+}}(%esp), %xmm0, %xmm0
; X86-AVX-NEXT:    retl
;
; X64-SSE-LABEL: test_mm_setr_epi32:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movd %ecx, %xmm0
; X64-SSE-NEXT:    movd %edx, %xmm1
; X64-SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; X64-SSE-NEXT:    movd %esi, %xmm2
; X64-SSE-NEXT:    movd %edi, %xmm0
; X64-SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; X64-SSE-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: test_mm_setr_epi32:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovd %edi, %xmm0
; X64-AVX-NEXT:    vpinsrd $1, %esi, %xmm0, %xmm0
; X64-AVX-NEXT:    vpinsrd $2, %edx, %xmm0, %xmm0
; X64-AVX-NEXT:    vpinsrd $3, %ecx, %xmm0, %xmm0
; X64-AVX-NEXT:    retq
  %res0  = insertelement <4 x i32> undef, i32 %a0, i32 0
  %res1  = insertelement <4 x i32> %res0, i32 %a1, i32 1
  %res2  = insertelement <4 x i32> %res1, i32 %a2, i32 2
  %res3  = insertelement <4 x i32> %res2, i32 %a3, i32 3
  %res = bitcast <4 x i32> %res3 to <2 x i64>
  ret <2 x i64> %res
}

; TODO test_mm_setr_epi64

define <2 x i64> @test_mm_setr_epi64x(i64 %a0, i64 %a1) nounwind {
; X86-SSE-LABEL: test_mm_setr_epi64x:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; X86-SSE-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-SSE-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; X86-SSE-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-SSE-NEXT:    movss {{.*#+}} xmm2 = mem[0],zero,zero,zero
; X86-SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; X86-SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; X86-SSE-NEXT:    retl
;
; X86-AVX-LABEL: test_mm_setr_epi64x:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-AVX-NEXT:    vpinsrd $1, {{[0-9]+}}(%esp), %xmm0, %xmm0
; X86-AVX-NEXT:    vpinsrd $2, {{[0-9]+}}(%esp), %xmm0, %xmm0
; X86-AVX-NEXT:    vpinsrd $3, {{[0-9]+}}(%esp), %xmm0, %xmm0
; X86-AVX-NEXT:    retl
;
; X64-SSE-LABEL: test_mm_setr_epi64x:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movq %rsi, %xmm1
; X64-SSE-NEXT:    movq %rdi, %xmm0
; X64-SSE-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: test_mm_setr_epi64x:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovq %rsi, %xmm0
; X64-AVX-NEXT:    vmovq %rdi, %xmm1
; X64-AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; X64-AVX-NEXT:    retq
  %res0  = insertelement <2 x i64> undef, i64 %a0, i32 0
  %res1  = insertelement <2 x i64> %res0, i64 %a1, i32 1
  ret <2 x i64> %res1
}

define <2 x double> @test_mm_setr_pd(double %a0, double %a1) nounwind {
; X86-SSE-LABEL: test_mm_setr_pd:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movsd {{.*#+}} xmm1 = mem[0],zero
; X86-SSE-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; X86-SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; X86-SSE-NEXT:    retl
;
; X86-AVX-LABEL: test_mm_setr_pd:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; X86-AVX-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; X86-AVX-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; X86-AVX-NEXT:    retl
;
; X64-SSE-LABEL: test_mm_setr_pd:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: test_mm_setr_pd:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; X64-AVX-NEXT:    retq
  %res0  = insertelement <2 x double> undef, double %a0, i32 0
  %res1  = insertelement <2 x double> %res0, double %a1, i32 1
  ret <2 x double> %res1
}

define <2 x double> @test_mm_setzero_pd() {
; SSE-LABEL: test_mm_setzero_pd:
; SSE:       # %bb.0:
; SSE-NEXT:    xorps %xmm0, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_setzero_pd:
; AVX:       # %bb.0:
; AVX-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  ret <2 x double> zeroinitializer
}

define <2 x i64> @test_mm_setzero_si128() {
; SSE-LABEL: test_mm_setzero_si128:
; SSE:       # %bb.0:
; SSE-NEXT:    xorps %xmm0, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_setzero_si128:
; AVX:       # %bb.0:
; AVX-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  ret <2 x i64> zeroinitializer
}

define <2 x i64> @test_mm_shuffle_epi32(<2 x i64> %a0) {
; SSE-LABEL: test_mm_shuffle_epi32:
; SSE:       # %bb.0:
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1-LABEL: test_mm_shuffle_epi32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,0,0,0]
; AVX1-NEXT:    ret{{[l|q]}}
;
; AVX512-LABEL: test_mm_shuffle_epi32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vbroadcastss %xmm0, %xmm0
; AVX512-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <4 x i32>
  %res = shufflevector <4 x i32> %arg0, <4 x i32> undef, <4 x i32> zeroinitializer
  %bc = bitcast <4 x i32> %res to <2 x i64>
  ret <2 x i64> %bc
}

define <2 x double> @test_mm_shuffle_pd(<2 x double> %a0, <2 x double> %a1) {
; SSE-LABEL: test_mm_shuffle_pd:
; SSE:       # %bb.0:
; SSE-NEXT:    shufpd {{.*#+}} xmm0 = xmm0[1],xmm1[0]
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_shuffle_pd:
; AVX:       # %bb.0:
; AVX-NEXT:    vshufpd {{.*#+}} xmm0 = xmm0[1],xmm1[0]
; AVX-NEXT:    ret{{[l|q]}}
  %res = shufflevector <2 x double> %a0, <2 x double> %a1, <2 x i32> <i32 1, i32 2>
  ret <2 x double> %res
}

define <2 x i64> @test_mm_shufflehi_epi16(<2 x i64> %a0) {
; SSE-LABEL: test_mm_shufflehi_epi16:
; SSE:       # %bb.0:
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,4,4,4]
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_shufflehi_epi16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,4,4,4]
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <8 x i16>
  %res = shufflevector <8 x i16> %arg0, <8 x i16> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 4, i32 4, i32 4>
  %bc = bitcast <8 x i16> %res to <2 x i64>
  ret <2 x i64> %bc
}

define <2 x i64> @test_mm_shufflelo_epi16(<2 x i64> %a0) {
; SSE-LABEL: test_mm_shufflelo_epi16:
; SSE:       # %bb.0:
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,0,0,0,4,5,6,7]
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_shufflelo_epi16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,0,0,0,4,5,6,7]
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <8 x i16>
  %res = shufflevector <8 x i16> %arg0, <8 x i16> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 4, i32 5, i32 6, i32 7>
  %bc = bitcast <8 x i16> %res to <2 x i64>
  ret <2 x i64> %bc
}

define <2 x i64> @test_mm_sll_epi16(<2 x i64> %a0, <2 x i64> %a1) {
; SSE-LABEL: test_mm_sll_epi16:
; SSE:       # %bb.0:
; SSE-NEXT:    psllw %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_sll_epi16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsllw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <8 x i16>
  %arg1 = bitcast <2 x i64> %a1 to <8 x i16>
  %res = call <8 x i16> @llvm.x86.sse2.psll.w(<8 x i16> %arg0, <8 x i16> %arg1)
  %bc = bitcast <8 x i16> %res to <2 x i64>
  ret <2 x i64> %bc
}
declare <8 x i16> @llvm.x86.sse2.psll.w(<8 x i16>, <8 x i16>) nounwind readnone

define <2 x i64> @test_mm_sll_epi32(<2 x i64> %a0, <2 x i64> %a1) {
; SSE-LABEL: test_mm_sll_epi32:
; SSE:       # %bb.0:
; SSE-NEXT:    pslld %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_sll_epi32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpslld %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <4 x i32>
  %arg1 = bitcast <2 x i64> %a1 to <4 x i32>
  %res = call <4 x i32> @llvm.x86.sse2.psll.d(<4 x i32> %arg0, <4 x i32> %arg1)
  %bc = bitcast <4 x i32> %res to <2 x i64>
  ret <2 x i64> %bc
}
declare <4 x i32> @llvm.x86.sse2.psll.d(<4 x i32>, <4 x i32>) nounwind readnone

define <2 x i64> @test_mm_sll_epi64(<2 x i64> %a0, <2 x i64> %a1) {
; SSE-LABEL: test_mm_sll_epi64:
; SSE:       # %bb.0:
; SSE-NEXT:    psllq %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_sll_epi64:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsllq %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %res = call <2 x i64> @llvm.x86.sse2.psll.q(<2 x i64> %a0, <2 x i64> %a1)
  ret <2 x i64> %res
}
declare <2 x i64> @llvm.x86.sse2.psll.q(<2 x i64>, <2 x i64>) nounwind readnone

define <2 x i64> @test_mm_slli_epi16(<2 x i64> %a0) {
; SSE-LABEL: test_mm_slli_epi16:
; SSE:       # %bb.0:
; SSE-NEXT:    psllw $1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_slli_epi16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsllw $1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <8 x i16>
  %res = call <8 x i16> @llvm.x86.sse2.pslli.w(<8 x i16> %arg0, i32 1)
  %bc = bitcast <8 x i16> %res to <2 x i64>
  ret <2 x i64> %bc
}
declare <8 x i16> @llvm.x86.sse2.pslli.w(<8 x i16>, i32) nounwind readnone

define <2 x i64> @test_mm_slli_epi32(<2 x i64> %a0) {
; SSE-LABEL: test_mm_slli_epi32:
; SSE:       # %bb.0:
; SSE-NEXT:    pslld $1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_slli_epi32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpslld $1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <4 x i32>
  %res = call <4 x i32> @llvm.x86.sse2.pslli.d(<4 x i32> %arg0, i32 1)
  %bc = bitcast <4 x i32> %res to <2 x i64>
  ret <2 x i64> %bc
}
declare <4 x i32> @llvm.x86.sse2.pslli.d(<4 x i32>, i32) nounwind readnone

define <2 x i64> @test_mm_slli_epi64(<2 x i64> %a0) {
; SSE-LABEL: test_mm_slli_epi64:
; SSE:       # %bb.0:
; SSE-NEXT:    psllq $1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_slli_epi64:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsllq $1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %res = call <2 x i64> @llvm.x86.sse2.pslli.q(<2 x i64> %a0, i32 1)
  ret <2 x i64> %res
}
declare <2 x i64> @llvm.x86.sse2.pslli.q(<2 x i64>, i32) nounwind readnone

define <2 x i64> @test_mm_slli_si128(<2 x i64> %a0) nounwind {
; SSE-LABEL: test_mm_slli_si128:
; SSE:       # %bb.0:
; SSE-NEXT:    pslldq {{.*#+}} xmm0 = zero,zero,zero,zero,zero,xmm0[0,1,2,3,4,5,6,7,8,9,10]
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_slli_si128:
; AVX:       # %bb.0:
; AVX-NEXT:    vpslldq {{.*#+}} xmm0 = zero,zero,zero,zero,zero,xmm0[0,1,2,3,4,5,6,7,8,9,10]
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <16 x i8>
  %res = shufflevector <16 x i8> zeroinitializer, <16 x i8> %arg0, <16 x i32> <i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26>
  %bc = bitcast <16 x i8> %res to <2 x i64>
  ret <2 x i64> %bc
}

define <2 x double> @test_mm_sqrt_pd(<2 x double> %a0) nounwind {
; SSE-LABEL: test_mm_sqrt_pd:
; SSE:       # %bb.0:
; SSE-NEXT:    sqrtpd %xmm0, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_sqrt_pd:
; AVX:       # %bb.0:
; AVX-NEXT:    vsqrtpd %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %res = call <2 x double> @llvm.x86.sse2.sqrt.pd(<2 x double> %a0)
  ret <2 x double> %res
}
declare <2 x double> @llvm.x86.sse2.sqrt.pd(<2 x double>) nounwind readnone

define <2 x double> @test_mm_sqrt_sd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_sqrt_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    sqrtsd %xmm0, %xmm1
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_sqrt_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    vsqrtsd %xmm0, %xmm1, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %call = call <2 x double> @llvm.x86.sse2.sqrt.sd(<2 x double> %a0)
  %ext0 = extractelement <2 x double> %call, i32 0
  %ins0 = insertelement <2 x double> undef, double %ext0, i32 0
  %ext1 = extractelement <2 x double> %a1, i32 1
  %ins1 = insertelement <2 x double> %ins0, double %ext1, i32 1
  ret <2 x double> %ins1
}
declare <2 x double> @llvm.x86.sse2.sqrt.sd(<2 x double>) nounwind readnone

define <2 x i64> @test_mm_sra_epi16(<2 x i64> %a0, <2 x i64> %a1) {
; SSE-LABEL: test_mm_sra_epi16:
; SSE:       # %bb.0:
; SSE-NEXT:    psraw %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_sra_epi16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsraw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <8 x i16>
  %arg1 = bitcast <2 x i64> %a1 to <8 x i16>
  %res = call <8 x i16> @llvm.x86.sse2.psra.w(<8 x i16> %arg0, <8 x i16> %arg1)
  %bc = bitcast <8 x i16> %res to <2 x i64>
  ret <2 x i64> %bc
}
declare <8 x i16> @llvm.x86.sse2.psra.w(<8 x i16>, <8 x i16>) nounwind readnone

define <2 x i64> @test_mm_sra_epi32(<2 x i64> %a0, <2 x i64> %a1) {
; SSE-LABEL: test_mm_sra_epi32:
; SSE:       # %bb.0:
; SSE-NEXT:    psrad %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_sra_epi32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsrad %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <4 x i32>
  %arg1 = bitcast <2 x i64> %a1 to <4 x i32>
  %res = call <4 x i32> @llvm.x86.sse2.psra.d(<4 x i32> %arg0, <4 x i32> %arg1)
  %bc = bitcast <4 x i32> %res to <2 x i64>
  ret <2 x i64> %bc
}
declare <4 x i32> @llvm.x86.sse2.psra.d(<4 x i32>, <4 x i32>) nounwind readnone

define <2 x i64> @test_mm_srai_epi16(<2 x i64> %a0) {
; SSE-LABEL: test_mm_srai_epi16:
; SSE:       # %bb.0:
; SSE-NEXT:    psraw $1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_srai_epi16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsraw $1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <8 x i16>
  %res = call <8 x i16> @llvm.x86.sse2.psrai.w(<8 x i16> %arg0, i32 1)
  %bc = bitcast <8 x i16> %res to <2 x i64>
  ret <2 x i64> %bc
}
declare <8 x i16> @llvm.x86.sse2.psrai.w(<8 x i16>, i32) nounwind readnone

define <2 x i64> @test_mm_srai_epi32(<2 x i64> %a0) {
; SSE-LABEL: test_mm_srai_epi32:
; SSE:       # %bb.0:
; SSE-NEXT:    psrad $1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_srai_epi32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsrad $1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <4 x i32>
  %res = call <4 x i32> @llvm.x86.sse2.psrai.d(<4 x i32> %arg0, i32 1)
  %bc = bitcast <4 x i32> %res to <2 x i64>
  ret <2 x i64> %bc
}
declare <4 x i32> @llvm.x86.sse2.psrai.d(<4 x i32>, i32) nounwind readnone

define <2 x i64> @test_mm_srl_epi16(<2 x i64> %a0, <2 x i64> %a1) {
; SSE-LABEL: test_mm_srl_epi16:
; SSE:       # %bb.0:
; SSE-NEXT:    psrlw %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_srl_epi16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsrlw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <8 x i16>
  %arg1 = bitcast <2 x i64> %a1 to <8 x i16>
  %res = call <8 x i16> @llvm.x86.sse2.psrl.w(<8 x i16> %arg0, <8 x i16> %arg1)
  %bc = bitcast <8 x i16> %res to <2 x i64>
  ret <2 x i64> %bc
}
declare <8 x i16> @llvm.x86.sse2.psrl.w(<8 x i16>, <8 x i16>) nounwind readnone

define <2 x i64> @test_mm_srl_epi32(<2 x i64> %a0, <2 x i64> %a1) {
; SSE-LABEL: test_mm_srl_epi32:
; SSE:       # %bb.0:
; SSE-NEXT:    psrld %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_srl_epi32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsrld %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <4 x i32>
  %arg1 = bitcast <2 x i64> %a1 to <4 x i32>
  %res = call <4 x i32> @llvm.x86.sse2.psrl.d(<4 x i32> %arg0, <4 x i32> %arg1)
  %bc = bitcast <4 x i32> %res to <2 x i64>
  ret <2 x i64> %bc
}
declare <4 x i32> @llvm.x86.sse2.psrl.d(<4 x i32>, <4 x i32>) nounwind readnone

define <2 x i64> @test_mm_srl_epi64(<2 x i64> %a0, <2 x i64> %a1) {
; SSE-LABEL: test_mm_srl_epi64:
; SSE:       # %bb.0:
; SSE-NEXT:    psrlq %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_srl_epi64:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsrlq %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %res = call <2 x i64> @llvm.x86.sse2.psrl.q(<2 x i64> %a0, <2 x i64> %a1)
  ret <2 x i64> %res
}
declare <2 x i64> @llvm.x86.sse2.psrl.q(<2 x i64>, <2 x i64>) nounwind readnone

define <2 x i64> @test_mm_srli_epi16(<2 x i64> %a0) {
; SSE-LABEL: test_mm_srli_epi16:
; SSE:       # %bb.0:
; SSE-NEXT:    psrlw $1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_srli_epi16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsrlw $1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <8 x i16>
  %res = call <8 x i16> @llvm.x86.sse2.psrli.w(<8 x i16> %arg0, i32 1)
  %bc = bitcast <8 x i16> %res to <2 x i64>
  ret <2 x i64> %bc
}
declare <8 x i16> @llvm.x86.sse2.psrli.w(<8 x i16>, i32) nounwind readnone

define <2 x i64> @test_mm_srli_epi32(<2 x i64> %a0) {
; SSE-LABEL: test_mm_srli_epi32:
; SSE:       # %bb.0:
; SSE-NEXT:    psrld $1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_srli_epi32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsrld $1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <4 x i32>
  %res = call <4 x i32> @llvm.x86.sse2.psrli.d(<4 x i32> %arg0, i32 1)
  %bc = bitcast <4 x i32> %res to <2 x i64>
  ret <2 x i64> %bc
}
declare <4 x i32> @llvm.x86.sse2.psrli.d(<4 x i32>, i32) nounwind readnone

define <2 x i64> @test_mm_srli_epi64(<2 x i64> %a0) {
; SSE-LABEL: test_mm_srli_epi64:
; SSE:       # %bb.0:
; SSE-NEXT:    psrlq $1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_srli_epi64:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsrlq $1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %res = call <2 x i64> @llvm.x86.sse2.psrli.q(<2 x i64> %a0, i32 1)
  ret <2 x i64> %res
}
declare <2 x i64> @llvm.x86.sse2.psrli.q(<2 x i64>, i32) nounwind readnone

define <2 x i64> @test_mm_srli_si128(<2 x i64> %a0) nounwind {
; SSE-LABEL: test_mm_srli_si128:
; SSE:       # %bb.0:
; SSE-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[5,6,7,8,9,10,11,12,13,14,15],zero,zero,zero,zero,zero
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_srli_si128:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsrldq {{.*#+}} xmm0 = xmm0[5,6,7,8,9,10,11,12,13,14,15],zero,zero,zero,zero,zero
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <16 x i8>
  %res = shufflevector <16 x i8> %arg0, <16 x i8> zeroinitializer, <16 x i32> <i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20>
  %bc = bitcast <16 x i8> %res to <2 x i64>
  ret <2 x i64> %bc
}

define void @test_mm_store_pd(double *%a0, <2 x double> %a1) {
; X86-SSE-LABEL: test_mm_store_pd:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movaps %xmm0, (%eax)
; X86-SSE-NEXT:    retl
;
; X86-AVX-LABEL: test_mm_store_pd:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vmovaps %xmm0, (%eax)
; X86-AVX-NEXT:    retl
;
; X64-SSE-LABEL: test_mm_store_pd:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movaps %xmm0, (%rdi)
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: test_mm_store_pd:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovaps %xmm0, (%rdi)
; X64-AVX-NEXT:    retq
  %arg0 = bitcast double* %a0 to <2 x double>*
  store <2 x double> %a1, <2 x double>* %arg0, align 16
  ret void
}

define void @test_mm_store_pd1(double *%a0, <2 x double> %a1) {
; X86-SSE-LABEL: test_mm_store_pd1:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0,0]
; X86-SSE-NEXT:    movaps %xmm0, (%eax)
; X86-SSE-NEXT:    retl
;
; X86-AVX-LABEL: test_mm_store_pd1:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vmovddup {{.*#+}} xmm0 = xmm0[0,0]
; X86-AVX-NEXT:    vmovapd %xmm0, (%eax)
; X86-AVX-NEXT:    retl
;
; X64-SSE-LABEL: test_mm_store_pd1:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0,0]
; X64-SSE-NEXT:    movaps %xmm0, (%rdi)
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: test_mm_store_pd1:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovddup {{.*#+}} xmm0 = xmm0[0,0]
; X64-AVX-NEXT:    vmovapd %xmm0, (%rdi)
; X64-AVX-NEXT:    retq
  %arg0 = bitcast double * %a0 to <2 x double>*
  %shuf = shufflevector <2 x double> %a1, <2 x double> undef, <2 x i32> zeroinitializer
  store <2 x double> %shuf, <2 x double>* %arg0, align 16
  ret void
}

define void @test_mm_store_sd(double *%a0, <2 x double> %a1) {
; X86-SSE-LABEL: test_mm_store_sd:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movsd %xmm0, (%eax)
; X86-SSE-NEXT:    retl
;
; X86-AVX-LABEL: test_mm_store_sd:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vmovsd %xmm0, (%eax)
; X86-AVX-NEXT:    retl
;
; X64-SSE-LABEL: test_mm_store_sd:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movsd %xmm0, (%rdi)
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: test_mm_store_sd:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovsd %xmm0, (%rdi)
; X64-AVX-NEXT:    retq
  %ext = extractelement <2 x double> %a1, i32 0
  store double %ext, double* %a0, align 1
  ret void
}

define void @test_mm_store_si128(<2 x i64> *%a0, <2 x i64> %a1) {
; X86-SSE-LABEL: test_mm_store_si128:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movaps %xmm0, (%eax)
; X86-SSE-NEXT:    retl
;
; X86-AVX-LABEL: test_mm_store_si128:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vmovaps %xmm0, (%eax)
; X86-AVX-NEXT:    retl
;
; X64-SSE-LABEL: test_mm_store_si128:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movaps %xmm0, (%rdi)
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: test_mm_store_si128:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovaps %xmm0, (%rdi)
; X64-AVX-NEXT:    retq
  store <2 x i64> %a1, <2 x i64>* %a0, align 16
  ret void
}

define void @test_mm_store1_pd(double *%a0, <2 x double> %a1) {
; X86-SSE-LABEL: test_mm_store1_pd:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0,0]
; X86-SSE-NEXT:    movaps %xmm0, (%eax)
; X86-SSE-NEXT:    retl
;
; X86-AVX-LABEL: test_mm_store1_pd:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vmovddup {{.*#+}} xmm0 = xmm0[0,0]
; X86-AVX-NEXT:    vmovapd %xmm0, (%eax)
; X86-AVX-NEXT:    retl
;
; X64-SSE-LABEL: test_mm_store1_pd:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0,0]
; X64-SSE-NEXT:    movaps %xmm0, (%rdi)
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: test_mm_store1_pd:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovddup {{.*#+}} xmm0 = xmm0[0,0]
; X64-AVX-NEXT:    vmovapd %xmm0, (%rdi)
; X64-AVX-NEXT:    retq
  %arg0 = bitcast double * %a0 to <2 x double>*
  %shuf = shufflevector <2 x double> %a1, <2 x double> undef, <2 x i32> zeroinitializer
  store <2 x double> %shuf, <2 x double>* %arg0, align 16
  ret void
}

define void @test_mm_storeh_sd(double *%a0, <2 x double> %a1) {
; X86-SSE-LABEL: test_mm_storeh_sd:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movhlps {{.*#+}} xmm0 = xmm0[1,1]
; X86-SSE-NEXT:    movsd %xmm0, (%eax)
; X86-SSE-NEXT:    retl
;
; X86-AVX-LABEL: test_mm_storeh_sd:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; X86-AVX-NEXT:    vmovsd %xmm0, (%eax)
; X86-AVX-NEXT:    retl
;
; X64-SSE-LABEL: test_mm_storeh_sd:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movhlps {{.*#+}} xmm0 = xmm0[1,1]
; X64-SSE-NEXT:    movsd %xmm0, (%rdi)
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: test_mm_storeh_sd:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; X64-AVX-NEXT:    vmovsd %xmm0, (%rdi)
; X64-AVX-NEXT:    retq
  %ext = extractelement <2 x double> %a1, i32 1
  store double %ext, double* %a0, align 8
  ret void
}

define void @test_mm_storel_epi64(<2 x i64> *%a0, <2 x i64> %a1) {
; X86-SSE-LABEL: test_mm_storel_epi64:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movlps %xmm0, (%eax)
; X86-SSE-NEXT:    retl
;
; X86-AVX-LABEL: test_mm_storel_epi64:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vmovlps %xmm0, (%eax)
; X86-AVX-NEXT:    retl
;
; X64-SSE-LABEL: test_mm_storel_epi64:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movq %xmm0, %rax
; X64-SSE-NEXT:    movq %rax, (%rdi)
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: test_mm_storel_epi64:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovq %xmm0, %rax
; X64-AVX-NEXT:    movq %rax, (%rdi)
; X64-AVX-NEXT:    retq
  %ext = extractelement <2 x i64> %a1, i32 0
  %bc = bitcast <2 x i64> *%a0 to i64*
  store i64 %ext, i64* %bc, align 8
  ret void
}

define void @test_mm_storel_sd(double *%a0, <2 x double> %a1) {
; X86-SSE-LABEL: test_mm_storel_sd:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movsd %xmm0, (%eax)
; X86-SSE-NEXT:    retl
;
; X86-AVX-LABEL: test_mm_storel_sd:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vmovsd %xmm0, (%eax)
; X86-AVX-NEXT:    retl
;
; X64-SSE-LABEL: test_mm_storel_sd:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movsd %xmm0, (%rdi)
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: test_mm_storel_sd:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovsd %xmm0, (%rdi)
; X64-AVX-NEXT:    retq
  %ext = extractelement <2 x double> %a1, i32 0
  store double %ext, double* %a0, align 8
  ret void
}

define void @test_mm_storer_pd(double *%a0, <2 x double> %a1) {
; X86-SSE-LABEL: test_mm_storer_pd:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    shufpd {{.*#+}} xmm0 = xmm0[1,0]
; X86-SSE-NEXT:    movapd %xmm0, (%eax)
; X86-SSE-NEXT:    retl
;
; X86-AVX-LABEL: test_mm_storer_pd:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; X86-AVX-NEXT:    vmovapd %xmm0, (%eax)
; X86-AVX-NEXT:    retl
;
; X64-SSE-LABEL: test_mm_storer_pd:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    shufpd {{.*#+}} xmm0 = xmm0[1,0]
; X64-SSE-NEXT:    movapd %xmm0, (%rdi)
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: test_mm_storer_pd:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; X64-AVX-NEXT:    vmovapd %xmm0, (%rdi)
; X64-AVX-NEXT:    retq
  %arg0 = bitcast double* %a0 to <2 x double>*
  %shuf = shufflevector <2 x double> %a1, <2 x double> undef, <2 x i32> <i32 1, i32 0>
  store <2 x double> %shuf, <2 x double>* %arg0, align 16
  ret void
}

define void @test_mm_storeu_pd(double *%a0, <2 x double> %a1) {
; X86-SSE-LABEL: test_mm_storeu_pd:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movups %xmm0, (%eax)
; X86-SSE-NEXT:    retl
;
; X86-AVX-LABEL: test_mm_storeu_pd:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vmovups %xmm0, (%eax)
; X86-AVX-NEXT:    retl
;
; X64-SSE-LABEL: test_mm_storeu_pd:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movups %xmm0, (%rdi)
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: test_mm_storeu_pd:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovups %xmm0, (%rdi)
; X64-AVX-NEXT:    retq
  %arg0 = bitcast double* %a0 to <2 x double>*
  store <2 x double> %a1, <2 x double>* %arg0, align 1
  ret void
}

define void @test_mm_storeu_si128(<2 x i64> *%a0, <2 x i64> %a1) {
; X86-SSE-LABEL: test_mm_storeu_si128:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movups %xmm0, (%eax)
; X86-SSE-NEXT:    retl
;
; X86-AVX-LABEL: test_mm_storeu_si128:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vmovups %xmm0, (%eax)
; X86-AVX-NEXT:    retl
;
; X64-SSE-LABEL: test_mm_storeu_si128:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movups %xmm0, (%rdi)
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: test_mm_storeu_si128:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovups %xmm0, (%rdi)
; X64-AVX-NEXT:    retq
  store <2 x i64> %a1, <2 x i64>* %a0, align 1
  ret void
}

define void @test_mm_stream_pd(double *%a0, <2 x double> %a1) {
; X86-SSE-LABEL: test_mm_stream_pd:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movntps %xmm0, (%eax)
; X86-SSE-NEXT:    retl
;
; X86-AVX-LABEL: test_mm_stream_pd:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vmovntps %xmm0, (%eax)
; X86-AVX-NEXT:    retl
;
; X64-SSE-LABEL: test_mm_stream_pd:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movntps %xmm0, (%rdi)
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: test_mm_stream_pd:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovntps %xmm0, (%rdi)
; X64-AVX-NEXT:    retq
  %arg0 = bitcast double* %a0 to <2 x double>*
  store <2 x double> %a1, <2 x double>* %arg0, align 16, !nontemporal !0
  ret void
}

define void @test_mm_stream_si32(i32 *%a0, i32 %a1) {
; X86-LABEL: test_mm_stream_si32:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movntil %eax, (%ecx)
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_stream_si32:
; X64:       # %bb.0:
; X64-NEXT:    movntil %esi, (%rdi)
; X64-NEXT:    retq
  store i32 %a1, i32* %a0, align 1, !nontemporal !0
  ret void
}

define void @test_mm_stream_si128(<2 x i64> *%a0, <2 x i64> %a1) {
; X86-SSE-LABEL: test_mm_stream_si128:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movntps %xmm0, (%eax)
; X86-SSE-NEXT:    retl
;
; X86-AVX-LABEL: test_mm_stream_si128:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vmovntps %xmm0, (%eax)
; X86-AVX-NEXT:    retl
;
; X64-SSE-LABEL: test_mm_stream_si128:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movntps %xmm0, (%rdi)
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: test_mm_stream_si128:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovntps %xmm0, (%rdi)
; X64-AVX-NEXT:    retq
  store <2 x i64> %a1, <2 x i64>* %a0, align 16, !nontemporal !0
  ret void
}

define <2 x i64> @test_mm_sub_epi8(<2 x i64> %a0, <2 x i64> %a1) nounwind {
; SSE-LABEL: test_mm_sub_epi8:
; SSE:       # %bb.0:
; SSE-NEXT:    psubb %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_sub_epi8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsubb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <16 x i8>
  %arg1 = bitcast <2 x i64> %a1 to <16 x i8>
  %res = sub <16 x i8> %arg0, %arg1
  %bc = bitcast <16 x i8> %res to <2 x i64>
  ret <2 x i64> %bc
}

define <2 x i64> @test_mm_sub_epi16(<2 x i64> %a0, <2 x i64> %a1) nounwind {
; SSE-LABEL: test_mm_sub_epi16:
; SSE:       # %bb.0:
; SSE-NEXT:    psubw %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_sub_epi16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsubw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <8 x i16>
  %arg1 = bitcast <2 x i64> %a1 to <8 x i16>
  %res = sub <8 x i16> %arg0, %arg1
  %bc = bitcast <8 x i16> %res to <2 x i64>
  ret <2 x i64> %bc
}

define <2 x i64> @test_mm_sub_epi32(<2 x i64> %a0, <2 x i64> %a1) nounwind {
; SSE-LABEL: test_mm_sub_epi32:
; SSE:       # %bb.0:
; SSE-NEXT:    psubd %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_sub_epi32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsubd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <4 x i32>
  %arg1 = bitcast <2 x i64> %a1 to <4 x i32>
  %res = sub <4 x i32> %arg0, %arg1
  %bc = bitcast <4 x i32> %res to <2 x i64>
  ret <2 x i64> %bc
}

define <2 x i64> @test_mm_sub_epi64(<2 x i64> %a0, <2 x i64> %a1) nounwind {
; SSE-LABEL: test_mm_sub_epi64:
; SSE:       # %bb.0:
; SSE-NEXT:    psubq %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_sub_epi64:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsubq %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %res = sub <2 x i64> %a0, %a1
  ret <2 x i64> %res
}

define <2 x double> @test_mm_sub_pd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_sub_pd:
; SSE:       # %bb.0:
; SSE-NEXT:    subpd %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_sub_pd:
; AVX:       # %bb.0:
; AVX-NEXT:    vsubpd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %res = fsub <2 x double> %a0, %a1
  ret <2 x double> %res
}

define <2 x double> @test_mm_sub_sd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_sub_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    subsd %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_sub_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    vsubsd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %ext0 = extractelement <2 x double> %a0, i32 0
  %ext1 = extractelement <2 x double> %a1, i32 0
  %fsub = fsub double %ext0, %ext1
  %res = insertelement <2 x double> %a0, double %fsub, i32 0
  ret <2 x double> %res
}

define <2 x i64> @test_mm_subs_epi8(<2 x i64> %a0, <2 x i64> %a1) nounwind {
; SSE-LABEL: test_mm_subs_epi8:
; SSE:       # %bb.0:
; SSE-NEXT:    psubsb %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_subs_epi8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsubsb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <16 x i8>
  %arg1 = bitcast <2 x i64> %a1 to <16 x i8>
  %res = call <16 x i8> @llvm.x86.sse2.psubs.b(<16 x i8> %arg0, <16 x i8> %arg1)
  %bc = bitcast <16 x i8> %res to <2 x i64>
  ret <2 x i64> %bc
}
declare <16 x i8> @llvm.x86.sse2.psubs.b(<16 x i8>, <16 x i8>) nounwind readnone

define <2 x i64> @test_mm_subs_epi16(<2 x i64> %a0, <2 x i64> %a1) nounwind {
; SSE-LABEL: test_mm_subs_epi16:
; SSE:       # %bb.0:
; SSE-NEXT:    psubsw %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_subs_epi16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsubsw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <8 x i16>
  %arg1 = bitcast <2 x i64> %a1 to <8 x i16>
  %res = call <8 x i16> @llvm.x86.sse2.psubs.w(<8 x i16> %arg0, <8 x i16> %arg1)
  %bc = bitcast <8 x i16> %res to <2 x i64>
  ret <2 x i64> %bc
}
declare <8 x i16> @llvm.x86.sse2.psubs.w(<8 x i16>, <8 x i16>) nounwind readnone

define <2 x i64> @test_mm_subs_epu8(<2 x i64> %a0, <2 x i64> %a1) nounwind {
; SSE-LABEL: test_mm_subs_epu8:
; SSE:       # %bb.0:
; SSE-NEXT:    psubusb %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_subs_epu8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsubusb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <16 x i8>
  %arg1 = bitcast <2 x i64> %a1 to <16 x i8>
  %res = call <16 x i8> @llvm.x86.sse2.psubus.b(<16 x i8> %arg0, <16 x i8> %arg1)
  %bc = bitcast <16 x i8> %res to <2 x i64>
  ret <2 x i64> %bc
}
declare <16 x i8> @llvm.x86.sse2.psubus.b(<16 x i8>, <16 x i8>) nounwind readnone

define <2 x i64> @test_mm_subs_epu16(<2 x i64> %a0, <2 x i64> %a1) nounwind {
; SSE-LABEL: test_mm_subs_epu16:
; SSE:       # %bb.0:
; SSE-NEXT:    psubusw %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_subs_epu16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsubusw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <8 x i16>
  %arg1 = bitcast <2 x i64> %a1 to <8 x i16>
  %res = call <8 x i16> @llvm.x86.sse2.psubus.w(<8 x i16> %arg0, <8 x i16> %arg1)
  %bc = bitcast <8 x i16> %res to <2 x i64>
  ret <2 x i64> %bc
}
declare <8 x i16> @llvm.x86.sse2.psubus.w(<8 x i16>, <8 x i16>) nounwind readnone

define i32 @test_mm_ucomieq_sd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_ucomieq_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    ucomisd %xmm1, %xmm0
; SSE-NEXT:    setnp %al
; SSE-NEXT:    sete %cl
; SSE-NEXT:    andb %al, %cl
; SSE-NEXT:    movzbl %cl, %eax
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_ucomieq_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    vucomisd %xmm1, %xmm0
; AVX-NEXT:    setnp %al
; AVX-NEXT:    sete %cl
; AVX-NEXT:    andb %al, %cl
; AVX-NEXT:    movzbl %cl, %eax
; AVX-NEXT:    ret{{[l|q]}}
  %res = call i32 @llvm.x86.sse2.ucomieq.sd(<2 x double> %a0, <2 x double> %a1)
  ret i32 %res
}
declare i32 @llvm.x86.sse2.ucomieq.sd(<2 x double>, <2 x double>) nounwind readnone

define i32 @test_mm_ucomige_sd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_ucomige_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    xorl %eax, %eax
; SSE-NEXT:    ucomisd %xmm1, %xmm0
; SSE-NEXT:    setae %al
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_ucomige_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    xorl %eax, %eax
; AVX-NEXT:    vucomisd %xmm1, %xmm0
; AVX-NEXT:    setae %al
; AVX-NEXT:    ret{{[l|q]}}
  %res = call i32 @llvm.x86.sse2.ucomige.sd(<2 x double> %a0, <2 x double> %a1)
  ret i32 %res
}
declare i32 @llvm.x86.sse2.ucomige.sd(<2 x double>, <2 x double>) nounwind readnone

define i32 @test_mm_ucomigt_sd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_ucomigt_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    xorl %eax, %eax
; SSE-NEXT:    ucomisd %xmm1, %xmm0
; SSE-NEXT:    seta %al
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_ucomigt_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    xorl %eax, %eax
; AVX-NEXT:    vucomisd %xmm1, %xmm0
; AVX-NEXT:    seta %al
; AVX-NEXT:    ret{{[l|q]}}
  %res = call i32 @llvm.x86.sse2.ucomigt.sd(<2 x double> %a0, <2 x double> %a1)
  ret i32 %res
}
declare i32 @llvm.x86.sse2.ucomigt.sd(<2 x double>, <2 x double>) nounwind readnone

define i32 @test_mm_ucomile_sd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_ucomile_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    xorl %eax, %eax
; SSE-NEXT:    ucomisd %xmm0, %xmm1
; SSE-NEXT:    setae %al
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_ucomile_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    xorl %eax, %eax
; AVX-NEXT:    vucomisd %xmm0, %xmm1
; AVX-NEXT:    setae %al
; AVX-NEXT:    ret{{[l|q]}}
  %res = call i32 @llvm.x86.sse2.ucomile.sd(<2 x double> %a0, <2 x double> %a1)
  ret i32 %res
}
declare i32 @llvm.x86.sse2.ucomile.sd(<2 x double>, <2 x double>) nounwind readnone

define i32 @test_mm_ucomilt_sd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_ucomilt_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    xorl %eax, %eax
; SSE-NEXT:    ucomisd %xmm0, %xmm1
; SSE-NEXT:    seta %al
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_ucomilt_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    xorl %eax, %eax
; AVX-NEXT:    vucomisd %xmm0, %xmm1
; AVX-NEXT:    seta %al
; AVX-NEXT:    ret{{[l|q]}}
  %res = call i32 @llvm.x86.sse2.ucomilt.sd(<2 x double> %a0, <2 x double> %a1)
  ret i32 %res
}
declare i32 @llvm.x86.sse2.ucomilt.sd(<2 x double>, <2 x double>) nounwind readnone

define i32 @test_mm_ucomineq_sd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_ucomineq_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    ucomisd %xmm1, %xmm0
; SSE-NEXT:    setp %al
; SSE-NEXT:    setne %cl
; SSE-NEXT:    orb %al, %cl
; SSE-NEXT:    movzbl %cl, %eax
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_ucomineq_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    vucomisd %xmm1, %xmm0
; AVX-NEXT:    setp %al
; AVX-NEXT:    setne %cl
; AVX-NEXT:    orb %al, %cl
; AVX-NEXT:    movzbl %cl, %eax
; AVX-NEXT:    ret{{[l|q]}}
  %res = call i32 @llvm.x86.sse2.ucomineq.sd(<2 x double> %a0, <2 x double> %a1)
  ret i32 %res
}
declare i32 @llvm.x86.sse2.ucomineq.sd(<2 x double>, <2 x double>) nounwind readnone

define <2 x double> @test_mm_undefined_pd() {
; CHECK-LABEL: test_mm_undefined_pd:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ret{{[l|q]}}
  ret <2 x double> undef
}

define <2 x i64> @test_mm_undefined_si128() {
; CHECK-LABEL: test_mm_undefined_si128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ret{{[l|q]}}
  ret <2 x i64> undef
}

define <2 x i64> @test_mm_unpackhi_epi8(<2 x i64> %a0, <2 x i64> %a1) {
; SSE-LABEL: test_mm_unpackhi_epi8:
; SSE:       # %bb.0:
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm1[8],xmm0[9],xmm1[9],xmm0[10],xmm1[10],xmm0[11],xmm1[11],xmm0[12],xmm1[12],xmm0[13],xmm1[13],xmm0[14],xmm1[14],xmm0[15],xmm1[15]
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_unpackhi_epi8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpunpckhbw {{.*#+}} xmm0 = xmm0[8],xmm1[8],xmm0[9],xmm1[9],xmm0[10],xmm1[10],xmm0[11],xmm1[11],xmm0[12],xmm1[12],xmm0[13],xmm1[13],xmm0[14],xmm1[14],xmm0[15],xmm1[15]
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <16 x i8>
  %arg1 = bitcast <2 x i64> %a1 to <16 x i8>
  %res = shufflevector <16 x i8> %arg0, <16 x i8> %arg1, <16 x i32> <i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>
  %bc = bitcast <16 x i8> %res to <2 x i64>
  ret <2 x i64> %bc
}

define <2 x i64> @test_mm_unpackhi_epi16(<2 x i64> %a0, <2 x i64> %a1) {
; SSE-LABEL: test_mm_unpackhi_epi16:
; SSE:       # %bb.0:
; SSE-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_unpackhi_epi16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <8 x i16>
  %arg1 = bitcast <2 x i64> %a1 to <8 x i16>
  %res = shufflevector <8 x i16> %arg0, <8 x i16> %arg1, <8 x i32> <i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
  %bc = bitcast <8 x i16> %res to <2 x i64>
  ret <2 x i64> %bc
}

define <2 x i64> @test_mm_unpackhi_epi32(<2 x i64> %a0, <2 x i64> %a1) {
; SSE-LABEL: test_mm_unpackhi_epi32:
; SSE:       # %bb.0:
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_unpackhi_epi32:
; AVX:       # %bb.0:
; AVX-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <4 x i32>
  %arg1 = bitcast <2 x i64> %a1 to <4 x i32>
  %res = shufflevector <4 x i32> %arg0,<4 x i32> %arg1, <4 x i32> <i32 2, i32 6, i32 3, i32 7>
  %bc = bitcast <4 x i32> %res to <2 x i64>
  ret <2 x i64> %bc
}

define <2 x i64> @test_mm_unpackhi_epi64(<2 x i64> %a0, <2 x i64> %a1) {
; SSE-LABEL: test_mm_unpackhi_epi64:
; SSE:       # %bb.0:
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_unpackhi_epi64:
; AVX:       # %bb.0:
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; AVX-NEXT:    ret{{[l|q]}}
  %res = shufflevector <2 x i64> %a0, <2 x i64> %a1, <2 x i32> <i32 1, i32 3>
  ret <2 x i64> %res
}

define <2 x double> @test_mm_unpackhi_pd(<2 x double> %a0, <2 x double> %a1) {
; SSE-LABEL: test_mm_unpackhi_pd:
; SSE:       # %bb.0:
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_unpackhi_pd:
; AVX:       # %bb.0:
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; AVX-NEXT:    ret{{[l|q]}}
  %res = shufflevector <2 x double> %a0, <2 x double> %a1, <2 x i32> <i32 1, i32 3>
  ret <2 x double> %res
}

define <2 x i64> @test_mm_unpacklo_epi8(<2 x i64> %a0, <2 x i64> %a1) {
; SSE-LABEL: test_mm_unpacklo_epi8:
; SSE:       # %bb.0:
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_unpacklo_epi8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <16 x i8>
  %arg1 = bitcast <2 x i64> %a1 to <16 x i8>
  %res = shufflevector <16 x i8> %arg0, <16 x i8> %arg1, <16 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23>
  %bc = bitcast <16 x i8> %res to <2 x i64>
  ret <2 x i64> %bc
}

define <2 x i64> @test_mm_unpacklo_epi16(<2 x i64> %a0, <2 x i64> %a1) {
; SSE-LABEL: test_mm_unpacklo_epi16:
; SSE:       # %bb.0:
; SSE-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_unpacklo_epi16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <8 x i16>
  %arg1 = bitcast <2 x i64> %a1 to <8 x i16>
  %res = shufflevector <8 x i16> %arg0, <8 x i16> %arg1, <8 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11>
  %bc = bitcast <8 x i16> %res to <2 x i64>
  ret <2 x i64> %bc
}

define <2 x i64> @test_mm_unpacklo_epi32(<2 x i64> %a0, <2 x i64> %a1) {
; SSE-LABEL: test_mm_unpacklo_epi32:
; SSE:       # %bb.0:
; SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_unpacklo_epi32:
; AVX:       # %bb.0:
; AVX-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <4 x i32>
  %arg1 = bitcast <2 x i64> %a1 to <4 x i32>
  %res = shufflevector <4 x i32> %arg0,<4 x i32> %arg1, <4 x i32> <i32 0, i32 4, i32 1, i32 5>
  %bc = bitcast <4 x i32> %res to <2 x i64>
  ret <2 x i64> %bc
}

define <2 x i64> @test_mm_unpacklo_epi64(<2 x i64> %a0, <2 x i64> %a1) {
; SSE-LABEL: test_mm_unpacklo_epi64:
; SSE:       # %bb.0:
; SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_unpacklo_epi64:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX-NEXT:    ret{{[l|q]}}
  %res = shufflevector <2 x i64> %a0, <2 x i64> %a1, <2 x i32> <i32 0, i32 2>
  ret <2 x i64> %res
}

define <2 x double> @test_mm_unpacklo_pd(<2 x double> %a0, <2 x double> %a1) {
; SSE-LABEL: test_mm_unpacklo_pd:
; SSE:       # %bb.0:
; SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_unpacklo_pd:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX-NEXT:    ret{{[l|q]}}
  %res = shufflevector <2 x double> %a0, <2 x double> %a1, <2 x i32> <i32 0, i32 2>
  ret <2 x double> %res
}

define <2 x double> @test_mm_xor_pd(<2 x double> %a0, <2 x double> %a1) nounwind {
; SSE-LABEL: test_mm_xor_pd:
; SSE:       # %bb.0:
; SSE-NEXT:    xorps %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_xor_pd:
; AVX:       # %bb.0:
; AVX-NEXT:    vxorps %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x double> %a0 to <4 x i32>
  %arg1 = bitcast <2 x double> %a1 to <4 x i32>
  %res = xor <4 x i32> %arg0, %arg1
  %bc = bitcast <4 x i32> %res to <2 x double>
  ret <2 x double> %bc
}

define <2 x i64> @test_mm_xor_si128(<2 x i64> %a0, <2 x i64> %a1) nounwind {
; SSE-LABEL: test_mm_xor_si128:
; SSE:       # %bb.0:
; SSE-NEXT:    xorps %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_xor_si128:
; AVX:       # %bb.0:
; AVX-NEXT:    vxorps %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %res = xor <2 x i64> %a0, %a1
  ret <2 x i64> %res
}

!0 = !{i32 1}

