; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx512dq,+avx512vl | FileCheck %s --check-prefixes=CHECK,X86
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512dq,+avx512vl | FileCheck %s --check-prefixes=CHECK,X64

; NOTE: This should use IR equivalent to what is generated by clang/test/CodeGen/avx512vldq-builtins.c

define <2 x double> @test_mm_cvtepi64_pd(<2 x i64> %__A) {
; CHECK-LABEL: test_mm_cvtepi64_pd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vcvtqq2pd %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %conv.i = sitofp <2 x i64> %__A to <2 x double>
  ret <2 x double> %conv.i
}

define <2 x double> @test_mm_mask_cvtepi64_pd(<2 x double> %__W, i8 zeroext %__U, <2 x i64> %__A) {
; X86-LABEL: test_mm_mask_cvtepi64_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1
; X86-NEXT:    vcvtqq2pd %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_cvtepi64_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtqq2pd %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %conv.i.i = sitofp <2 x i64> %__A to <2 x double>
  %0 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %1 = select <2 x i1> %extract.i, <2 x double> %conv.i.i, <2 x double> %__W
  ret <2 x double> %1
}

define <2 x double> @test_mm_maskz_cvtepi64_pd(i8 zeroext %__U, <2 x i64> %__A) {
; X86-LABEL: test_mm_maskz_cvtepi64_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1
; X86-NEXT:    vcvtqq2pd %xmm0, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_cvtepi64_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtqq2pd %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %conv.i.i = sitofp <2 x i64> %__A to <2 x double>
  %0 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %1 = select <2 x i1> %extract.i, <2 x double> %conv.i.i, <2 x double> zeroinitializer
  ret <2 x double> %1
}

define <4 x double> @test_mm256_cvtepi64_pd(<4 x i64> %__A) {
; CHECK-LABEL: test_mm256_cvtepi64_pd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vcvtqq2pd %ymm0, %ymm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %conv.i = sitofp <4 x i64> %__A to <4 x double>
  ret <4 x double> %conv.i
}

define <4 x double> @test_mm256_mask_cvtepi64_pd(<4 x double> %__W, i8 zeroext %__U, <4 x i64> %__A) {
; X86-LABEL: test_mm256_mask_cvtepi64_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1
; X86-NEXT:    vcvtqq2pd %ymm1, %ymm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_cvtepi64_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtqq2pd %ymm1, %ymm0 {%k1}
; X64-NEXT:    retq
entry:
  %conv.i.i = sitofp <4 x i64> %__A to <4 x double>
  %0 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = select <4 x i1> %extract.i, <4 x double> %conv.i.i, <4 x double> %__W
  ret <4 x double> %1
}

define <4 x double> @test_mm256_maskz_cvtepi64_pd(i8 zeroext %__U, <4 x i64> %__A) {
; X86-LABEL: test_mm256_maskz_cvtepi64_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1
; X86-NEXT:    vcvtqq2pd %ymm0, %ymm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_cvtepi64_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtqq2pd %ymm0, %ymm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %conv.i.i = sitofp <4 x i64> %__A to <4 x double>
  %0 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = select <4 x i1> %extract.i, <4 x double> %conv.i.i, <4 x double> zeroinitializer
  ret <4 x double> %1
}

define <2 x double> @test_mm_cvtepu64_pd(<2 x i64> %__A) {
; CHECK-LABEL: test_mm_cvtepu64_pd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vcvtuqq2pd %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %conv.i = uitofp <2 x i64> %__A to <2 x double>
  ret <2 x double> %conv.i
}

define <2 x double> @test_mm_mask_cvtepu64_pd(<2 x double> %__W, i8 zeroext %__U, <2 x i64> %__A) {
; X86-LABEL: test_mm_mask_cvtepu64_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1
; X86-NEXT:    vcvtuqq2pd %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_cvtepu64_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtuqq2pd %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %conv.i.i = uitofp <2 x i64> %__A to <2 x double>
  %0 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %1 = select <2 x i1> %extract.i, <2 x double> %conv.i.i, <2 x double> %__W
  ret <2 x double> %1
}

define <2 x double> @test_mm_maskz_cvtepu64_pd(i8 zeroext %__U, <2 x i64> %__A) {
; X86-LABEL: test_mm_maskz_cvtepu64_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1
; X86-NEXT:    vcvtuqq2pd %xmm0, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_cvtepu64_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtuqq2pd %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %conv.i.i = uitofp <2 x i64> %__A to <2 x double>
  %0 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %1 = select <2 x i1> %extract.i, <2 x double> %conv.i.i, <2 x double> zeroinitializer
  ret <2 x double> %1
}

define <4 x double> @test_mm256_cvtepu64_pd(<4 x i64> %__A) {
; CHECK-LABEL: test_mm256_cvtepu64_pd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vcvtuqq2pd %ymm0, %ymm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %conv.i = uitofp <4 x i64> %__A to <4 x double>
  ret <4 x double> %conv.i
}

define <4 x double> @test_mm256_mask_cvtepu64_pd(<4 x double> %__W, i8 zeroext %__U, <4 x i64> %__A) {
; X86-LABEL: test_mm256_mask_cvtepu64_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1
; X86-NEXT:    vcvtuqq2pd %ymm1, %ymm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_cvtepu64_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtuqq2pd %ymm1, %ymm0 {%k1}
; X64-NEXT:    retq
entry:
  %conv.i.i = uitofp <4 x i64> %__A to <4 x double>
  %0 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = select <4 x i1> %extract.i, <4 x double> %conv.i.i, <4 x double> %__W
  ret <4 x double> %1
}

define <4 x double> @test_mm256_maskz_cvtepu64_pd(i8 zeroext %__U, <4 x i64> %__A) {
; X86-LABEL: test_mm256_maskz_cvtepu64_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1
; X86-NEXT:    vcvtuqq2pd %ymm0, %ymm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_cvtepu64_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtuqq2pd %ymm0, %ymm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %conv.i.i = uitofp <4 x i64> %__A to <4 x double>
  %0 = bitcast i8 %__U to <8 x i1>
  %extract.i = shufflevector <8 x i1> %0, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = select <4 x i1> %extract.i, <4 x double> %conv.i.i, <4 x double> zeroinitializer
  ret <4 x double> %1
}
