/* vi: set sw=4 ts=4: */
/*
 * Utility routines.
 *
 * Copyright (C) tons of folks.  Tracking down who wrote what
 * isn't something I'm going to worry about...  If you wrote something
 * here, please feel free to acknowledge your work.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Based in part on code from sash, Copyright (c) 1999 by David I. Bell 
 * Permission has been granted to redistribute this code under the GPL.
 *
 */

#include <stdio.h>
#include <sys/stat.h>
#include "libbb.h"

/*
 * Copy chunksize bytes between two file descriptors
 *
 * unsigned long is used so that if -1 is passed as chunksize it will read as
 * much as possible, and it will work with off_t or off64_t
 */
extern int copy_file_chunk(FILE *src_file, FILE *dst_file, unsigned long long chunksize)
{
	off_t size, amount_written;
	char buffer[BUFSIZ]; /* BUFSIZ is declared in stdio.h */
	
	while (chunksize > 0) {
		if (chunksize > BUFSIZ) {
			size = BUFSIZ;
		} else {
			size = chunksize;
		}
		amount_written = fwrite(buffer, 1, fread(buffer, 1, size, src_file), dst_file);
		if (amount_written != size) {
			error_msg("Couldnt write correct amount");
			return(FALSE);
		}
		chunksize -= amount_written;
	}
	return (TRUE);
}

/* END CODE */
/*
Local Variables:
c-file-style: "linux"
c-basic-offset: 4
tab-width: 4
End:
*/
