/*
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package java.lang;

/**
 * {@code RuntimeException} is the superclass of all classes that represent
 * exceptional conditions which occur as a result of executing an application in
 * the virtual machine. Unlike checked exceptions (exceptions where the type
 * doesn't extend {@code RuntimeException} or {@link Error}), the compiler does
 * not require code to handle runtime exceptions.
 * 
 * @since Android 1.0
 */
public class RuntimeException extends Exception {
    
    private static final long serialVersionUID = -7034897190745766939L;

    /**
     * Constructs a new {@code RuntimeException} that includes the current stack
     * trace.
     * 
     * @since Android 1.0
     */
    public RuntimeException() {
        super();
    }

    /**
     * Constructs a new {@code RuntimeException} with the current stack trace
     * and the specified detail message.
     * 
     * @param detailMessage
     *            the detail message for this exception.
     * @since Android 1.0
     */
    public RuntimeException(String detailMessage) {
        super(detailMessage);
    }

   /**
     * Constructs a new {@code RuntimeException} with the current stack trace,
     * the specified detail message and the specified cause.
     * 
     * @param detailMessage
     *            the detail message for this exception.
     * @param throwable
     *            the cause of this exception.
     * @since Android 1.0
     */
    public RuntimeException(String detailMessage, Throwable throwable) {
        super(detailMessage, throwable);
    }

    /**
     * Constructs a new {@code RuntimeException} with the current stack trace
     * and the specified cause.
     * 
     * @param throwable
     *            the cause of this exception.
     * @since Android 1.0
     */
    public RuntimeException(Throwable throwable) {
        super(throwable);
    }
}
