#!/bin/sh
#
# Slackware Add-on package Project
# <http://www.asahi-net.or.jp/~wp7s-mrn/>
#
# Date:
#   2002.07.07
#
# Package: 
#   Wnn7SDK-1.0.0-i386-1.tgz
#
# Files:
#   ftp://ftp.omronsoft.co.jp/pub/Wnn7/sdk_source/Wnn7SDK.tgz
#
# Patches:
#   None.
#
# Author:
#   Shinji Morino <peace24@blue.email.ne.jp>
#
export PATH=$PATH:/usr/X11R6/bin
PACKAGE=Wnn7SDK
VERSION=1.0.0
PREFIX=/usr/local
PKGROOT=`pwd`
tar -zxvf Wnn7SDK.tgz
cd src

#make
make World -f Makefile.ini

#makepkg
cd Wnn
echo 'Creating package now ...'
if [ ! -d ${PKGROOT}/${PACKAGE}-${VERSION}-root ]; then
  mkdir -p ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/local/include/wnn7
  mkdir -p ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/local/lib
  mkdir -p ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
  mkdir -p ${PKGROOT}/${PACKAGE}-${VERSION}-root/install
fi
mv include/commonhd.h   ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/local/include/wnn7
mv include/config.h     ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/local/include/wnn7
mv include/copyright.h  ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/local/include/wnn7
mv include/demcom.h     ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/local/include/wnn7
mv include/dslib.h      ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/local/include/wnn7
mv include/fi_jdata.h   ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/local/include/wnn7
mv include/hinsi_file.h ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/local/include/wnn7
mv include/jd_sock.h    ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/local/include/wnn7
mv include/jdata.h      ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/local/include/wnn7
mv include/jh.h         ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/local/include/wnn7
mv include/jlib.h       ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/local/include/wnn7
mv include/jllib.h      ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/local/include/wnn7
mv include/jslib.h      ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/local/include/wnn7
mv include/msg.h        ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/local/include/wnn7
mv include/mt_jlib.h    ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/local/include/wnn7
mv include/rk_spclval.h ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/local/include/wnn7
mv include/wnn_os.h     ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/local/include/wnn7
mv include/wnn_string.h ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/local/include/wnn7
mv include/wnnerror.h   ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/local/include/wnn7
mv jlib/libwnn.a        ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/local/lib
mv jlib/libwnn.so.1.0   ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/local/lib
pushd .
cd ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/local/lib
ln -s libwnn.so.1.0 libwnn.so.1
ln -s libwnn.so.1.0 libwnn.so
popd
cd ..
cp ./README             ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
cp ${PKGROOT}/doinst.sh ${PKGROOT}/${PACKAGE}-${VERSION}-root/install
cd ${PKGROOT}/${PACKAGE}-${VERSION}-root
yes | makepkg ${PACKAGE}-${VERSION}-i386-1.tgz
mv ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PACKAGE}-${VERSION}-i386-1.tgz ${PKGROOT}

#remove temporary files
rm -R ${PKGROOT}/${PACKAGE}-${VERSION}-root

