#!/bin/sh
#
# Slackware Add-on package Project
# <http://www.asahi-net.or.jp/~wp7s-mrn/>
#
# Date:
#   2002.07.10
#
# Package: 
#   groff-1.17.2-i386-1.tgz
#   groff-gxditview-1.17.2-i386-1.tgz
#   groff-perl-1.17.2-0vl4.i386.tgz
#
# Files:
#   ftp://ftp.ring.gr.jp/pub/linux/Vine/Vine-2.5/i386/Vine/SRPMS/SRPMS/groff-1.17.2-0vl4.src.rpm
# Patches:
#   None
#
# Author:
#   Shinji Morino <peace24@blue.email.ne.jp>
#
PATH=$PATH:/usr/X11R6/bin
PACKAGE=groff
VERSION=1.17.2
PKGROOT=`pwd`

#make
rpm --rebuild groff-1.17.2-0vl4.src.rpm

#makepkg
echo 'Creating package now ...'
if [ ! -d ${PKGROOT}/${PACKAGE}-${VERSION}-root ]; then
  mkdir -p ${PKGROOT}/${PACKAGE}-${VERSION}-root
fi
mv /usr/src/rpm/RPMS/i386/groff-1.17.2-0vl4.i386.rpm           ${PKGROOT}
mv /usr/src/rpm/RPMS/i386/groff-gxditview-1.17.2-0vl4.i386.rpm ${PKGROOT}
mv /usr/src/rpm/RPMS/i386/groff-perl-1.17.2-0vl4.i386.rpm      ${PKGROOT}
cd ${PKGROOT}
rpm2tgz groff-1.17.2-0vl4.i386.rpm
rpm2tgz groff-gxditview-1.17.2-0vl4.i386.rpm
rpm2tgz groff-perl-1.17.2-0vl4.i386.rpm
tar -zxvf groff-1.17.2-0vl4.i386.tgz            -C${PACKAGE}-${VERSION}-root
tar -zxvf groff-gxditview-1.17.2-0vl4.i386.tgz  -C${PACKAGE}-${VERSION}-root
tar -zxvf  groff-perl-1.17.2-0vl4.i386.tgz      -C${PACKAGE}-${VERSION}-root
cd ${PKGROOT}/${PACKAGE}-${VERSION}-root
mv ./usr/doc ./usr/share
mv ./usr/man ./usr/share
yes | makepkg groff-1.17.2-i386-1.tgz
mv groff-1.17.2-i386-1.tgz ..

#remove temporary files
rm -R ${PKGROOT}/${PACKAGE}-${VERSION}-root
rm ${PKGROOT}/groff-1.17.2-0vl4.i386.rpm
rm ${PKGROOT}/groff-1.17.2-0vl4.i386.tgz
rm ${PKGROOT}/groff-gxditview-1.17.2-0vl4.i386.rpm
rm ${PKGROOT}/groff-gxditview-1.17.2-0vl4.i386.tgz
rm ${PKGROOT}/groff-perl-1.17.2-0vl4.i386.rpm
rm ${PKGROOT}/groff-perl-1.17.2-0vl4.i386.tgz

