/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import jp.riken.brain.ni.samuraigraph.base.SGICopiable;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;

public class SGUtility {
    public static String[] getAvailableFontNames() {
        String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCanonicalPath(String string) {
        File file = new File(string);
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string2 = null;
            return string2;
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
        }
        String string3 = null;
        try {
            string3 = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
        return string3;
    }

    public static Rectangle2D createUnion(ArrayList arrayList) {
        if (arrayList == null) {
            throw new IllegalArgumentException("rectList==null");
        }
        Rectangle2D rectangle2D = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            Rectangle2D rectangle2D2 = (Rectangle2D)arrayList.get(i);
            if (rectangle2D2 == null) {
                throw new IllegalArgumentException("rect==null");
            }
            rectangle2D = rectangle2D == null ? rectangle2D2 : rectangle2D2.createUnion(rectangle2D);
        }
        return rectangle2D;
    }

    public static double getRectStart(Rectangle2D rectangle2D, boolean bl) {
        if (bl) {
            return rectangle2D.getX();
        }
        return rectangle2D.getY();
    }

    public static double getRectSize(Rectangle2D rectangle2D, boolean bl) {
        if (bl) {
            return rectangle2D.getWidth();
        }
        return rectangle2D.getHeight();
    }

    public static double getRectEnd(Rectangle2D rectangle2D, boolean bl) {
        return SGUtility.getRectStart(rectangle2D, bl) + SGUtility.getRectSize(rectangle2D, bl);
    }

    public static boolean setRectStart(Rectangle2D rectangle2D, double d, boolean bl) {
        if (bl) {
            rectangle2D.setRect(d, rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        } else {
            rectangle2D.setRect(rectangle2D.getX(), d, rectangle2D.getWidth(), rectangle2D.getHeight());
        }
        return true;
    }

    public static boolean setRectEnd(Rectangle2D rectangle2D, double d, boolean bl) {
        if (bl) {
            rectangle2D.setRect(d - rectangle2D.getWidth(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        } else {
            rectangle2D.setRect(rectangle2D.getX(), d - rectangle2D.getHeight(), rectangle2D.getWidth(), rectangle2D.getHeight());
        }
        return true;
    }

    public static boolean setRectSize(Rectangle2D rectangle2D, double d, boolean bl) {
        if (bl) {
            rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), d, rectangle2D.getHeight());
        } else {
            rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), d);
        }
        return true;
    }

    public static boolean isRectContains(Rectangle2D rectangle2D, double d, boolean bl) {
        return SGUtilityNumber.contains(SGUtility.getRectStart(rectangle2D, bl), SGUtility.getRectEnd(rectangle2D, bl), d);
    }

    public static boolean isRectContains(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, boolean bl) {
        return SGUtilityNumber.contains(SGUtility.getRectStart(rectangle2D, bl), SGUtility.getRectEnd(rectangle2D, bl), SGUtility.getRectStart(rectangle2D2, bl), SGUtility.getRectEnd(rectangle2D2, bl));
    }

    public static double getOverlapping(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, boolean bl) {
        return SGUtilityNumber.getOverlap(SGUtility.getRectStart(rectangle2D, bl), SGUtility.getRectEnd(rectangle2D, bl), SGUtility.getRectStart(rectangle2D2, bl), SGUtility.getRectEnd(rectangle2D2, bl));
    }

    public static boolean showMessageDialog(Component component, Object object, String string, int n) {
        JOptionPane.showMessageDialog(component, object, string, n);
        return true;
    }

    public static boolean showIllegalInputErrorMessageDialog(Component component) {
        Toolkit.getDefaultToolkit().beep();
        SGUtility.showMessageDialog(component, "\u4e0d\u6b63\u306a\u5165\u529b\u3067\u3059\u3002", "Illegal input", 0);
        return true;
    }

    public static boolean showFileNotFoundMessageDialog(Component component) {
        SGUtility.showMessageDialog(component, "Failed to open the file denoted by a specified pathname.", "File not found", -1);
        return true;
    }

    public static void setCenter(Window window, Window window2) {
        Dimension dimension = window2.getSize();
        int n = window.getWidth();
        int n2 = window.getHeight();
        int n3 = window2.getX() + (dimension.width - n) / 2;
        int n4 = window2.getY() + (dimension.height - n2) / 2;
        window.setLocation(n3, n4);
    }

    public static boolean copyObjects(ArrayList arrayList, ArrayList arrayList2) {
        if (arrayList == null | arrayList2 == null) {
            throw new IllegalArgumentException("list1==null | list2==null");
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            if (!(e instanceof SGICopiable)) {
                throw new IllegalArgumentException("Not copiable objects are included.");
            }
            SGICopiable sGICopiable = (SGICopiable)e;
            arrayList2.add(sGICopiable.copy());
        }
        return true;
    }

    public static JMenuItem addItem(JPopupMenu jPopupMenu, ActionListener actionListener, String string) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jPopupMenu.add(jMenuItem);
        jMenuItem.addActionListener(actionListener);
        return jMenuItem;
    }
}

