/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.border.EtchedBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import jp.riken.brain.ni.samuraigraph.application.SGFileChooserWizardDialog;

public class SGMultiDataFileChooserWizardDialog
extends SGFileChooserWizardDialog
implements TableModelListener,
DropTargetListener {
    public static final String TITLE = "Choose data files.";
    private JPanel mButtonPanel;
    private JButton mCancelButton;
    private JPanel mInsideScrollPanePanel;
    private JButton mNextButton;
    private JButton mOKButton;
    private JPanel mPanel;
    private JButton mPreviousButton;
    private JScrollPane mScrollPane;
    private JPanel mSingleFileChooserButtonPanel;
    protected JTable mTable;
    private JScrollPane mTableScrollPane;
    public static final String[] COLUMN_NAME = new String[]{"Figure ID", "Data Type", "Data Name", "File Name"};
    public static final int COLUMN_NUM_FIGURE_ID = 0;
    public static final int COLUMN_NUM_DATA_TYPE = 1;
    public static final int COLUMN_NUM_DATA_NAME = 2;
    public static final int COLUMN_NUM_FILE_NAME = 3;
    private int mFileNumber;
    private DefaultTableModel mTableModel = null;
    public static final int DEFAULT_ROW_HEIGHT = 16;
    public static final String NO_DATA = "NO_DATA";
    public static final int DEFAULT_SINGLE_FILE_CHOOSER_BUTTON_WIDTH = 20;
    private JButton[] mSingleFileChooserButtonArray = null;

    public SGMultiDataFileChooserWizardDialog() {
        this.initComponents();
        this.initProperty();
    }

    public SGMultiDataFileChooserWizardDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
    }

    private void initComponents() {
        this.mPanel = new JPanel();
        this.mScrollPane = new JScrollPane();
        this.mInsideScrollPanePanel = new JPanel();
        this.mSingleFileChooserButtonPanel = new JPanel();
        this.mTableScrollPane = new JScrollPane();
        this.mTable = new JTable();
        this.mButtonPanel = new JPanel();
        this.mPreviousButton = new JButton();
        this.mNextButton = new JButton();
        this.mOKButton = new JButton();
        this.mCancelButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.mPanel.setLayout(new GridBagLayout());
        this.mPanel.setFont(new Font("Dialog", 0, 11));
        this.mScrollPane.setFont(new Font("Dialog", 0, 11));
        this.mScrollPane.setPreferredSize(new Dimension(458, 200));
        this.mInsideScrollPanePanel.setLayout(new GridBagLayout());
        this.mInsideScrollPanePanel.setFont(new Font("Dialog", 0, 11));
        this.mSingleFileChooserButtonPanel.setLayout(new BoxLayout(this.mSingleFileChooserButtonPanel, 1));
        this.mSingleFileChooserButtonPanel.setFont(new Font("Dialog", 0, 11));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.mInsideScrollPanePanel.add((Component)this.mSingleFileChooserButtonPanel, gridBagConstraints);
        this.mTableScrollPane.setVerticalScrollBarPolicy(21);
        this.mTableScrollPane.setHorizontalScrollBarPolicy(31);
        this.mTableScrollPane.setBorder(null);
        this.mTableScrollPane.setFont(new Font("Dialog", 0, 11));
        this.mTableScrollPane.setPreferredSize(new Dimension(434, 196));
        this.mTable.setFont(new Font("Dialog", 0, 11));
        this.mTableScrollPane.setViewportView(this.mTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.mInsideScrollPanePanel.add((Component)this.mTableScrollPane, gridBagConstraints);
        this.mScrollPane.setViewportView(this.mInsideScrollPanePanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.mPanel.add((Component)this.mScrollPane, gridBagConstraints);
        this.getContentPane().add((Component)this.mPanel, new GridBagConstraints());
        this.mButtonPanel.setBorder(new EtchedBorder());
        this.mButtonPanel.setFont(new Font("Dialog", 0, 11));
        this.mPreviousButton.setFont(new Font("Dialog", 1, 12));
        this.mPreviousButton.setText("<Prev");
        this.mButtonPanel.add(this.mPreviousButton);
        this.mNextButton.setFont(new Font("Dialog", 1, 12));
        this.mNextButton.setText("Next>");
        this.mButtonPanel.add(this.mNextButton);
        this.mOKButton.setFont(new Font("Dialog", 1, 12));
        this.mOKButton.setText("OK");
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setFont(new Font("Dialog", 1, 12));
        this.mCancelButton.setText("Cancel");
        this.mButtonPanel.add(this.mCancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        this.pack();
    }

    private boolean initProperty() {
        this.setTitle(TITLE);
        this.mOKButton.setEnabled(false);
        this.mTableModel = new OriginalTableModel();
        this.mTableModel.addTableModelListener(this);
        this.mTable.setRowHeight(16);
        DropTarget dropTarget = new DropTarget(this.mTable, 3, this, true);
        this.setDropTarget(dropTarget);
        this.getPreviousButton().addActionListener(this);
        this.getNextButton().addActionListener(this);
        this.getOKButton().addActionListener(this);
        this.getCancelButton().addActionListener(this);
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        JTable jTable = this.getTable();
        for (int i = 0; i < this.mSingleFileChooserButtonArray.length; ++i) {
            if (!object.equals(this.mSingleFileChooserButtonArray[i])) continue;
            this.mFileChooser.setMultiSelectionEnabled(false);
            File[] fileArray = this.showFileChooser();
            if (fileArray == null) {
                return;
            }
            File file = fileArray[0];
            this.setSelectedFile(i, file);
            break;
        }
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        boolean bl = true;
        DefaultTableModel defaultTableModel = this.mTableModel;
        int n = defaultTableModel.getRowCount();
        int n2 = defaultTableModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                Object object = defaultTableModel.getValueAt(i, j);
                if (object != null) continue;
                bl = false;
                break;
            }
            if (!bl) break;
        }
        this.getOKButton().setEnabled(bl);
    }

    public JTable getTable() {
        return this.mTable;
    }

    public boolean setTable(JTable jTable) {
        this.mTable = jTable;
        return true;
    }

    public TableModel getTableModel() {
        return this.mTable.getModel();
    }

    public boolean setTableModel(TableModel tableModel) {
        this.mTable.setModel(tableModel);
        return true;
    }

    public void setFigureIDArray(String[] stringArray) {
        this.setData(stringArray, 0);
    }

    public void setDataNameArray(String[] stringArray) {
        this.setData(stringArray, 2);
    }

    public void setDataTypeArray(String[] stringArray) {
        this.setData(stringArray, 1);
    }

    public void setFileNameArray(String[] stringArray) {
        this.setData(stringArray, 3);
    }

    private void setData(Object[] objectArray, int n) {
        Component[] componentArray;
        int n2;
        DefaultTableModel defaultTableModel = this.mTableModel;
        int n3 = COLUMN_NAME.length;
        int n4 = this.mTableModel.getRowCount();
        Object[][] objectArray2 = new Object[n4][n3];
        for (n2 = 0; n2 < n3; ++n2) {
            int n5;
            if (n2 == n) {
                for (n5 = 0; n5 < n4; ++n5) {
                    objectArray2[n5][n2] = objectArray[n5];
                }
                continue;
            }
            for (n5 = 0; n5 < n4; ++n5) {
                objectArray2[n5][n2] = defaultTableModel.getDataVector().elementAt(n5).elementAt(n2);
            }
        }
        defaultTableModel.setDataVector(objectArray2, COLUMN_NAME);
        this.setTableModel(defaultTableModel);
        n2 = -1;
        for (int i = 0; i < n4; ++i) {
            componentArray = objectArray2[i][2];
            if (!NO_DATA.equals(componentArray)) continue;
            n2 = i;
            break;
        }
        ArrayList<Component> arrayList = new ArrayList<Component>();
        componentArray = this.mSingleFileChooserButtonPanel.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JButton)) continue;
            arrayList.add(componentArray[i]);
        }
        if (n2 != -1) {
            JButton jButton = (JButton)arrayList.get(n2);
            jButton.setEnabled(false);
        }
    }

    public void init(int n) {
        JComponent jComponent;
        Component[] componentArray = this.mSingleFileChooserButtonPanel.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JButton)) continue;
            jComponent = (JButton)componentArray[i];
            ((AbstractButton)jComponent).removeActionListener(this);
        }
        this.mSingleFileChooserButtonPanel.removeAll();
        JTable jTable = this.getTable();
        jComponent = jTable.getTableHeader();
        int n2 = 16 * (n + 1);
        this.mSingleFileChooserButtonPanel.setPreferredSize(new Dimension(20, n2));
        int n3 = this.mInsideScrollPanePanel.getHeight();
        int n4 = n3 < n2 ? n2 : n3;
        int n5 = this.mTableScrollPane.getPreferredSize().width;
        this.mTableScrollPane.setPreferredSize(new Dimension(n5, n4));
        JLabel jLabel = new JLabel(" ");
        jLabel.setFont(new Font("Dialog", 1, 12));
        jLabel.setPreferredSize(new Dimension(20, 16));
        this.mSingleFileChooserButtonPanel.add(jLabel);
        JButton[] jButtonArray = this.mSingleFileChooserButtonArray = new JButton[n];
        for (int i = 0; i < n; ++i) {
            JButton jButton = new JButton(" ");
            jButton.setFont(new Font("Dialog", 1, 12));
            jButton.setPreferredSize(new Dimension(20, 16));
            jButton.addActionListener(this);
            jButtonArray[i] = jButton;
            this.mSingleFileChooserButtonPanel.add(jButton);
        }
        Object[][] objectArray = new Object[n][];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = new Object[COLUMN_NAME.length];
        }
        this.setData(objectArray);
    }

    public void setData(Object[][] objectArray) {
        DefaultTableModel defaultTableModel = this.mTableModel;
        defaultTableModel.setDataVector(objectArray, COLUMN_NAME);
        this.setTableModel(defaultTableModel);
    }

    private File[] showFileChooser() {
        ArrayList arrayList = this.openFileChooser();
        if (arrayList == null) {
            return null;
        }
        if (arrayList.size() == 0) {
            return null;
        }
        File[] fileArray = new File[arrayList.size()];
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray[i] = (File)arrayList.get(i);
        }
        return fileArray;
    }

    public TreeMap getSelectedFilePathListMap() {
        JTable jTable = this.mTable;
        TreeMap treeMap = new TreeMap();
        for (int i = 0; i < jTable.getRowCount(); ++i) {
            Object object = jTable.getValueAt(i, 0);
            Object object2 = treeMap.get(object);
            if (object2 == null) {
                object2 = new ArrayList();
                treeMap.put(object, object2);
            }
            ArrayList arrayList = (ArrayList)object2;
            Object object3 = jTable.getValueAt(i, 3);
            arrayList.add(object3);
        }
        return treeMap;
    }

    public String[] getSelectedFileNames() {
        JTable jTable = this.getTable();
        int n = jTable.getRowCount();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)jTable.getValueAt(i, 3);
        }
        return stringArray;
    }

    private boolean setSelectedFiles(File[] fileArray) {
        int n;
        JTable jTable = this.getTable();
        for (n = 0; n < jTable.getRowCount(); ++n) {
            jTable.setValueAt(null, n, 3);
        }
        for (n = 0; n < fileArray.length; ++n) {
            this.setSelectedFile(n, fileArray[n]);
        }
        return true;
    }

    private boolean setSelectedFile(int n, File file) {
        String string = file.getPath();
        this.mTable.setValueAt(string, n, 3);
        return true;
    }

    public int getFileNumber() {
        return this.mFileNumber;
    }

    public void setFileNumber(int n) {
        if (n < 0) {
            new IllegalArgumentException("num<0");
        }
        this.mFileNumber = n;
    }

    protected JButton getPreviousButton() {
        return this.mPreviousButton;
    }

    protected JButton getNextButton() {
        return this.mNextButton;
    }

    protected JButton getOKButton() {
        return this.mOKButton;
    }

    protected JButton getCancelButton() {
        return this.mCancelButton;
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        dropTargetDragEvent.acceptDrag(3);
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        DropTarget dropTarget = (DropTarget)dropTargetDropEvent.getSource();
        Component component = dropTarget.getComponent();
        SGMultiDataFileChooserWizardDialog sGMultiDataFileChooserWizardDialog = (SGMultiDataFileChooserWizardDialog)component;
        dropTargetDropEvent.acceptDrop(3);
        JTable jTable = this.mTable;
        DefaultTableModel defaultTableModel = this.mTableModel;
        JViewport jViewport = this.mScrollPane.getViewport();
        Point point = jViewport.getViewPosition();
        Point point2 = dropTargetDropEvent.getLocation();
        int n = this.getInsets().left - point.x;
        int n2 = this.getInsets().top + this.mScrollPane.getY() - point.y + jTable.getRowHeight();
        Point point3 = new Point(point2.x - n, point2.y - n2);
        try {
            if ((dropTargetDropEvent.getDropAction() & 3) != 0) {
                Transferable transferable = dropTargetDropEvent.getTransferable();
                List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                if (list.size() == 0) {
                    return;
                }
                File file = (File)list.get(0);
                int n3 = jTable.rowAtPoint(point3);
                int n4 = jTable.getRowCount();
                if (!NO_DATA.equals(defaultTableModel.getValueAt(n3, 3))) {
                    Rectangle rectangle = jTable.getCellRect(n3, 3, true);
                    if (n3 != -1) {
                        jTable.setValueAt(file.getPath(), n3, 3);
                    }
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            dropTargetDropEvent.dropComplete(false);
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    private class OriginalTableModel
    extends DefaultTableModel {
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

