/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : Line_dlg.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/01/16
 *    Last                 : 2002/06/25
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#define LINE_DLG
#include "MemoryLeak.h"
#include "List_cad.h"
#include "List_Dimension.h"
#include "List_PolyLine.h"
#include "List_Block.h"
#include "List_Undo.h"
#include "List_Select.h"
#include "global.h"
#include "Draw.h"
#include "Line_dlg.h"





/* -------------------------------------------------------------------
 * ɽƤܥκ
 * style_box "expose ()" ٥ȥϥɥ
 */
gint style_box_expose_event(GtkWidget *widget, GdkEventExpose *event, Line_set *lsbox)
{
	gint w, h;
	GdkGC *ld_gc;
	int style;

	/* 褹 widget Υͤ */
	style = GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(widget), "value"));

	/* GC  */
	ld_gc = create_gc(widget);

	/* ɥ󥰥쥢礭 */
	w = widget->allocation.width;
	h = widget->allocation.height;

	/* ܥط */
	PenSet(ld_gc, 1, 0xe0e0e0);
	gdk_draw_rectangle (widget->window, ld_gc, TRUE, 0, 0, w, h);

	/* ܥ˸褦ΩΤˤ */
	PenSet(ld_gc, 1, 0x000000);
	gdk_draw_line(widget->window, ld_gc, 2, h-2, w-2, h-2);
	gdk_draw_line(widget->window, ld_gc, 1, h-1, w-1, h-1);
	gdk_draw_line(widget->window, ld_gc, w-2, 2, w-2, h-2);
	gdk_draw_line(widget->window, ld_gc, w-1, 1, w-1, h-1);
	PenSet(ld_gc, 1, 0xffffff);
	gdk_draw_line(widget->window, ld_gc, 1, 1, w-1, 1);
	gdk_draw_line(widget->window, ld_gc, 2, 2, w-2, 2);
	gdk_draw_line(widget->window, ld_gc, 1, 1, 1, h-1);
	gdk_draw_line(widget->window, ld_gc, 2, 2, 2, h-2);

	/* ɽХå顼 */
	PenSet_with_back(ld_gc, style, 0x000000, 0xe0e0e0);
	gdk_draw_line(widget->window, ld_gc, 3, h/2, w-3, h/2);

	/* GC  */
	delete_gc(ld_gc);

	return FALSE;
}





/* ------------------------------------------------------------------
 * ɽƤ widget κ
 * color_box "expose ()" ٥ȥϥɥ
 */
gint color_box_expose_event(GtkWidget *widget, GdkEventExpose *event, Line_set *lsbox)
{
	gint w, h;
	GdkGC *ld_gc;
	long color;

	/* widget ͤ */
	color = GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(widget), "value"));

	/* GC  */
	ld_gc = create_gc(widget);

	/* ɥ󥰥쥢礭 */
	w = widget->allocation.width;
	h = widget->allocation.height;

	PenSet(ld_gc, 1, 0xe0e0e0);
	gdk_draw_rectangle (widget->window, ld_gc, TRUE, 0, 0, w, h);

	PenSet(ld_gc, 1, color);
	gdk_draw_rectangle (widget->window, ld_gc, TRUE, 1, 1, w-1, h-1);

	PenSet(ld_gc, 1, 0x000000);
	gdk_draw_rectangle (widget->window, ld_gc, FALSE, 1, 1, w-1, h-1);
	PenSet(ld_gc, 1, 0x000000);
	gdk_draw_rectangle (widget->window, ld_gc, FALSE, 2, 2, w-2, h-2);

	/* GC  */
	delete_gc(ld_gc);

	return FALSE;
}





/* ------------------------------------------------------------------
 * draw_area "expose ()" ٥ȥϥɥ
 */
gint draw_area_expose_event(GtkWidget *widget, GdkEventExpose *event, Line_set *lsbox)
{
	draw_area_box_draw(widget, lsbox);
	return FALSE;
}





int draw_area_box_draw(GtkWidget *widget, Line_set *lsbox)
{
	gint x, y;
	GdkGC *ld_gc;

	/* ɥ󥰥쥢礭 */
	x = widget->allocation.width;
	y = widget->allocation.height;

	/* GC  */
	ld_gc = create_gc(widget);

	PenSet(ld_gc, 1, sagcad_color.Back);
	gdk_draw_rectangle (widget->window, ld_gc, TRUE, 0, 0, x, y);

	PenSet(ld_gc, 1, 0xffffff);
	gdk_draw_rectangle (widget->window, ld_gc, FALSE, 0, 0, x, y);

	//PenSet(ld_gc, lsbox->style_value, lsbox->color_value);
	PenSet_with_back(ld_gc, lsbox->style_value, lsbox->color_value, sagcad_color.Back);
	gdk_draw_line(widget->window, ld_gc, 0, y/2, x, y/2);

	/* GC  */
	delete_gc(ld_gc);
	return 1;
}





int style_box_button_press_event(GtkWidget *widget, GdkEventButton *event, Line_set *lsbox)
{
	/* 줿 style_box ͤ */
	lsbox->style_value = GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(widget), "value"));
	draw_area_box_draw(lsbox->draw_area, lsbox);
	return TRUE;
}





int color_box_button_press_event(GtkWidget *widget, GdkEventButton *event, Line_set *lsbox)
{
	/* 줿 color_box ͤ */
	lsbox->color_value = GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(widget), "value"));
	draw_area_box_draw(lsbox->draw_area, lsbox);
	return TRUE;
}





/* -------------------------
 * 줿٥
 */
static gint lsbox_key_press_event(GtkWidget *widget, GdkEventKey *event, Line_set *lsbox)
{		
#ifdef TEST
	g_print("sagcad : key_press_event\n");
	g_print("state  = %d\n", event->state);
	g_print("keyval = %d   0x%x\n", event->keyval, event->keyval);
	g_print("length = %d\n", event->length);
	g_print("string = %s\n", event->string);
#endif
//	0xff8d;

	if(event->keyval == 0xff8d || event->keyval == 0xff0d) 	{
		/* 줿ܥͤ */
		gtk_main_quit();
	}
	return TRUE; 
}





/* -------------------------------------------------------
 *   Line_set_dlg
 */
int Line_set_dlg(int *style, long *color)
{
	Line_set *lsbox;

	int x, y, l;
	GtkWidget *action_vbox;
	GtkWidget *hbox1;
	GtkWidget *style_box;
	GtkWidget *table1;
	GtkWidget *table2;
	GtkWidget *color_box;
	GtkWidget *hbox2;
	GtkWidget *line_status;
	GtkWidget *btn_ok;
	GtkWidget *separator;

	lsbox = (Line_set *)g_malloc(sizeof(Line_set));

	lsbox->style_value = *style;
	lsbox->color_value = *color;


	/*  */
	lsbox->dialog = gtk_dialog_new();
	gtk_window_set_title(GTK_WINDOW(lsbox->dialog), "Line Setting");
	gtk_signal_connect( GTK_OBJECT(lsbox->dialog), "key_press_event",
						GTK_SIGNAL_FUNC(lsbox_key_press_event), lsbox);

	/* Υ󥨥ꥢ */
//	action_area = GTK_DIALOG(lsbox->dialog)->action_area;

	/* action_vbox  */
	action_vbox = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start((GtkBox *)GTK_DIALOG(lsbox->dialog)->action_area, 
					   action_vbox, TRUE, TRUE, 0);
	gtk_widget_show(action_vbox);


	/* hbox1  */
	hbox1 = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start((GtkBox *)action_vbox, hbox1, TRUE, TRUE, 0);
	gtk_widget_show(hbox1);

	/* ѥ졼  */
	separator = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(action_vbox), separator, FALSE, FALSE, 8);
	gtk_widget_show(separator);

	/* hbox2  */
	hbox2 = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start((GtkBox *)action_vbox, hbox2, TRUE, TRUE, 0);
	gtk_widget_show(hbox2);


	/* table(style)  */
	table1 = gtk_table_new(1, 5, FALSE);
	for (y = 0 ; y < 5 ; y++) {
		style_box = gtk_drawing_area_new();
		gtk_object_set_data(GTK_OBJECT(style_box), "value", (gpointer)y);
		/* ɥ󥰥ꥢΥ */
		gtk_drawing_area_size( GTK_DRAWING_AREA(style_box), 100, 18);
		/* "expose_event" ٥ȥϥɥ */
		gtk_signal_connect(GTK_OBJECT(style_box), "expose_event",
				   (GtkSignalFunc) style_box_expose_event, lsbox);
		/* "button_press_event" ٥ȥϥɥ */
		gtk_signal_connect(GTK_OBJECT(style_box), "button_press_event",
						   (GtkSignalFunc) style_box_button_press_event, lsbox);
		/* ٥ȥޥ */
		gtk_widget_set_events(style_box,  GDK_EXPOSURE_MASK
										| GDK_LEAVE_NOTIFY_MASK
										| GDK_BUTTON_PRESS_MASK
										| GDK_POINTER_MOTION_MASK
										| GDK_POINTER_MOTION_HINT_MASK);
		gtk_table_attach_defaults(GTK_TABLE(table1), style_box, 0, 1, y, y+1);
		gtk_widget_show(style_box);
	}
	gtk_box_pack_start((GtkBox *)hbox1, table1, TRUE, TRUE, 0);
	gtk_widget_show(table1);





	/* ѥ졼  */
	separator = gtk_vseparator_new();
	gtk_box_pack_start(GTK_BOX(hbox1), separator, FALSE, FALSE, 4);
	gtk_widget_show(separator);





	/* table(color)  */
	table2 = gtk_table_new(5, 5, FALSE);
	for (x = 0 ; x < 5 ; x++) {
		for (y = 0 ; y < 5 ; y++) {
			l = y * 5 + x;

			color_box = gtk_drawing_area_new();
			/* ɥ󥰥ꥢΥ */
			gtk_drawing_area_size( GTK_DRAWING_AREA(color_box), 20, 20);
			/* "expose_event"٥ȥϥɥ */
			gtk_signal_connect(GTK_OBJECT(color_box), "expose_event",
					   (GtkSignalFunc) color_box_expose_event, lsbox);
			/* "button_press_event"٥ȥϥɥ */
			gtk_signal_connect(GTK_OBJECT(color_box), "button_press_event",
					   (GtkSignalFunc) color_box_button_press_event, lsbox);
			/* ٥ȥޥ */
			gtk_widget_set_events(color_box,  GDK_EXPOSURE_MASK
											| GDK_LEAVE_NOTIFY_MASK
											| GDK_BUTTON_PRESS_MASK
											| GDK_POINTER_MOTION_MASK
											| GDK_POINTER_MOTION_HINT_MASK);

			gtk_table_attach_defaults(GTK_TABLE(table2), color_box, x, x+1, y, y+1);
			gtk_object_set_data(GTK_OBJECT(color_box), "value", (gpointer)ColorMenu[l]);
			gtk_widget_show(color_box);
		}
	}
	gtk_box_pack_start((GtkBox *)hbox1, table2, TRUE, TRUE, 0);
	gtk_widget_show(table2);





	/* draw_area  */
	line_status = gtk_drawing_area_new();
	/* ɥ󥰥ꥢΥ */
	gtk_drawing_area_size( GTK_DRAWING_AREA(line_status), 100, 18);
	gtk_box_pack_start(GTK_BOX(hbox2), line_status, FALSE, TRUE, 0);
	/* "expose_event" ٥ȥϥɥ */
	gtk_signal_connect(GTK_OBJECT(line_status), "expose_event",
					   (GtkSignalFunc) draw_area_expose_event, lsbox);
	lsbox->draw_area = line_status;
	gtk_widget_show(line_status);


	/* ѥ졼  */
	separator = gtk_vseparator_new();
	gtk_box_pack_start(GTK_BOX(hbox2), separator, FALSE, FALSE, 4);
	gtk_widget_show(separator);


	/* OKܥ */
	btn_ok = gtk_button_new_with_label("OK");
	gtk_box_pack_start(GTK_BOX(hbox2), btn_ok, TRUE, TRUE, 0);
	gtk_object_set_data(GTK_OBJECT(btn_ok), "value", (gpointer)-1);
	gtk_signal_connect(GTK_OBJECT(btn_ok), "clicked",
					   GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
	gtk_widget_show(btn_ok);



	GTK_WINDOW(lsbox->dialog)->focus_widget = GTK_WIDGET(btn_ok);


	/* Ļ֤ */
	gtk_widget_show(lsbox->dialog);
	/* ֤ */
	gtk_grab_add(lsbox->dialog);


	/* ᥤ󥤥٥ȥ롼 */
	gtk_main();


	gtk_grab_remove(lsbox->dialog);
	gtk_widget_destroy(lsbox->dialog);

	*style = lsbox->style_value;
	*color = lsbox->color_value;
	return 1; 
}



/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : Line_dlg.c
 * ====================================================================
 */
