/* ====================================================================
 * ===  Copyright (C) 1998-2002 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : sagcad
 *    Description          : CAD/CAM
 *    Source               : toolbar.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2002 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/01/16
 *    Last                 : 2002/06/25
 * ====================================================================
 */

#ifndef __TOOLBAR_H__
#define __TOOLBAR_H__



/*
 * -------------------------------------------------------
 * 1 :   (struct #define etc)
 * -------------------------------------------------------
 */
#define SPACE_CMD "_SPACE_"

struct ToolBarItem
{
	char *tooltips;
	char **xpm;
	void *func;
	int button_type;
	int signal_type;
};



/*
 * -------------------------------------------------------
 * 2 : ѿ
 * -------------------------------------------------------
 */
/* toolbar.c ƤФ줿Ȥ */
#ifdef TOOLBAR 
/* File */
#include "xpm/New.xpm"
#include "xpm/Open.xpm"
#include "xpm/ReName.xpm"
#include "xpm/Save.xpm"
#include "xpm/Parts_in.xpm"
#include "xpm/Print.xpm"
#include "xpm/PrinterSetting.xpm"
#include "xpm/End.xpm"

#include "xpm/Undo.xpm"
#include "xpm/Redo.xpm"

#include "xpm/Cut.xpm"
#include "xpm/Copy.xpm"
#include "xpm/Paste.xpm"

#include "xpm/Redraw.xpm"
#include "xpm/Center.xpm"

#include "xpm/View_0.xpm"
#include "xpm/View_1.xpm"
#include "xpm/View_2.xpm"
#include "xpm/View_3.xpm"
#include "xpm/View_4.xpm"
#include "xpm/View_5.xpm"

#include "xpm/EnvSet.xpm"
#include "xpm/Version.xpm"
#include "xpm/Help.xpm"

/* Draw */
#include "xpm/Cancel.xpm"
#include "xpm/Draw.xpm"
#include "xpm/Split.xpm"
#include "xpm/Trim.xpm"
#include "xpm/Both_Trim.xpm"
#include "xpm/Fillet.xpm"
#include "xpm/C_Cut.xpm"
#include "xpm/Point_Input.xpm"
#include "xpm/Cont_Line.xpm"
#include "xpm/Line3.xpm"
#include "xpm/Point3.xpm"

/* Edit */
#include "xpm/Select.xpm"
#include "xpm/RectSelect.xpm"
#include "xpm/Mirr.xpm"
#include "xpm/Para.xpm"
#include "xpm/Roll.xpm"
#include "xpm/Matrix.xpm"
#include "xpm/Scaling.xpm"
#include "xpm/LineStyleChange.xpm"
#include "xpm/LayerCopy.xpm"
#include "xpm/LayerMove.xpm"
#include "xpm/Delete.xpm"

/* Dimension */
#include "xpm/DimenX.xpm"
#include "xpm/DimenY.xpm"
#include "xpm/DimenDistance.xpm"
#include "xpm/DimenAngle.xpm"
#include "xpm/DimenR.xpm"
#include "xpm/DimenD.xpm"
#include "xpm/DimenPoint.xpm"
#include "xpm/DimenPullLine.xpm"
#include "xpm/DimenAtension.xpm"
#include "xpm/DimenEdit.xpm"

#include "xpm/PolyLine.xpm"
#include "xpm/Ellipse.xpm"

/* CAM */
//#include "xpm/Cam25D.xpm"
#include "xpm/CamNcDraw.xpm"
//#include "xpm/CamPoket.xpm"
#include "xpm/CamProfile.xpm"

/* Outside Process */
#include "xpm/outside_process.xpm"


/* toolbar.c ʳƤФ줿Ȥ */
#else



#endif /* TOOLBAR */
#undef TOOLBAR


/*
 * -------------------------------------------------------
 * 3 : ؿ
 * -------------------------------------------------------
 */
GtkWidget *create_toolbar_OutMode1(GtkWidget *window);
GtkWidget *create_toolbar_InMode1(GtkWidget *window);
GtkWidget *create_toolbar_InMode2(GtkWidget *window);
void AppendButtons(GtkWidget *window, GtkWidget *toolbar, struct ToolBarItem *Item);
GtkWidget *pixmap_from_xpm(GtkWidget *widget, gchar **xpm_data);

int undo_buttun(int frag);
int redo_buttun(int frag);



#endif /* __TOOLBAR_H__ */



/* ====================================================================
 * ===  Copyright (C) 1998-2002 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : sagcad
 *    Description          : CAD/CAM
 *    Source               : toolbar.h
 * ====================================================================
 */
