/* ====================================================================
 * ===  Copyright (C) 1998-2002 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : sagcad
 *    Description          : CAD/CAM
 *    Source               : iges.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2002 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/03/27
 *    Last                 : 2002/09/10
 * ====================================================================
 */
#ifndef __IGES_H__
#define __IGES_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 :   (struct #define etc)
 * -------------------------------------------------------
 */



/* -------------------------------------------------------
 * 2 : ѿ (global)
 * -------------------------------------------------------
 */
#ifdef _IGES_
#define   GLOBAL
// 
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
// ʬ̵
#define   GLOBAL_VAL(v)  /* */
#endif




#undef  GLOBAL
#undef  GLOBAL_VAL
#undef _IGES_



/* -------------------------------------------------------
 * 3 : ؿ (Function)
 * -------------------------------------------------------
 */
int igesFileSave(char *SaveFileName);
int start_section_write(FILE *stream);
int global_section_write(char *SaveFileName, char *UserName, char *CompanyName, FILE *stream);
int directory_section_write(FILE *stream);
int parameter_section_write(FILE *stream);
int terminate_section_write(FILE *stream);

int SagToIges_Style(int style);
int SagToIges_Color(long color);
int lenN(int n, char *str);
int spclen(int n, char *str);

int igesFileRead(char *ReadFileName);



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __IGES_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2002 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : sagcad
 *    Source               : iges.h
 * ====================================================================
 */
