/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : Mouse.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/01/18
 *    Last                 : 2003/04/16
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <stdio.h>
#include "intl.h"

#include "types.h"
#include "List_cad.h"
#include "List_cam.h"
#include "List_Dimension.h"
#include "List_PolyLine.h"
#include "List_Ellipse.h"
#include "List_Vertex.h"
#include "List_Block.h"
#include "List_Undo.h"
#include "List_Select.h"
#include "global.h"
#include "Trace.h"
#include "Select.h"
#include "Draw.h"
#include "sagcad.h"
#include "DrawMode.h"
#include "MsgBox.h"
#include "TrimFunc.h"
#include "Ellipse.h"
#include "InputBox.h"
//#include "CamProfile.h"
//#include "Dlg.h"
#include "etc.h"
#include "CopyFunc.h"
#include "Dimension.h"
//#include "FileFunc.h"
//#include "offset.h"
#include "plcDlg.h"
#include "B_spline.h"
#include "spline.h"
#include "MemoryLeak.h"

#include "CopyDlg.h"
#include "TurnDlg.h"
#include "ScalingDlg.h"
#include "GridCopyDlg.h"
#include "SnapDlg.h"
#include "TextEditDlg.h"
#include "sgy.h"
#include "DXF_read.h"
#include "CulcInputDlg.h"
#include "Command.h"
#include "CamSetDlg.h"
#include "CamProfile.h"
#include "OutsideProcess.h"

#define _MOUSE_
#include "Mouse.h"





/* -------------------------------------------------------------------
 * ޥΥܥ󤬲줿Ȥ
 */
void SagCad_MouseDown(GtkWidget *widget, int Button, int Shift, int x, int y)
{
	if (Shift != 0) {
		/* Alt + ܥ */
		if (Shift == 4) {
//			if (Button == 1) MenuCommand(widget, ID_ZOOM_UP);
//			else if (Button == 2) MenuCommand(widget, ID_ZOOM_DOWN);
		}
		/* Ctrl +  */
		else if (Shift == 2) {
//			if (Button == 1) MenuCommand(widget, ID_LEFT);
//			else if (Button == 2) MenuCommand(widget, ID_RIGHT);
		}
		/* Shift + 岼 */
		else if (Shift == 1) {
//			if (Button == 1) MenuCommand(widget, ID_UP);
//			else if (Button == 2) MenuCommand(widget, ID_DOWN);
		}
	}


//g_print("Mouse.c : SagCad_MouseDown() : in 1\n");


	/* 濴ʿ޷*/
	else if (Center_set_mode == 100) MouseMode_Center(widget, Button, ToViewX(x), ToViewY(y));
	/* 1⡼ (OnlyOne) */
	else if (OnlyOne_mode == 210) {
		MouseRet_OnlyOne(widget, x, y, Button);
		MouseMode_OnlyOne(widget, x, y, Button);
	}
	/* ⡼ (OnlyOne) */
	else if (Chain2_OnlyOne_mode == 211) MouseMode_ChainOne(widget, x, y, Button);
	else {
		/* ⡼̵ΤȤ (mode = 0) */
		if (mode == 0) MouseMode_Non(widget, Button, x, y);
		/* ޥ⡼ */
		else if (mode == 200) MouseMode_Draw(widget, Button, x, y);
		/* ʿ */
		else if (mode == 110) MouseMode_PartsRead(widget, Button, x, y);

		/* ⡼ */
		else if (mode == 300 && outside_process_on == 0) MouseMode_Select(widget, Button, x, y);
		/* ⡼ () */
		else if (mode == 300 && outside_process_on == 1) MouseMode_Select_ops(widget, Button, x, y);
		/* ϰ⡼ */
		else if (mode == 310 && outside_process_on == 0) MouseMode_Rect(widget, Button, x, y);
		/* ϰ⡼ () */
		else if (mode == 310 && outside_process_on == 1) MouseMode_Rect_ops(widget, Button, x, y);

		/* ȥ⡼ */
		else if (mode == 220) MouseMode_Trim(widget, Button, x, y);
		/* ξȥ⡼ */
		else if (mode == 225) MouseMode_Trim(widget, Button, x, y);
		/* ʬ */
		else if (mode == 260) MouseMode_Split(widget, Button, x, y);
		/* եå */
		else if (mode == 270) MouseMode_Fillet(widget, Button, x, y);
		/*  */
		else if (mode == 280) MouseMode_Chamfering(widget, Button, x, y);
		/* Ϣ³ */
		else if (mode == 250) MouseMode_ContLine(widget, Button, x, y);
		/* Ǳ */
		else if (mode == 230) MouseMode_3P_Circle(widget, Button, x, y);
		/* դǱ */
		else if (mode == 240) MouseMode_3L_Circle(widget, Button, x, y);

		/* ʿ */
		else if (mode == 340) MouseMode_Parallel(widget, Button, x, y);
		/* ž */
		else if (mode == 350) MouseMode_Turn(widget, Button, x, y);
		/* о */
		else if (mode == 330) MouseMode_Mirror(widget, Button, x, y);

		/* ˡʿ */
		else if (mode == 510) MouseMode_DimensionX(widget, Button, x, y);
		/* ˡľ */
		else if (mode == 520) MouseMode_DimensionY(widget, Button, x, y);
		/* ˡΥ */
		else if (mode == 530) MouseMode_DimensionP(widget, Button, x, y);
		/* ˡȾ */
		else if (mode == 540) MouseMode_DimensionR(widget, Button, x, y);
		/* ˡľ */
		else if (mode == 550) MouseMode_DimensionD(widget, Button, x, y);
		/* ˡ */
		else if (mode == 560) MouseMode_DimensionA(widget, Button, x, y);
		/* ˡɸ */
		else if (mode == 570) MouseMode_DimensionPT(widget, Button, x, y);
		/* ˡ */
		else if (mode == 580) MouseMode_DimensionHD(widget, Button, x, y);
		/* ˡ */
		else if (mode == 590) MouseMode_DimensionAT(widget, Button, x, y);
		/* ˡԽ */
		else if (mode == 610) MouseMode_DimensionEDT(widget, Button, x, y);
		/* ݥ饤 */
		else if (mode == 255) MouseMode_PolyLine(widget, Button, x, y);
		/* ãͻ (޷ü) */
		else if (mode == 900) MouseMode_CamProfile(widget, Button, x, y);
#ifdef AFTER
		/* offset  (޷ü) */
		else if (mode == 1000) MouseMode_offset(widget, Button, x, y);
#endif
	}
}





/* -------------------------------------------------------------------
 * ޥΥܥȤ
 *	
 */
void SagCad_MouseUp(GtkWidget *widget, int Button, int Shift, int x, int y)
{
	/*	*/
	if (OnlyOne_mode != 0 || Center_set_mode != 0 || Chain2_OnlyOne_mode != 0) return;

	/* ܥ줿Ȥ */
	if (Button == 1) {
		/* ϰϥ쥯 */
		if (mode == 310) {
			//g_print("Mouse.c : SagCad_MouseUp() : mode = 310 : in\n");
			if (RectStart == 1) {
				//g_print("Mouse.c : SagCad_MouseUp() : RectStart = 1 : in\n");
				/* ޥ򥭥ץ㡼ʤȲ̤鳰줿Ȥˤʤ롣*/
				RectStart = 0;
				MoveX = x;
				MoveY = y;
				EndX = x;
				EndY = y;

				PenSet_with_back(gc, 2, sagcad_color.Back, sagcad_color.Back);
				gdk_draw_line(widget->window, gc, StartX, StartY, MoveX, StartY);
				gdk_draw_line(widget->window, gc, MoveX, StartY, MoveX, MoveY);
				gdk_draw_line(widget->window, gc, MoveX, MoveY, StartX, MoveY);
				gdk_draw_line(widget->window, gc, StartX, MoveY, StartX, StartY);
				
				SqSelect(widget, ToViewX(StartX), ToViewY(StartY), ToViewX(EndX), ToViewY(EndY));
				(*ReturnFunc)(widget, Button, x, y);
			}
			return;
		}



		/* -------------------------------------------------
		 *	 ޥȤˡκɸ DC Υʤ顢
		 * ο޷򥻥쥯Ȥ롣
		 *	 ޥȤˡκɸȤ餷ȡ
		 * ο޷ϥ쥯Ȥʤǥ󥻥뤹롣
		 * 
		 * Ȥκɸϡ(mouse_select_frag.x , mouse_select_frag.y)
		 */
		else if (mode != 0 /*&& (mode < 500 || mode > 530)*/) {
			/* Ȥκɸ(mouse_select_frag.x , mouse_select_frag.y)ΥȤ */
			if ((mouse_select_frag.x > sg(ToViewX(x), 3) - DC && mouse_select_frag.x < sg(ToViewX(x), 3) + DC) 
				&& (mouse_select_frag.y > sg(ToViewY(y), 3) - DC && mouse_select_frag.y < sg(ToViewY(y), 3) + DC))
			{
				/* [Ȥ Sleep ᤯ [ΥȤ] ΤΥե饰 */
				Already = 1;
				select_list_add_last(&mouse_select_frag);
				SelectDraw(widget, select_list_info.tail->select, SCD_SELECT, UPDATE_ON);
				(*ReturnFunc)(widget, Button, x, y);
			}

			/* 餵줿󥻥 */
			else {
				(*ReturnFunc)(widget, Button, x, y);
				SelectDraw(widget, &mouse_select_frag, SCD_ORG, UPDATE_ON);
			}
			mouse_select_frag.index = 0;
			mouse_select_frag.x = 0;
			mouse_select_frag.y = 0;
			mouse_select_frag.diagram_point.Nuru_point = NULL;
		}
	}
	return;
}





/* -------------------------------------------------------------------
 * ޥưȤ
 *	
 */
void SagCad_MouseMove(GtkWidget *widget, int Button, int Shift, int x, int y)
{
	char str[256];


	char value[256];
	int len, n, i, k;

	/* Mouse X */
	FloatOut_n(value, abs(ToViewX(x)), 0, 0);
	len = strlen(value);
	if (len == 1) k = 5;
	else if (len == 2) k = 4;
	else if (len == 3) k = 3;
	else if (len == 4) k = 2;
	else if (len == 5) k = 1;
	else if (len > 5) k = 0;
	else k = 3;
	FloatOut_n(value, ToViewX(x), k, 0);
	len = strlen(value);
	n = 10-len;
	strcpy (str, "X");
	if (n > 0) {
		for (i = 0 ; i < n ; i++) {
			strcat (str, " ");
		}
	}
	strcat (str, value);
	StatusMsg_MouseX(str);

	/* Mousu Y */
	FloatOut_n(value, abs(ToViewY(y)), 0, 0);
	len = strlen(value);
	if (len == 1) k = 5;
	else if (len == 2) k = 4;
	else if (len == 3) k = 3;
	else if (len == 4) k = 2;
	else if (len == 5) k = 1;
	else if (len > 5) k = 0;
	else k = 3;
	FloatOut_n(value, ToViewY(y), k, 0);
	len = strlen(value);
	n = 10-len;
	strcpy (str, "Y");
	if (n > 0) {
		for (i = 0 ; i < n ; i++) {
			strcat (str, " ");
		}
	}
	strcat (str, value);
	StatusMsg_MouseY(str);


	if (OnlyOne_mode != 0 || Center_set_mode != 0 || Chain2_OnlyOne_mode != 0) return;


	if (Button == 1) {
		/* ⡼ */
		switch (mode) {
			case 0:
				return;
				break;

			/* ϰϥ쥯 */
			case 310:
				//g_print("Mouse.c : SagCad_MouseMove() : mode = 310 : in\n");
				if(RectStart == 1) {
					//g_print("Mouse.c : SagCad_MouseMove() : õ : StartX[%d]  StartY[%d] MoveX[%d]  MoveY[%d]\n", 
					//					StartX, StartY, MoveX, MoveY);
					/* ä */
					PenSet_with_back(gc, 2, sagcad_color.Back, sagcad_color.Back);
					gdk_draw_line(widget->window, gc, StartX, StartY, MoveX, StartY);
					gdk_draw_line(widget->window, gc, MoveX, StartY, MoveX, MoveY);
					gdk_draw_line(widget->window, gc, MoveX, MoveY, StartX, MoveY);
					gdk_draw_line(widget->window, gc, StartX, MoveY, StartX, StartY);
					
					MoveX = x;
					MoveY = y;
					//g_print("Mouse.c : SagCad_MouseMove() :  : StartX[%d]  StartY[%d] MoveX[%d]  MoveY[%d]\n", 
					//					StartX, StartY, MoveX, MoveY);
					
					/*  */
					PenSet_with_back(gc, 2, sagcad_color.Dimension, sagcad_color.Back);
					gdk_draw_line(widget->window, gc, StartX, StartY, MoveX, StartY);
					gdk_draw_line(widget->window, gc, MoveX, StartY, MoveX, MoveY);
					gdk_draw_line(widget->window, gc, MoveX, MoveY, StartX, MoveY);
					gdk_draw_line(widget->window, gc, StartX, MoveY, StartX, StartY);
				}
				break;
		}
	}



	/* ⡼ */
	switch (mode) {
		/* ʿˡ */
		case 510:
			if(select_list_num() == 2) {
				Dim_now.Type = 10;
				/* ܰʹߤλ 
				 * ǽˤ褿ȤϡޤˡƤʤΤǡ
				 * äϡƤϤʤ
				 * 
				 * ǽˤ褿ȤDim_old.Text ϡNULL 
				 * 
				 */
				if(Dim_old.Text[0] != '\0')
					DimensionDraw(widget, &Dim_old, SCD_HIDE);

				if ((sagcad_system.GridMode & 2) == 2) {
					PicPoint.X[3] = sagcad_system.Grid * (int)(ToViewX(x) / sagcad_system.Grid);
					PicPoint.Y[3] = sagcad_system.Grid * (int)(ToViewY(y) / sagcad_system.Grid);
				}
				else {
					PicPoint.X[3] = ToViewX(x);
					PicPoint.Y[3] = ToViewY(y);
				}
				Dimension_X_Culc(&Dim_now, PicPoint);
				DimensionDraw(widget, &Dim_now, SCD_ORG);
				Dim_old = Dim_now;
				UpDate();
			}
			break;
		/* ľˡ */
		case 520:
			if(select_list_num() == 2) {
				Dim_now.Type = 20;
				if(Dim_old.Text[0] != '\0')		/* ܰʹߤλ */
					DimensionDraw(widget, &Dim_old, SCD_HIDE);

				if ((sagcad_system.GridMode & 2) == 2) {
					PicPoint.X[3] = sagcad_system.Grid * (int)(ToViewX(x) / sagcad_system.Grid);
					PicPoint.Y[3] = sagcad_system.Grid * (int)(ToViewY(y) / sagcad_system.Grid);
				}
				else {
					PicPoint.X[3] = ToViewX(x);
					PicPoint.Y[3] = ToViewY(y);
				}
				Dimension_Y_Culc(&Dim_now, PicPoint);
				DimensionDraw(widget, &Dim_now, SCD_ORG);
				Dim_old = Dim_now;
				UpDate();
			}
			break;

		/* Υˡ */
		case 530:
			if(select_list_num() == 2) {
				Dim_now.Type = 30;
				if(Dim_old.Text[0] != '\0')		/* ܰʹߤλ */
					DimensionDraw(widget, &Dim_old, SCD_HIDE);

				if ((sagcad_system.GridMode & 2) == 2) {
					PicPoint.X[3] = sagcad_system.Grid * (int)(ToViewX(x) / sagcad_system.Grid);
					PicPoint.Y[3] = sagcad_system.Grid * (int)(ToViewY(y) / sagcad_system.Grid);
				}
				else {
					PicPoint.X[3] = ToViewX(x);
					PicPoint.Y[3] = ToViewY(y);
				}
				Dimension_P_Culc(&Dim_now, PicPoint);
				DimensionDraw(widget, &Dim_now, SCD_ORG);
				Dim_old = Dim_now;
				UpDate();
			}
			break;

		/* Ⱦˡ */
		case 540:
			if(select_list_num() == 1) {
				Dim_now.Type = 40;
				if(Dim_old.Text[0] != '\0')		/* ܰʹߤλ */
					DimensionDraw(drawing_area, &Dim_old, SCD_HIDE);

				if ((sagcad_system.GridMode & 2) == 2) {
					PicPoint.X[2] = sagcad_system.Grid * (int)(ToViewX(x) / sagcad_system.Grid);
					PicPoint.Y[2] = sagcad_system.Grid * (int)(ToViewY(y) / sagcad_system.Grid);
				}
				else {
					PicPoint.X[2] = ToViewX(x);
					PicPoint.Y[2] = ToViewY(y);
				}
				Dimension_R_Culc(&Dim_now, PicPoint);
				DimensionDraw(widget, &Dim_now, SCD_ORG);
				Dim_old = Dim_now;
				UpDate();
			}
			break;

		/* ľˡ */
		case 550:
			if(select_list_num() == 1) {
				Dim_now.Type = 50;
				if(Dim_old.Text[0] != '\0')		/* ܰʹߤλ */
					DimensionDraw(drawing_area, &Dim_old, SCD_HIDE);

				if ((sagcad_system.GridMode & 2) == 2) {
					PicPoint.X[2] = sagcad_system.Grid * (int)(ToViewX(x) / sagcad_system.Grid);
					PicPoint.Y[2] = sagcad_system.Grid * (int)(ToViewY(y) / sagcad_system.Grid);
				}
				else {
					PicPoint.X[2] = ToViewX(x);
					PicPoint.Y[2] = ToViewY(y);
				}
				Dimension_D_Culc(&Dim_now, PicPoint);
				DimensionDraw(drawing_area, &Dim_now, SCD_ORG);
				Dim_old = Dim_now;
				UpDate();
			}
			break;

		/* ˡ */
		case 560:
			if(select_list_num() == 3) {
				Dim_now.Type = 60;
				if(Dim_old.Text[0] != '\0')		/* ܰʹߤλ */
					DimensionDraw(drawing_area, &Dim_old, SCD_HIDE);

				if ((sagcad_system.GridMode & 2) == 2) {
					PicPoint.X[4] = sagcad_system.Grid * (int)(ToViewX(x) / sagcad_system.Grid);
					PicPoint.Y[4] = sagcad_system.Grid * (int)(ToViewY(y) / sagcad_system.Grid);
				}
				else {
					PicPoint.X[4] = ToViewX(x);
					PicPoint.Y[4] = ToViewY(y);
				}
				Dimension_A_Culc(&Dim_now, PicPoint);
				DimensionDraw(drawing_area, &Dim_now, SCD_ORG);
				Dim_old = Dim_now;
				UpDate();
			}
			break;

		/* ɸˡ */
		case 570:
			if(select_list_num() == 1) {
				Dim_now.Type = 70;
				if(Dim_old.Text[0] != '\0')		/* ܰʹߤλ */
					DimensionDraw(drawing_area, &Dim_old, SCD_HIDE);

				if ((sagcad_system.GridMode & 2) == 2) {
					PicPoint.X[2] = sagcad_system.Grid * (int)(ToViewX(x) / sagcad_system.Grid);
					PicPoint.Y[2] = sagcad_system.Grid * (int)(ToViewY(y) / sagcad_system.Grid);
				}
				else {
					PicPoint.X[2] = ToViewX(x);
					PicPoint.Y[2] = ToViewY(y);
				}
				Dimension_PT_Culc(&Dim_now, PicPoint);
				DimensionDraw(drawing_area, &Dim_now, SCD_ORG);
				Dim_old = Dim_now;
				UpDate();
			}
			break;

		/* ˡ */
		case 580:
			if(select_list_num() >= 1) {
				Dim_now.Type = 80;
				if(Dim_old.Text[0] != '\0')		/* ܰʹߤλ */
					DimensionDraw(drawing_area, &Dim_old, SCD_HIDE);
				if(select_list_num() == 1) {
					if ((sagcad_system.GridMode & 2) == 2) {
						PicPoint.X[2] = sagcad_system.Grid * (int)(ToViewX(x) / sagcad_system.Grid);
						PicPoint.Y[2] = sagcad_system.Grid * (int)(ToViewY(y) / sagcad_system.Grid);
					}
					else {
						PicPoint.X[2] = ToViewX(x);
						PicPoint.Y[2] = ToViewY(y);
					}
				}
				if(select_list_num() == 2) {
					if ((sagcad_system.GridMode & 2) == 2) {
						PicPoint.X[3] = sagcad_system.Grid * (int)(ToViewX(x) / sagcad_system.Grid);
						PicPoint.Y[3] = sagcad_system.Grid * (int)(ToViewY(y) / sagcad_system.Grid);
					}
					else {
						PicPoint.X[3] = ToViewX(x);
						PicPoint.Y[3] = ToViewY(y);
					}
				}
				Dimension_HD_Culc(&Dim_now, PicPoint);
				DimensionDraw(drawing_area, &Dim_now, SCD_ORG);
				Dim_old = Dim_now;
				UpDate();
			}
			break;

		/* ˡ */
		case 590:
			Dim_now.Type = 90;
			if(Dim_old.Text[0] != '\0')		/* ܰʹߤλ */
				DimensionDraw(drawing_area, &Dim_old, SCD_HIDE);

			if ((sagcad_system.GridMode & 2) == 2) {
				Dim_now.SearchPointX = sagcad_system.Grid * (int)(ToViewX(x) / sagcad_system.Grid);
				Dim_now.SearchPointY = sagcad_system.Grid * (int)(ToViewY(y) / sagcad_system.Grid);
			}
			else {
				Dim_now.SearchPointX = ToViewX(x);
				Dim_now.SearchPointY = ToViewY(y);
			}

			/*  */
			Dim_now.diagram_of_char_index = 0;
			if (Dim_now.diagram_of_char != NULL) {
				xfree(Dim_now.diagram_of_char);
			}
			Dim_now.diagram_of_char = NULL;


			DimensionDraw(drawing_area, &Dim_now, SCD_ORG);
			Dim_old = Dim_now;
			UpDate();
			break;
#ifdef AFTER
#endif
	}
}





/* ---------------------------------------------------------
 * ⡼̵ΤȤ (Main)
 */
int MouseMode_Non(GtkWidget *widget, int Button, int x, int y)
{
	switch (Button) {
		/* ܥ */
		case 1:
			(*ReturnFunc)(widget, Button, x, y);
			break;
		/* ܥ */
		case 2:
			(*ReturnFunc)(widget, Button, x, y);
			break;
		/* ܥ */
		case 4:
			(*ReturnFunc)(widget, Button, x, y);
			break;
	}
	return 0;
}


/* ---------------------------------------------------------
 * ⡼̵ΤȤ (Return)
 */
int MouseRet_Non(GtkWidget *widget, int Button, int x, int y)
{
	char mstr[256];

	sprintf(mstr, _("Select a command.") );	
	StatusMsg(mstr);
	return 1;
}





/* -------------------------------------------------------------------
 * 濴 (Main)
 */
int MouseMode_Center(GtkWidget *widget, int Button, double x, double y)
{
	int dumy;


	switch (Button) {
		case 1:
			g_print("Left Button\n");
			dumy = MouseRet_CenterL(x, y);
			if (dumy == 1) {
				/*  */
				Redraw();
				/* 濴ե饰 OFF */
				Center_set_mode = 0;
				/* ޥɥ饤˸Υåɽ */
				(*ReturnFunc)(widget, 1, 0, 0);
			}
			return 1;
			break;
		case 2:
			g_print("Right Button\n");
			dumy = MouseRet_CenterR(x, y);
			/*  */
			Redraw();
			/* 濴ե饰 OFF */
			Center_set_mode = 0;
			/* ޥɥ饤˸Υåɽ */
			(*ReturnFunc)(widget, 1, 0, 0);
			return 1;
			break;
		case 4:
			g_print("Mid Button\n");
			/* 濴ե饰 OFF */
			Center_set_mode = 0;
			/* ޥɥ饤˸Υåɽ */
			(*ReturnFunc)(widget, 1, 0, 0);
			return 1;
			break;
	}
	return 0;
}


/* -------------------------------------------------------------------
 * 濴  ޷ɤ߼ (Sub L)
 */
int MouseRet_CenterL(double x, double y)
{
	CAD *cad;
	if( (DcObj & 1) == 1 ) {
		cad = TenLook(x, y);
		if (cad != NULL) {
			MagX = (float)cad->sx;
			MagY = (float)cad->sy;
			return 1;
		}
	}
	return 0;
}


/* -------------------------------------------------------------------
 * 濴   Ǥ (Sub R)
 */
int MouseRet_CenterR(double x,double y)
{
	MagX = (float) x;
	MagY = (float) y;
	return 1;
}





/* -------------------------------------------------------
 * 쥯Ȥ줿ǸΥǡΥ쥯Ȳ
 */
int select_last_cansel(void)
{
	if (select_list_info.head != NULL && select_list_info.tail != NULL) {
		/* ο᤹ */
		SelectDraw(drawing_area, select_list_info.tail->select, SCD_ORG, UPDATE_ON);
		/* Select Data ꥹȤ */
		select_list_free(select_list_info.tail);
		return 1;
	}
	return 0;
}





/* -------------------------------------------------------
 * ʥå
 * 
 *	  ޷	 1 : 
 *				 2 : 
 *				 4 : ߸
 *				 8 : 
 *				15 : ޷
 *	
 *	  ˡ޷	16 : 
 *				32 : Ⱦ
 *				64 : 濴
 *			   128 : Ǥ
 *			   256 : ˡ޷
 *			   512 : ݥ饤
 *			  1024 : ֥å
 * 
 * 
 * draw			: 1+2+4+8=15
 * select		: 1+2+4+8+256+512=783
 * dimension	: 1+16+32+64=113
 * 
 * 
 * 
 */
int snap_set(int snap, int mask)
{
	SNAP_DLG snap_dlg;


	/* SnapDialog */
	if (mode == 300) {
		snap_dlg.value = 16;
	}
	else {
		snap_dlg.value = 0;
	}
	snap_dlg.mask = mask;		// ǤΤƤ (3 ʤǤʤ)
	snap_dlg.snap = snap;

	snap_dlg.point_check_button = NULL;
	snap_dlg.line_check_button = NULL;
	snap_dlg.arc_check_button = NULL;
	snap_dlg.circle_check_button = NULL;

	snap_dlg.polyline_check_button = NULL;
	snap_dlg.dimension_check_button = NULL;
	snap_dlg.block_check_button = NULL;
	snap_dlg.ellipse_check_button = NULL;

	snap_dlg.start_end_check_button = NULL;
	snap_dlg.half_4_point_check_button = NULL;
	snap_dlg.center_check_button = NULL;
	snap_dlg.any_check_button = NULL;

	snap_dlg.chain_check_button = NULL;
	snap_dlg.chain2_check_button = NULL;
	snap_dlg.color_check_button = NULL;

	snap_dlg.parent = MainWindow;
	snap_dlg.dialog = NULL;

	SnapDialog(&snap_dlg);

//	g_print("----- [ SnapDialog ] -----\n");
//	g_print("mode = %d\n", snap_dlg.mask);
//	g_print("snap = %d\n", snap_dlg.snap);
//	g_print("--------------------------\n\n");

	if (snap_dlg.value == 0) {
		return 0;
	}
	
	DcObj = snap_dlg.snap;

	if (snap_dlg.value == 2) {
		cmd_select_chain();
	}
	else if (snap_dlg.value == 4) {
		cmd_select_chain2();
	}
	else if (snap_dlg.value == 8) {
		cmd_select_color();
	}

	return 1;
}





/* -------------------------------------------------------------------
 * ⡼ (Main)
 * 
 */
int MouseMode_Select(GtkWidget *widget, int Button, int x, int y)
{
	switch (Button) {
		/* ܥ */
		case 1:
			
			if (SelectChainFrag == 0 && SelectColorFrag == 0) {
				MouseSelect(widget, ToViewX(x), ToViewY(y), DcObj, 0);
			}
			else if (SelectChainFrag != 0) {
				MouseSelect(widget, ToViewX(x), ToViewY(y), 6, 0);
			}
			else if (SelectColorFrag != 0) {
				MouseSelect(widget, ToViewX(x), ToViewY(y), 15, 0);
			}
			break;
		/* ܥ */
		case 2:
			if (SelectChainFrag == 0 || SelectColorFrag == 0) {
				select_last_cansel();
				(*ReturnFunc)(widget, Button, x, y);
			}
			break;
		/* ܥ */
		case 4:
			snap_set(DcObj, 783);
			break;
	}
	return 0;
}



/* -------------------------------------------------------
 * ⡼ (Return)
 */
int MouseRet_Select(GtkWidget *widget, int Button, int x, int y)
{
	char str[256], mstr[256];


	if(select_list_info.head != NULL) {
		DataInfo(select_list_info.tail->select, str);
		sprintf(mstr, _(" [Select] Select a diagram. (Select %d)  %s") , (int) select_list_num(), str);
	}
	else {
		sprintf(mstr, _(" [Select] Select a diagram. (Select 0) ") );
	}
	StatusMsg(mstr);


	switch (Button) {
		/* ܥ */
		case 1:
			if(select_list_info.head != NULL) {
				/* ޥɵư˲쥯ȤƤ */
				/* ޥɵư + 1 ˲쥯ȤƤ */
				/* ϡ޷ǡǤ */
				if (OP_SelectList != NULL && OP_SelectList->next != NULL && select_list_info.tail->select->index != 3) {
					if (SelectChainFrag == 1) SelectChain(select_list_info.tail->select->diagram_point.cad_point);
					if (SelectColorFrag == 1) SelectMaskColor(select_list_info.tail->select->diagram_point.cad_point);
					if (SelectChainFrag == 2) {
						KeepReturnFunc = ReturnFunc;
						ReturnFunc = MouseRet_ChainOne;
						Chain2index = 0;
						SelectChain2(select_list_info.tail->select->diagram_point.cad_point, 0);
					}
					SelectChainFrag = 0;
					SelectColorFrag = 0;
					OP_SelectList = NULL;
				}

				/* ޥɵư˲쥯ȤƤʤä */
				/* Ĳ쥯ȤƤ */
				/* ϡ޷ǡǤ */
				else if (OP_SelectList == NULL && select_list_info.head != NULL && select_list_info.head->select->index != 3) {
					if (SelectChainFrag == 1) SelectChain(select_list_info.head->select->diagram_point.cad_point);
					if (SelectColorFrag == 1) SelectMaskColor(select_list_info.head->select->diagram_point.cad_point);
					if (SelectChainFrag == 2) {
						KeepReturnFunc = ReturnFunc;
						ReturnFunc = MouseRet_ChainOne;
						Chain2index = 0;
						SelectChain2(select_list_info.tail->select->diagram_point.cad_point, 0);
					}
					SelectChainFrag = 0;
					SelectColorFrag = 0;
					OP_SelectList = NULL;
				}
			}
			break;
		/* ܥ */
		case 2:
			break;
		/* ܥ */
		case 4:
			break;
	}
	return 0;
}





/* -------------------------------------------------------
 * ϰ⡼ (Main)
 */
int MouseMode_Rect(GtkWidget *widget, int Button, int x, int y)
{
	switch (Button) {
		/* ܥ */
		case 1:
			//g_print("Mouse.c : MouseMode_Rect() : Button = 1 : in\n");
//			SetCapture(widget);
			RectStart = 1;
			MoveX = x;
			MoveY = y;
			StartX = x;
			StartY = y;
			break;
		/* ܥ */
		case 2:
			select_last_cansel();
			(*ReturnFunc)(widget, Button, x, y);
			break;
		/* ܥ */
		case 4:
			snap_set(DcObj, 783);
			break;
	}
	return 0;
}


/* -------------------------------------------------------
 * ϰ⡼ (Return)
 */
int MouseRet_Rect(GtkWidget *widget, int Button, int x, int y)
{
	char str[256], mstr[256];


	if(select_list_info.head != NULL) {
		DataInfo(select_list_info.tail->select, str);
		sprintf(mstr, _(" [Rect Select] Select a diagram. (Select %d)  %s") , (int) select_list_num(), str);
	}
	else {
		sprintf(mstr, _(" [Rect Select] Select a diagram. (Select 0) ") );
	}
	StatusMsg(mstr);


	switch (Button) {
		/* ܥ */
		case 1:
			break;
		/* ܥ */
		case 2:
			break;
		/* ܥ */
		case 4:
			break;
	}
	return 0;
}





/* -------------------------------------------------------------------
 * 1⡼ (OnlyOne)
 */
int MouseMode_OnlyOne(GtkWidget *widget, int X, int Y, int Button)
{
	/*  (OK) */
	if (Button == 1) {
		OnlyOne (1);
		UpDate();
		return 1;
	}
	/* 㤦 (NO) */
	if (Button == 2) {
		OnlyOne (2);
		UpDate();
		return 1;
	}
	/* ᤿ (Cancel) */
	if (Button == 4) {
		OnlyOne (0);
		UpDate();
		return 1;
	}
	return 0;
}


/* ---------------------------------------------------------
 * 1⡼ (OnlyOne) (Return)
 */
int MouseRet_OnlyOne(GtkWidget *widget, int Button, int x, int y)
{
	char mstr[256];

	sprintf(mstr, _(" Is it this diagram? [Yes:(Left/RET)] [No:(Right/SPC)] [Cancel:(Center/ESC)]") );
	StatusMsg(mstr);
	return 1;
}


/* -------------------------------------------------------------------
 * ޷⡼ (mode = 210)
 * ȥ꡼Ƥ޷椫Ūο޷֡
 * -------------------------------------------------------------------
 * ؿ : OnlyOne
 *  : int Frag
 *		  Frag = 0 : CANCEL
 *		  Frag = 1 : YES
 *		  Frag = 2 : NO	 
 *		  Frag = 3 : START	   Frag = 2 ƱΥǥåäʤʽѡ
 *  : void
 *  : OnlyOneIndex : ǥå
 *		: OnlyOneEntry : ǡ
 *		: OnlyOneCAD[] : 
 *	
 *  : OnlyOne(3) ȤäƺǽθɽȤ,˥ʤɤ
 *		: õä "expouse_event" ȯΤ
 *		: ΤȤޤʤƤϤʤʤ
 *	
 *	
 *	
 * struct OnlyOneDat{
 *	   int Index;
 *	   int Entry;
 *	   struct CAD cad[13];
 *	   int RetMode;
 *	   int (*ReturnFunc)();
 * };
 * struct OnlyOneDat OnlyOne;
 *	
 *	
 */
void OnlyOne(int Frag)
{
	int J;
//	char DumyStr[255];


	/* TEST */
	if (Frag == 2) {
		if (OnlyOneIndex == OnlyOneEntry)	OnlyOneIndex = 1;
		else	OnlyOneIndex = OnlyOneIndex + 1;
	}
	/* TEST */

//	if (Frag == 3) {
//		sprintf(DumyStr,	"ο޷Ǥ[Yes/ܥ/Return] [No/ܥ/Space] [Cancel/ܥ/ESC]");
//		StatusMsg(DumyStr);
//		MouseRet_OnlyOne(drawing_area, 1, 0, 0);
//	}


	if (OnlyOneIndex == 1)	J = OnlyOneEntry;
	else	J = OnlyOneIndex - 1;

	/*  */
	if (Frag == 1) {
		OnlyOneCAD[OnlyOneIndex].layer = NowLayer;
		OnlyOneCAD[OnlyOneIndex].color = NowColor;
		OnlyOneCAD[OnlyOneIndex].style = NowStyle;
	}
	else if (Frag == 2 || Frag == 3) {
		OnlyOneCAD[OnlyOneIndex].color = sagcad_color.Select;
		OnlyOneCAD[OnlyOneIndex].style = 2;
	}
	else if (Frag == 0) {
		OnlyOneCAD[OnlyOneIndex].color = sagcad_color.Back;
		OnlyOneCAD[OnlyOneIndex].style = 2;
	}

	/* ΤȤ */
	if (OnlyOneCAD[OnlyOneIndex].code == 0) {
		/*  */
		if (Frag == 2) {
			PointDraw(drawing_area, OnlyOneCAD[J].sx, OnlyOneCAD[J].sy,
					  OnlyOneCAD[J].style, sagcad_color.Back);
		}
		PointDraw(drawing_area, OnlyOneCAD[OnlyOneIndex].sx, OnlyOneCAD[OnlyOneIndex].sy,
				  OnlyOneCAD[OnlyOneIndex].style, OnlyOneCAD[OnlyOneIndex].color);
	}

	/* ľΤȤ */
	else if (OnlyOneCAD[OnlyOneIndex].code == 1) {
		/* ľ */
		if (Frag == 2) {
			LineDraw(drawing_area, OnlyOneCAD[J].sx, OnlyOneCAD[J].sy,
					 OnlyOneCAD[J].ex, OnlyOneCAD[J].ey,
					 OnlyOneCAD[J].style, sagcad_color.Back);
		}
		LineDraw(drawing_area, OnlyOneCAD[OnlyOneIndex].sx, OnlyOneCAD[OnlyOneIndex].sy,
				 OnlyOneCAD[OnlyOneIndex].ex, OnlyOneCAD[OnlyOneIndex].ey,
				 OnlyOneCAD[OnlyOneIndex].style, OnlyOneCAD[OnlyOneIndex].color);
	}
	/* ߸̤ΤȤ */
	else if (OnlyOneCAD[OnlyOneIndex].code == 2) {
		/* ߸̤ */
		if (Frag == 2) {
			ArcDraw(drawing_area, OnlyOneCAD[J].cx, OnlyOneCAD[J].cy, OnlyOneCAD[J].r, 
					OnlyOneCAD[J].sx, OnlyOneCAD[J].sy, OnlyOneCAD[J].ex, OnlyOneCAD[J].ey,
					OnlyOneCAD[J].style, sagcad_color.Back);
		}
		ArcDraw(drawing_area, 
				OnlyOneCAD[OnlyOneIndex].cx, OnlyOneCAD[OnlyOneIndex].cy, OnlyOneCAD[OnlyOneIndex].r, 
				OnlyOneCAD[OnlyOneIndex].sx, OnlyOneCAD[OnlyOneIndex].sy, 
				OnlyOneCAD[OnlyOneIndex].ex, OnlyOneCAD[OnlyOneIndex].ey,
				OnlyOneCAD[OnlyOneIndex].style, OnlyOneCAD[OnlyOneIndex].color);
	}
	/* ߤΤȤ */
	else if (OnlyOneCAD[OnlyOneIndex].code == 4) {
		 /* ߤ */
		if (Frag == 2) {
			CircleDraw(drawing_area, OnlyOneCAD[J].cx, OnlyOneCAD[J].cy, OnlyOneCAD[J].r, 
					   OnlyOneCAD[OnlyOneIndex].style, sagcad_color.Back);
		}
		CircleDraw(drawing_area, 
				   OnlyOneCAD[OnlyOneIndex].cx, OnlyOneCAD[OnlyOneIndex].cy, OnlyOneCAD[OnlyOneIndex].r, 
				   OnlyOneCAD[OnlyOneIndex].style, OnlyOneCAD[OnlyOneIndex].color);
	}


	/*  (OK) */
	if (Frag == 1) {
		undo_index_plus();
		cad_list_add_first_with_undo(&OnlyOneCAD[OnlyOneIndex], &cad_list_info);
//		SelectCadDraw(drawing_area, select_search_num(1)->select->diagram_point.cad_point, SCD_ORG);
//		SelectCadDraw(drawing_area, select_search_num(2)->select->diagram_point.cad_point, SCD_ORG);
		select_list_all_free();
		OnlyOne_mode = 0;
		ReturnFunc = OnlyOneKeepReturnFunc;
		(*ReturnFunc)(drawing_area, 1, 0, 0);
		ModifiedFlag = 1;
		return;
	}

	/* 㤦 (NO) */
	else if (Frag == 2 || Frag == 3) {
		MouseRet_OnlyOne(drawing_area, 1, 0, 0);
		return;
	}

	/* ᤿ (Cancel) */
	else if (Frag == 0) {
//		SelectCadDraw(drawing_area, select_search_num(1)->select->diagram_point.cad_point, SCD_ORG);
//		SelectCadDraw(drawing_area, select_search_num(2)->select->diagram_point.cad_point, SCD_ORG);
		select_list_all_free();
		OnlyOne_mode = 0;
		ReturnFunc = OnlyOneKeepReturnFunc;
		(*ReturnFunc)(drawing_area, 1, 0, 0);
		return;
	}
}





/* -------------------------------------------------------------------
 * ⡼ (Main)
 */
int MouseMode_ChainOne(GtkWidget *widget, int X, int Y, int Button)
{
	/*  (OK) */
	if (Button == 1) {
		SelectChain2_OnlyOne (1);
		return 1;
	}
	/* 㤦 (NO) */
	if (Button == 2) {
		SelectChain2_OnlyOne (2);
		return 1;
	}
	/* ᤿ (Cancel) */
	if (Button == 4) {
		SelectChain2_OnlyOne (0);
		return 1;
	}
	return 0;
}



/* ---------------------------------------------------------
 * ⡼ (Return)
 */
int MouseRet_ChainOne(GtkWidget *widget, int Button, int x, int y)
{
	char mstr[256];

	sprintf(mstr, _(" Does it go to here? [Yes:(Left/RET)] [No:(Right/SPC)] [Cancel:(Center/ESC)]") );	
	StatusMsg(mstr);
	return 0;
}





/* -------------------------------------------------------
 * ޥ⡼ 200 (Main)
 */
int MouseMode_Draw(GtkWidget *widget, int Button, int x, int y)
{
	switch (Button) {
		/* ܥ */
		case 1:
			MouseSelect(widget, ToViewX(x), ToViewY(y), DcObj, 1);
			break;
		/* ܥ */
		case 2:
			select_last_cansel();
			(*ReturnFunc)(widget, Button, x, y);
			break;
		/* ܥ */
		case 4:
			snap_set(DcObj, 15+2048);
			break;
	}
	return 0;
}


/* -------------------------------------------------------
 * ޥ⡼ 200 (Return)
 */
int MouseRet_Draw(GtkWidget *widget, int Button, int x, int y)
{
	int Ret;
	char str[256], mstr[256];
	PLC_DLG plc_dlg;


	switch ( select_list_num() ) {
		/* 쥯ȥǡ */
		case 0:
			if (OnlyOne_mode == 210) {
				sprintf(mstr, _(" Is it this diagram? [Yes:(Left/RET)] [No:(Right/SPC)] [Center:(Mid/ESC)]") );
			}
			else {
				sprintf(mstr, _(" [Drawing] Select the 1st diagram. (Select 0) ") );
			}
			StatusMsg(mstr);
			break;
		case 1:
			DataInfo(select_list_info.tail->select, str);
			sprintf(mstr, _(" [Drawing] Select the 2nd diagram. (Select %d)  %s") , 
					(int) select_list_num(), str);
			StatusMsg(mstr);
			break;
		case 2:
			DataInfo(select_list_info.tail->select, str);
			sprintf(mstr, 
				_(" [Drawing] Select the diagram to create. (Select %d)  %s") , 
				(int) select_list_num(), 
				str);
			StatusMsg(mstr);


			plc_dlg.value = 0;
			plc_dlg.parent = MainWindow;
			plc_dlg.dialog = NULL;
			Ret = plcDialog(&plc_dlg);
			switch (plc_dlg.value) {
				/* 󥻥 */
				case 0:
					SelectDraw(widget, select_search_num(1)->select, SCD_ORG, UPDATE_OFF);
					SelectDraw(widget, select_search_num(2)->select, SCD_ORG, UPDATE_ON);
					/* ꥹȤ */
					select_list_all_free();
					//(*ReturnFunc)(widget, Button, x, y);
					return 1;
					break;
				/* ޥ */
				case 1:
					CreatePoint(widget);
					SelectDraw(widget, select_search_num(1)->select, SCD_ORG, UPDATE_OFF);
					SelectDraw(widget, select_search_num(2)->select, SCD_ORG, UPDATE_ON);
					/* ꥹȤ */
					select_list_all_free();
					//(*ReturnFunc)(widget, Button, x, y);
					return 1;
					break;
				/* ޥ */
				case 2:
					CreateLine(widget);
					SelectDraw(widget, select_search_num(1)->select, SCD_ORG, UPDATE_OFF);
					SelectDraw(widget, select_search_num(2)->select, SCD_ORG, UPDATE_ON);
					/* ꥹȤ */
					select_list_all_free();
					//(*ReturnFunc)(widget, Button, x, y);
					return 1;
					break;
				/* ߥޥ */
				case 3:
					CreateCircle(widget);
					SelectDraw(widget, select_search_num(1)->select, SCD_ORG, UPDATE_OFF);
					SelectDraw(widget, select_search_num(2)->select, SCD_ORG, UPDATE_ON);
					/* ꥹȤ */
					select_list_all_free();
					//(*ReturnFunc)(widget, Button, x, y);
					return 1;
					break;
			}
			break;
	}
	return 0;
}





/* -------------------------------------------------------------------
 * ξ ȥ⡼ (Main)
 */
int MouseMode_Trim(GtkWidget *widget, int Button, int x, int y)
{
	switch (Button) {
		/* ܥ */
		case 1:
			if (select_list_num() < 2) {
				MouseSelect(widget, ToViewX(x), ToViewY(y), DcObj, 0);
			}
			else if (select_list_num() == 2) {
				MouseSelect(widget, ToViewX(x), ToViewY(y), DcObj, 1);
			}
			break;
		/* ܥ */
		case 2:
			select_last_cansel();
			(*ReturnFunc)(widget, Button, x, y);
			break;
		/* ܥ */
		case 4:
			snap_set(DcObj, 15+2048);
			break;
	}
	return 0;
}



/* -------------------------------------------------------------------
 * ξ ȥ⡼ (Return)
 */
int MouseRet_Trim(GtkWidget *widget, int Button, int x, int y)
{
	char DumyStr[255], str[256], mstr[256];
	struct TrimDat Trim;
	int CE_frag = 0;


	if (mode == 220) sprintf(DumyStr, " ");
	else if (mode == 225) sprintf(DumyStr, _("two") );


	/* 쥯ȥǡ */
	switch ( select_list_num() ) {
		case 0:
			/* åɽ */
			sprintf(mstr, _(" [Trim %s] Trim element (S0) ") , DumyStr);
			StatusMsg(mstr);
			break;
		case 1:
			/* åɽ */
			DataInfo(select_list_info.tail->select, str);
			sprintf(mstr, _(" [Trim %s] Limit element (S%d)  %s") , 
				DumyStr, (int) select_list_num(), str);
			StatusMsg(mstr);
			break;
	}


	switch (Button) {
		/* ܥ */
		case 1:
			switch ( select_list_num() ) {
				/* 쥯ȥǡ */
				case 2:
					/* ܤʱߤʤ */
					if (select_search_num(1)->select->index == 16) {
						Trim.TraceData[1].code = 16;
						Trim.ellipse[1] = *(select_search_num(1)->select->diagram_point.ellipse_point);
						/* ʱ */
						if (sg(Trim.ellipse[1].sa, 3) == 0 && sg(Trim.ellipse[1].ea, 3) == 360) {
							CE_frag = 4;
						}
						/* ʱ߸ */
						else {
							CE_frag = 2;
						}
					}



					/* ߤʱߤʤʤ */
					if (select_search_num(1)->select->diagram_point.cad_point->code != 4 && CE_frag != 4) {
						if (mode == 220)		Trim.Index = 1;
						else if (mode == 225)	Trim.Index = 2;

						/* ܤΥǡ */
						if (select_search_num(1)->select->index == 16) {
							Trim.TraceData[1].code = 16;
							Trim.ellipse[1] = *(select_search_num(1)->select->diagram_point.ellipse_point);
							
							if (sg(Trim.ellipse[1].sa, 3) == 0 && sg(Trim.ellipse[1].ea, 3) == 360) {
								Trim.ellipse[1].code = 0;
							}
							else {
								Trim.ellipse[1].code = 1;
							}
						}
						else {
							Trim.TraceData[1] = *(select_search_num(1)->select->diagram_point.cad_point);
						}

						/* ܤΥǡ */
						if (select_search_num(2)->select->index == 16) {
							Trim.TraceData[2].code = 16;
							Trim.ellipse[2] = *(select_search_num(2)->select->diagram_point.ellipse_point);
							if (sg(Trim.ellipse[2].sa, 3) == 0 && sg(Trim.ellipse[2].ea, 3) == 360) {
								Trim.ellipse[2].code = 0;
							}
							else {
								Trim.ellipse[2].code = 1;
							}
						}
						else {
							Trim.TraceData[2] = *(select_search_num(2)->select->diagram_point.cad_point);
						}

						/* ԥåΥǡ */
						Trim.PicX[1] = select_search_num(1)->select->x;
						Trim.PicY[1] = select_search_num(1)->select->y;
						Trim.PicX[2] = select_search_num(2)->select->x;
						Trim.PicY[2] = select_search_num(2)->select->y;

						if(TrimMain(&Trim) == 1) {
							/* õ */
							SelectDraw(widget, select_search_num(1)->select, SCD_HIDE, UPDATE_OFF);
							SelectDraw(widget, select_search_num(2)->select, SCD_HIDE, UPDATE_ON);

							/* ȥǡѹ */
							/* CAD *p_cad Υǡθ */
							/* CAD Data ѹ롢 Undo Baffer ˽ */
							undo_index_plus();

							if (select_search_num(1)->select->index == 16) {
								ellipse_list_edit_with_undo(
									ellipse_search_ellipse(select_search_num(1)->select->diagram_point.ellipse_point, 
														   &ellipse_list_info), 
									&Trim.ellipse[1], 
									&ellipse_list_info);
							}
							else {
								cad_list_edit_with_undo(
									cad_search_cad(select_search_num(1)->select->diagram_point.cad_point, 
												   &cad_list_info), 
									&Trim.TraceData[1], 
									&cad_list_info);
							}

							if (mode == 225) {
								if (select_search_num(2)->select->index == 16) {
									ellipse_list_edit_with_undo(
										ellipse_search_ellipse(select_search_num(2)->select->diagram_point.ellipse_point, 
															   &ellipse_list_info), 
										&Trim.ellipse[2], 
										&ellipse_list_info);
								}
								else {
									cad_list_edit_with_undo(
										cad_search_cad(select_search_num(2)->select->diagram_point.cad_point, 
													   &cad_list_info), 
										&Trim.TraceData[2], 
										&cad_list_info);
								}
							}

							/* */
							SelectDraw(widget, select_search_num(1)->select, SCD_ORG, UPDATE_OFF);
							SelectDraw(widget, select_search_num(2)->select, SCD_ORG, UPDATE_ON);
							mouse_select_frag.index = 0;
							mouse_select_frag.x = 0;
							mouse_select_frag.y = 0;
							mouse_select_frag.diagram_point.cad_point = NULL;
						}
						/* ꥹȤ */
						select_list_all_free();
						/* åɽ */
						sprintf(mstr, _(" [Trim %s] Trim element (S0) ") , DumyStr);
						StatusMsg(mstr);
						break;
					}

					/* ߤʱߤʤ⤦Ķ޷ */
					/* åɽ */
					DataInfo(select_list_info.tail->select, str);
					sprintf(mstr, _(" [Trim %s] Limit element (S%d)  %s") , 
						DumyStr, (int) select_list_num(), str);
					StatusMsg(mstr);
					break;



				case 3:
					/* ܤʱߤʤ */
					if (select_search_num(1)->select->index == 16) {
						Trim.TraceData[1].code = 16;
						Trim.ellipse[1] = *(select_search_num(1)->select->diagram_point.ellipse_point);
						/* ʱ */
						if (sg(Trim.ellipse[1].sa, 3) == 0 && sg(Trim.ellipse[1].ea, 3) == 360) {
							CE_frag = 4;
						}
						/* ʱ߸ */
						else {
							CE_frag = 2;
						}
					}


					if (select_search_num(1)->select->diagram_point.cad_point->code == 4 || CE_frag == 4) {
						if (mode == 220) Trim.Index = 1;
						else if (mode == 225) Trim.Index = 2;

						/* ܤΥǡ */
						if (select_search_num(1)->select->index == 16) {
							Trim.TraceData[1].code = 16;
							Trim.ellipse[1] = *(select_search_num(1)->select->diagram_point.ellipse_point);
							if (sg(Trim.ellipse[1].sa, 3) == 0 && sg(Trim.ellipse[1].ea, 3) == 360) {
								Trim.ellipse[1].code = 0;
							}
							else {
								Trim.ellipse[1].code = 1;
							}
						}
						else {
							Trim.TraceData[1] = *(select_search_num(1)->select->diagram_point.cad_point);
						}

						/* ܤΥǡ */
						if (select_search_num(2)->select->index == 16) {
							Trim.TraceData[2].code = 16;
							Trim.ellipse[2] = *(select_search_num(2)->select->diagram_point.ellipse_point);
							if (sg(Trim.ellipse[2].sa, 3) == 0 && sg(Trim.ellipse[2].ea, 3) == 360) {
								Trim.ellipse[2].code = 0;
							}
							else {
								Trim.ellipse[2].code = 1;
							}
						}
						else {
							Trim.TraceData[2] = *(select_search_num(2)->select->diagram_point.cad_point);
						}

						/* ܤΥǡ */
						if (select_search_num(3)->select->index == 16) {
							Trim.TraceData[3].code = 16;
							Trim.ellipse[3] = *(select_search_num(3)->select->diagram_point.ellipse_point);
							if (sg(Trim.ellipse[3].sa, 3) == 0 && sg(Trim.ellipse[3].ea, 3) == 360) {
								Trim.ellipse[3].code = 0;
							}
							else {
								Trim.ellipse[3].code = 1;
							}
						}
						else {
							Trim.TraceData[3] = *(select_search_num(3)->select->diagram_point.cad_point);
						}

						/* ԥåΥǡ */
						Trim.PicX[1] = select_search_num(1)->select->x;
						Trim.PicY[1] = select_search_num(1)->select->y;
						Trim.PicX[2] = select_search_num(2)->select->x;
						Trim.PicY[2] = select_search_num(2)->select->y;
						Trim.PicX[3] = select_search_num(3)->select->x;
						Trim.PicY[3] = select_search_num(3)->select->y;

						if(TrimMain(&Trim) == 1) {
							/* õ */
							SelectDraw(widget, select_search_num(1)->select, SCD_HIDE, UPDATE_OFF);
							SelectDraw(widget, select_search_num(2)->select, SCD_HIDE, UPDATE_OFF);
							SelectDraw(widget, select_search_num(3)->select, SCD_HIDE, UPDATE_ON);
							
							/* ȥǡѹ */
							/* CAD *p_cad Υǡθ */
							/* CAD Data ѹ롢 Undo Baffer ˽ */
							undo_index_plus();

							if (select_search_num(1)->select->index == 16) {
								ellipse_list_edit_with_undo(
									ellipse_search_ellipse(select_search_num(1)->select->diagram_point.ellipse_point, 
														   &ellipse_list_info), 
									&Trim.ellipse[1], 
									&ellipse_list_info);
							}
							else {
								cad_list_edit_with_undo(
									cad_search_cad(select_search_num(1)->select->diagram_point.cad_point, 
												   &cad_list_info), 
									&Trim.TraceData[1], 
									&cad_list_info);
							}

							if (mode == 225) {
								if (select_search_num(2)->select->index == 16) {
									ellipse_list_edit_with_undo(
										ellipse_search_ellipse(select_search_num(2)->select->diagram_point.ellipse_point, 
															   &ellipse_list_info), 
										&Trim.ellipse[2], 
										&ellipse_list_info);
								}
								else {
									cad_list_edit_with_undo(
										cad_search_cad(select_search_num(2)->select->diagram_point.cad_point, 
													   &cad_list_info), 
										&Trim.TraceData[2], 
										&cad_list_info);
								}
							}

							if (mode == 225) {
								if (select_search_num(3)->select->index == 16) {
									ellipse_list_edit_with_undo(
										ellipse_search_ellipse(select_search_num(3)->select->diagram_point.ellipse_point, 
															   &ellipse_list_info), 
										&Trim.ellipse[3], 
										&ellipse_list_info);
								}
								else {
									cad_list_edit_with_undo(
										cad_search_cad(select_search_num(3)->select->diagram_point.cad_point, 
													   &cad_list_info), 
										&Trim.TraceData[3], 
										&cad_list_info);
								}
							}

							/*  */
							mouse_select_frag.index = 0;
							mouse_select_frag.x = 0;
							mouse_select_frag.y = 0;
							mouse_select_frag.diagram_point.cad_point = NULL;
							mouse_select_frag.diagram_point.dimension_point = NULL;

							SelectDraw(widget, select_search_num(1)->select, SCD_ORG, UPDATE_OFF);
							SelectDraw(widget, select_search_num(2)->select, SCD_ORG, UPDATE_ON);
							SelectDraw(widget, select_search_num(3)->select, SCD_ORG, UPDATE_ON);
						}
						/* ꥹȤ */
						select_list_all_free();
						/* åɽ */
						sprintf(mstr, _(" [Trim %s] Trim element (S0) ") , DumyStr);
						StatusMsg(mstr);
					}
					break;
			}
			break;
		/* ܥ */
		case 2:
			break;
		/* ܥ */
		case 4:
			break;
	}
	return 0;
}





/* -------------------------------------------------------
 * ʬ⡼ (Main)
 */
int MouseMode_Split(GtkWidget *widget, int Button, int x, int y)
{
	switch (Button) {
		/* ܥ */
		case 1:
			MouseSelect(widget, ToViewX(x), ToViewY(y), DcObj, 0);
			break;
		/* ܥ */
		case 2:
			select_last_cansel();
			(*ReturnFunc)(widget, Button, x, y);
			break;
		/* ܥ */
		case 4:
			snap_set(DcObj, 15+2048);
			break;
	}
	return 0;
}



/* -------------------------------------------------------
 * ʬ⡼ (Return)
 */
int MouseRet_Split(GtkWidget *widget, int Button, int x, int y)
{
	char str[256], mstr[256];
	struct TrimDat Trim;
	int CE_frag = 0;


	/* 쥯ȥǡ */
	switch ( select_list_num() ) {
		case 0:
			/* åɽ */
			sprintf(mstr, _(" [Divide] element") );
			StatusMsg(mstr);
			break;
		case 1:
			/* åɽ */
			DataInfo(select_list_info.tail->select, str);
			sprintf(mstr, _(" [Divide] Dividing point (S%d)  %s") , 
				(int)select_list_num(), str);
			StatusMsg(mstr);
			break;
	}


	switch (Button) {
		/* ܥ */
		case 1:
			switch ( select_list_num() ) {
				/* 쥯ȥǡ */
				case 2:
					/* ܤʱߤʤ */
					if (select_search_num(1)->select->index == 16) {
						Trim.TraceData[1].code = 16;
						Trim.ellipse[1] = *(select_search_num(1)->select->diagram_point.ellipse_point);
						/* ʱ */
						if (sg(Trim.ellipse[1].sa, 3) == 0 && sg(Trim.ellipse[1].ea, 3) == 360) {
							CE_frag = 4;
						}
						/* ʱ߸ */
						else {
							CE_frag = 2;
						}
					}

					/* ߤʱߤʤʤ */
					if (select_search_num(1)->select->diagram_point.cad_point->code != 4 && CE_frag != 4) {
						/* ܤΥǡ */
						if (select_search_num(1)->select->index == 16) {
							Trim.TraceData[1].code = 16;
							Trim.ellipse[1] = *(select_search_num(1)->select->diagram_point.ellipse_point);
							
							if (sg(Trim.ellipse[1].sa, 3) == 0 && sg(Trim.ellipse[1].ea, 3) == 360) {
								Trim.ellipse[1].code = 0;
							}
							else {
								Trim.ellipse[1].code = 1;
							}
						}
						else {
							Trim.TraceData[1] = *(select_search_num(1)->select->diagram_point.cad_point);
						}

						/* ܤΥǡ */
						if (select_search_num(2)->select->index == 16) {
							Trim.TraceData[2].code = 16;
							Trim.ellipse[2] = *(select_search_num(2)->select->diagram_point.ellipse_point);
							if (sg(Trim.ellipse[2].sa, 3) == 0 && sg(Trim.ellipse[2].ea, 3) == 360) {
								Trim.ellipse[2].code = 0;
							}
							else {
								Trim.ellipse[2].code = 1;
							}
						}
						else {
							Trim.TraceData[2] = *(select_search_num(2)->select->diagram_point.cad_point);
						}

						/* ԥåΥǡ */
						Trim.PicX[1] = select_search_num(1)->select->x;
						Trim.PicY[1] = select_search_num(1)->select->y;
						Trim.PicX[2] = select_search_num(2)->select->x;
						Trim.PicY[2] = select_search_num(2)->select->y;
					}
					else return 0;


					if (Split(&Trim) == 1) {
						/* õ */
						SelectDraw(widget, select_search_num(1)->select, SCD_HIDE, UPDATE_OFF);
						SelectDraw(widget, select_search_num(2)->select, SCD_HIDE, UPDATE_ON);

						undo_index_plus();

						/* ELLIPSE */
						if (select_search_num(1)->select->index == 16) {
							/* ELLIPSE Data ѹ롢 Undo Baffer ˽ */
							ellipse_list_edit_with_undo(
								ellipse_search_ellipse(select_search_num(1)->select->diagram_point.ellipse_point, 
													   &ellipse_list_info), 
								&Trim.ellipse[1], 
								&ellipse_list_info);
							/* ELLIPSE Data ꥹȤκǽɲäơ Undo Baffer ˽ */
							ellipse_list_add_first_with_undo(&Trim.ellipse[3], &ellipse_list_info);
							
#ifdef TEST
							g_print ("MouseRet_Split() : ellipse 0 : (%f,%f),(%f,%f),%f,(%f,%f)\n", 
									 select_search_num(1)->select->diagram_point.ellipse_point->cx, 
									 select_search_num(1)->select->diagram_point.ellipse_point->cy, 
									 select_search_num(1)->select->diagram_point.ellipse_point->dx, 
									 select_search_num(1)->select->diagram_point.ellipse_point->dy, 
									 select_search_num(1)->select->diagram_point.ellipse_point->k, 
									 select_search_num(1)->select->diagram_point.ellipse_point->sa, 
									 select_search_num(1)->select->diagram_point.ellipse_point->ea);
							g_print ("MouseRet_Split() : ellipse 1 : (%f,%f),(%f,%f),%f,(%f,%f)\n", 
									 Trim.ellipse[1].cx, Trim.ellipse[1].cy, 
									 Trim.ellipse[1].dx, Trim.ellipse[1].dy, 
									 Trim.ellipse[1].k, 
									 Trim.ellipse[1].sa, Trim.ellipse[1].ea);
							g_print ("MouseRet_Split() : ellipse 2 : (%f,%f),(%f,%f),%f,(%f,%f)\n", 
									 Trim.ellipse[3].cx, Trim.ellipse[3].cy, 
									 Trim.ellipse[3].dx, Trim.ellipse[3].dy, 
									 Trim.ellipse[3].k, 
									 Trim.ellipse[3].sa, Trim.ellipse[3].ea);
#endif
						}
						/* CAD */
						else {
							/* CAD Data ѹ롢 Undo Baffer ˽ */
							cad_list_edit_with_undo(
									cad_search_cad(select_search_num(1)->select->diagram_point.cad_point, 
												   &cad_list_info), 
									&Trim.TraceData[1], 
									&cad_list_info);
							/* CAD Data ꥹȤκǽɲäơ Undo Baffer ˽ */
							cad_list_add_first_with_undo(&Trim.TraceData[3], &cad_list_info);
						}

						/*  */
						mouse_select_frag.index = 0;
						mouse_select_frag.x = 0;
						mouse_select_frag.y = 0;
						mouse_select_frag.diagram_point.cad_point = NULL;
						mouse_select_frag.diagram_point.dimension_point = NULL;
						if (select_search_num(1)->select->index == 16) {
							EllipseDraw(widget, ellipse_list_info.head->ellipse, SCD_ORG);
						}
						else {
							SelectCadDraw(widget, cad_list_info.head->cad, SCD_ORG);
						}
						SelectDraw(widget, select_search_num(1)->select, SCD_ORG, UPDATE_OFF);
						SelectDraw(widget, select_search_num(2)->select, SCD_ORG, UPDATE_ON);
					}
					else {
						g_print ("MouseRet_Split() : Split ؿ0֤ޤ\n");
						SelectDraw(widget, select_search_num(1)->select, SCD_ORG, UPDATE_OFF);
						SelectDraw(widget, select_search_num(2)->select, SCD_ORG, UPDATE_ON);
					}

					/* ꥹȤ */
					select_list_all_free();
					/* åɽ */
					(*ReturnFunc)(widget, Button, x, y);
					break;
			}
			break;
		/* ܥ */
		case 2:
			break;
		/* ܥ */
		case 4:
			break;
	}
	return 0;
}





/* -------------------------------------------------------
 * եåȥ⡼ (Main)
 */
int MouseMode_Fillet(GtkWidget *widget, int Button, int x, int y)
{
	switch (Button) {
		/* ܥ */
		case 1:
			MouseSelect(widget, ToViewX(x), ToViewY(y), DcObj, 0);
			break;
		/* ܥ */
		case 2:
			select_last_cansel();
			(*ReturnFunc)(widget, Button, x, y);
			break;
		/* ܥ */
		case 4:
			snap_set(DcObj, 15);
			break;
	}
	return 0;
}



/* -------------------------------------------------------
 * եåȥ⡼ (Return)
 */
int MouseRet_Fillet(GtkWidget *widget, int Button, int x, int y)
{
	char str[255], mstr[256];
	struct TrimDat Trim;

	/* 쥯ȥǡ */
	switch ( select_list_num() ) {
		case 0:
			/* åɽ */
			sprintf(mstr, _(" [Fillet] Select the 1st element. (Select 0) ") );
			StatusMsg(mstr);
			break;

		case 1:
			/* åɽ */
			DataInfo(select_list_info.tail->select, str);
			sprintf(mstr, _(" [Fillet] Select the 2nd element. (Select %d)  %s") , 
					(int) select_list_num(), str);
			StatusMsg(mstr);
			break;
	}


	switch (Button) {
		/* ܥ */
		case 1:
			switch ( select_list_num() ) {
				/* 쥯ȥǡ */
				case 2:
					Trim.TraceData[1] = *select_search_num(1)->select->diagram_point.cad_point;
					Trim.TraceData[2] = *select_search_num(2)->select->diagram_point.cad_point;
					Trim.PicX[1] = select_search_num(1)->select->x;
					Trim.PicY[1] = select_search_num(1)->select->y;
					Trim.PicX[2] = select_search_num(2)->select->x;
					Trim.PicY[2] = select_search_num(2)->select->y;


					if (Fillet(&Trim, sagcad_system.FilletRC) == 1) {
						/* õ */
						SelectCadDraw(widget, select_search_num(1)->select->diagram_point.cad_point, SCD_HIDE);
						SelectCadDraw(widget, select_search_num(2)->select->diagram_point.cad_point, SCD_HIDE);

						undo_index_plus();
						/* CAD Data ѹ롢 Undo Baffer ˽ */
						//CAD_LIST *cad_list_edit_with_undo(CAD_LIST *point, CAD *change_cad);
						/* ǡθ(CAD *p_cad  CAD_LIST ) */
						//CAD_LIST *cad_search_cad(CAD *p_cad);
						cad_list_edit_with_undo(
								cad_search_cad(select_search_num(1)->select->diagram_point.cad_point, &cad_list_info), 
								&Trim.TraceData[1], 
								&cad_list_info);
						cad_list_edit_with_undo(
								cad_search_cad(select_search_num(2)->select->diagram_point.cad_point, &cad_list_info), 
								&Trim.TraceData[2], 
								&cad_list_info);


						/* CAD Data ꥹȤκǽɲäơ Undo Baffer ˽ */
						cad_list_add_first_with_undo(&Trim.TraceData[3], &cad_list_info);

						/*  */
						mouse_select_frag.index = 0;
						mouse_select_frag.x = 0;
						mouse_select_frag.y = 0;
						mouse_select_frag.diagram_point.cad_point = NULL;
						mouse_select_frag.diagram_point.dimension_point = NULL;
						SelectCadDraw(widget, select_search_num(1)->select->diagram_point.cad_point, SCD_ORG);
						SelectCadDraw(widget, select_search_num(2)->select->diagram_point.cad_point, SCD_ORG);
						SelectCadDraw(widget, cad_list_info.head->cad, SCD_ORG);
					}
					/* ꥹȤ */
					select_list_all_free();
					/* åɽ */
					(*ReturnFunc)(widget, Button, x, y);
					break;
			}
			break;
		/* ܥ */
		case 2:
			break;
		/* ܥ */
		case 4:
			break;
	}
	return 0;
}



/* -------------------------------------------------------
 * ̼⡼ (Main)
 */
int MouseMode_Chamfering(GtkWidget *widget, int Button, int x, int y)
{
	switch (Button) {
		/* ܥ */
		case 1:
			MouseSelect(widget, ToViewX(x), ToViewY(y), DcObj, 0);
			break;
		/* ܥ */
		case 2:
			select_last_cansel();
			(*ReturnFunc)(widget, Button, x, y);
			break;
		/* ܥ */
		case 4:
			snap_set(DcObj, 15);
			break;
	}
	return 0;
}



/* -------------------------------------------------------
 * ̼⡼ (Return)
 */
int MouseRet_Chamfering(GtkWidget *widget, int Button, int x, int y)
{
	char str[255], mstr[256];
	struct TrimDat Trim;

	/* 쥯ȥǡ */
	switch ( select_list_num() ) {
		case 0:
			/* åɽ */
			sprintf(mstr, _(" [Chamfer] Select the 1st element. (Select 0) ") );
			StatusMsg(mstr);
			break;

		case 1:
			/* åɽ */
			DataInfo(select_list_info.tail->select, str);
			sprintf(mstr, _(" [Chamfer] Select the 2nd element. (Select %d)  %s") , 
					(int) select_list_num(), str);
			StatusMsg(mstr);
			break;
	}


	switch (Button) {
		/* ܥ */
		case 1:
			switch ( select_list_num() ) {
				/* 쥯ȥǡ */
				case 2:
					Trim.TraceData[1] = *select_search_num(1)->select->diagram_point.cad_point;
					Trim.TraceData[2] = *select_search_num(2)->select->diagram_point.cad_point;
					Trim.PicX[1] = select_search_num(1)->select->x;
					Trim.PicY[1] = select_search_num(1)->select->y;
					Trim.PicX[2] = select_search_num(2)->select->x;
					Trim.PicY[2] = select_search_num(2)->select->y;
					
					if(Fillet(&Trim, sagcad_system.FilletRC) == 1) {
						/* õ */
						SelectCadDraw(widget, select_search_num(1)->select->diagram_point.cad_point, SCD_HIDE);
						SelectCadDraw(widget, select_search_num(2)->select->diagram_point.cad_point, SCD_HIDE);


						undo_index_plus();
						/* CAD Data ѹ롢 Undo Baffer ˽ */
						//CAD_LIST *cad_list_edit_with_undo(CAD_LIST *point, CAD *change_cad);
						/* ǡθ(CAD *p_cad  CAD_LIST ) */
						//CAD_LIST *cad_search_cad(CAD *p_cad);
						cad_list_edit_with_undo(
								cad_search_cad(select_search_num(1)->select->diagram_point.cad_point, &cad_list_info), 
								&Trim.TraceData[1], 
								&cad_list_info);
						cad_list_edit_with_undo(
								cad_search_cad(select_search_num(2)->select->diagram_point.cad_point, &cad_list_info), 
								&Trim.TraceData[2], 
								&cad_list_info);


						Trim.TraceData[3].code = 1;
						Trim.TraceData[3].cx = 0;
						Trim.TraceData[3].cy = 0;
						Trim.TraceData[3].r = 0;
						/* CAD Data ꥹȤκǽɲäơ Undo Baffer ˽ */
						cad_list_add_first_with_undo(&Trim.TraceData[3], &cad_list_info);

						/*  */
						mouse_select_frag.index = 0;
						mouse_select_frag.x = 0;
						mouse_select_frag.y = 0;
						mouse_select_frag.diagram_point.cad_point = NULL;
						mouse_select_frag.diagram_point.dimension_point = NULL;
						SelectCadDraw(widget, select_search_num(1)->select->diagram_point.cad_point, SCD_ORG);
						SelectCadDraw(widget, select_search_num(2)->select->diagram_point.cad_point, SCD_ORG);
						SelectCadDraw(widget, cad_list_info.head->cad, SCD_ORG);
					}
					/* ꥹȤ */
					select_list_all_free();
					/* åɽ */
					(*ReturnFunc)(widget, Button, x, y);
					break;
			}
			break;
		/* ܥ */
		case 2:
			break;
		/* ܥ */
		case 4:
			break;
	}
	return 0;
}





/* -------------------------------------------------------------------
 * Ϣ³⡼ (Main)
 */
int MouseMode_ContLine(GtkWidget *widget, int Button, int x, int y)
{
	switch (Button) {
		/* ܥ */
		case 1:
			MouseSelect(widget, ToViewX(x), ToViewY(y), 1, 0);
			break;
		/* ܥ */
		case 2:
			/* ꥹȤ */
			if(select_list_info.head != NULL) SelectCadDraw(widget, select_list_info.head->select->diagram_point.cad_point, SCD_ORG);
			select_list_all_free();
			/* åɽ */
			(*ReturnFunc)(widget, Button, x, y);
			break;
		/* ܥ */
		case 4:
			break;
	}
	return 0;
}



/* -------------------------------------------------------
 * Ϣ³⡼ (Return)
 */
int MouseRet_ContLine(GtkWidget *widget, int Button, int x, int y)
{
	char str[255], mstr[256];
	CAD cad;

	/* 쥯ȥǡ */
	switch ( select_list_num() ) {
		case 0:
			/* åɽ */
			sprintf(mstr, _(" [Continuation Line] Start point") );
			StatusMsg(mstr);
			break;
		case 1:
			/* åɽ */
			DataInfo(select_list_info.tail->select, str);
			sprintf(mstr, _(" [Continuation Line] End point (S %d)  %s") , 
				(int) select_list_num(), str);
			StatusMsg(mstr);
			break;
	}


	switch (Button) {
		/* ܥ */
		case 1:
			switch ( select_list_num() ) {
				/* 쥯ȥǡ */
				case 2:
					cad.layer = NowLayer;
					cad.style = NowStyle;
					cad.color = NowColor;
					cad.code = 1;
					cad.sx = select_search_num(1)->select->diagram_point.cad_point->sx;
					cad.sy = select_search_num(1)->select->diagram_point.cad_point->sy;
					cad.ex = select_search_num(2)->select->diagram_point.cad_point->sx;
					cad.ey = select_search_num(2)->select->diagram_point.cad_point->sy;
					cad.cx = 0;
					cad.cy = 0;
					cad.r = 0;

					undo_index_plus();
					/* CAD Data ꥹȤκǽɲäơ Undo Baffer ˽ */
					cad_list_add_first_with_undo(&cad, &cad_list_info);
					SelectCadDraw(widget, cad_list_info.head->cad, SCD_ORG);

					select_search_num(1)->select->diagram_point.cad_point = select_search_num(2)->select->diagram_point.cad_point;
					/* Select Data ꥹȤ */
					select_list_free(select_list_info.tail);
					/* åɽ */
					(*ReturnFunc)(widget, Button, x, y);
					break;
			}
			break;
		/* ܥ */
		case 2:
			break;
		/* ܥ */
		case 4:
			break;
	}
	return 0;
}





/* -------------------------------------------------------
 * Ǳ (Main)
 */
int MouseMode_3P_Circle(GtkWidget *widget, int Button, int x, int y)
{
	switch (Button) {
		/* ܥ */
		case 1:
			MouseSelect(widget, ToViewX(x), ToViewY(y), 1, 0);
			break;
		/* ܥ */
		case 2:
			select_last_cansel();
			(*ReturnFunc)(widget, Button, x, y);
			break;
		/* ܥ */
		case 4:
			break;
	}
	return 0;
}



/* -------------------------------------------------------
 * Ǳ (Return)
 */
int MouseRet_3P_Circle(GtkWidget *widget, int Button, int x, int y)
{
	char str[255], mstr[256];
	struct RtnDat PPPCH;
	CAD cad;

	/* 쥯ȥǡ */
	switch ( select_list_num() ) {
		case 0:
			/* åɽ */
			sprintf(mstr, _(" [Circle from three points] 1st point") );
			StatusMsg(mstr);
			break;
		case 1:
			/* åɽ */
			DataInfo(select_list_info.tail->select, str);
			sprintf(mstr, _(" [Circle from three points] 2nd point (S %d)  %s") , 
				(int) select_list_num(), str);
			StatusMsg(mstr);
			break;
		case 2:
			/* åɽ */
			DataInfo(select_list_info.tail->select, str);
			sprintf(mstr, _(" [Circle from three points] 3rd point (S %d)  %s") , 
				(int) select_list_num(), str);
			StatusMsg(mstr);
			break;
	}


	switch (Button) {
		/* ܥ */
		case 1:
			switch ( select_list_num() ) {
				/* 쥯ȥǡ */
				case 3:
					SelectCadDraw(widget, select_search_num(1)->select->diagram_point.cad_point, SCD_ORG);
					SelectCadDraw(widget, select_search_num(2)->select->diagram_point.cad_point, SCD_ORG);
					SelectCadDraw(widget, select_search_num(3)->select->diagram_point.cad_point, SCD_ORG);

					PPPCH.sx[1]= select_search_num(1)->select->diagram_point.cad_point->sx;
					PPPCH.sy[1]= select_search_num(1)->select->diagram_point.cad_point->sy;
					PPPCH.sx[2]= select_search_num(2)->select->diagram_point.cad_point->sx;
					PPPCH.sy[2]= select_search_num(2)->select->diagram_point.cad_point->sy;
					PPPCH.sx[3]= select_search_num(3)->select->diagram_point.cad_point->sx;
					PPPCH.sy[3]= select_search_num(3)->select->diagram_point.cad_point->sy;
					pppc(&PPPCH);

					cad.layer = NowLayer;
					cad.style = NowStyle;
					cad.color = NowColor;
					cad.code = 4;
					cad.sx = 0;
					cad.sy = 0;
					cad.ex = 0;
					cad.ey = 0;
					cad.cx = PPPCH.cx[1];
					cad.cy = PPPCH.cy[1];
					cad.r =  PPPCH.r[1];

					undo_index_plus();
					/* CAD Data ꥹȤκǽɲäơ Undo Baffer ˽ */
					cad_list_add_first_with_undo(&cad, &cad_list_info);
					SelectCadDraw(widget, cad_list_info.head->cad, SCD_ORG);

					mouse_select_frag.index = 0;
					mouse_select_frag.x = 0;
					mouse_select_frag.y = 0;
					mouse_select_frag.diagram_point.cad_point = NULL;
					mouse_select_frag.diagram_point.dimension_point = NULL;
					/* ꥹȤ */
					select_list_all_free();
					(*ReturnFunc)(widget, Button, x, y);
					return 1;
					break;
			}
			break;
		/* ܥ */
		case 2:
			break;
		/* ܥ */
		case 4:
			break;
	}
	return 0;
}



/* -------------------------------------------------------
 * դǱ (Main)
 */
int MouseMode_3L_Circle(GtkWidget *widget, int Button, int x, int y)
{
	switch (Button) {
		/* ܥ */
		case 1:
			MouseSelect(widget, ToViewX(x), ToViewY(y), 2, 0);
			break;
		/* ܥ */
		case 2:
			select_last_cansel();
			(*ReturnFunc)(widget, Button, x, y);
			break;
		/* ܥ */
		case 4:
			break;
	}
	return 0;
}



/* -------------------------------------------------------
 * դǱ (Return)
 */
int MouseRet_3L_Circle(GtkWidget *widget, int Button, int x, int y)
{
	char str[255], mstr[256];
	struct RtnDat LLLCH;
	int Ret;


	/* 쥯ȥǡ */
	switch ( select_list_num() ) {
		case 0:
			/* åɽ */
			sprintf(mstr, _(" [Circle from three lines] 1st line") );
			StatusMsg(mstr);
			break;
		case 1:
			/* åɽ */
			DataInfo(select_list_info.tail->select, str);
			sprintf(mstr, _(" [Circle from three lines] 2nd line (S %d)  %s") , 
				(int) select_list_num(), str);
			StatusMsg(mstr);
			break;
		case 2:
			/* åɽ */
			DataInfo(select_list_info.tail->select, str);
			sprintf(mstr, _(" [Circle from three lines] 3rd line (S %d)  %s") , 
				(int) select_list_num(), str);
			StatusMsg(mstr);
			break;
	}


	switch (Button) {
		/* ܥ */
		case 1:
			switch ( select_list_num() ) {
				/* 쥯ȥǡ */
				case 3:
					SelectCadDraw(widget, select_search_num(1)->select->diagram_point.cad_point, SCD_ORG);
					SelectCadDraw(widget, select_search_num(2)->select->diagram_point.cad_point, SCD_ORG);
					SelectCadDraw(widget, select_search_num(3)->select->diagram_point.cad_point, SCD_ORG);

					LLLCH.sx[1]= select_search_num(1)->select->diagram_point.cad_point->sx; 
					LLLCH.sy[1]= select_search_num(1)->select->diagram_point.cad_point->sy;
					LLLCH.ex[1]= select_search_num(1)->select->diagram_point.cad_point->ex; 
					LLLCH.ey[1]= select_search_num(1)->select->diagram_point.cad_point->ey;

					LLLCH.sx[2]= select_search_num(2)->select->diagram_point.cad_point->sx; 
					LLLCH.sy[2]= select_search_num(2)->select->diagram_point.cad_point->sy;
					LLLCH.ex[2]= select_search_num(2)->select->diagram_point.cad_point->ex; 
					LLLCH.ey[2]= select_search_num(2)->select->diagram_point.cad_point->ey;

					LLLCH.sx[3]= select_search_num(3)->select->diagram_point.cad_point->sx; 
					LLLCH.sy[3]= select_search_num(3)->select->diagram_point.cad_point->sy; 
					LLLCH.ex[3]= select_search_num(3)->select->diagram_point.cad_point->ex; 
					LLLCH.ey[3]= select_search_num(3)->select->diagram_point.cad_point->ey; 

					Ret = lllc(&LLLCH);

					if (LLLCH.type == 0) {
						if (Ret == 0)
							MsgBox("SagCAD", "Error", _("Three straight line is Parallel !") , NULL, NULL, "OK");
						else if (Ret == -1)
							MsgBox("SagCAD", "Error", _("One point of intersection !") , NULL, NULL, "OK");
						mouse_select_frag.index = 0;
						mouse_select_frag.x = 0;
						mouse_select_frag.y = 0;
						mouse_select_frag.diagram_point.cad_point = NULL;
						/* ꥹȤ */
						select_list_all_free();
						/* åɽ */
						(*ReturnFunc)(widget, Button, x, y);
						return 0;
					}
					if (LLLCH.type == 2) {
						OnlyOneCAD[1].code =	4;
						OnlyOneCAD[1].cx =		sg(LLLCH.cx[1], 6);
						OnlyOneCAD[1].cy =		sg(LLLCH.cy[1], 6);
						OnlyOneCAD[1].r =		sg(LLLCH.r[1], 6);
						
						OnlyOneCAD[2].code =	4;
						OnlyOneCAD[2].cx =		sg(LLLCH.cx[2], 6);
						OnlyOneCAD[2].cy =		sg(LLLCH.cy[2], 6);
						OnlyOneCAD[2].r =		sg(LLLCH.r[2], 6);
						
						OnlyOneIndex = 1;
						OnlyOneEntry = 2;
						OnlyOne_mode = 210;
						OnlyOne(3);
						return 1;
					}
					else if (LLLCH.type == 4) {
						OnlyOneCAD[1].code =	4;
						OnlyOneCAD[1].cx =		sg(LLLCH.cx[1], 6);
						OnlyOneCAD[1].cy =		sg(LLLCH.cy[1], 6);
						OnlyOneCAD[1].r =		sg(LLLCH.r[1], 6);
						
						OnlyOneCAD[2].code =	4;
						OnlyOneCAD[2].cx =		sg(LLLCH.cx[2], 6);
						OnlyOneCAD[2].cy =		sg(LLLCH.cy[2], 6);
						OnlyOneCAD[2].r =		sg(LLLCH.r[2], 6);
						
						OnlyOneCAD[3].code =	4;
						OnlyOneCAD[3].cx =		sg(LLLCH.cx[3], 6);
						OnlyOneCAD[3].cy =		sg(LLLCH.cy[3], 6);
						OnlyOneCAD[3].r =		sg(LLLCH.r[3], 6);
						
						OnlyOneCAD[4].code =	4;
						OnlyOneCAD[4].cx =		sg(LLLCH.cx[4], 6);
						OnlyOneCAD[4].cy =		sg(LLLCH.cy[4], 6);
						OnlyOneCAD[4].r =		sg(LLLCH.r[4], 6);
						
						OnlyOneIndex = 1;
						OnlyOneEntry = 4;
						OnlyOne_mode = 210;
						OnlyOne(3);
						return 1;
					}
					break;
			}
			break;
		/* ܥ */
		case 2:
			break;
		/* ܥ */
		case 4:
			break;
	}
	return 0;
}





/* ---------------------------------------------------------
 * ʿ (Main)
 */
int MouseMode_Parallel(GtkWidget *widget, int Button, int x, int y)
{
	COPY_DLG copy_dlg;
	char mstr[256];

	switch (Button) {
		/* ܥ */
		case 1:
			MouseSelect(widget, ToViewX(x), ToViewY(y), 1, 1);
			break;
		/* ܥ */
		case 2:
			if (select_list_num() == CopyFrag) {
				sprintf(mstr, _(" [Parallel] Move/Copy Setting Dialog") );
				StatusMsg(mstr);

				/* COPY_DLG ¤ν */
				copy_dlg.x_pitch = 0;
				copy_dlg.y_pitch = 0;
				copy_dlg.repeats = 1;
				copy_dlg.x_pitch_entry = NULL;
				copy_dlg.y_pitch_entry = NULL;
				copy_dlg.repeats_entry = NULL;
				copy_dlg.parent = MainWindow;
				copy_dlg.dialog = NULL;

				/* ܡϥɽ */
				CopyDialog(&copy_dlg);
				CopyPara(copy_dlg.x_pitch, copy_dlg.y_pitch, copy_dlg.repeats);

				/* mode ⡼ 300  */
				ReturnFunc = MouseRet_Select;
				DcObj = 15;
				mode = 300;
				/* åɽ */
				(*ReturnFunc)(widget, Button, x, y);
			}
			break;
		/* ܥ */
		case 4:
			break;
	}
	return 0;
}



/* ---------------------------------------------------------
 * ʿ (Return)
 */
int MouseRet_Parallel(GtkWidget *widget, int Button, int x, int y)
{
	COPY_DLG copy_dlg;
	char mstr[256];
//	int Repeat;
	double sx1, sy1, sx2, sy2;

	switch (Button) {
		/* ܥ */
		case 1:
			if (select_list_num() == CopyFrag) {
				/* åɽ */
				sprintf(mstr, _(" [Parallel] Left:Start point / Right:Show setting dialog.") );
				StatusMsg(mstr);
				return 1;
			}

			if (select_list_num() == CopyFrag + 1) {
				/* åɽ */
				sprintf(mstr, _(" [Parallel] Start point") );
				StatusMsg(mstr);
				return 1;
			}

			if (select_list_num() == CopyFrag + 2) {
				/* å򥪥ꥸʥɽ */
				SelectCadDraw(widget, select_search_num(CopyFrag + 1)->select->diagram_point.cad_point, SCD_ORG);
				SelectCadDraw(widget, select_search_num(CopyFrag + 2)->select->diagram_point.cad_point, SCD_ORG);

				sx1 = select_search_num(CopyFrag + 1)->select->diagram_point.cad_point->sx;
				sy1 = select_search_num(CopyFrag + 1)->select->diagram_point.cad_point->sy;
				sx2 = select_search_num(CopyFrag + 2)->select->diagram_point.cad_point->sx;
				sy2 = select_search_num(CopyFrag + 2)->select->diagram_point.cad_point->sy;


				/* COPY_DLG ¤ν */
				copy_dlg.x_pitch = sx2 - sx1;
				copy_dlg.y_pitch = sy2 - sy1;
				copy_dlg.repeats = 1;
				copy_dlg.x_pitch_entry = NULL;
				copy_dlg.y_pitch_entry = NULL;
				copy_dlg.repeats_entry = NULL;
				copy_dlg.parent = MainWindow;
				copy_dlg.dialog = NULL;


				/* Select Data ꥹȤ */
				select_list_free(select_list_info.tail);
				select_list_free(select_list_info.tail);

				/* ܡϥɽ */
				CopyDialog(&copy_dlg);
				CopyPara(copy_dlg.x_pitch, copy_dlg.y_pitch, copy_dlg.repeats);

				/* mode ⡼ 300  */
				ReturnFunc = MouseRet_Select;
				DcObj = 15;
				mode = 300;
				/* åɽ */
				(*ReturnFunc)(widget, Button, x, y);
				return 1;
			}
			break;
		/* ܥ */
		case 2:
			break;
		/* ܥ */
		case 4:
			break;
	}
	return 0;
}





/* -------------------------------------------------------
 * žư (Main)
 */
int MouseMode_Turn(GtkWidget *widget, int Button, int x, int y)
{
	TURN_DLG turn_dlg;
	char mstr[256];

	switch (Button) {
		/* ܥ */
		case 1:
			MouseSelect(widget, ToViewX(x), ToViewY(y), 1, 1);
			break;
		/* ܥ */
		case 2:
			if (select_list_num() == CopyFrag) {
				sprintf(mstr, _(" [Rotate] Move/Copy Setting Dialog") );
				StatusMsg(mstr);

				/* TurnDialog */
				turn_dlg.x_pos = 0;
				turn_dlg.y_pos = 0;
				turn_dlg.angle = 0;
				turn_dlg.repeats = 1;
				turn_dlg.x_pos_entry = NULL;
				turn_dlg.y_pos_entry = NULL;
				turn_dlg.angle_entry = NULL;
				turn_dlg.repeats_entry = NULL;
				turn_dlg.parent = MainWindow;
				turn_dlg.dialog = NULL;

				TurnDialog(&turn_dlg);
				CopyRoll(turn_dlg.x_pos, turn_dlg.y_pos, turn_dlg.angle, turn_dlg.repeats);

				/* mode ⡼ 300  */
				ReturnFunc = MouseRet_Select;
				DcObj = 15;
				mode = 300;
				/* åɽ */
				(*ReturnFunc)(widget, Button, x, y);
			}
			break;
		/* ܥ */
		case 4:
			break;
	}
	return 0;
}



/* -------------------------------------------------------
 * žư (Return)
 */
int MouseRet_Turn(GtkWidget *widget, int Button, int x, int y)
{
	TURN_DLG turn_dlg;
	char mstr[256];

	switch (Button) {
		/* ܥ */
		case 1:
			if (select_list_num() == CopyFrag) {
				/* åɽ */
				sprintf(mstr, 
					_(" [Rotate] Left:Rotate center point / Right:Show setting dialog.") );
				StatusMsg(mstr);
			}

			if (select_list_num() == CopyFrag + 1) {
				/** å򥪥ꥸʥɽ **/
				SelectCadDraw(widget, select_search_num(CopyFrag + 1)->select->diagram_point.cad_point, SCD_ORG);

				turn_dlg.x_pos = select_search_num(CopyFrag + 1)->select->diagram_point.cad_point->sx;
				turn_dlg.y_pos = select_search_num(CopyFrag + 1)->select->diagram_point.cad_point->sy;

				/* Select Data ꥹȤ */
				select_list_free(select_list_info.tail);


				/* TurnDialog */
				//turn_dlg.x_pos = 0;
				//turn_dlg.y_pos = 0;
				turn_dlg.angle = 0;
				turn_dlg.repeats = 1;
				turn_dlg.x_pos_entry = NULL;
				turn_dlg.y_pos_entry = NULL;
				turn_dlg.angle_entry = NULL;
				turn_dlg.repeats_entry = NULL;
				turn_dlg.parent = MainWindow;
				turn_dlg.dialog = NULL;

				TurnDialog(&turn_dlg);
				CopyRoll(turn_dlg.x_pos, turn_dlg.y_pos, turn_dlg.angle, turn_dlg.repeats);

				/* mode ⡼ 300  */
				ReturnFunc = MouseRet_Select;
				DcObj = 15;
				mode = 300;
				/* åɽ */
				(*ReturnFunc)(widget, Button, x, y);
			}
			break;
		/* ܥ */
		case 2:
			break;
		/* ܥ */
		case 4:
			break;
	}
	return 0;
}



/* -------------------------------------------------------
 * оΰư (Main)
 */
int MouseMode_Mirror(GtkWidget *widget, int Button, int x, int y)
{
	switch (Button) {
		/* ܥ */
		case 1:
			MouseSelect(widget, ToViewX(x), ToViewY(y), 2, 1);
			break;
		/* ܥ */
		case 2:
			break;
		/* ܥ */
		case 4:
			break;
	}
	return 0;
}



/* -------------------------------------------------------
 * оΰư (Return)
 */
int MouseRet_Mirror(GtkWidget *widget, int Button, int x, int y)
{
	char str[255], mstr[256];
	int Ret, Repeat;
	double sx, sy, ex, ey;

	switch (Button) {
		/* ܥ */
		case 1:
			if (select_list_num() == CopyFrag) {
				/* åɽ */
				sprintf(mstr, 
					_(" [Mirror] Mirror axis line") );
				StatusMsg(mstr);
			}

			if (select_list_num() == CopyFrag + 1) {
				while (1) {
					/* ϥܥåɽ */
					strcpy(str, "");
					Ret = InputBox( _("Mirror mode setting") , _("1 : Move") , _("2 : Copy") , str);
					if (Ret == 1) {
						Repeat = atoi(str);
						if (Repeat != 1 && Repeat != 2) {
							MsgBox("SagCAD", "Error", _("1 or 2") , NULL, NULL, "OK");
						}
						else {
							break;
						}
					}
					else {
						/* mode ⡼ 300  */
						ReturnFunc = MouseRet_Select;
						DcObj = 15;
						mode = 300;
						/* åɽ */
						(*ReturnFunc)(widget, Button, x, y);
						return 0;
					}
				}

				/* å򥪥ꥸʥɽ */
				SelectCadDraw(widget, select_search_num(CopyFrag + 1)->select->diagram_point.cad_point, SCD_ORG);

				sx = select_search_num(CopyFrag + 1)->select->diagram_point.cad_point->sx;
				sy = select_search_num(CopyFrag + 1)->select->diagram_point.cad_point->sy;
				ex = select_search_num(CopyFrag + 1)->select->diagram_point.cad_point->ex;
				ey = select_search_num(CopyFrag + 1)->select->diagram_point.cad_point->ey;

				/* Select Data ꥹȤ */
				select_list_free(select_list_info.tail);

				CopyMirr(sx, sy, ex, ey, Repeat);

				/* mode ⡼ 300  */
				ReturnFunc = MouseRet_Select;
				DcObj = 15;
				mode = 300;
				/* åɽ */
				(*ReturnFunc)(widget, Button, x, y);
			}
			break;
		/* ܥ */
		case 2:
			break;
		/* ܥ */
		case 4:
			break;
	}
	return 0;
}





/* -------------------------------------------------------------------
 * ʿɹ (Main)
 */
int MouseMode_PartsRead(GtkWidget *widget, int Button, int x, int y)
{
	switch (Button) {
		/* ܥ */
		case 1:
			MouseSelect(widget, ToViewX(x), ToViewY(y), 1, 0);
			break;
		/* ܥ */
		case 2:
			MouseSelect(widget, ToViewX(x), ToViewY(y), 128, 0);
			break;
		/* ܥ */
		case 4:
			break;
	}
	return 0;
}



/* -------------------------------------------------------------------
 * ʿɹ (Return)
 */
int MouseRet_PartsRead(GtkWidget *widget, int Button, int x, int y)
{
	char mstr[256];

	/* ޥɥ饤ɽ */
	sprintf(mstr, _(" [Part Insert] Read point") );
	StatusMsg(mstr);


	if (select_list_num() == 1) {
		/* ɸǡ */
		if (select_search_num(1)->select->index == 1) {
			if (strstr(PartsFile, ".sgy") != NULL || strstr(PartsFile, ".SGY") != NULL) {
				ReadPartsFileNameGet(PartsFile, 
									 select_list_info.head->select->x, 
									 select_list_info.head->select->y);
			}
			else if (strstr(PartsFile, ".dxf") != NULL || strstr(PartsFile, ".DXF") != NULL) {
				DxfFileOpen(PartsFile, select_list_info.head->select->x, select_list_info.head->select->y);
			}
		}
		/* ǡ */
		else if (select_search_num(1)->select->index == 2) {
			if (select_search_num(1)->select->diagram_point.cad_point->code == 0) {
				if (strstr(PartsFile, ".sgy") != NULL || strstr(PartsFile, ".SGY") != NULL) {
					ReadPartsFileNameGet(PartsFile, 
										 select_search_num(1)->select->diagram_point.cad_point->sx, 
										 select_search_num(1)->select->diagram_point.cad_point->sy
										 );
				}
				else if (strstr(PartsFile, ".dxf") != NULL || strstr(PartsFile, ".DXF") != NULL) {
					DxfFileOpen(PartsFile, 
								select_search_num(1)->select->diagram_point.cad_point->sx, 
								select_search_num(1)->select->diagram_point.cad_point->sy
								);
				}
			}
		}
		SelectCancel(drawing_area);
		/* mode ⡼ 300  */
		ReturnFunc = MouseRet_Select;
		DcObj = 15;
		mode = 300;
		/* åɽ */
		(*ReturnFunc)(widget, Button, x, y);
		Redraw();
	}

	return 0;
}





int PicPointCheck(GtkWidget *widget, int Button, int x, int y, int n)
{
	if (
		PicPoint.X[n-1] == select_search_num(n)->select->x 
		&& 
		PicPoint.Y[n-1] == select_search_num(n)->select->y 
		) 
	{
		select_last_cansel();
		(*ReturnFunc)(widget, Button, x, y);
		return 1;
	}
	return 0;
}





/* ---------------------------------------------------------
 * ʿˡ ⡼ (Main)
 * 510
 */
int MouseMode_DimensionX(GtkWidget *widget, int Button, int x, int y)
{
	switch (Button) {
		/* ܥ */
		case 1:
			MouseSelect(widget, ToViewX(x), ToViewY(y), DcObj, 1);
			break;
		/* ܥ */
		case 2:
			MouseSelect(widget, ToViewX(x), ToViewY(y), 128, 1);
			break;
		/* ܥ */
		case 4:
			snap_set(DcObj, 113);
			break;
	}
	return 1;
}



/* ---------------------------------------------------------
 * ʿˡ ⡼ (Return)
 */
int MouseRet_DimensionX(GtkWidget *widget, int Button, int x, int y)
{
	char mstr[256];

	switch (select_list_num()) {
		/* 쥯ȥǡ */
		case 0:
			/* åɽ */
			sprintf(mstr, _(" [Horizontal Dimension] 1st point") );
			StatusMsg(mstr);
			break;
		case 1:
			/* åɽ */
			sprintf(mstr, " [Horizontal Dimension] 2nd point");
			StatusMsg(mstr);
			PointDraw(drawing_area, 
					  select_search_num(1)->select->x, 
					  select_search_num(1)->select->y, 
					  1, sagcad_color.Select);
			UpDate();

			PicPoint.X[1] = select_search_num(1)->select->x;
			PicPoint.Y[1] = select_search_num(1)->select->y;
			break;
		case 2:
			if (PicPointCheck(widget, Button, x, y, 2)) break;;
			if(Dim_old.Text[0] == '\0'){
				sprintf(mstr, _(" [Horizontal Dimension] What place ?") );
				StatusMsg(mstr);
				PointDraw(drawing_area, 
						  select_search_num(2)->select->x, 
						  select_search_num(2)->select->y, 
						  1, sagcad_color.Select);
				UpDate();

				PicPoint.X[2] = select_search_num(2)->select->x;
				PicPoint.Y[2] = select_search_num(2)->select->y;
			}
			break;
		case 3:
			if (PicPointCheck(widget, Button, x, y, 3)) break;;
			/* åɽ */
			sprintf(mstr, _(" [Horizontal Dimension] 1st point") );
			StatusMsg(mstr);
			PointDraw(drawing_area, select_search_num(1)->select->x, select_search_num(1)->select->y, 1, sagcad_color.Back);
			PointDraw(drawing_area, select_search_num(2)->select->x, select_search_num(2)->select->y, 1, sagcad_color.Back);

			PicPoint.X[3] = select_search_num(3)->select->x;
			PicPoint.Y[3] = select_search_num(3)->select->y;
			Dimension_X_Culc(&Dim_now, PicPoint);
			DimensionDraw(widget, &Dim_now, SCD_HIDE);
//			Dim_now.FontType = sagcad_dimension.font_Type;
			DimensionDraw(widget, &Dim_now, SCD_ORG);
			UpDate();
			/* ˡ ɲ */
			undo_index_plus();
			dimension_list_add_first_with_undo(&Dim_now, &dimension_list_info);
			Dim_old.Text[0] = '\0';
			Dim_now.diagram_of_char_index = 0;
			Dim_now.diagram_of_char = NULL;
			Dim_now.AssistLine = NULL;
			/* ꥹȤ */
			select_list_all_free();
//			Dim_now.FontType = 1;
			break;
	}
	return 1;
}





/* ---------------------------------------------------------
 * ʿˡ ⡼ (Main)
 */
int MouseMode_DimensionY(GtkWidget *widget, int Button, int x, int y)
{
	switch (Button) {
		/* ܥ */
		case 1:
			MouseSelect(widget, ToViewX(x), ToViewY(y), DcObj, 1);
			break;
		/* ܥ */
		case 2:
			MouseSelect(widget, ToViewX(x), ToViewY(y), 128, 1);
			break;
		/* ܥ */
		case 4:
			snap_set(DcObj, 113);
			break;
	}
	return 1;
}



/* ---------------------------------------------------------
 * ʿˡ ⡼ (Return)
 */
int MouseRet_DimensionY(GtkWidget *widget, int Button, int x, int y)
{
	char mstr[256];

	switch (select_list_num()) {
		/* 쥯ȥǡ */
		case 0:
			sprintf(mstr, _(" [Vertical Dimension] 1st point") );
			StatusMsg(mstr);
			break;
		case 1:
			sprintf(mstr, _(" [Vertical Dimension] 2nd point") );
			StatusMsg(mstr);
			PointDraw(drawing_area, select_search_num(1)->select->x, select_search_num(1)->select->y, 1, sagcad_color.Select);
			UpDate();

			PicPoint.X[1] = select_search_num(1)->select->x;
			PicPoint.Y[1] = select_search_num(1)->select->y;
			break;
		case 2:
			if (PicPointCheck(widget, Button, x, y, 2)) break;;
			if(Dim_old.Text[0] == '\0'){
				sprintf(mstr, _(" [Vertical Dimension] What place ?") );
				StatusMsg(mstr);
				PointDraw(drawing_area, 
						  select_search_num(2)->select->x, select_search_num(2)->select->y, 
						  1, sagcad_color.Select);
				UpDate();

				PicPoint.X[2] = select_search_num(2)->select->x;
				PicPoint.Y[2] = select_search_num(2)->select->y;
			}
			break;
		case 3:
			if (PicPointCheck(widget, Button, x, y, 3)) break;;
			sprintf(mstr, _(" [Vertical Dimension] 1st point") );
			StatusMsg(mstr);
			PointDraw(drawing_area, 
					  select_search_num(1)->select->x, select_search_num(1)->select->y, 
					  1, sagcad_color.Back);
			PointDraw(drawing_area, 
					  select_search_num(2)->select->x, select_search_num(2)->select->y, 
					  1, sagcad_color.Back);
			UpDate();

			PicPoint.X[3] = select_search_num(3)->select->x;
			PicPoint.Y[3] = select_search_num(3)->select->y;
			Dimension_Y_Culc(&Dim_now, PicPoint);
			DimensionDraw(widget, &Dim_now, SCD_HIDE);
//			Dim_now.FontType = sagcad_dimension.font_Type;
			DimensionDraw(widget, &Dim_now, SCD_ORG);
			UpDate();
			/* ˡ ɲ */
			Dim_now.Type = 20;

			undo_index_plus();
			dimension_list_add_first_with_undo(&Dim_now, &dimension_list_info);
			Dim_old.Text[0] = '\0';
			Dim_now.diagram_of_char_index = 0;
			Dim_now.diagram_of_char = NULL;
			Dim_now.AssistLine = NULL;
			/* ꥹȤ */
			select_list_all_free();
//			Dim_now.FontType = 1;
			break;
	}
	return 1;
}





/* ---------------------------------------------------------
 * Υˡ ⡼ (Main)
 */
int MouseMode_DimensionP(GtkWidget *widget, int Button, int x, int y)
{
	switch (Button) {
		/* ܥ */
		case 1:
			MouseSelect(widget, ToViewX(x), ToViewY(y), DcObj, 1);
			break;

		/* ܥ */
		case 2:
			MouseSelect(widget, ToViewX(x), ToViewY(y), 128, 1);
			break;

		/* ܥ */
		case 4:
			snap_set(DcObj, 113);
			break;
	}
	return 1;
}



/* ---------------------------------------------------------
 * Υˡ ⡼ (Return)
 */
int MouseRet_DimensionP(GtkWidget *widget, int Button, int x, int y)
{
	char mstr[256];

	switch (select_list_num()) {
		case 0:
			sprintf(mstr, _(" [Distance Dimension] 1st point") );
			StatusMsg(mstr);
			break;
		case 1:
			sprintf(mstr, _(" [Distance Dimension] 2nd point") );
			StatusMsg(mstr);
			PointDraw(drawing_area, select_search_num(1)->select->x, select_search_num(1)->select->y, 1, sagcad_color.Select);
			UpDate();

			PicPoint.X[1] = select_search_num(1)->select->x;
			PicPoint.Y[1] = select_search_num(1)->select->y;
			break;
			
		case 2:
			if (PicPointCheck(widget, Button, x, y, 2)) break;;
			if(Dim_old.Text[0] == '\0'){
				sprintf(mstr, _(" [Distance Dimension] What place ?") );
				StatusMsg(mstr);
				PointDraw(drawing_area, select_search_num(2)->select->x, select_search_num(2)->select->y, 1, sagcad_color.Select);
				UpDate();

				PicPoint.X[2] = select_search_num(2)->select->x;
				PicPoint.Y[2] = select_search_num(2)->select->y;
			}
			break;
			
		case 3:
			if (PicPointCheck(widget, Button, x, y, 3)) break;;
			sprintf(mstr, _(" [Distance Dimension] 1st point") );
			StatusMsg(mstr);
			PointDraw(drawing_area, select_search_num(1)->select->x, select_search_num(1)->select->y, 1, sagcad_color.Back);
			PointDraw(drawing_area, select_search_num(2)->select->x, select_search_num(2)->select->y, 1, sagcad_color.Back);
			PicPoint.X[3] = select_search_num(3)->select->x;
			PicPoint.Y[3] = select_search_num(3)->select->y;
			Dimension_P_Culc(&Dim_now, PicPoint);
			DimensionDraw(widget, &Dim_now, SCD_HIDE);
//			Dim_now.FontType = sagcad_dimension.font_Type;
			DimensionDraw(widget, &Dim_now, SCD_ORG);
			UpDate();
			/* ˡ ɲ */
			Dim_now.Type = 30;

			undo_index_plus();
			dimension_list_add_first_with_undo(&Dim_now, &dimension_list_info);
			Dim_old.Text[0] = '\0';
			Dim_now.diagram_of_char_index = 0;
			Dim_now.diagram_of_char = NULL;
			Dim_now.AssistLine = NULL;
			/* ꥹȤ */
			select_list_all_free();
//			Dim_now.FontType = 1;
			break;
	}
	return 1;
}



/* ---------------------------------------------------------
 * Ⱦˡ ⡼ (Main)
 */
int MouseMode_DimensionR(GtkWidget *widget, int Button, int x, int y)
{
	switch (Button) {
		/* ܥ */
		case 1:
			switch ( select_list_num() ) {
				/* 쥯ȥǡ */
				case 0:
					MouseSelect(widget, ToViewX(x), ToViewY(y), 12, 1);
					break;
				case 1:
					MouseSelect(widget, ToViewX(x), ToViewY(y), DcObj, 1);
					break;
			}
			break;

		/* ܥ */
		case 2:
			if(select_list_num() == 1)
				MouseSelect(widget, ToViewX(x), ToViewY(y), 128, 1);
			break;

		/* ܥ */
		case 4:
			break;
	}
	return 1;
}



/* ---------------------------------------------------------
 * Ⱦˡ ⡼ (Return)
 */
int MouseRet_DimensionR(GtkWidget *widget, int Button, int x, int y)
{
	char mstr[256];
	struct RtnDat ISAEAH;


	switch ( select_list_num() ) {
		case 0:
			sprintf(mstr, _(" [Radius Dimansion] circle or arc") );
			StatusMsg(mstr);
			break;
		case 1:
			sprintf(mstr, _(" [Radius Dimansion] What place ?") );
			StatusMsg(mstr);
			SelectCadDraw(widget, select_search_num(1)->select->diagram_point.cad_point, SCD_SELECT);
			UpDate();

			PicPoint.X[1] = select_search_num(1)->select->diagram_point.cad_point->cx;
			PicPoint.Y[1] = select_search_num(1)->select->diagram_point.cad_point->cy;
			PicPoint.X[3] = select_search_num(1)->select->diagram_point.cad_point->r;
			if (select_search_num(1)->select->diagram_point.cad_point->code == 2) {
				iSaEa(cad_search_cad(select_search_num(1)->select->diagram_point.cad_point, &cad_list_info), &ISAEAH);
				PicPoint.X[4] = ISAEAH.sx[1];
				PicPoint.Y[4] = ISAEAH.sy[1];
			}
			else if (select_search_num(1)->select->diagram_point.cad_point->code == 4) {
				PicPoint.X[4] = 0;
				PicPoint.Y[4] = 360;
			}
			break;
		case 2:
			Dimension_R_Culc(&Dim_now, PicPoint);
			if (Dim_now.AssistLine != NULL) {
				sprintf(mstr, _(" [Radius Dimansion] circle or arc") );
				StatusMsg(mstr);
				SelectCadDraw(widget, select_search_num(1)->select->diagram_point.cad_point, SCD_ORG);
				DimensionDraw(widget, &Dim_now, SCD_HIDE);
//				Dim_now.FontType = sagcad_dimension.font_Type;
				DimensionDraw(drawing_area, &Dim_now, SCD_ORG);
				UpDate();
				/* ˡ ɲ */
				undo_index_plus();
				dimension_list_add_first_with_undo(&Dim_now, &dimension_list_info);
				Dim_old.Text[0] = '\0';
				Dim_now.diagram_of_char_index = 0;
				Dim_now.diagram_of_char = NULL;
				Dim_now.AssistLine = NULL;
				/* ꥹȤ */
				select_list_all_free();
//				Dim_now.FontType = 1;
			}
			else {
				select_list_free(select_list_info.tail);
				sprintf(mstr, _(" [Radius Dimansion] What place ?") );
				StatusMsg(mstr);
			}
			break;
	}
	return 1;
}





/* ---------------------------------------------------------
 * ľˡ ⡼ (Main)
 */
int MouseMode_DimensionD(GtkWidget *widget, int Button, int x, int y)
{
	switch (Button) {
		/* ܥ */
		case 1:
			switch ( select_list_num() ) {
				/* 쥯ȥǡ */
				case 0:
					MouseSelect(widget, ToViewX(x), ToViewY(y), 12, 1);
					break;
				case 1:
					MouseSelect(widget, ToViewX(x), ToViewY(y), DcObj, 1);
					break;
			}
			break;

		/* ܥ */
		case 2:
			if(select_list_num() == 1)
				MouseSelect(widget, ToViewX(x), ToViewY(y), 128, 1);
			break;

		/* ܥ */
		case 4:
			break;
	}
	return 1;
}



/* ---------------------------------------------------------
 * ľˡ ⡼ (Return)
 */
int MouseRet_DimensionD(GtkWidget *widget, int Button, int x, int y)
{
	char mstr[256];

	switch ( select_list_num() ) {
		case 0:
			sprintf(mstr, _(" [Diameter Dimension] circle or arc") );
			StatusMsg(mstr);
			break;
		case 1:
			sprintf(mstr, _(" [Diameter Dimension] What place ?") );
			StatusMsg(mstr);
			SelectCadDraw(widget, select_search_num(1)->select->diagram_point.cad_point, SCD_SELECT);
			UpDate();

			PicPoint.X[1] = select_search_num(1)->select->diagram_point.cad_point->cx;
			PicPoint.Y[1] = select_search_num(1)->select->diagram_point.cad_point->cy;
			PicPoint.X[6] = select_search_num(1)->select->diagram_point.cad_point->r;
			break;
		case 2:
			sprintf(mstr, _(" [Diameter Dimension] circle or arc") );
			StatusMsg(mstr);
			SelectCadDraw(widget, select_search_num(1)->select->diagram_point.cad_point, SCD_ORG);
			PicPoint.X[2] = select_search_num(2)->select->x;
			PicPoint.Y[2] = select_search_num(2)->select->y;
			Dimension_D_Culc(&Dim_now, PicPoint);
			DimensionDraw(widget, &Dim_now, SCD_HIDE);
//			Dim_now.FontType = sagcad_dimension.font_Type;
			DimensionDraw(drawing_area, &Dim_now, SCD_ORG);
			UpDate();
			/* ˡ ɲ */
			undo_index_plus();
			dimension_list_add_first_with_undo(&Dim_now, &dimension_list_info);
			Dim_old.Text[0] = '\0';
			Dim_now.diagram_of_char_index = 0;
			Dim_now.diagram_of_char = NULL;
			Dim_now.AssistLine = NULL;
			/* ꥹȤ */
			select_list_all_free();
//			Dim_now.FontType = 1;
			break;
	}
	return 1;
}





/* ---------------------------------------------------------
 * ˡ ⡼ (Main)
 */
int MouseMode_DimensionA(GtkWidget *widget, int Button, int x, int y)
{
	switch (Button) {
		/* ܥ */
		case 1:
			MouseSelect(widget, ToViewX(x), ToViewY(y), DcObj, 1);
			break;
		/* ܥ */
		case 2:
			MouseSelect(widget, ToViewX(x), ToViewY(y), 128, 1);
			break;
		/* ܥ */
		case 4:
			break;
	}
	return 1;
}



/* ---------------------------------------------------------
 * ˡ ⡼ (Return)
 */
int MouseRet_DimensionA(GtkWidget *widget, int Button, int x, int y)
{
	char mstr[256];

	switch ( select_list_num() ) {
		case 0:
			sprintf(mstr, _(" [Angle Dimension] Center point") );
			StatusMsg(mstr);
			break;
		case 1:
			sprintf(mstr, _(" [Angle Dimension] 1st point") );
			StatusMsg(mstr);
			PointDraw(drawing_area, select_search_num(1)->select->x, select_search_num(1)->select->y, 1, sagcad_color.Select);
			UpDate();

			PicPoint.X[1] = select_search_num(1)->select->x;
			PicPoint.Y[1] = select_search_num(1)->select->y;
			break;
			
		case 2:
			if (PicPointCheck(widget, Button, x, y, 2)) break;
			sprintf(mstr, _(" [Angle Dimension] 2nd point") );
			StatusMsg(mstr);
			PointDraw(drawing_area, select_search_num(2)->select->x, select_search_num(2)->select->y, 1, sagcad_color.Select);
			UpDate();

			PicPoint.X[2] = select_search_num(2)->select->x;
			PicPoint.Y[2] = select_search_num(2)->select->y;
			break;
			
		case 3:
			if (PicPointCheck(widget, Button, x, y, 3)) break;
			if(Dim_old.Text[0] == '\0'){
				sprintf(mstr, _(" [Angle Dimension] What place ?") );
				StatusMsg(mstr);
				PointDraw(drawing_area, select_search_num(3)->select->x, select_search_num(3)->select->y, 1, sagcad_color.Select);
				UpDate();

				PicPoint.X[3] = select_search_num(3)->select->x;
				PicPoint.Y[3] = select_search_num(3)->select->y;
			}
			break;
			
		case 4:
			if (PicPointCheck(widget, Button, x, y, 4)) break;
			sprintf(mstr, _(" [Angle Dimension] Center point") );
			StatusMsg(mstr);
			PointDraw(drawing_area, select_search_num(1)->select->x, select_search_num(1)->select->y, 1, sagcad_color.Back);
			PointDraw(drawing_area, select_search_num(2)->select->x, select_search_num(2)->select->y, 1, sagcad_color.Back);
			PointDraw(drawing_area, select_search_num(3)->select->x, select_search_num(3)->select->y, 1, sagcad_color.Back);

			PicPoint.X[4] = select_search_num(4)->select->x;
			PicPoint.Y[4] = select_search_num(4)->select->y;
			Dimension_A_Culc(&Dim_now, PicPoint);
			DimensionDraw(widget, &Dim_now, SCD_HIDE);
//			Dim_now.FontType = sagcad_dimension.font_Type;
			DimensionDraw(widget, &Dim_now, SCD_ORG);
			UpDate();
			/* ˡ ɲ */
			undo_index_plus();
			dimension_list_add_first_with_undo(&Dim_now, &dimension_list_info);
			Dim_old.Text[0] = '\0';
			Dim_now.diagram_of_char_index = 0;
			Dim_now.diagram_of_char = NULL;
			Dim_now.AssistLine = NULL;
			/* ꥹȤ */
			select_list_all_free();
//			Dim_now.FontType = 1;
			break;
	}
	return 1;
}





/* ---------------------------------------------------------
 * ɸˡ ⡼ (Main)
 */
int MouseMode_DimensionPT(GtkWidget *widget, int Button, int x, int y)
{
	switch (Button) {
		/* ܥ */
		case 1:
			MouseSelect(widget, ToViewX(x), ToViewY(y), DcObj, 1);
			break;
		/* ܥ */
		case 2:
			MouseSelect(widget, ToViewX(x), ToViewY(y), 128, 1);
			break;
		/* ܥ */
		case 4:
			break;
	}
	return 1;
}



/* ---------------------------------------------------------
 * ɸˡ ⡼ (Return)
 */
int MouseRet_DimensionPT(GtkWidget *widget, int Button, int x, int y)
{
	char mstr[256];

	switch ( select_list_num() ) {
		/* 쥯ȥǡ */
		case 0:
			sprintf(mstr, _(" [Coordinates Dimension] point") );
			StatusMsg(mstr);
			break;
		case 1:
			sprintf(mstr, _(" [Coordinates Dimension] What place ?") );
			StatusMsg(mstr);
			PointDraw(drawing_area, select_search_num(1)->select->x, select_search_num(1)->select->y, 1, sagcad_color.Select);
			UpDate();
			PicPoint.X[1] = select_search_num(1)->select->x;
			PicPoint.Y[1] = select_search_num(1)->select->y;
			break;
		case 2:
			if (PicPointCheck(widget, Button, x, y, 2)) break;
			sprintf(mstr, _(" [Coordinates Dimension] point") );
			StatusMsg(mstr);
			PointDraw(drawing_area, select_search_num(1)->select->x, select_search_num(1)->select->y, 1, sagcad_color.Back);
			PicPoint.X[2] = select_search_num(2)->select->x;
			PicPoint.Y[2] = select_search_num(2)->select->y;
			Dimension_PT_Culc(&Dim_now, PicPoint);
			DimensionDraw(widget, &Dim_now, SCD_HIDE);
//			Dim_now.FontType = sagcad_dimension.font_Type;
			DimensionDraw(widget, &Dim_now, SCD_ORG);
			UpDate();
			/* ˡ ɲ */
			undo_index_plus();
			dimension_list_add_first_with_undo(&Dim_now, &dimension_list_info);
			Dim_old.Text[0] = '\0';
			Dim_now.diagram_of_char_index = 0;
			Dim_now.diagram_of_char = NULL;
			Dim_now.AssistLine = NULL;
			/* ꥹȤ */
			select_list_all_free();
//			Dim_now.FontType = 1;
			break;
	}
	return 1;
}





/* ---------------------------------------------------------
 * ˡ ⡼ (Main)
 */
int MouseMode_DimensionHD(GtkWidget *widget, int Button, int x, int y)
{
	switch (Button) {
		/* ܥ */
		case 1:
			MouseSelect(widget, ToViewX(x), ToViewY(y), DcObj, 1);
			break;
		/* ܥ */
		case 2:
			MouseSelect(widget, ToViewX(x), ToViewY(y), 128, 1);
			break;
		/* ܥ */
		case 4:
			break;
	}
	return 1;
}



/* ---------------------------------------------------------
 * ˡ ⡼ (Return)
 */
int MouseRet_DimensionHD(GtkWidget *widget, int Button, int x, int y)
{
	double scale;
	TEXT_EDIT_DLG a;
	char mstr[256];

	switch ( select_list_num() ) {
		/* 쥯ȥǡ */
		case 0:
			sprintf(mstr, _(" [Drawer Line Dimension] The tip of the arrow") );
			StatusMsg(mstr);
			break;
		case 1:
			sprintf(mstr, _(" [Drawer Line Dimension] To what place") );
			StatusMsg(mstr);

			PicPoint.X[1] = select_search_num(1)->select->x;
			PicPoint.Y[1] = select_search_num(1)->select->y;
			PicPoint.X[3] = 0;
			PicPoint.Y[3] = 0;
			break;
		case 2:
			sprintf(mstr, _(" [Drawer Line Dimension] What place ?") );
			StatusMsg(mstr);
			PointDraw(drawing_area, select_search_num(1)->select->x, select_search_num(1)->select->y, 1, sagcad_color.Select);
			UpDate();

			PicPoint.X[1] = select_search_num(1)->select->x;
			PicPoint.Y[1] = select_search_num(1)->select->y;
			PicPoint.X[2] = select_search_num(2)->select->x;
			PicPoint.Y[2] = select_search_num(2)->select->y;
			break;

		case 3:
			sprintf(mstr, _(" [Drawer Line Dimension] The tip of the arrow") );
			StatusMsg(mstr);
			PointDraw(drawing_area, select_search_num(1)->select->x, select_search_num(1)->select->y, 1, sagcad_color.Back);
			PicPoint.X[1] = select_search_num(1)->select->x;
			PicPoint.Y[1] = select_search_num(1)->select->y;
			PicPoint.X[2] = select_search_num(2)->select->x;
			PicPoint.Y[2] = select_search_num(2)->select->y;
			PicPoint.X[3] = select_search_num(3)->select->x;
			PicPoint.Y[3] = select_search_num(3)->select->y;
			Dimension_HD_Culc(&Dim_now, PicPoint);
			DimensionDraw(widget, &Dim_now, SCD_ORG);
			UpDate();
			/* ˡ ɲ */
			undo_index_plus();
			dimension_list_add_first_with_undo(&Dim_now, &dimension_list_info);
			Dim_old.Text[0] = '\0';
			Dim_now.diagram_of_char_index = 0;
			Dim_now.diagram_of_char = NULL;
			Dim_now.AssistLine = NULL;
			/* ꥹȤ */
			select_list_all_free();
//			Dim_now.FontType = sagcad_dimension.font_Type;



			/* ޥɥ饤ɽ */
			sprintf(mstr, _(" [Drawer Line Dimension] Setting dialog") );
			StatusMsg(mstr);


			/* TextEditDialog */
			strcpy(a.Text, "");
			strcpy(a.UpperText, "");
			strcpy(a.LowerText, "");

			a.FontHeight = sagcad_dimension.Font_height;
			scale = a.FontHeight / 9;
			a.FontSpace = sagcad_dimension.Font_space * scale;
			a.WordSpace = sagcad_dimension.Word_space * scale;
			a.FontOverLineSpace = sagcad_dimension.Font_space_line * scale;

			a.Angle = 0;
			a.SearchPointX = 0;
			a.SearchPointY = 0;
			a.FitPointX = 0;
			a.FitPointY = 1;


			a.entry_Text = NULL;
			a.entry_UpperText = NULL;
			a.entry_LowerText = NULL;

			a.entry_FontHeight = NULL;
			a.entry_FontSpace = NULL;
			a.entry_WordSpace = NULL;
			a.entry_FontOverLineSpace = NULL;
			a.entry_SearchPointX = NULL;
			a.entry_SearchPointY = NULL;
			a.entry_Angle = NULL;
			a.entry_FitPointX = NULL;
			a.entry_FitPointY = NULL;

			a.parent = MainWindow;
			a.dialog = NULL;

			TextEditDialog(&a);
			if (a.FontHeight == 0) {
				SelectCancel(drawing_area);
				mode = 0;
				return 0;
			}

			strcpy(Dim_now.Text, a.Text);
			strcpy(Dim_now.UpperText, a.UpperText);
			strcpy(Dim_now.LowerText, a.LowerText);
			Dim_now.FontHeight = a.FontHeight;
			Dim_now.FontSpace = a.FontSpace;
			Dim_now.WordSpace = a.WordSpace;
			Dim_now.FontOverLineSpace = a.FontOverLineSpace;


			ReturnFunc = MouseRet_DimensionHD;
			DcObj = 113;
			Dim_now.Type = 80;
			Dim_now.Layer = NowLayer;
			Dim_now.text_color = sagcad_color.Dimension;
			Dim_now.Assist_color = sagcad_color.Dimension;

			Dim_now.FontType = sagcad_dimension.font_Type;
			Dim_now.DrawType = DRAW_REAL;
			Dim_old.Text[0] = '\0';
			
			Dim_now.start.x = 0;
			Dim_now.start.y = 0;
			Dim_now.end.x = 0;
			Dim_now.end.y = 0;

			Dim_now.diagram_of_char_index = 0;
			Dim_now.diagram_of_char = NULL;
			Dim_now.index = 0;
			Dim_now.AssistLine = NULL;
			mode = 580;
			(*ReturnFunc)(drawing_area, 1, 0, 0);
			break;
	}
	return 1;
}





/* ---------------------------------------------------------
 * ˡ ⡼ (Main)
 */
int MouseMode_DimensionAT(GtkWidget *widget, int Button, int x, int y)
{
	switch (Button) {
		/* ܥ */
		case 1:
			MouseSelect(widget, ToViewX(x), ToViewY(y), DcObj, 1);
			break;
		/* ܥ */
		case 2:
			MouseSelect(widget, ToViewX(x), ToViewY(y), 128, 1);
			break;
		/* ܥ */
		case 4:
			break;
	}
	return 1;
}



/* ---------------------------------------------------------
 * ˡ ⡼ (Return)
 */
int MouseRet_DimensionAT(GtkWidget *widget, int Button, int x, int y)
{
	double scale;
	TEXT_EDIT_DLG a;
	char mstr[256];

	switch ( select_list_num() ) {
		case 1:
			sprintf(mstr, _(" [String] What place ?") );
			StatusMsg(mstr);
			Dim_now.SearchPointX = select_search_num(1)->select->x;
			Dim_now.SearchPointY = select_search_num(1)->select->y;
			DimensionDraw(drawing_area, &Dim_now, SCD_ORG);
			UpDate();
			/* ˡ ɲ */
			undo_index_plus();
			dimension_list_add_first_with_undo(&Dim_now, &dimension_list_info);
			Dim_old.Text[0] = '\0';
			Dim_now.diagram_of_char_index = 0;
			Dim_now.diagram_of_char = NULL;
			Dim_now.AssistLine = NULL;
			/* ꥹȤ */
			select_list_all_free();
//			Dim_now.FontType = 1;


			/* ޥɥ饤ɽ */
			sprintf(mstr, _(" [String] Input string") );
			StatusMsg(mstr);


			/* TextEditDialog */
			strcpy(a.Text, "");
			strcpy(a.UpperText, "");
			strcpy(a.LowerText, "");

			a.FontHeight = sagcad_dimension.Font_height;
			scale = a.FontHeight / 9;
			a.FontSpace = sagcad_dimension.Font_space * scale;
			a.WordSpace = sagcad_dimension.Word_space * scale;
			a.FontOverLineSpace = sagcad_dimension.Font_space_line * scale;

			a.Angle = 0;
			a.SearchPointX = 0;
			a.SearchPointY = 0;
			a.FitPointX = 0;
			a.FitPointY = 1;


			a.entry_Text = NULL;
			a.entry_UpperText = NULL;
			a.entry_LowerText = NULL;

			a.entry_FontHeight = NULL;
			a.entry_FontSpace = NULL;
			a.entry_WordSpace = NULL;
			a.entry_FontOverLineSpace = NULL;
			a.entry_SearchPointX = NULL;
			a.entry_SearchPointY = NULL;
			a.entry_Angle = NULL;
			a.entry_FitPointX = NULL;
			a.entry_FitPointY = NULL;

			a.parent = MainWindow;
			a.dialog = NULL;

			TextEditDialog(&a);
			if (a.FontHeight == 0) {
				SelectCancel(drawing_area);
				mode = 0;
				return 0;
			}

			strcpy(Dim_now.Text, a.Text);
			strcpy(Dim_now.UpperText, a.UpperText);
			strcpy(Dim_now.LowerText, a.LowerText);
			Dim_now.FontHeight = a.FontHeight;
			Dim_now.FontSpace = a.FontSpace;
			Dim_now.WordSpace = a.WordSpace;
			Dim_now.FontOverLineSpace = a.FontOverLineSpace;


			ReturnFunc = MouseRet_DimensionAT;
			DcObj = 113;
			Dim_now.Type = 90;
			Dim_now.Layer = NowLayer;
			Dim_now.text_color = sagcad_color.Dimension;
			Dim_now.Assist_color = sagcad_color.Dimension;

			Dim_now.FontType = sagcad_dimension.font_Type;
			Dim_now.DrawType = DRAW_REAL;
			Dim_old.Text[0] = '\0';
			
			Dim_now.start.x = 0;
			Dim_now.start.y = 0;
			Dim_now.end.x = 0;
			Dim_now.end.y = 0;

			Dim_now.diagram_of_char_index = 0;
			Dim_now.diagram_of_char = NULL;
			Dim_now.index = 0;
			Dim_now.AssistLine = NULL;
			mode = 590;
			(*ReturnFunc)(drawing_area, 1, 0, 0);


			/* ޥɥ饤ɽ */
			sprintf(mstr, _(" [String] What place ?") );
			StatusMsg(mstr);
			break;
	}
	return 1;
}





/* -------------------------------------------------------------------
 * ˡ & ƥ Խ ⡼(Main)
 */
int MouseMode_DimensionEDT(GtkWidget *widget, int Button, int x, int y)
{
	switch (Button) {
		/* ܥ */
		case 1:
			MouseSelect(widget, ToViewX(x), ToViewY(y), 256, 1);
			break;
		/* ܥ */
		case 2:
			break;
		/* ܥ */
		case 4:
			break;
	}
	return 1;
}



/* -------------------------------------------------------------------
 * ˡ & ƥ Խ ⡼(Return)
 */
int MouseRet_DimensionEDT(GtkWidget *widget, int Button, int x, int y)
{
	TEXT_EDIT_DLG a;
	DIMENSION *dp, d;
	char mstr[256];


	if ( select_list_info.head != NULL 
		&& select_list_info.head->select->index == 3 
			&& select_list_info.head->select->diagram_point.dimension_point != NULL) 
	{
		sprintf(mstr, _(" [Edit Dimension] Edit text") );
		StatusMsg(mstr);

		/* TextEditDialog */
		dp = select_list_info.head->select->diagram_point.dimension_point;
		strcpy(a.Text, dp->Text);
		strcpy(a.UpperText, dp->UpperText);
		strcpy(a.LowerText, dp->LowerText);

		a.FontHeight = dp->FontHeight;
		a.FontSpace = dp->FontSpace;
		a.WordSpace = dp->WordSpace;
		a.FontOverLineSpace = dp->FontOverLineSpace;

		a.Angle = dp->Angle;
		a.SearchPointX = dp->SearchPointX;
		a.SearchPointY = dp->SearchPointY;
		a.FitPointX = dp->FitPointX;
		a.FitPointY = dp->FitPointY;


		a.entry_Text = NULL;
		a.entry_UpperText = NULL;
		a.entry_LowerText = NULL;

		a.entry_FontHeight = NULL;
		a.entry_FontSpace = NULL;
		a.entry_WordSpace = NULL;
		a.entry_FontOverLineSpace = NULL;
		a.entry_SearchPointX = NULL;
		a.entry_SearchPointY = NULL;
		a.entry_Angle = NULL;
		a.entry_FitPointX = NULL;
		a.entry_FitPointY = NULL;

		a.parent = MainWindow;
		a.dialog = NULL;

		TextEditDialog(&a);
		if (a.FontHeight == 0) {
			SelectCancel(drawing_area);
			mode = 0;
			return 0;
		}

		d.Layer = dp->Layer;
		d.text_color = dp->text_color;
		d.Assist_color = dp->Assist_color;
		d.Type = dp->Type;
		d.DrawType = dp->DrawType;

		strcpy(d.Text, a.Text);
		strcpy(d.UpperText, a.UpperText);
		strcpy(d.LowerText, a.LowerText);

		d.FontType = dp->FontType;
		strcpy(d.FontName, dp->FontName);

		d.FontHeight = a.FontHeight;
		d.FontSpace = a.FontSpace;
		d.WordSpace = a.WordSpace;
		d.FontOverLineSpace = a.FontOverLineSpace;

		d.Angle = a.Angle;
		d.SearchPointX = a.SearchPointX;
		d.SearchPointY = a.SearchPointY;
		d.StartPoint = dp->StartPoint;
		d.FitPointX = a.FitPointX;
		d.FitPointY = a.FitPointY;

		
		xfree(dp->diagram_of_char);
		dp->diagram_of_char_index = 0;
		dp->diagram_of_char = NULL;

		d.diagram_of_char_index = 0;
		d.diagram_of_char = NULL;
		d.index = dp->index;
		d.AssistLine = dp->AssistLine;

		SelectDraw(widget, select_list_info.head->select, SCD_HIDE, UPDATE_OFF);
		undo_index_plus();
		dimension_list_edit_with_undo(dimension_search_dimension(dp, &dimension_list_info), &d, &dimension_list_info);
		SelectDraw(widget, select_list_info.head->select, SCD_ORG, UPDATE_ON);


	}
	/* ꥹȤ */
	select_list_all_free();
	sprintf(mstr, _(" [Edit Dimension] Dimension element"));
	StatusMsg(mstr);
	return 1;
}





/* -------------------------------------------------------------------
 * ݥ饤⡼ (Main)
 */
int MouseMode_PolyLine(GtkWidget *widget, int Button, int x, int y)
{
	SELECT_LIST *slp;
	POLYLINE polyline;
	POLYLINE_LIST *pllp;
	VERTEX vertex;
	long n, i;
	char str[256];
	int Ret;


	switch (Button) {
		/* ܥ */
		case 1:
			/*  */
			MouseSelect(widget, ToViewX(x), ToViewY(y), 1, 1);
			break;
		/* ܥ */
		case 2:
			/* Ǥ */
			MouseSelect(widget, ToViewX(x), ToViewY(y), 128, 0);
			break;
		/* ܥ */
		case 4:
			/* λ */
			n = select_list_num();
			if (n > 2) {
				/* -----------------------------------------------------------------
				 * ޷
				 */
				i = 0;
				slp = select_list_info.head;
				/* -------------------------------------------
				 * ǸޤǸĤʤ硢 p  NULL  
				 * äƥ롼פȴ롣
				 */
				polyline.vertex_list_info.head = NULL;
				polyline.vertex_list_info.tail = NULL;

				while (slp != NULL) {
					/* Ǥ */
					if (slp->select->index == 1) {
						vertex.x = slp->select->x;
						vertex.y = slp->select->y;
						vertex_list_add_last(&vertex, &polyline.vertex_list_info);
					}

					/*  */
					else if (   (slp->select->index == 2 || slp->select->index == 4) 
								&& 
								(slp->select->diagram_point.cad_point != NULL)   )
					{
						vertex.x = slp->select->diagram_point.cad_point->sx;
						vertex.y = slp->select->diagram_point.cad_point->sy;
						vertex_list_add_last(&vertex, &polyline.vertex_list_info);
					}

					/* ¾ */
					else {
						//
					}

					slp = slp->next;	/* ݥ󥿤򼡤Υǡ˰ܤ */
				}

				/*  */
				/* ϥܥåɽ */
				strcpy(str, "");
				Ret = CulcInputBox(MainWindow, _("Curve Setting") , _("0:broken line (open)  1:broken line (close)") , 
								   _("2:open spline  3:close spline  4:B-spline") , str);
				if (Ret == -1) {
					/* ꥹȤ */
					select_list_all_free();
					/* åɽ */
					(*ReturnFunc)(widget, Button, x, y);
					return 0;
				}

				/* ޤ */
				if (atoi(str) == 0) {
					polyline.code = 8;
					polyline.frag = 0;
				}
				/* ޤ() */
				else if (atoi(str) == 1) {
					polyline.code = 8;
					polyline.frag = 1;
				}
				/* ץ饤 */
				else if (atoi(str) == 2) {
					polyline.code = 16;
					polyline.frag = 0;
				}
				/* ץ饤() */
				else if (atoi(str) == 3) {
					polyline.code = 16;
					polyline.frag = 1;
				}
				/* ¥ץ饤 */
				else if (atoi(str) == 4) {
					polyline.code = 32;
					polyline.frag = 0;
				}
				/* Ͽ */
				polyline.layer = NowLayer;
				polyline.style = 1;
				polyline.color = NowColor;
				polyline.pitch = 0.05;
				polyline.split = 7;
				polyline.index = vertex_list_num(&polyline.vertex_list_info);
				/* POLYLINE Data ꥹȤκǸɲ */
				undo_index_plus();
				pllp = polyline_list_add_first_with_undo(&polyline, &polyline_list_info);

				PolyLineDraw(widget, pllp->polyline, SCD_ORG);
			}
			/* ꥹȤ */
			select_list_all_free();
			/* åɽ */
			(*ReturnFunc)(widget, Button, x, y);
			break;
	}
	return 0;
}



/* -------------------------------------------------------
 * ݥ饤⡼ɥ⡼ (Return)
 */
int MouseRet_PolyLine(GtkWidget *widget, int Button, int x, int y)
{
//char str[256];
	char mstr[256];
	long n;



	n = select_list_num();
	/* 쥯ȥǡ */
	switch ( n ) {
		case 0:
			/* åɽ */
			sprintf(mstr, _(" [Polyline] Start point (End : Center Button)") );
			StatusMsg(mstr);
			break;
		case 1:
			/* åɽ */
			sprintf(mstr, _(" [Polyline] 2nd point (End : Center Button) (S %d)") , (int) n);
			StatusMsg(mstr);
			break;
		case 2:
			/* åɽ */
			sprintf(mstr, _(" [Polyline] 3rd point (End : Center Button) (S %d)") , (int) n);
			StatusMsg(mstr);
			break;
		default:
			/* åɽ */
			sprintf(mstr, _(" [Polyline] %d point (End : Center Button) (S %d)") , 
				(int) n, (int) n);
			StatusMsg(mstr);
			break;
	}


	/* ɽ */
	if (n == 1) {
		if (select_list_info.tail->select->index == 1) {
			PointDraw(widget, select_search_num(n)->select->x, select_search_num(n)->select->y, 1, 0x0000ff);
		}
		else if (	select_list_info.tail->select->index == 2 
					|| 
					select_list_info.tail->select->index == 4
				) 
		{
			SelectCadDraw(widget, select_list_info.tail->select->diagram_point.cad_point, SCD_SELECT);
		}
	}
	/* ܰʹߤϡɽ */
	else if (n > 1) {
		if (select_list_info.tail->select->index == 1) {
			PointDraw(	widget, 
						select_list_info.tail->select->x, 
						select_list_info.tail->select->y, 1, 0x0000ff);

			if (select_search_num(n-1)->select->index == 1) {
				LineDraw(	widget, 
							select_search_num(n-1)->select->x, 
							select_search_num(n-1)->select->y, 
							select_list_info.tail->select->x, 
							select_list_info.tail->select->y, 
							1, 
							NowColor);
			}
			else if (	select_search_num(n-1)->select->index == 2 
						|| 
						select_search_num(n-1)->select->index == 4) 
			{
				LineDraw(	widget, 
							select_search_num(n-1)->select->diagram_point.cad_point->sx, 
							select_search_num(n-1)->select->diagram_point.cad_point->sy, 
							select_list_info.tail->select->x, 
							select_list_info.tail->select->y, 
							1, 
							NowColor);
			}
		}

		else if (	select_list_info.tail->select->index == 2 
					|| 
					select_list_info.tail->select->index == 4
				) 
		{
			SelectCadDraw(widget, select_list_info.tail->select->diagram_point.cad_point, SCD_SELECT);

			if (select_search_num(n-1)->select->index == 1) {
				LineDraw(	widget, 
							select_search_num(n-1)->select->x, 
							select_search_num(n-1)->select->y, 
							select_list_info.tail->select->diagram_point.cad_point->sx, 
							select_list_info.tail->select->diagram_point.cad_point->sy, 
							1, 
							NowColor);
			}
			else if (	select_search_num(n-1)->select->index == 2 
						|| 
						select_search_num(n-1)->select->index == 4) 
			{
				LineDraw(	widget, 
							select_search_num(n-1)->select->diagram_point.cad_point->sx, 
							select_search_num(n-1)->select->diagram_point.cad_point->sy, 
							select_list_info.tail->select->diagram_point.cad_point->sx, 
							select_list_info.tail->select->diagram_point.cad_point->sy, 
							1, 
							NowColor);
			}
		}
	}
	UpDate();
	return 0;
}





/* -------------------------------------------------------------------
 * ã  (Main)
 */
int MouseMode_CamProfile(GtkWidget *widget, int Button, int x, int y)
{
	CAM_SET_DLG cam_set_dlg;
	SELECT *select = NULL;
	CAD *cad;
	static int frag = 2; /* 2:ž	4:ȿž */
	CAM_ENV CamProperty;


	switch (Button) {
		/* ܥ */
		case 1:
			if (select_list_num() == CopyFrag) {
				MouseSelect(widget, ToViewX(x), ToViewY(y), 6, 2);
			}
			if (select_list_num() == CopyFrag + 1) {
				if (select_list_info.tail->select->diagram_point.cad_point->code == 1) {
					if (frag == 2) {
						SelectChain2_S_Bow(	select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											sagcad_color.Back);
					}
					if (frag == 4) {
						SelectChain2_S_Bow(	select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											sagcad_color.Back);
					}
				}
				if (select_list_info.tail->select->diagram_point.cad_point->code == 2) {
					SelectChain2_ArcBow(	select_list_info.tail->select->diagram_point.cad_point->cx, 
											select_list_info.tail->select->diagram_point.cad_point->cy, 
											select_list_info.tail->select->diagram_point.cad_point->r, 
											select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											sagcad_color.Back, frag);
				}
				cad = select_list_info.tail->select->diagram_point.cad_point;
				select_last_cansel();
				SelectCadDraw (drawing_area, cad, SCD_SELECT);
				UpDate();

				select = select_search_cad(cad)->select;
				select_search_cad(cad)->select = select_list_info.head->select;
				select_list_info.head->select = select;


				/*  */
//				cam_set_dlg.CamCheck = sagcad_cam.CamCheck;
				cam_set_dlg.AbsInc = sagcad_cam.AbsInc;
				cam_set_dlg.Modal = sagcad_cam.Modal;
				cam_set_dlg.RIJ = sagcad_cam.RIJ;
				cam_set_dlg.Heel = sagcad_cam.Heel;
				cam_set_dlg.start_str = NULL;
				cam_set_dlg.end_str = NULL;

				cam_set_dlg.value = 0;
				cam_set_dlg.toggle_frag = 0;

				cam_set_dlg.abs_check = NULL;
				cam_set_dlg.inc_check = NULL;
				cam_set_dlg.r_check = NULL;
				cam_set_dlg.ij_check = NULL;
				cam_set_dlg.modal_off_check = NULL;
				cam_set_dlg.modal_on_check = NULL;
				cam_set_dlg.start_text = NULL;
				cam_set_dlg.end_text = NULL;
				cam_set_dlg.parent = MainWindow;
				cam_set_dlg.dialog = NULL;


				CamSetDialog(&cam_set_dlg);

				if (cam_set_dlg.value == 0) {
					// g_print("Cancel ޤ\n");
					return 0;
				}
#ifdef TEST
				else {
					g_print ("AbsInc = %d   Modal = %d   RIJ = %d   Heel = %d\n", 
							 cam_set_dlg.AbsInc, 
							 cam_set_dlg.Modal, 
							 cam_set_dlg.RIJ, 
							 cam_set_dlg.Heel 
							);
				}
#endif


//#ifdef TEST
				CamDataRead(frag);

				CamProperty.CamCheck = 1;
				CamProperty.AbsInc = cam_set_dlg.AbsInc;
				CamProperty.Modal = cam_set_dlg.Modal;
				CamProperty.RIJ = cam_set_dlg.RIJ;
				CamProperty.Heel = cam_set_dlg.Heel;
				if (cam_set_dlg.start_str != NULL) {
					strcpy(CamProperty.StartStr, cam_set_dlg.start_str);
					//g_print ("Start Code\n%s\n", cam_set_dlg.start_str);
					g_free(cam_set_dlg.start_str);
					cam_set_dlg.start_str = NULL;
				}
				else {
					CamProperty.StartStr[0] = '\0';
				}
				if (cam_set_dlg.end_str != NULL) {
					strcpy(CamProperty.EndStr, cam_set_dlg.end_str);
					//g_print ("End Code\n%s\n", cam_set_dlg.end_str);
					g_free(cam_set_dlg.end_str);
					cam_set_dlg.end_str = NULL;
				}
				else {
					CamProperty.EndStr[0] = '\0';
				}

				if ( Hitohude(CamProperty.CamCheck) != 0 ) {
					NcOut(CamProperty);
				}
				frag = 2;
				ReturnFunc = MouseRet_Select;
				DcObj = 15+256;
				mode = 300;
				(*ReturnFunc)(drawing_area, 1, 0, 0);
//#endif

			}
			break;
		/* ܥ */
		case 2:
			if (select_list_num() == CopyFrag + 1) {
				if (frag == 2) frag = 4;
				else if (frag == 4) frag = 2;

				if (select_list_info.tail->select->diagram_point.cad_point->code == 1) {
					if (frag == 2) {
						SelectChain2_S_Bow(	select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											sagcad_color.Back);
						SelectChain2_S_Bow(	select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											sagcad_color.Cam);
					}
					if (frag == 4) {
						SelectChain2_S_Bow(	select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											sagcad_color.Back);
						SelectChain2_S_Bow(	select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											sagcad_color.Cam);
					}
				}
				if (select_list_info.tail->select->diagram_point.cad_point->code == 2) {
					if (frag == 2) {
						SelectChain2_ArcBow(select_list_info.tail->select->diagram_point.cad_point->cx, 
											select_list_info.tail->select->diagram_point.cad_point->cy, 
											select_list_info.tail->select->diagram_point.cad_point->r, 
											select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											sagcad_color.Back, 4);
						SelectChain2_ArcBow(select_list_info.tail->select->diagram_point.cad_point->cx, 
											select_list_info.tail->select->diagram_point.cad_point->cy, 
											select_list_info.tail->select->diagram_point.cad_point->r, 
											select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											sagcad_color.Cam, 2);
					}
					if (frag == 4) {
						SelectChain2_ArcBow(select_list_info.tail->select->diagram_point.cad_point->cx, 
											select_list_info.tail->select->diagram_point.cad_point->cy, 
											select_list_info.tail->select->diagram_point.cad_point->r, 
											select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											sagcad_color.Back, 2);
						SelectChain2_ArcBow(select_list_info.tail->select->diagram_point.cad_point->cx, 
											select_list_info.tail->select->diagram_point.cad_point->cy, 
											select_list_info.tail->select->diagram_point.cad_point->r, 
											select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											sagcad_color.Cam, 4);
					}
				}
				UpDate();
			}
			break;
		/* ܥ */
		case 4:
			if (select_list_num() == CopyFrag + 1) {
				if (select_list_info.tail->select->diagram_point.cad_point->code == 1) {
					if (frag == 2) {
						SelectChain2_S_Bow(	select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											sagcad_color.Back);
					}
					if (frag == 4) {
						SelectChain2_S_Bow(	select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											sagcad_color.Back);
					}
				}
				if (select_list_info.tail->select->diagram_point.cad_point->code == 2) {
					SelectChain2_ArcBow(	select_list_info.tail->select->diagram_point.cad_point->cx, 
											select_list_info.tail->select->diagram_point.cad_point->cy, 
											select_list_info.tail->select->diagram_point.cad_point->r, 
											select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											sagcad_color.Back, frag);
				}
				frag = 2;
				cad = select_list_info.tail->select->diagram_point.cad_point;
				select_last_cansel();
				SelectCadDraw (drawing_area, cad, SCD_SELECT);
				UpDate();

				ReturnFunc = MouseRet_Select;
				DcObj = 15+256;
				mode = 300;
				(*ReturnFunc)(drawing_area, 1, 0, 0);
			}
			break;
	}
	return 0;
}



/* -------------------------------------------------------------------
 * ã  (Return)
 */
int MouseRet_CamProfile(GtkWidget *widget, int Button, int x, int y)
{
	char mstr[256];


	if (select_list_num() == CopyFrag) {
		/* ޥɥ饤ɽ */
		sprintf(mstr, _(" [CAM] Start point") );
		StatusMsg(mstr);
	}
	else if (select_list_num() == CopyFrag + 1) {
		/* ޥɥ饤ɽ */
		sprintf(mstr, _(" [CAM] Direction [ YES/Left  NO/Right  CANCEL/Mid]") );
		StatusMsg(mstr);
	}



	switch (Button) {
		/* ܥ */
		case 1:
			if (select_list_num() == CopyFrag + 1) {
				if (select_list_info.tail->select->diagram_point.cad_point->code == 1) {
					SelectChain2_S_Bow(	select_list_info.tail->select->diagram_point.cad_point->sx, 
										select_list_info.tail->select->diagram_point.cad_point->sy, 
										select_list_info.tail->select->diagram_point.cad_point->ex, 
										select_list_info.tail->select->diagram_point.cad_point->ey, 
										sagcad_color.Cam);
				}
				if (select_list_info.tail->select->diagram_point.cad_point->code == 2) {
					SelectChain2_ArcBow(	select_list_info.tail->select->diagram_point.cad_point->cx, 
											select_list_info.tail->select->diagram_point.cad_point->cy, 
											select_list_info.tail->select->diagram_point.cad_point->r, 
											select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											sagcad_color.Cam, 2);
				}
				UpDate();
				break;
			}
			break;
		/* ܥ */
		case 2:
			break;
		/* ܥ */
		case 4:
			break;
	}
	return 0;
}





#ifdef AFTER
void DUMMY_________________________________01(void){}













/* -------------------------------------------------------------------
 * OFFSET  (Main)
 */
int MouseMode_offset(GtkWidget *widget, int Button, int x, int y)
{
	SELECT *select;
	CAD *cad;
	static int frag = 2; /* 2:ž	4:ȿž */


	switch (Button) {
		/* ܥ */
		case 1:
			if (select_list_num() == CopyFrag) {
				MouseSelect(widget, ToViewX(x), ToViewY(y), 6, 2);
			}
			if (select_list_num() == CopyFrag + 1) {
				if (select_list_info.tail->select->diagram_point.cad_point->code == 1) {
					if (frag == 2) {
						SelectChain2_S_Bow(	select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											sagcad_color.Back);
					}
					if (frag == 4) {
						SelectChain2_S_Bow(	select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											sagcad_color.Back);
					}
				}
				if (select_list_info.tail->select->diagram_point.cad_point->code == 2) {
					SelectChain2_ArcBow(	select_list_info.tail->select->diagram_point.cad_point->cx, 
											select_list_info.tail->select->diagram_point.cad_point->cy, 
											select_list_info.tail->select->diagram_point.cad_point->r, 
											select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											sagcad_color.Back, frag);
				}

				/* Ͽ޷ OnScreen ˤ */
				if (frag == 2) {
					select_list_info.tail->select->diagram_point.cad_point->OnScreen = 1;
				}
				else if (frag == 4) {
					select_list_info.tail->select->diagram_point.cad_point->OnScreen = -1;
				}

				cad = select_list_info.tail->select->diagram_point.cad_point;
				select_last_cansel();
				SelectCadDraw (drawing_area, cad, SCD_SELECT);

				select = select_search_cad(cad)->select;
				select_search_cad(cad)->select = select_list_info.head->select;
				select_list_info.head->select = select;


				frag = 2;
				ReturnFunc = MouseRet_Select;
				DcObj = 15+256;
				mode = 300;
				(*ReturnFunc)(drawing_area, 1, 0, 0);

				Poket_main();

			}
			break;
		/* ܥ */
		case 2:
			if (select_list_num() == CopyFrag + 1) {
				if (frag == 2) frag = 4;
				else if (frag == 4) frag = 2;

				if (select_list_info.tail->select->diagram_point.cad_point->code == 1) {
					if (frag == 2) {
						SelectChain2_S_Bow(	select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											sagcad_color.Back);
						SelectChain2_S_Bow(	select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											sagcad_color.Cam);
					}
					if (frag == 4) {
						SelectChain2_S_Bow(	select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											sagcad_color.Back);
						SelectChain2_S_Bow(	select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											sagcad_color.Cam);
					}
				}
				if (select_list_info.tail->select->diagram_point.cad_point->code == 2) {
					if (frag == 2) {
						SelectChain2_ArcBow(select_list_info.tail->select->diagram_point.cad_point->cx, 
											select_list_info.tail->select->diagram_point.cad_point->cy, 
											select_list_info.tail->select->diagram_point.cad_point->r, 
											select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											sagcad_color.Back, 4);
						SelectChain2_ArcBow(select_list_info.tail->select->diagram_point.cad_point->cx, 
											select_list_info.tail->select->diagram_point.cad_point->cy, 
											select_list_info.tail->select->diagram_point.cad_point->r, 
											select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											sagcad_color.Cam, 2);
					}
					if (frag == 4) {
						SelectChain2_ArcBow(select_list_info.tail->select->diagram_point.cad_point->cx, 
											select_list_info.tail->select->diagram_point.cad_point->cy, 
											select_list_info.tail->select->diagram_point.cad_point->r, 
											select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											sagcad_color.Back, 2);
						SelectChain2_ArcBow(select_list_info.tail->select->diagram_point.cad_point->cx, 
											select_list_info.tail->select->diagram_point.cad_point->cy, 
											select_list_info.tail->select->diagram_point.cad_point->r, 
											select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											sagcad_color.Cam, 4);
					}
				}
			}
			break;
		/* ܥ */
		case 4:
			if (select_list_num() == CopyFrag + 1) {
				if (select_list_info.tail->select->diagram_point.cad_point->code == 1) {
					if (frag == 2) {
						SelectChain2_S_Bow(	select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											sagcad_color.Back);
					}
					if (frag == 4) {
						SelectChain2_S_Bow(	select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											sagcad_color.Back);
					}
				}
				if (select_list_info.tail->select->diagram_point.cad_point->code == 2) {
					SelectChain2_ArcBow(	select_list_info.tail->select->diagram_point.cad_point->cx, 
											select_list_info.tail->select->diagram_point.cad_point->cy, 
											select_list_info.tail->select->diagram_point.cad_point->r, 
											select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											sagcad_color.Back, frag);
				}
				frag = 2;
				cad = select_list_info.tail->select->diagram_point.cad_point;
				select_last_cansel();
				SelectCadDraw (drawing_area, cad, SCD_SELECT);

				ReturnFunc = MouseRet_Select;
				DcObj = 15+256;
				mode = 300;
				(*ReturnFunc)(drawing_area, 1, 0, 0);
			}
			break;
	}
	return 0;
}



/* -------------------------------------------------------------------
 * OFFSET  (Return)
 */
int MouseRet_offset(GtkWidget *widget, int Button, int x, int y)
{
	char mstr[256];


	if (select_list_num() == CopyFrag) {
		/* ޥɥ饤ɽ */
		sprintf(mstr," offset ⡼   Ͽ޷ԥåʺܥ");
		StatusMsg(mstr);
	}
	else if (select_list_num() == CopyFrag + 1) {
		/* ޥɥ饤ɽ */
		sprintf(mstr," offset ⡼ɡؼƲ[ YES/Left   NO/Right   CANCEL/Mid]");
		StatusMsg(mstr);
	}



	switch (Button) {
		/* ܥ */
		case 1:
			if (select_list_num() == CopyFrag + 1) {
				if (select_list_info.tail->select->diagram_point.cad_point->code == 1) {
					SelectChain2_S_Bow(	select_list_info.tail->select->diagram_point.cad_point->sx, 
										select_list_info.tail->select->diagram_point.cad_point->sy, 
										select_list_info.tail->select->diagram_point.cad_point->ex, 
										select_list_info.tail->select->diagram_point.cad_point->ey, 
										sagcad_color.Cam);
				}
				if (select_list_info.tail->select->diagram_point.cad_point->code == 2) {
					SelectChain2_ArcBow(	select_list_info.tail->select->diagram_point.cad_point->cx, 
											select_list_info.tail->select->diagram_point.cad_point->cy, 
											select_list_info.tail->select->diagram_point.cad_point->r, 
											select_list_info.tail->select->diagram_point.cad_point->sx, 
											select_list_info.tail->select->diagram_point.cad_point->sy, 
											select_list_info.tail->select->diagram_point.cad_point->ex, 
											select_list_info.tail->select->diagram_point.cad_point->ey, 
											sagcad_color.Cam, 2);
				}
				break;
			}
			break;
		/* ܥ */
		case 2:
			break;
		/* ܥ */
		case 4:
			break;
	}
	return 0;
}





#endif





/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : Mouse.c
 * ====================================================================
 */





/* -------------------------------------------------------------------
 * ⡼ (Main)
 * 
 */
int MouseMode_Select_ops(GtkWidget *widget, int Button, int x, int y)
{
	int i_obj;


	switch (Button) {
		/* ܥ */
		case 1:
			if (outside_process.Work[outside_process.now].work == OPS_SELECT_ONE) {
				if ((outside_process.Work[outside_process.now].sel_obj & 128) == 128) {
					i_obj = outside_process.Work[outside_process.now].sel_obj - 128;
				}
				else {
					i_obj = outside_process.Work[outside_process.now].sel_obj;
				}
				MouseSelect(widget, ToViewX(x), ToViewY(y), i_obj, 0);
			}

			if (outside_process.Work[outside_process.now].work == OPS_SELECT_MANY) {
				
				if (SelectChainFrag == 0 && SelectColorFrag == 0) {
					MouseSelect(widget, ToViewX(x), ToViewY(y), outside_process.Work[outside_process.now].sel_obj, 0);
				}
				else if (SelectChainFrag != 0) {
					MouseSelect(widget, ToViewX(x), ToViewY(y), 6, 0);
				}
				else if (SelectColorFrag != 0) {
					MouseSelect(widget, ToViewX(x), ToViewY(y), 15, 0);
				}
			}
			
			break;
		/* ܥ */
		case 2:
			if ((outside_process.Work[outside_process.now].sel_obj & 128) == 128) {
				MouseSelect(widget, ToViewX(x), ToViewY(y), 128, 0);
			}
			else {
				if (SelectChainFrag == 0 || SelectColorFrag == 0) {
					select_last_cansel();
					(*ReturnFunc)(widget, Button, x, y);
				}
			}
			break;
		/* ܥ */
		case 4:
			snap_set(DcObj, 783);
			break;
	}
	return 0;
}



/* -------------------------------------------------------
 * ⡼ (Return)
 */
int MouseRet_Select_ops(GtkWidget *widget, int Button, int x, int y)
{
	char str[256], mstr[256];


	/* 򤵤ƤȤɽ */
	if(select_list_info.head != NULL) {
		DataInfo(select_list_info.tail->select, str);
		sprintf(mstr, " [Outside Process] %s (λϡOutside process Button) (Select %d)  %s", outside_process.Work[outside_process.now].msg, (int) select_list_num(), str);
	}

	/* 򤵤ƤʤȤɽ */
	else {
		/*  */
		if (outside_process.Work[outside_process.now].work == OPS_SELECT_ONE) {
			sprintf(mstr, " [Outside Process] %s (Select 0)", outside_process.Work[outside_process.now].msg);
		}
		/*  */
		if (outside_process.Work[outside_process.now].work == OPS_SELECT_MANY) {
			sprintf(mstr, " [Outside Process] %s (λϡOutside process Button) (Select 0)", outside_process.Work[outside_process.now].msg);
		}
	}
	StatusMsg(mstr);


	switch (Button) {
		/* ܥ */
		case 1:
			/*  */
			if (outside_process.Work[outside_process.now].work == OPS_SELECT_ONE) {
				if (select_list_info.head != NULL) {
					mode = 0;
					ReturnFunc = MouseRet_Non;
//					g_print ("Mouse L -> Go ops_select_output() \n");
					ops_select_output(&outside_process);
				}
			}
			
			/*  */
			else if (outside_process.Work[outside_process.now].work == OPS_SELECT_MANY) {
				if (select_list_info.head != NULL) {
					/* ޥɵư˲쥯ȤƤ */
					/* ޥɵư + 1 ˲쥯ȤƤ */
					/* ϡ޷ǡǤ */
					if (OP_SelectList != NULL && OP_SelectList->next != NULL && select_list_info.tail->select->index != 3) {
						if (SelectChainFrag == 1) SelectChain(select_list_info.tail->select->diagram_point.cad_point);
						if (SelectColorFrag == 1) SelectMaskColor(select_list_info.tail->select->diagram_point.cad_point);
						if (SelectChainFrag == 2) {
							KeepReturnFunc = ReturnFunc;
							ReturnFunc = MouseRet_ChainOne;
							Chain2index = 0;
							SelectChain2(select_list_info.tail->select->diagram_point.cad_point, 0);
						}
						SelectChainFrag = 0;
						SelectColorFrag = 0;
						OP_SelectList = NULL;
					}

					/* ޥɵư˲쥯ȤƤʤä */
					/* Ĳ쥯ȤƤ */
					/* ϡ޷ǡǤ */
					else if (OP_SelectList == NULL && select_list_info.head != NULL && select_list_info.head->select->index != 3) {
						if (SelectChainFrag == 1) SelectChain(select_list_info.head->select->diagram_point.cad_point);
						if (SelectColorFrag == 1) SelectMaskColor(select_list_info.head->select->diagram_point.cad_point);
						if (SelectChainFrag == 2) {
							KeepReturnFunc = ReturnFunc;
							ReturnFunc = MouseRet_ChainOne;
							Chain2index = 0;
							SelectChain2(select_list_info.tail->select->diagram_point.cad_point, 0);
						}
						SelectChainFrag = 0;
						SelectColorFrag = 0;
						OP_SelectList = NULL;
					}
				}
			}
			break;
		/* ܥ */
		case 2:
			/*  */
			if (outside_process.Work[outside_process.now].work == OPS_SELECT_ONE) {
				if (select_list_info.head != NULL) {
					mode = 0;
					ReturnFunc = MouseRet_Non;
//					g_print ("Mouse R -> Go ops_select_output() \n");
					ops_select_output(&outside_process);
				}
			}
			break;
		/* ܥ */
		case 4:
			break;
	}
	return 0;
}





/* -------------------------------------------------------
 * ϰ⡼ (Main)
 */
int MouseMode_Rect_ops(GtkWidget *widget, int Button, int x, int y)
{
	switch (Button) {
		/* ܥ */
		case 1:
			//g_print("Mouse.c : MouseMode_Rect() : Button = 1 : in\n");
//			SetCapture(widget);
			RectStart = 1;
			MoveX = x;
			MoveY = y;
			StartX = x;
			StartY = y;
			break;
		/* ܥ */
		case 2:
			select_last_cansel();
			(*ReturnFunc)(widget, Button, x, y);
			break;
		/* ܥ */
		case 4:
			snap_set(DcObj, 783);
			break;
	}
	return 0;
}


/* -------------------------------------------------------
 * ϰ⡼ (Return)
 */
int MouseRet_Rect_ops(GtkWidget *widget, int Button, int x, int y)
{
	char str[256], mstr[256];


	if(select_list_info.head != NULL) {
		DataInfo(select_list_info.tail->select, str);
		sprintf(mstr, " ϰ ޷򤷤Ƥ (Select %d)  %s", (int) select_list_num(), str);
		sprintf(mstr, " [Outside Process]ϰ %s (λϡOutside process Button) (Select %d)  %s", outside_process.Work[outside_process.now].msg, (int) select_list_num(), str);
	}
	else {
		sprintf(mstr, " [Outside Process]ϰ %s (λϡOutside process Button) (Select 0)", outside_process.Work[outside_process.now].msg);
	}
	StatusMsg(mstr);


	switch (Button) {
		/* ܥ */
		case 1:
			break;
		/* ܥ */
		case 2:
			break;
		/* ܥ */
		case 4:
			break;
	}
	return 0;
}





