/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : Assistance.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/02/27
 *    Last                 : 2003/04/16
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define DRAW
#include "MemoryLeak.h"
#include "List_cad.h"
#include "List_Dimension.h"
#include "List_PolyLine.h"
#include "List_Block.h"
#include "List_Undo.h"
#include "List_Select.h"
#include "List_font.h"
#include "global.h"
#include "Trace.h"
#include "Select.h"
#include "Draw.h"
#include "etc.h"
#include "Select.h"
#define _ASSISTANCE_
#include "Assistance.h"





/* -------------------------------------------------------------------
 * ˡޥ򤹤Ȥܰ¤ȤʤݥȤɽ
 *	
 *	
 */
int SearchPointDraw(GtkWidget *widget, double x, double y, long color)
{
	double d;

	d = 0.3 / Mag;
	LineDraw(widget, x+d, y+d, x+d, y-d, 1, color);
	LineDraw(widget, x+d, y-d, x-d, y-d, 1, color);
	LineDraw(widget, x-d, y-d, x-d, y+d, 1, color);
	LineDraw(widget, x-d, y+d, x+d, y+d, 1, color);
	return 1;
}





/* -------------------------------------------------------------------
 * Ĺ׻
 *	
 * DrawType
 *	   0 : ٤˹碌ɽ (ץ󥿡᡼)
 *	   1 : ̾ƤƱ礭
 *	   2 : ꤷ礭򤽤Τޤɽ
 */
double ArrowLength(int DrawType)
{
	/* ̤ν̼ɽ (ץ󥿡᡼) */
	if (DrawType == DRAW_DISP)
		return (sagcad_dimension.arrow_length / printer.scale);
	/* ʸɽ */
	else if (DrawType == DRAW_CONST) 
		return (sagcad_dimension.arrow_length / Mag);
	/* ꤷ礭򤽤Τޤɽ */
	else if (DrawType == DRAW_REAL) 
		return sagcad_dimension.arrow_length;
	else 
		return sagcad_dimension.arrow_length;
}





/* -------------------------------------------------------------------
 *  (defin = 10)
 *	
 * LineFrag
 *	   0	  : Τ
 *	   0 ʳ : ľ
 *	
 */
int LineEndArrow(GtkWidget *widget, double SX, double SY, double EX, double EY, int LineFrag, int DrawType, long color)
{
	struct RtnDat LAH, PAPH;
	double EX1, EY1, EX2, EY2;

	/* -----------------------------------------------------
	 * LA	ľγ
	 *		 (A.sx[1],A.SY[1]),(A.ex[1],A.EY[1])
	 *				 Ans A.ANGLE
	 */
	LAH.sx[1] = EX;
	LAH.sy[1] = EY;
	LAH.ex[1] = SX;
	LAH.ey[1] = SY;
	la(&LAH);
	/* -----------------------------------------------------
	 * PAP	ȳ٤ȵΥľν
	 *		 (A.sx[1] , A.sy[1]) , A.ANGLE , A.l
	 *				 Ans  (A.ex[1] , A.EY[1])
	 */
	PAPH.sx[1] = EX;
	PAPH.sy[1] = EY;
	PAPH.angle = LAH.angle + sagcad_dimension.arrow_angle;
	PAPH.l = ArrowLength(DrawType);
	pap(&PAPH);
	/* (EX1 , EY1) */
	EX1 = PAPH.ex[1];
	EY1 = PAPH.ey[1];

	PAPH.sx[1] = EX;
	PAPH.sy[1] = EY;
	PAPH.angle = LAH.angle - sagcad_dimension.arrow_angle;
	PAPH.l = ArrowLength(DrawType);
	pap(&PAPH);
	/* (EX2 , EY2) */
	EX2 = PAPH.ex[1];
	EY2 = PAPH.ey[1];

	if (LineFrag != 0) LineDraw(widget, SX, SY, EX, EY, 1, color);
	LineDraw(widget, EX, EY, EX1, EY1, 1, color);
	LineDraw(widget, EX, EY, EX2, EY2, 1, color);
	return 0;
}





/* -------------------------------------------------------------------
 * ξü (defin = 20)
 *	
 * LineFrag
 *	   0	  : Τ
 *	   0 ʳ : ľ
 */
int LineBothArrow(GtkWidget *widget, double SX, double SY, double EX, double EY, int LineFrag, int DrawType, long color)
{
	struct RtnDat LAH, PAPH;
	double EX1, EY1, EX2, EY2;


	/* LA	ľγ */
	LAH.sx[1] = EX;
	LAH.sy[1] = EY;
	LAH.ex[1] = SX;
	LAH.ey[1] = SY;
	la(&LAH);
	/* PAP	ȳ٤ȵΥľν */
	PAPH.sx[1] = EX;
	PAPH.sy[1] = EY;
	PAPH.angle = LAH.angle + sagcad_dimension.arrow_angle;
	PAPH.l = ArrowLength(DrawType);
	pap(&PAPH);
	EX1 = PAPH.ex[1];
	EY1 = PAPH.ey[1];

	PAPH.sx[1] = EX;
	PAPH.sy[1] = EY;
	PAPH.angle = LAH.angle - sagcad_dimension.arrow_angle;
	PAPH.l = ArrowLength(DrawType);
	pap(&PAPH);
	EX2 = PAPH.ex[1];
	EY2 = PAPH.ey[1];

	LineDraw(widget, EX, EY, EX1, EY1, 1, color);
	LineDraw(widget, EX, EY, EX2, EY2, 1, color);

	/* LA	ľγ */
	LAH.sx[1] = SX;
	LAH.sy[1] = SY;
	LAH.ex[1] = EX;
	LAH.ey[1] = EY;
	la(&LAH);

	/* PAP	ȳ٤ȵΥľν */
	PAPH.sx[1] = SX;
	PAPH.sy[1] = SY;
	PAPH.angle = LAH.angle + sagcad_dimension.arrow_angle;
	PAPH.l = ArrowLength(DrawType);
	pap(&PAPH);
	EX1 = PAPH.ex[1];
	EY1 = PAPH.ey[1];

	PAPH.sx[1] = SX;
	PAPH.sy[1] = SY;
	PAPH.angle = LAH.angle - sagcad_dimension.arrow_angle;
	PAPH.l = ArrowLength(DrawType);
	pap(&PAPH);
	EX2 = PAPH.ex[1];
	EY2 = PAPH.ey[1];

	LineDraw(widget, SX, SY, EX1, EY1, 1, color);
	LineDraw(widget, SX, SY, EX2, EY2, 1, color);

	if (LineFrag != 0) LineDraw(widget, SX, SY, EX, EY, 1, color);

	return 0;
}





/* -------------------------------------------------------------------
 * ξü˵ (defin = 30)
 *	
 * LineFrag
 *	   0	  : Τ
 *	   0 ʳ : ľ
 */
int LineBothConverseArrow(GtkWidget *widget, double SX, double SY, double EX, double EY, int LineFrag, int DrawType, long color)
{
	struct RtnDat LAH,PAPH;
	double EX1,EY1,EX2,EY2;
	
	/* LA	ľγ */
	LAH.sx[1] = EX;
	LAH.sy[1] = EY;
	LAH.ex[1] = SX;
	LAH.ey[1] = SY;
	la(&LAH);

	/* PAP	ȳ٤ȵΥľν */
	PAPH.sx[1] = SX;
	PAPH.sy[1] = SY;
	PAPH.angle = LAH.angle + sagcad_dimension.arrow_angle;
	PAPH.l = ArrowLength(DrawType);
	pap(&PAPH);
	EX1 = PAPH.ex[1];
	EY1 = PAPH.ey[1];

	PAPH.sx[1] = SX;
	PAPH.sy[1] = SY;
	PAPH.angle = LAH.angle - sagcad_dimension.arrow_angle;
	PAPH.l = ArrowLength(DrawType);
	pap(&PAPH);
	EX2 = PAPH.ex[1];
	EY2 = PAPH.ey[1];

	LineDraw(widget, SX, SY, EX1, EY1, 1, color);
	LineDraw(widget, SX, SY, EX2, EY2, 1, color);

	/* LA	ľγ */
	LAH.sx[1] = SX;
	LAH.sy[1] = SY;
	LAH.ex[1] = EX;
	LAH.ey[1] = EY;
	la(&LAH);
	/* PAP	ȳ٤ȵΥľν */
	PAPH.sx[1] = EX;
	PAPH.sy[1] = EY;
	PAPH.angle = LAH.angle + sagcad_dimension.arrow_angle;
	PAPH.l = ArrowLength(DrawType);
	pap(&PAPH);
	EX1 = PAPH.ex[1];
	EY1 = PAPH.ey[1];

	PAPH.sx[1] = EX;
	PAPH.sy[1] = EY;
	PAPH.angle = LAH.angle - sagcad_dimension.arrow_angle;
	PAPH.l = ArrowLength(DrawType);
	pap(&PAPH);
	EX2 = PAPH.ex[1];
	EY2 = PAPH.ey[1];

	LineDraw(widget, EX, EY, EX1, EY1, 1, color);
	LineDraw(widget, EX, EY, EX2, EY2, 1, color);

	if (LineFrag != 0) LineDraw(widget, SX, SY, EX, EY, 1, color);

	return 0;
}





/* -------------------------------------------------------------------
 * ξü(߸) (defin = 60)
 *	
 * ArcFrag
 *	   0	  : Τ
 *	   0 ʳ : ľ
 */
int ArcBothArrow(GtkWidget *widget, double CX, double CY, double R, double SX, double SY, double EX, double EY, int ArcFrag, int DrawType, long color)
{
	/* Dumy = ArcBow(CX, CY, R, SA,EA, INDEX) */

	struct RtnDat PAPH, LAH;
	double SA, EA;
	double SX1, SY1, SX2, SY2;
	double EX1, EY1, EX2, EY2;


	/* 濴γ SA 롣 */
	/* LA	  ľγ */
	LAH.sx[1] = CX;
	LAH.sy[1] = CY;
	LAH.ex[1] = SX;
	LAH.ey[1] = SY;
	la(&LAH);
	SA = LAH.angle;
	if(SA > 360) SA = SA - 360;

	PAPH.sx[1] = SX;
	PAPH.sy[1] = SY;
	PAPH.angle = SA + 90 - sagcad_dimension.arrow_angle;
	PAPH.l = ArrowLength(DrawType);
	pap(&PAPH);
	SX1 = PAPH.ex[1];
	SY1 = PAPH.ey[1];

	PAPH.sx[1] = SX;
	PAPH.sy[1] = SY;
	PAPH.angle = SA + 90 + sagcad_dimension.arrow_angle;
	PAPH.l = ArrowLength(DrawType);
	pap(&PAPH);
	SX2 = PAPH.ex[1];
	SY2 = PAPH.ey[1];

	LineDraw(widget, SX, SY, SX1, SY1, 5, color);
	LineDraw(widget, SX, SY, SX2, SY2, 5, color);



	/* 濴齪γ EA 롣 */
	/* LA	  ľγ */
	LAH.sx[1] = CX;
	LAH.sy[1] = CY;
	LAH.ex[1] = EX;
	LAH.ey[1] = EY;
	la(&LAH);
	EA = LAH.angle;
	if(EA > 360) EA = EA - 360;

	PAPH.sx[1] = EX;
	PAPH.sy[1] = EY;
	PAPH.angle = EA - 90 - sagcad_dimension.arrow_angle;
	PAPH.l = ArrowLength(DrawType);
	pap(&PAPH);
	EX1 = PAPH.ex[1];
	EY1 = PAPH.ey[1];

	PAPH.sx[1] = EX;
	PAPH.sy[1] = EY;
	PAPH.angle = EA - 90 + sagcad_dimension.arrow_angle;
	PAPH.l = ArrowLength(DrawType);
	pap(&PAPH);
	EX2 = PAPH.ex[1];
	EY2 = PAPH.ey[1];

	LineDraw(widget, EX, EY, EX1, EY1, 5, color);
	LineDraw(widget, EX, EY, EX2, EY2, 5, color);

	if (ArcFrag != 0) ArcDraw (widget, CX, CY, R, SX, SY, EX, EY, 5, color);

	return 0;
}





/* -------------------------------------------------------------------
 *    ¦:з	¦:бĹ (defin = 70)
 *	
 * 1 γ(Angle) 롣
 * 2 Ĺ(LineLen) 롣
 * 3 start_point 롣
 * 4 end_point 롣
 * 5 
 *	
 */
int AssistanceLine(GtkWidget *widget, double SX, double SY, double EX, double EY, int DrawType, long color)
{
	double Angle, LineLen, start_pointX, start_pointY, end_pointX, end_pointY;
	struct RtnDat a;
	int Ret;

	/* 1 γ(Angle) 롣*/
	a.sx[1] = SX;
	a.sy[1] = SY;
	a.ex[1] = EX;
	a.ey[1] = EY;
	Ret = la(&a);
	Angle = a.angle;

	/* 2 Ĺ(LineLen) 롣*/
	a.sx[1] = SX;
	a.sy[1] = SY;
	a.ex[1] = EX;
	a.ey[1] = EY;
	Ret = pp(&a);
	LineLen = a.l;

	/* 3 start_point 롣*/
	a.sx[1] = SX;
	a.sy[1] = SY;
	a.angle = Angle;

	/* ̤ν̼ɽ (ץ󥿡᡼) */
	if (DrawType == DRAW_DISP)
		a.l = sagcad_dimension.assistance_line_space / printer.scale;
	/* ʸɽ */
	else if (DrawType == DRAW_CONST) 
		a.l = (sagcad_dimension.assistance_line_space / Mag);
	/* ꤷ礭򤽤Τޤɽ */
	else if (DrawType == DRAW_REAL) 
		a.l = sagcad_dimension.assistance_line_space;
	else 
		a.l = sagcad_dimension.assistance_line_space;
	Ret = pap(&a);
	start_pointX = a.ex[1];
	start_pointY = a.ey[1];

	/* 4 end_point 롣*/
	a.sx[1] = SX;
	a.sy[1] = SY;
	a.angle = Angle;

	/* ̤ν̼ɽ (ץ󥿡᡼) */
	if (DrawType == DRAW_DISP)
		a.l = LineLen + sagcad_dimension.assistance_line_extension / printer.scale;
	/* ʸɽ */
	else if (DrawType == DRAW_CONST) 
		a.l = LineLen + (sagcad_dimension.assistance_line_extension / Mag);
	/* ꤷ礭򤽤Τޤɽ */
	else if (DrawType == DRAW_REAL) 
		a.l = LineLen + sagcad_dimension.assistance_line_extension;
	else 
		a.l = LineLen + sagcad_dimension.assistance_line_extension;
	Ret = pap(&a);
	end_pointX = a.ex[1];
	end_pointY = a.ey[1];

	/* 5 */
	LineDraw(widget, start_pointX, start_pointY, end_pointX, end_pointY, 1, color);
	return 1;
}





/* -------------------------------------------------------------------
 * ()αĹ (defin = 80)
 *	
 * (SX,SY)-(EX,EY) ǻꤵ줿ľ sagcad_dimension.arrow_line_extension 
 * ǻꤵ줿ĹĹ롣
 *	
 * 1 γ(Angle) 롣
 * 2 Ĺ(LineLen) 롣
 * 3 end_point 롣
 * 4 
 *	
 */
int LineEndExtension(GtkWidget *widget, double SX, double SY, double EX, double EY, int DrawType, long color)
{
	double Angle, LineLen, end_pointX, end_pointY;
	struct RtnDat a;
	int Ret;

	/* 1 γ(Angle) 롣*/
	a.sx[1] = SX;
	a.sy[1] = SY;
	a.ex[1] = EX;
	a.ey[1] = EY;
	Ret = la(&a);
	Angle = a.angle;

	/* 2 Ĺ(LineLen) 롣*/
	a.sx[1] = SX;
	a.sy[1] = SY;
	a.ex[1] = EX;
	a.ey[1] = EY;
	Ret = pp(&a);
	LineLen = a.l;

	/* 3 end_point 롣*/
	a.sx[1] = SX;
	a.sy[1] = SY;
	a.angle = Angle;

	/* ̤ν̼ɽ (ץ󥿡᡼) */
	if (DrawType == DRAW_DISP)
		a.l = LineLen + (sagcad_dimension.arrow_line_extension / printer.scale);
	/* ʸɽ */
	else if (DrawType == DRAW_CONST) 
		a.l = LineLen + (sagcad_dimension.arrow_line_extension / Mag);
	/* ꤷ礭򤽤Τޤɽ */
	else if (DrawType == DRAW_REAL) 
		a.l = LineLen + sagcad_dimension.arrow_line_extension;
	else 
		a.l = LineLen + sagcad_dimension.arrow_line_extension;

	Ret = pap(&a);
	end_pointX = a.ex[1];
	end_pointY = a.ey[1];

	/* 4 */
	LineDraw(widget, SX, SY, end_pointX, end_pointY, 1, color);
	return 1;
}





/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : Assistance.c
 * ====================================================================
 */

