/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : DrawArea.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/02/07
 *    Last                 : 2003/02/07
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <unistd.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "MemoryLeak.h"
#include "List_cad.h"
#include "List_Dimension.h"
#include "List_PolyLine.h"
#include "List_Block.h"
#include "List_Undo.h"
#include "List_Select.h"
#include "global.h"
#include "Draw.h"
#include "Mouse.h"
#define _DRAWAREA_
#include "DrawArea.h"



/* ------------------------------------------------------------------
 * ɥ󥰥ꥢ
 * expose () ٥ȥϥɥ
 * 
 */
int expose_event(GtkWidget *widget, GdkEventExpose *event)
{
	gdk_draw_pixmap (widget->window, 
					 gc, 
					 pixmap, 
					 event->area.x, event->area.y,  
					 event->area.x, event->area.y,  
					 event->area.width, event->area.height);

	return FALSE;
}



/* ------------------------------------------------------------------
 * ɥ󥰥ꥢ
 * "motion_notify_event (ɥå)" ٥ȥϥɥ
 */
int motion_notify_event(GtkWidget *widget, GdkEventMotion *event)
{
	int x, y;
	GdkModifierType state;
	char str[64];
	int Button = 0, Shift = 0;

	/* event κɸĴ٤ */
	if (event->is_hint)
		gdk_window_get_pointer (event->window, &x, &y, &state);
	else {
		x = event->x;
		y = event->y;
		state = event->state;
	}

	/* ޥκɸɽ */
	sprintf(str, "x %.2f  ", ToViewX(x));
	gtk_label_set(GTK_LABEL(MouseX), str);

	sprintf(str, "y %.2f", ToViewY(y));
	gtk_label_set(GTK_LABEL(MouseY), str);

	if ((state & GDK_SHIFT_MASK) == GDK_SHIFT_MASK) Shift = 1;
	if ((state & GDK_MOD1_MASK) == GDK_MOD1_MASK) Shift = 2;
	if ((state & GDK_CONTROL_MASK) == GDK_CONTROL_MASK) Shift = 4;

	/* ܥ */
	if ((state & GDK_BUTTON1_MASK) == GDK_BUTTON1_MASK) Button = 1;
	/* ܥ */
	if ((state & GDK_BUTTON2_MASK) == GDK_BUTTON2_MASK) Button = 4;
	/* ܥ */
	if ((state & GDK_BUTTON3_MASK) == GDK_BUTTON3_MASK) Button = 2;

	//g_print ("motion_notify_event : event  x = %d  y = %d\n", x, y);

	SagCad_MouseMove(widget, Button, Shift, x, y);
	return TRUE;
}



/* ------------------------------------------------------------------
 * ɥ󥰥ꥢ
 * "button_press (å)" ٥ȥϥɥ
 */
int button_press_event(GtkWidget *widget, GdkEventButton *event)
{
	int Shift = 0, Button = 0;

	if ((event->state & GDK_SHIFT_MASK) == GDK_SHIFT_MASK) Shift = 1;
	if ((event->state & GDK_MOD1_MASK) == GDK_MOD1_MASK) Shift = 2;
	if ((event->state & GDK_CONTROL_MASK) == GDK_CONTROL_MASK) Shift = 4;

	/* ܥ */
	if (event->button == 1) Button = 1;
	/* ܥ */
	else if (event->button == 2) Button = 4;
	/* ܥ */
	else if (event->button == 3) Button = 2;

	//g_print ("button_press_event : event  x = %f  y = %f\n", event->x, event->y);
	//g_print("DrawArea.c : button_press_event() : in\n");

	SagCad_MouseDown(widget, Button, Shift, (int) event->x, (int) event->y);
	return TRUE;
}



/* ------------------------------------------------------------------
 * ɥ󥰥ꥢ
 * "release_event (꡼)" ٥ȥϥɥ
 * 
 */
int button_release_event(GtkWidget *widget, GdkEventButton *event)
{
	int Shift = 0, Button = 0;

	if ((event->state & GDK_SHIFT_MASK) == GDK_SHIFT_MASK) Shift = 1;
	if ((event->state & GDK_MOD1_MASK) == GDK_MOD1_MASK) Shift = 2;
	if ((event->state & GDK_CONTROL_MASK) == GDK_CONTROL_MASK) Shift = 4;

	/* ܥ */
	if (event->button == 1) Button = 1;
	/* ܥ */
	else if (event->button == 2) Button = 4;
	/* ܥ */
	else if (event->button == 3) Button = 2;

	//g_print ("button_release_event : event  x = %f  y = %f\n", event->x, event->y);

	SagCad_MouseUp(widget, Button, Shift, (int)event->x, (int)event->y);
	return TRUE;
}





int configure_event (GtkWidget *widget, GdkEventConfigure *event)
{

	if (sagcad_system.DeviceX == widget->allocation.width && sagcad_system.DeviceY == widget->allocation.height) {
		return 0;
	}


	/* ɥ󥰥쥢礭 */
	sagcad_system.DeviceX = widget->allocation.width;
	sagcad_system.DeviceY = widget->allocation.height;

	/* ڥ */
	sagcad_system.Aspect = (double)sagcad_system.DeviceY / (double)sagcad_system.DeviceX;
	/* sagcad_system.ViewX ǥץ쥤μºݤΥˤ */
	//sagcad_system.ViewX = 200;//sagcad_system.DeviceX;
	window_set();


	/* GC */
	if (gc == NULL) {
		gc = create_gc(widget);
	}

	if (pixmap) {
		gdk_pixmap_unref (pixmap);
	}

	pixmap = gdk_pixmap_new (widget->window, 
							 widget->allocation.width, 
							 widget->allocation.height, 
							 -1);

	PenSet(gc, 1, sagcad_color.Back);
	gdk_draw_rectangle (pixmap, gc, TRUE, 0, 0, widget->allocation.width, widget->allocation.height);

//g_print("DrawArea.c : configure_event() : Draw\n");
	Draw(widget);

	return TRUE;
}





/* ------------------------------------------------------------------
 * ɥ󥰥ꥢ
 * 
 */
GtkWidget *create_drawing_area(void)
{
	GtkWidget *drawing_area;

	/* ɥ󥰥ꥢ */
	drawing_area = gtk_drawing_area_new();
	/* ɥ󥰥ꥢΥ */
	gtk_drawing_area_size( GTK_DRAWING_AREA(drawing_area), PICTURE_WIDTH, PICTURE_HEIGHT);

	/* "configure_event"٥ȥϥɥ */
	gtk_signal_connect(GTK_OBJECT(drawing_area), "configure_event",
				 (GtkSignalFunc) configure_event, NULL);
	/* "expose_event"٥ȥϥɥ */
	gtk_signal_connect(GTK_OBJECT(drawing_area), "expose_event",
				 (GtkSignalFunc) expose_event, NULL);
	/* "motion_notify_event"٥ȥϥɥ */
	gtk_signal_connect(GTK_OBJECT(drawing_area), "motion_notify_event",
				 (GtkSignalFunc) motion_notify_event, NULL);
	/* "button_press_event"٥ȥϥɥ */
	gtk_signal_connect(GTK_OBJECT(drawing_area), "button_press_event",
				 (GtkSignalFunc) button_press_event, NULL);
	/* "button_release_event"٥ȥϥɥ */
	gtk_signal_connect(GTK_OBJECT(drawing_area), "button_release_event",
				 (GtkSignalFunc) button_release_event, NULL);
	/* ٥ȥޥ */
	gtk_widget_set_events(drawing_area, GDK_EXPOSURE_MASK
										 | GDK_LEAVE_NOTIFY_MASK
										 | GDK_BUTTON_PRESS_MASK
										 | GDK_BUTTON_RELEASE_MASK
										 | GDK_POINTER_MOTION_MASK
										 | GDK_POINTER_MOTION_HINT_MASK);

	return drawing_area;
}





/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : DrawArea.c
 * ====================================================================
 */
