/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : about.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/03/22
 *    Last                 : 2003/04/16
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "MemoryLeak.h"
#include "List_cad.h"
#include "List_Dimension.h"
#include "List_PolyLine.h"
#include "List_Block.h"
#include "List_Undo.h"
#include "List_Select.h"
#include "global.h"
#define _ABOUT_
#include "about.h"

#include "xpm/sagcad.xpm"



/* -------------------------------------------------------------------
 * OK "pushed"
 * 
 */
void about_ok_pushed(GtkWidget *widget, gpointer data)
{
	return;
}





/* -------------------------------------------------------------------
 * about SagCAD
 * 
 */
gint about(GtkWidget *parent)
{
	char str[256];


	GtkWidget *dialog;
	GtkWidget *main_vbox;
		GtkWidget *hbox;
			GtkWidget *pixmap_widget;
				GdkBitmap *mask;
				GdkPixmap *pixmap_data;

			GtkWidget *label_vbox;
				GtkWidget *title_label;
				GtkWidget *version_label;
			GtkWidget *copyright1_label;
			GtkWidget *copyright2_label;
			GtkWidget *copyright3_label;
			GtkWidget *reserved_label;
		GtkWidget *separator;
		GtkWidget *ok_buttun;


	/* (gridcopy_dlg->dialog) */
	dialog = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_CENTER);
	gtk_window_set_title(GTK_WINDOW(dialog), "SagCAD");
//	gtk_signal_connect( GTK_OBJECT(dialog), "key_press_event",
//						GTK_SIGNAL_FUNC(gridcopy_dlg_key_press_event), gridcopy_dlg);


		/* ˤޤѥå󥰥ܥå(main_vbox) */
		main_vbox = gtk_vbox_new(0, 5);
		gtk_container_add(GTK_CONTAINER(dialog), main_vbox);
		gtk_container_border_width(GTK_CONTAINER(dialog), 5);
		gtk_widget_show(main_vbox);

			/* ѥå󥰥ܥå(hbox) */
			hbox = gtk_hbox_new(FALSE, 10);
			gtk_box_pack_start(GTK_BOX(main_vbox), hbox, TRUE, TRUE, 0);
			gtk_widget_show(hbox);

					/* icon */
					pixmap_data = gdk_pixmap_create_from_xpm_d(parent->window, 
															   &mask, 
															   NULL, 
															   (gchar **) sagcad_xpm);
					pixmap_widget = gtk_pixmap_new(pixmap_data, mask);
					gtk_box_pack_start(GTK_BOX(hbox), pixmap_widget, TRUE, TRUE, 0);
					gtk_widget_show(pixmap_widget);


				/* ˤޤѥå󥰥ܥå(main_vbox) */
				label_vbox = gtk_vbox_new(0, 2);
				gtk_box_pack_start(GTK_BOX(hbox), label_vbox, TRUE, TRUE, 0);
				gtk_widget_show(label_vbox);

					/* title_label */
					title_label = gtk_label_new("SagCAD");
					gtk_misc_set_alignment(GTK_MISC(title_label), 0.0f, 1.0f);
//					gtk_widget_set_usize (title_label, 300, 20);
					gtk_label_set_justify(GTK_LABEL(title_label), GTK_JUSTIFY_LEFT);
					gtk_box_pack_start(GTK_BOX(label_vbox), title_label, TRUE, TRUE, 0);
					gtk_widget_show(title_label);

					/* version_label */
					sprintf(str, "Version ");
					strcat(str, VERSION);
					version_label = gtk_label_new(str);
					gtk_misc_set_alignment(GTK_MISC(version_label), 0.0f, 1.0f);
//					gtk_widget_set_usize (version_label, 300, 20);
					gtk_box_pack_start(GTK_BOX(label_vbox), version_label, TRUE, TRUE, 0);
					gtk_label_set_justify(GTK_LABEL(version_label), GTK_JUSTIFY_LEFT);
					gtk_widget_show(version_label);

					/* copyright1_label */
					copyright1_label = gtk_label_new("Copyright (C) 1998-2003");
					gtk_misc_set_alignment(GTK_MISC(copyright1_label), 0.0f, 1.0f);
//					gtk_widget_set_usize (copyright1_label, 300, 20);
					gtk_label_set_justify(GTK_LABEL(copyright1_label), GTK_JUSTIFY_LEFT);
					gtk_box_pack_start(GTK_BOX(label_vbox), copyright1_label, TRUE, TRUE, 0);
					gtk_widget_show(copyright1_label);

					/* copyright2_label */
					copyright2_label = gtk_label_new("Sagiya Metal Mold Factory,Inc.");
					gtk_misc_set_alignment(GTK_MISC(copyright2_label), 0.0f, 1.0f);
//					gtk_widget_set_usize (copyright2_label, 300, 20);
					gtk_label_set_justify(GTK_LABEL(copyright2_label), GTK_JUSTIFY_LEFT);
					gtk_box_pack_start(GTK_BOX(label_vbox), copyright2_label, TRUE, TRUE, 0);
					gtk_widget_show(copyright2_label);

					/* copyright3_label */
					copyright3_label = gtk_label_new("Yutaka Sagiya.");
					gtk_misc_set_alignment(GTK_MISC(copyright3_label), 0.0f, 1.0f);
//					gtk_widget_set_usize (copyright3_label, 300, 20);
					gtk_label_set_justify(GTK_LABEL(copyright3_label), GTK_JUSTIFY_LEFT);
					gtk_box_pack_start(GTK_BOX(label_vbox), copyright3_label, TRUE, TRUE, 0);
					gtk_widget_show(copyright3_label);

					/* reserved_label */
					reserved_label = gtk_label_new("All Rights Reserved.");
					gtk_misc_set_alignment(GTK_MISC(reserved_label), 0.0f, 1.0f);
//					gtk_widget_set_usize (reserved_label, 300, 20);
					gtk_label_set_justify(GTK_LABEL(reserved_label), GTK_JUSTIFY_LEFT);
					gtk_box_pack_start(GTK_BOX(label_vbox), reserved_label, TRUE, TRUE, 0);
					gtk_widget_show(reserved_label);


		/* ѥ졼(separator) */
		separator = gtk_hseparator_new();
		gtk_box_pack_start( GTK_BOX(main_vbox), separator, TRUE, TRUE, 0);
		gtk_widget_show(separator);


		/* -----------------------------------------------------
		 * ѥå󥰥ܥå(action_hbox) 
		 * ܥ(cancel_buttun & ok_buttun) 
		 * Ǽ
		 */
		/* OKܥ */
		ok_buttun = gtk_button_new_with_label("OK");
		gtk_widget_set_usize (ok_buttun, 80, 20);
		gtk_box_pack_start(GTK_BOX(main_vbox), ok_buttun, TRUE, TRUE, 2);
		gtk_signal_connect(GTK_OBJECT(ok_buttun), "clicked", GTK_SIGNAL_FUNC(about_ok_pushed), 0);
		gtk_signal_connect(GTK_OBJECT(ok_buttun), "clicked", GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
	//	  GTK_WIDGET_SET_FLAGS(ok_buttun, GTK_CAN_DEFAULT);
	//	  gtk_widget_grab_default(ok_buttun);
		gtk_widget_show(ok_buttun);


	/*  ե ok_buttun  */
	gtk_window_set_focus(GTK_WINDOW(dialog), ok_buttun);

	/* ̤ɽ */
	gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);
	/* ᥤ󥦥ɥǤʤ褦 */
	gtk_window_set_transient_for(GTK_WINDOW(dialog), GTK_WINDOW(parent));


	/* Ļ֤ */
	gtk_widget_show(dialog);
	/* ᥤ󥤥٥ȥ롼 */
	gtk_main();
	gtk_widget_destroy(dialog);
	return 0; 
}





/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : about.c
 * ====================================================================
 */
