/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : culcfunc.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/03/14
 *    Last                 : 2007/11/08
 * ====================================================================
 */

#ifndef __CULCFUNC_H__
#define __CULCFUNC_H__


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 : 前処理  (struct #define etc)
 * -------------------------------------------------------
 */
#define PI 3.14159265358979

	/* 座標計算関数用　構造体の宣言 */
	struct RtnDat
	{
		int type;		// 
		double angle;	// 
		double l;		// 
		double sx[5];	// 
		double sy[5];	// 
		double ex[5];	// 
		double ey[5];	// 
		double cx[13];	// 
		double cy[13];	// 
		double r[13];	// 
	};



/* -------------------------------------------------------
 * 2 : 外部変数 (global)
 * -------------------------------------------------------
 */
#ifdef	  _CULCFUNC_
#define   GLOBAL
// 初期値設定
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
// 初期値設定の代入部分を無くす
#define   GLOBAL_VAL(v)  /* */
#endif


	GLOBAL int calcu_digits GLOBAL_VAL(10);	/* 計算用小数点以下桁数 */
	GLOBAL int compa_digits GLOBAL_VAL(3);	/* 比較用小数点以下桁数 */
	GLOBAL double digits GLOBAL_VAL(0.0001);		/* 比較用誤差 */
	// Act_llp() の sg() 関数の桁は？


#undef	GLOBAL
#undef	GLOBAL_VAL
#undef	_CULCFUNC_



/* -------------------------------------------------------
 * 3 : 外部関数 (Function)
 * -------------------------------------------------------
 */
int isEqual(double a, double b, int isEqual_digits);
int arc_max_and_min(struct RtnDat *rtn);

double raddeg(double a);					/*	1 */
double degrad(double a);					/*	2 */
int pa(struct RtnDat *dumy);				/*	3 */
int ppp(struct RtnDat *dumy);				/*	4 */
int lla(struct RtnDat *dumy);				/*	5 */
int pap(struct RtnDat *dumy);				/*	6 */
int lo(struct RtnDat *dumy);				/*	7 */
int la(struct RtnDat *dumy);				/*	8 */
int pp(struct RtnDat *dumy);				/*	9 */
int llp(struct RtnDat *dumy);				/* 10 */
int lcp(struct RtnDat *dumy);				/* 11 */
int ccp(struct RtnDat *dumy);				/* 12 */
int plp (struct RtnDat *dumy);				/* 13 */
int pcl(struct RtnDat *dumy);				/* 14 */
int ccl(struct RtnDat *dumy);				/* 15 */
int pcc(struct RtnDat *dumy);				/* 16 */
int lcc(struct RtnDat *dumy);				/* 17 */
int ppc(struct RtnDat *dumy);				/* 18 */
int ccc(struct RtnDat *dumy);				/* 19 */
int plc(struct RtnDat *dumy);				/* 20 */
int llc(struct RtnDat *dumy);				/* 21 */
int lll(struct RtnDat *dumy);				/* 22 */
int pll(struct RtnDat *dumy);				/* 23 */
int cal(struct RtnDat *dumy);				/* 24 */
double sg(double dumy,int keta);			/* 28 */
int pppc(struct RtnDat *dumy);
int lllc(struct RtnDat *a);
int ChkPointCircleSide(struct RtnDat *a);
int ChkPointLineSide(struct RtnDat *a);
int LCP1(struct RtnDat *a);
int CCP1(struct RtnDat *a);

int near_point_on_line(double *x, double *y, double sx, double sy, double ex, double ey);
int near_point_on_circle(double *x, double *y, double cx, double cy, double r);
int point_on_line(double x, double y, double sx, double sy, double ex, double ey);
int point_on_arc(double x, double y, double cx, double cy, double r, double sx, double sy, double ex, double ey);
int Act_llp(struct RtnDat *a);
int Act_lcp(struct RtnDat *a);
int Act_ccp(struct RtnDat *dumy);
int Swap_double(double *a, double *b);
int FloatOut(char *str, double dbl, int Dot);	// 数値(小数点)出力用
int FloatOut6(char *str, double dbl, int Dot);	// 数値(小数点)出力用
int FloatOut_n(char *str, double dbl, int n, int Dot);

/* 回転    点(px,py) を 原点(x,y) を中心に Angle 度回転移動 */
int rotation(double *px, double *py, double x, double y, double Angle);
/* 平行    点(px,py) を ベクトル(x,y) で平行移動 */
int parallel(double *px, double *py, double x, double y);
/* 対称    点(x,y) を 線(sx,sy)-(ex,ey) に対して対称移動 */
int symmetry(double sx, double sy, double ex, double ey, double *x, double *y);
/* スケーリング    点(x,y) を 原点(x,y) を中心に k 倍した図形に変換 */
int scaling(double *px, double *py, double x, double y, double k);
int scaling_xy(double *px, double *py, double x, double y, double kx, double ky);

/* 角度を 0 から 360 の間にする */
int angle_check(double *angle);



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __CULCFUNC_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : culcfunc.h
 * ====================================================================
 */
