/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : CopyFunc.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *	  Begin 			   : 2001/03/14
 *    Last                 : 2007/11/08
 * ====================================================================
 */

#ifndef __COPYFUNC_H__
#define __COPYFUNC_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 : 前処理  (struct #define etc)
 * -------------------------------------------------------
 */



/* -------------------------------------------------------
 * 2 : 外部変数 (global)
 * -------------------------------------------------------
 */
#ifdef _COPYFUNC_
#define   GLOBAL
// 初期値設定
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
// 初期値設定の代入部分を無くす
#define   GLOBAL_VAL(v)  /* */
#endif




#undef	GLOBAL
#undef	GLOBAL_VAL
#undef _COPYFUNC_



/* -------------------------------------------------------
 * 3 : 外部関数 (Function)
 * -------------------------------------------------------
 */
/* CAD DATA a を ベクトル(x,y) で平行移動した図形に変換して返す */
int Parallel(SELECT *select, double x, double y);
/* CAD DATA a を 原点(x,y) を中心に Angle 度回転移動した図形に変換して返す */
int Rotation(SELECT *select, double x, double y, double Angle);
/* CAD DATA a を 直線(sx,sy)-(ex,ey) を中心に 対称移動した図形に変換して返す */
int Mirror(SELECT *select, double sx, double sy, double ex, double ey);
/* CAD DATA a を 原点(x,y) を中心に k 倍した図形に変換して返す */
int Scaling(SELECT *select, double x, double y, double k);


/* セレクト図形を ピッチ(x,y), 回数 Repeat で移動または複写する
 * (Repeat=1 移動	Repeat>1 複写)
 */
int CopyPara(double x, double y, int Repeat);

/* セレクト図形を 原点(x,y), 角度 Angle, 回数 Repeat で移動または複写する
 * (Repeat=1 移動	Repeat>1 複写)
 */
int CopyRoll(double x, double y, double angle, int Repeat);

/* セレクト図形を 直線(sx,sy)-(ex,ey) を軸に 対称移動または複写する
 * (Repeat=1 移動	Repeat=2 複写)
 */
int CopyMirr(double sx, double sy, double ex, double ey, int Repeat);

/* セレクト図形を  原点(x,y) を中心に k 倍した図形に変換する
 * (元の図形をいじる)
 */
int CopyScaling(double x, double y, double k, int Frag);

/* セレクト図形を 
 * X のピッチを x, Y のピッチを y, X の回数を RepeatX, Yの回数を RepeatY
 * で複写する
 */
int CopyKousi(double x, double y, int RepeatX, int RepeatY);

int AssistLineCopy(DIMENSION *copy_dimension, DIMENSION *org_dimension);

int ScalingXY(SELECT *select, double x, double y, double kx, double ky);



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __COPYFUNC_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : CopyFunc.h
 * ====================================================================
 */
