/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : sagcad
 *    Description          : CAD/CAM
 *    Source               : toolbar.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/01/16
 *    Last                 : 2007/10/17
 * ====================================================================
 */

#ifndef __TOOLBAR_H__
#define __TOOLBAR_H__



/*
 * -------------------------------------------------------
 * 1 : 前処理  (struct #define etc)
 * -------------------------------------------------------
 */
#define SPACE_CMD "_SPACE_"
#define TLLOBAR_ICON_SIZE 28

struct ToolBarItem
{
	char *tooltips;
	char *xpm_file;
	char **xpm;
	void *func;
	int button_type;
	int signal_type;
};

#define TABLE_SPACE "_SPACE_"

struct TableToolBarItem
{
	char *tooltips;
	char *xpm_file;
	char **xpm;
	void *func;
	int rows;
	int columns;
	int button_type;
};
/*
struct TableToolBarItem
{
	char *tooltips;
	char *xpm_file;
	void *func;
	int rows;
	int columns;
};
*/


/*
 * -------------------------------------------------------
 * 2 : 外部変数
 * -------------------------------------------------------
 */
/* toolbar.c から呼ばれたとき */
#ifdef TOOLBAR 
#include "xpm/Parts_in.xpm"
#include "xpm/print-setup.xpm"
#include "xpm/Center.xpm"
#include "xpm/View_0.xpm"
#include "xpm/View_1.xpm"
#include "xpm/View_2.xpm"
#include "xpm/View_3.xpm"
#include "xpm/View_4.xpm"
#include "xpm/View_5.xpm"
#include "xpm/about.xpm"
// Draw 
#include "xpm/Cancel.xpm"
#include "xpm/Draw.xpm"
#include "xpm/Split.xpm"
#include "xpm/Trim.xpm"
#include "xpm/Both_Trim.xpm"
#include "xpm/Fillet.xpm"
#include "xpm/C_Cut.xpm"
#include "xpm/Point_Input.xpm"
#include "xpm/Cont_Line.xpm"
#include "xpm/Line3.xpm"
#include "xpm/Point3.xpm"

// Edit 
#include "xpm/Select.xpm"
#include "xpm/RectSelect.xpm"
#include "xpm/Mirr.xpm"
#include "xpm/Para.xpm"
#include "xpm/Roll.xpm"
#include "xpm/Matrix.xpm"
#include "xpm/Scaling.xpm"
#include "xpm/LineStyleChange.xpm"
#include "xpm/LayerCopy.xpm"
#include "xpm/LayerMove.xpm"
//#include "xpm/Delete.xpm"

// Dimension 
#include "xpm/DimenX.xpm"
#include "xpm/DimenY.xpm"
#include "xpm/DimenDistance.xpm"
#include "xpm/DimenAngle.xpm"
#include "xpm/DimenR.xpm"
#include "xpm/DimenD.xpm"
#include "xpm/DimenPoint.xpm"
#include "xpm/DimenPullLine.xpm"
#include "xpm/DimenAtension.xpm"
#include "xpm/DimenEdit.xpm"

#include "xpm/PolyLine.xpm"
#include "xpm/Ellipse.xpm"

// CAM 
//#include "xpm/Cam25D.xpm"
#include "xpm/CamNcDraw.xpm"
//#include "xpm/CamPoket.xpm"
#include "xpm/CamProfile.xpm"

// Outside Process 
#include "xpm/outside_process.xpm"


/* toolbar.c 以外から呼ばれたとき */
#else



#endif /* TOOLBAR */
#undef TOOLBAR


/*
 * -------------------------------------------------------
 * 3 : 外部関数
 * -------------------------------------------------------
 */
GtkWidget *create_hbox_toolbar(GtkWidget *container);
void AppendButtons(GtkWidget *container, GtkWidget *toolbar, struct ToolBarItem *Item);
GtkWidget *create_table_toolbar(GtkWidget *container);
void table_append_buttons(GtkWidget *container, GtkWidget *toolbar, struct TableToolBarItem *Item);
int undo_buttun(int frag);
int redo_buttun(int frag);



#endif /* __TOOLBAR_H__ */



/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : sagcad
 *    Description          : CAD/CAM
 *    Source               : toolbar.h
 * ====================================================================
 */
