/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : font.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/02/27
 *    Last                 : 2007/10/14
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
//#include <langinfo.h>

#include "MemoryLeak.h"
#include "List_cad.h"
#include "List_font.h"
#include "List_Dimension.h"
#include "List_PolyLine.h"
#include "List_Block.h"
#include "List_Undo.h"
#include "List_Select.h"
#include "global.h"
#include "culcfunc.h"
#include "Select.h"
#include "Draw.h"
#include "etc.h"
#define _FONT_
#include "font.h"



#define MINI_TEXT_HEIGHT 0.6
#define MINI_TEXT_UP_POS 0.2
#define MINI_TEXT_LOW_POS 0.5



/* -------------------------------------------------------------------
 * 文字列を表示する
 * -------------------------------------------------------------------
 *	1 : n 文字目の データを 原点に読み込んでスケーリングしたデータを関数(char_scale)で作成
 *	2 : 1 のデータを now_char_X オフセットして取り込む。
 *	3 : now_char_X を取り込んだ 文字幅 + distance オフセットさせる。
 *	4 : 1,2,3 を文字数繰り返す。
 *	
 *	5 : できたデータを angle で回転させ、(x､y) オフセットさせ表示。
 *	
 * text	 : テキスト
 * height: 高さ
 * space : 文字と文字の間隔
 * angle : 角度
 * x	 : 基準Ｘ
 * y	 : 基準Ｙ
 * color : 色
 * point : 0,1,2 書き出し位置
 *		   0 :	．TEXT
 *		   1 :	TE．XT
 *		   2 :	TEXT
 * frag  : 0:文字列長さ計算だけ   1:表示
 *	
 *	
 * hDC も渡して、LineBasic で描いた方がいいのでは？
 * -------------------------------------------------------------------
 */
int DrawTextVector (GtkWidget *widget, DIMENSION *a, long color)
{
	int i, Ret;
	
	double SX, SY, EX, EY;


	if (a->diagram_of_char == NULL) {
		CulcTextVector (widget, a);
	}


	/* -------------------------------------------------------------------
	 * 直線を枠の中だけの座標を返す
	 *	
	 *	
	 * 戻値　： int    0:不可視    1:変換 OK	2:変換無し可視
	 *	
	 */
	SX = a->start.x;
	SY = a->start.y;
	EX = a->end.x;
	EY = a->end.y;
	Ret = LineCheckDraw(&SX, &SY, &EX, &EY);
	if (Ret == 0) {
		return 0;
	}


	if (a->FontHeight < ((sagcad_system.ViewX / Mag) / 400)) {
		LineDraw(widget, SX, SY, EX, EY, 1, color);
		return 0;
	}


#ifdef TEST
	/* -----------------------------------------------------
	 * 表示
	 */
	for (i = 0 ; i < a->diagram_of_char_index ; i++) {
		/* 文字を表示 */
		char_draw(widget, &a->diagram_of_char[i], color);
	}
#endif


//#ifdef TEST
	for (i = 0 ; i < a->diagram_of_char_index ; i++) {
		if (a->diagram_of_char[i].defin == 0) {
			//
		}
		if (a->diagram_of_char[i].defin == 1) {
			LineDraw(	widget,
						a->diagram_of_char[i].sx, a->diagram_of_char[i].sy, 
						a->diagram_of_char[i].ex, a->diagram_of_char[i].ey, 6, color);
		}
		else if (a->diagram_of_char[i].defin == 2) {
			ArcDraw(widget,	
						a->diagram_of_char[i].cx, a->diagram_of_char[i].cy,  a->diagram_of_char[i].r,
						a->diagram_of_char[i].sx, a->diagram_of_char[i].sy, 
						a->diagram_of_char[i].ex, a->diagram_of_char[i].ey, 
						6, color);	
		}
		else if (a->diagram_of_char[i].defin == 4) {
			CircleDraw(widget, 
						a->diagram_of_char[i].cx, 
						a->diagram_of_char[i].cy, 
						a->diagram_of_char[i].r, 6, color);
		}
	}
//#endif


	return 1;
}





/* -------------------------------------------------------------------
 * 文字をスケーリング 
 */
int char_scale(double scale, SAG_FONT *font)
{
	int i;
	
	font->width = sg((scale * font->width), 6);
	font->height = sg((scale * font->height), 6);

	if (font->index > 0) {
		for (i = 0 ; i < font->index ; i++) {
			font->font_data[i].cx = sg((scale * font->font_data[i].cx), 6);
			font->font_data[i].cy = sg((scale * font->font_data[i].cy), 6);
			font->font_data[i].sx = sg((scale * font->font_data[i].sx), 6);
			font->font_data[i].sy = sg((scale * font->font_data[i].sy), 6);
			font->font_data[i].ex = sg((scale * font->font_data[i].ex), 6);
			font->font_data[i].ey = sg((scale * font->font_data[i].ey), 6);
			font->font_data[i].r  = sg( scale * font->font_data[i].r  , 6);
		}
	}
	return 1;
}





/* -------------------------------------------------------------------
 * 文字をオフセットさせる
 */
int char_offset(double x, double y, SAG_FONT *font)
{
	int i;

	for (i = 0 ; i < font->index ; i++) {
		if(font->font_data[i].code == 1 || font->font_data[i].code == 2) {
			font->font_data[i].sx = sg(font->font_data[i].sx + x, 6);
			font->font_data[i].sy = sg(font->font_data[i].sy + y, 6);
			font->font_data[i].ex = sg(font->font_data[i].ex + x, 6);
			font->font_data[i].ey = sg(font->font_data[i].ey + y, 6);
		}
		if(font->font_data[i].code == 2 || font->font_data[i].code == 4) {
			font->font_data[i].cx = sg(font->font_data[i].cx + x, 6);
			font->font_data[i].cy = sg(font->font_data[i].cy + y, 6);
		}
	}
	return 1;
}





/* -------------------------------------------------------------------
 * 文字を回転させる
 */
int char_rolling(double angle, SAG_FONT *font)
{
	double RAD, DX, DY, x = 0, y = 0;
	int i;

	RAD = degrad(angle);

	if (font->index > 0) {
		for (i = 0 ; i < font->index ; i++) {
			if (font->font_data[i].code == 1 || font->font_data[i].code == 2) {
				DX = font->font_data[i].sx - x;
				DY = font->font_data[i].sy - y;
				font->font_data[i].sx = sg((DX * cos(RAD) - DY * sin(RAD)) + x, 6);
				font->font_data[i].sy = sg((DY * cos(RAD) + DX * sin(RAD)) + y, 6);

				DX = font->font_data[i].ex - x;
				DY = font->font_data[i].ey - y;
				font->font_data[i].ex = sg((DX * cos(RAD) - DY * sin(RAD)) + x, 6);
				font->font_data[i].ey = sg((DY * cos(RAD) + DX * sin(RAD)) + y, 6);
			}

			if (font->font_data[i].code == 2 || font->font_data[i].code == 4) {
				DX = font->font_data[i].cx - x;
				DY = font->font_data[i].cy - y;
				font->font_data[i].cx = sg((DX * cos(RAD) - DY * sin(RAD)) + x, 6);
				font->font_data[i].cy = sg((DY * cos(RAD) + DX * sin(RAD)) + y, 6);
			}
		}
	}
	return 1;
}





/* -------------------------------------------------------------------
 * 文字を表示
 */
int char_draw(GtkWidget *widget, SAG_FONT *font, long color)
{
	int i;

	for (i = 0 ; i < font->index ; i++) {
		if (font->font_data[i].code == 0) {
			//
		}
		if (font->font_data[i].code == 1) {
			LineDraw(	widget,
						font->font_data[i].sx, font->font_data[i].sy, 
						font->font_data[i].ex, font->font_data[i].ey, 6, color);
		}
		else if (font->font_data[i].code == 2) {
			ArcDraw(widget,	
						font->font_data[i].cx, font->font_data[i].cy,  font->font_data[i].r,
						font->font_data[i].sx, font->font_data[i].sy, 
						font->font_data[i].ex, font->font_data[i].ey, 
						6, color);	
		}
		else if (font->font_data[i].code == 4) {
			CircleDraw(widget, 
						font->font_data[i].cx, 
						font->font_data[i].cy, 
						font->font_data[i].r, 6, color);
		}
	}
	return 1;
}





/* -------------------------------------------------------------------
 * 文字データを表示
 */
int char_data_print(SAG_FONT *font)
{
	char str[256];
	int i;

	sprintf(str, "CHAR = %s   width = %f   height = %f   index = %d\n", font->moji, font->width, font->height, font->index);
	for (i = 0 ; i < font->index ; i++) {
		sprintf(str, "sx = %f   sy = %f   ex = %f   ey = %f\n", font->font_data[i].sx, font->font_data[i].sy, font->font_data[i].ex, font->font_data[i].ey);
		sprintf(str, "cx = %f   cy = %f   r = %f\n", font->font_data[i].cx, font->font_data[i].cy, font->font_data[i].r);
	}
	return 1;
}






/* -------------------------------------------------------------------
 * 文字列データを UTF-8 で何文字かを計算
 */
int saglen(char *text)
{
	int i, k, TextLen, bite;
	char utf8_text[256];

	strcpy(utf8_text, text);

	k=0;
	TextLen = strlen(utf8_text);
	for (i = 0 ; i < TextLen ; i++) {
		/* 多バイト文字の処理 */
		bite = utf8_bite_num(utf8_text[k]);
		if (bite > 1) {
			TextLen = TextLen - (bite - 1);
			k = k + (bite - 1);
		}
		k++;
	}
	return TextLen;
}





/* -------------------------------------------------------------------
 * ベクトルフォントの計算
 * -------------------------------------------------------------------
 *	1 : n 文字目の データを 原点に読み込んでスケーリングしたデータを関数(char_scale)で作成
 *	2 : 1 のデータを now_char_X オフセットして取り込む。
 *	3 : now_char_X を取り込んだ 文字幅 + distance オフセットさせる。
 *	4 : 1,2,3 を文字数繰り返す。
 *	
 *	5 : できたデータを angle で回転させ、(x､y) オフセットさせ表示。
 *	
 * a->text : テキスト
 * a->UpperText : テキスト
 * a->LowerText : テキスト
 * a->FontHeight : 高さ
 * a->FontSpace : 文字と文字の間隔				寸法作成時に計算されているものとする
 * a->FontOverLineSpace : 文字と補助線の間隔	寸法作成時に計算されているものとする
 * a->Angle : 角度
 * a->SearchPointX : 基準Ｘ
 * a->SearchPointY : 基準Ｙ
 * a->text_color : 色
 * a->FitPointX : 0,1,2 書き出し位置
 *     0 :	.TEXT
 *     1 :	TE.XT
 *     2 :	TEXT.
 * a->FitPointY : 0,1,2,3 
 *     0 : BaseLine
 *     1 : BaseLine + FontOverLineSpace (LowerLine)
 *     2 : MidLine
 *     3 : UpperLine
 *     4 : UpperLine + FontOverLineSpace
 * 
 * frag  : 0:文字列長さ計算だけ   1:表示
 *	
 *	
 * -------------------------------------------------------------------
 */
double CulcTextVector (GtkWidget *widget, DIMENSION *a)
{
	int len, TextLen, UpperTextLen = 0, LowerTextLen = 0, TotalTextLen, i, k, Ret, data;
	SAG_FONT *p_font;
	SAG_FONT *p_array_font;
	SAG_FONT_DATA *p_font_data;

	int TotalDiagram = 0, j;
	ASSISTANCE *p_assistance = NULL;

	double now_char_X = 0, string_width, text_string_width, upper_text_string_width, lower_text_string_width;
	double scale = 0, font_space = 0, word_space = 0, Font_space_line = 0, y_pos = 0;
	double UpLow_space = 0;
	struct RtnDat PAPH;
	char utf8_text[256];
	char utf8_upper[256];
	char utf8_lower[256];
	int bite = 0;				/* UTF-8 １文字のバイト数 */


//g_print("font.c : CulcTextVector() : a->FontHeight = %f\n", a->FontHeight);
//g_print("font.c : CulcTextVector() : a->FontSpace = %f\n", a->FontSpace);


	/* -----------------------------------------------------
	 * UTF-8 に変換
	 */
	strcpy(utf8_text, a->Text);
	strcpy(utf8_upper, a->UpperText);
	strcpy(utf8_lower, a->LowerText);

	/* -----------------------------------------------------
	 * 文字列分のフォント用データを確保
	 */
	len = strlen(utf8_text) + strlen(utf8_upper) + strlen(utf8_lower);
	if (len != 0) {
		p_array_font = (SAG_FONT *)xmalloc(len * sizeof(SAG_FONT));
	}
	else {
		return 0;
	}





	/* -----------------------------------------------------
	 * Text
	 * 
	 */
	k=0;
	TextLen = strlen(utf8_text);


	/* -------------------------------------------
	 * 寸法文字
	 */
	/* 初期設定 */
	scale = (a->FontHeight / 9);
	font_space = a->FontSpace;
	word_space = a->WordSpace;
	UpLow_space = word_space;
	Font_space_line = a->FontOverLineSpace;

	/* 計算 */
	for (i = 0; i < TextLen; i++) {
		/* １文字のデータを探す */
		p_font = font_search(&utf8_text[k], sagcad_dimension.font_file2);// <----ここがおかしい
		if (p_font == NULL) {
			g_print("Error : font.c : DrawTextVector() : Text\n");
			return 0;
		}
		
		/* p_array_font[i] に探したデータをコピー */
		p_array_font[i] = *p_font;
		if (p_array_font[i].moji[0] == ' ' && p_array_font[i].moji[1] == '\0') p_array_font[i].width = word_space;

		/* フォントのデータ用のメモリを index だけ確保する */
		if (p_array_font[i].index > 0) {
			p_font_data = (SAG_FONT_DATA *)xmalloc(p_array_font[i].index * sizeof(SAG_FONT_DATA));
			/* メモリにフォントのデータをコピーする */
			for (data = 0 ; data < p_array_font[i].index ; data++) {
				p_font_data[data] = p_font->font_data[data];
			}
			/* フォントのデータをコピーしたポインタに書き換える */
			p_array_font[i].font_data = p_font_data;
		}
		else {
			p_array_font[i].index = 0;
			p_array_font[i].font_data = NULL;
		}

		/* 文字をスケーリング */
		char_scale(scale, &p_array_font[i]);
		/* 文字列中の i 番目の位置にオフセットする。 */
		char_offset(now_char_X, 0, &p_array_font[i]);
		/* 次の文字の書き出し位置 */
		now_char_X = now_char_X + p_array_font[i].width + font_space;

		/* 全角文字の処理 */
		bite = utf8_bite_num(utf8_text[k]);
		if (bite > 1) {
			TextLen = TextLen - (bite - 1);
			k = k + (bite - 1);
		}
		k++;
	}
	/* 文字列の幅を計算 */
	text_string_width = now_char_X - font_space;





	/* -----------------------------------------------------
	 * 上限公差
	 * 
	 */
	if (strlen(utf8_upper) == 0) {
		upper_text_string_width = text_string_width;
	}
	else {
		now_char_X = text_string_width + UpLow_space;
		k=0;
		UpperTextLen = strlen(a->UpperText);

		/* 初期設定 */
		scale = ((a->FontHeight * MINI_TEXT_HEIGHT) / 9);
		font_space = a->FontSpace * MINI_TEXT_HEIGHT;
		word_space = a->WordSpace * MINI_TEXT_HEIGHT;
		y_pos = (a->FontHeight / 2)+(MINI_TEXT_UP_POS * a->FontHeight);

		/* 計算 */
		for (i = TextLen ; i < TextLen + UpperTextLen ; i++) {
			/* １文字のデータを探す */
			p_font = font_search(&utf8_upper[k], sagcad_dimension.font_file2);
			if (p_font == NULL) {
				g_print("Error : font.c : DrawTextVector() : UpperText\n");
				return 0;
			}
			
			/* p_array_font[i] に探したデータをコピー */
			p_array_font[i] = *p_font;
			if (p_array_font[i].moji[0] == ' ' && p_array_font[i].moji[1] == '\0') p_array_font[i].width = word_space;

			/* メモリの確保 */
			if (p_array_font[i].index > 0) {
				/* フォントのデータ用のメモリを index だけ確保する */
				p_font_data = (SAG_FONT_DATA *)xmalloc(p_array_font[i].index * sizeof(SAG_FONT_DATA));
				/* メモリにフォントのデータをコピーする */
				for (data = 0 ; data < p_array_font[i].index ; data++) {
					p_font_data[data] = p_font->font_data[data];
				}
				/* フォントのデータをコピーしたポインタに書き換える */
				p_array_font[i].font_data = p_font_data;
			}
			else {
				p_array_font[i].index = 0;
				p_array_font[i].font_data = NULL;
			}

			/* 文字をスケーリング */
			char_scale(scale, &p_array_font[i]);
			/* 文字列中の i 番目の位置にオフセットする。 */
			char_offset(now_char_X, y_pos, &p_array_font[i]);
			/* 次の文字の書き出し位置 */
			now_char_X = now_char_X + p_array_font[i].width + font_space;

			/* 全角文字の処理 */
			bite = utf8_bite_num(utf8_upper[k]);
			if (bite > 1) {
				UpperTextLen = UpperTextLen - (bite - 1);
				k = k + (bite - 1);
			}
			k++;
		}
		/* 文字列の幅を計算 */
		upper_text_string_width = (now_char_X - font_space);
	}





	/* -----------------------------------------------------
	 * 下限公差
	 * 
	 */
	if (strlen(utf8_lower) == 0) {
		lower_text_string_width = text_string_width;
	}
	else {
		now_char_X = text_string_width + UpLow_space;
		k=0;
		LowerTextLen = strlen(a->LowerText);


		/* 初期設定 */
		scale = ((a->FontHeight * MINI_TEXT_HEIGHT) / 9/*p_array_font[i].height*/);
		font_space = a->FontSpace * MINI_TEXT_HEIGHT/* * scale*/;
		word_space = a->WordSpace * MINI_TEXT_HEIGHT;
		y_pos = (a->FontHeight / 2)-(MINI_TEXT_LOW_POS * a->FontHeight);

		/* 計算 */
		for (i = TextLen + UpperTextLen ; i < TextLen + UpperTextLen + LowerTextLen ; i++) {
			/* １文字のデータを探す */
			p_font = font_search(&utf8_lower[k], sagcad_dimension.font_file2);
			if (p_font == NULL) {
				g_print("Error : font.c : DrawTextVector() : LowerText\n");
				return 0;
			}
			
			/* p_array_font[i] に探したデータをコピー */
			p_array_font[i] = *p_font;
			if (p_array_font[i].moji[0] == ' ' && p_array_font[i].moji[1] == '\0') p_array_font[i].width = word_space;

			/* メモリの確保 */
			if (p_array_font[i].index > 0) {

				/* フォントのデータ用のメモリを index だけ確保する */
				p_font_data = (SAG_FONT_DATA *)xmalloc(p_array_font[i].index * sizeof(SAG_FONT_DATA));
				/* メモリにフォントのデータをコピーする */
				for (data = 0 ; data < p_array_font[i].index ; data++) {
					p_font_data[data] = p_font->font_data[data];
				}
				/* フォントのデータをコピーしたポインタに書き換える */
				p_array_font[i].font_data = p_font_data;
			}
			else {
				p_array_font[i].index = 0;
				p_array_font[i].font_data = NULL;
			}

			/* 文字をスケーリング */
			char_scale(scale, &p_array_font[i]);
			/* 文字列中の i 番目の位置にオフセットする。 */
			char_offset(now_char_X, y_pos, &p_array_font[i]);
			/* 次の文字の書き出し位置 */
			now_char_X = now_char_X + p_array_font[i].width + font_space;

			/* 全角文字の処理 */
			bite = utf8_bite_num(utf8_lower[k]);
			if (bite > 1) {
				LowerTextLen = LowerTextLen - (bite - 1);
				k = k + (bite - 1);
			}
			k++;
		}
		/* 文字列の幅を計算 */
		lower_text_string_width = (now_char_X - font_space);
	}






	/* -----------------------------------------------------
	 * 文字列の幅を計算
	 * 
	 */
	if(upper_text_string_width >= lower_text_string_width)
		string_width = upper_text_string_width;
	else 
		string_width = lower_text_string_width;

	/* 全部の文字数を計算 */
	TotalTextLen = TextLen + UpperTextLen + LowerTextLen;


	/* 文字位置合わせ前に設定 */
	a->start.x = a->SearchPointX;
	a->start.y = a->SearchPointY;





	/* -----------------------------------------------------
	 * 文字位置合わせ X
	 */
	/* Left (default) */
	if (a->FitPointX == 0) {
		// デフォルト
	}
	/* Center */
	else if (a->FitPointX == 1) {
		PAPH.sx[1] = 0;
		PAPH.sy[1] = 0;
		PAPH.angle = -180;		/* -180 */
		PAPH.l = string_width / 2;
		pap(&PAPH);
		for (i = 0 ; i < TotalTextLen ; i++) {
			/* 文字列中の i 番目の位置にオフセットする。 */
			char_offset(PAPH.ex[1], PAPH.ey[1], &p_array_font[i]);
		}

		a->start.x = sg(a->start.x + PAPH.ex[1], 6);
		a->start.y = sg(a->start.y + PAPH.ey[1], 6);
	}
	/* Right */
	else if (a->FitPointX == 2) {
		PAPH.sx[1] = 0;
		PAPH.sy[1] = 0;
		PAPH.angle = -180;		/* -180 */
		PAPH.l = string_width;
		pap(&PAPH);
		for (i = 0 ; i < TotalTextLen ; i++) {
			/* 文字列中の i 番目の位置にオフセットする。 */
			char_offset(PAPH.ex[1], PAPH.ey[1], &p_array_font[i]);
		}
		a->start.x = sg(a->start.x + PAPH.ex[1], 6);
		a->start.y = sg(a->start.y + PAPH.ey[1], 6);
	}



	/* -----------------------------------------------------
	 * 文字位置合わせ Y
	 */
	/* Bottom (default) */
	if (a->FitPointY == 0) {
		// デフォルト
	}
	/* Bottom + FontOverLineSpace */
	else if (a->FitPointY == 1) {
		PAPH.sx[1] = 0;
		PAPH.sy[1] = 0;
		PAPH.angle = 90;		/* -90 */
		PAPH.l = Font_space_line;
		pap(&PAPH);
		for (i = 0 ; i < TotalTextLen ; i++) {
			/* オフセットする。 */
			char_offset(PAPH.ex[1], PAPH.ey[1], &p_array_font[i]);
		}
		a->start.x = sg(a->start.x + PAPH.ex[1], 6);
		a->start.y = sg(a->start.y + PAPH.ey[1], 6);
	}
	/* Middle */
	else if (a->FitPointY == 2) {
		PAPH.sx[1] = 0;
		PAPH.sy[1] = 0;
		PAPH.angle = -90;		/* -90 */
		PAPH.l = a->FontHeight / 2;
		pap(&PAPH);
		for (i = 0 ; i < TotalTextLen ; i++) {
			/* オフセットする。 */
			char_offset(PAPH.ex[1], PAPH.ey[1], &p_array_font[i]);
		}
		a->start.x = sg(a->start.x + PAPH.ex[1], 6);
		a->start.y = sg(a->start.y + PAPH.ey[1], 6);
	}
	/* Top */
	else if (a->FitPointY == 3) {
		PAPH.sx[1] = 0;
		PAPH.sy[1] = 0;
		PAPH.angle = -90;		/* -90 */
		PAPH.l = a->FontHeight;
		pap(&PAPH);
		for (i = 0 ; i < TotalTextLen ; i++) {
			/* オフセットする。 */
			char_offset(PAPH.ex[1], PAPH.ey[1], &p_array_font[i]);
		}
		a->start.x = sg(a->start.x + PAPH.ex[1], 6);
		a->start.y = sg(a->start.y + PAPH.ey[1], 6);
	}
	/* Top + FontOverLineSpace */
	else if (a->FitPointY == 4) {
		PAPH.sx[1] = 0;
		PAPH.sy[1] = 0;
		PAPH.angle = -90;		/* -90 */
		PAPH.l = a->FontHeight + Font_space_line;
		pap(&PAPH);
		for (i = 0 ; i < TotalTextLen ; i++) {
			/* オフセットする。 */
			char_offset(PAPH.ex[1], PAPH.ey[1], &p_array_font[i]);
		}
		a->start.x = sg(a->start.x + PAPH.ex[1], 6);
		a->start.y = sg(a->start.y + PAPH.ey[1], 6);
	}





	/* -----------------------------------------------------
	 * 実際の図面の位置に移動する
	 * 
	 */
	for (i = 0 ; i < TotalTextLen ; i++) {
		/* 回転させる */
		Ret = char_rolling(a->Angle, &p_array_font[i]);
		/* 文字を図面上の位置にオフセットさせる */
		char_offset(a->SearchPointX, a->SearchPointY, &p_array_font[i]);
		/* 文字を表示 */
//			char_draw(widget, &p_array_font[i], color);
	}





	/* -------------------------------------------------------------------
	 * pap 始点と角度と距離で直線の終点を求める
	 */
	PAPH.sx[1] = a->start.x;
	PAPH.sy[1] = a->start.y;
	PAPH.angle = a->Angle;
	PAPH.l = string_width;
	pap(&PAPH);
	a->end.x = PAPH.ex[1];
	a->end.y = PAPH.ey[1];



	/* 図形要素の数を求める */
	TotalDiagram = 0;
	for (i = 0 ; i < TotalTextLen ; i++) {
		TotalDiagram = TotalDiagram + p_array_font[i].index;
	}

	/* 図形要素の数だけメモリを確保 */
	if (TotalDiagram > 0) {
		p_assistance = (ASSISTANCE *)xmalloc( TotalDiagram * sizeof(ASSISTANCE) );
		a->diagram_of_char_index = TotalDiagram;
		a->diagram_of_char = p_assistance;
	}
	else {
		a->diagram_of_char_index = 0;
		a->diagram_of_char = NULL;
	}

	/* 確保したメモリにフォントの図形要素をコピー */
	if (TotalDiagram > 0) {
		k = 0;
		for (i = 0 ; i < TotalTextLen ; i++) {
			for (j = 0 ; j < p_array_font[i].index ; j++) {
				p_assistance[k].defin = p_array_font[i].font_data[j].code;
				p_assistance[k].sx = p_array_font[i].font_data[j].sx;
				p_assistance[k].sy = p_array_font[i].font_data[j].sy;
				p_assistance[k].ex = p_array_font[i].font_data[j].ex;
				p_assistance[k].ey = p_array_font[i].font_data[j].ey;
				p_assistance[k].cx = p_array_font[i].font_data[j].cx;
				p_assistance[k].cy = p_array_font[i].font_data[j].cy;
				p_assistance[k].r  = p_array_font[i].font_data[j].r;
				k++;
			}
		}
	}

	/* for DEBUG */
	if (k == TotalDiagram) {
		//g_print("font.c : CulcTextVector() : k == TotalDiagram\n");
	}
	else {
		//g_print("font.c : CulcTextVector() : k != TotalDiagram  %d : %d \n", k, TotalDiagram);
	}

	/* 作業用のメモリ開放 */
	for (i = 0 ; i < TotalTextLen ; i++) {
		if (p_array_font[i].index > 0 && p_array_font[i].font_data != NULL) {
			xfree(p_array_font[i].font_data);
		}
	}
	xfree(p_array_font);

	return string_width;
}





/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : font.c
 * ====================================================================
 */
